/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.internal.emf.xml;

import com.ibm.wtp.emf.xml.TranslatorResource;
import com.ibm.wtp.internal.emf.xml.CacheEventNode;
import com.ibm.wtp.internal.emf.xml.CacheEventStack;
import java.util.ArrayList;
import java.util.Collection;
import org.xml.sax.Attributes;

public class CacheEventPool {
    public static final int DEFAULT_CAPACITY = 10;
    public static final int DEFAULT_CAPACITY_INCREMENT = 25;
    private int poolCapacity = 10;
    private CacheEventStack availablePool = null;
    private Collection inusePool = null;

    public CacheEventPool() {
        this(10);
    }

    public CacheEventPool(int initialCapacity) {
        this.poolCapacity = initialCapacity > 0 ? initialCapacity : 10;
        this.availablePool = new CacheEventStack();
        this.inusePool = new ArrayList(this.poolCapacity);
    }

    public CacheEventNode createCacheEventNode(TranslatorResource resource) {
        CacheEventNode adapter = this.fetchFreeNode();
        adapter.init(resource);
        return adapter;
    }

    public CacheEventNode createCacheEventNode(CacheEventNode parent, String nodeName, Attributes attributes) {
        CacheEventNode adapter = this.fetchFreeNode();
        adapter.init(parent, nodeName, attributes);
        return adapter;
    }

    public void releaseNode(CacheEventNode adapter) {
        this.freeNode(adapter);
    }

    public void freezePool() {
        this.availablePool.clear();
        this.availablePool = null;
    }

    public void warmPool() {
        this.ensureMinimumCapacity();
    }

    private CacheEventNode fetchFreeNode() {
        CacheEventNode result = null;
        if (this.availablePool == null || this.availablePool.isEmpty()) {
            this.warmPool();
        }
        result = this.availablePool.pop();
        this.inusePool.add(result);
        return result;
    }

    private void freeNode(CacheEventNode adapter) {
        if (this.inusePool.remove(adapter)) {
            this.availablePool.push(adapter);
        }
        if (this.availablePool.size() > 5 * this.poolCapacity) {
            this.availablePool.clear();
            this.ensureMinimumCapacity();
        }
    }

    private void ensureMinimumCapacity() {
        if (this.availablePool == null) {
            this.availablePool = new CacheEventStack();
        }
        if (this.availablePool.size() < this.poolCapacity) {
            int minimumCapacity = this.poolCapacity - this.availablePool.size();
            int i = 0;
            while (i < minimumCapacity) {
                this.availablePool.push(new CacheEventNode(this));
                ++i;
            }
        }
    }
}

