/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.emf.xml;

import com.ibm.wtp.emf.xml.Renderer;
import com.ibm.wtp.internal.emf.xml.EMF2DOMRendererFactoryDefaultHandler;
import com.ibm.wtp.internal.emf.xml.RendererFactoryDefaultHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class RendererFactory {
    private static RendererFactory defaultRendererFactory;
    private static RendererFactoryDefaultHandler defaultHandler;
    private boolean validating = true;
    public static final Notifier NotificationEngine;

    static {
        NotificationEngine = Notifier.INSTANCE;
    }

    public abstract Renderer createRenderer();

    public static RendererFactory getDefaultRendererFactory() {
        if (defaultRendererFactory == null) {
            defaultRendererFactory = RendererFactory.getDefaultHandler().getDefaultRendererFactory();
        }
        return defaultRendererFactory;
    }

    public static void setDefaultRendererFactory(RendererFactory factory) {
        NotificationEngine.notifyListeners(factory);
        defaultRendererFactory = factory;
    }

    public String toString() {
        return "RendererFactory instance: " + this.getClass().getName();
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean b) {
        this.validating = b;
    }

    public static RendererFactoryDefaultHandler getDefaultHandler() {
        if (defaultHandler == null) {
            defaultHandler = EMF2DOMRendererFactoryDefaultHandler.INSTANCE;
        }
        return defaultHandler;
    }

    public static void setDefaultHandler(RendererFactoryDefaultHandler handler) {
        defaultHandler = handler;
    }

    public static class Notifier {
        private static final Notifier INSTANCE = new Notifier();
        private final Collection resourceFactoryListeners = new ArrayList();

        private Notifier() {
        }

        public void notifyListeners(RendererFactory rendererFactory) {
            int length = this.resourceFactoryListeners.size();
            if (length > 0 && rendererFactory != RendererFactory.getDefaultRendererFactory()) {
                WeakReference wref = null;
                Listener listener = null;
                Collection collection = this.resourceFactoryListeners;
                synchronized (collection) {
                    Iterator i = this.resourceFactoryListeners.iterator();
                    while (i.hasNext()) {
                        wref = (WeakReference)i.next();
                        listener = (Listener)wref.get();
                        if (listener != null) {
                            listener.updateRendererFactory(rendererFactory);
                            continue;
                        }
                        i.remove();
                    }
                }
            }
        }

        public void addListener(Listener l) {
            Collection collection = this.resourceFactoryListeners;
            synchronized (collection) {
                this.resourceFactoryListeners.add(new WeakReference<Listener>(l));
            }
        }

        public void removeListener(Listener listenerToRemove) {
            int length = this.resourceFactoryListeners.size();
            if (length > 0) {
                WeakReference wref = null;
                Listener listener = null;
                Collection collection = this.resourceFactoryListeners;
                synchronized (collection) {
                    Iterator i = this.resourceFactoryListeners.iterator();
                    while (i.hasNext()) {
                        wref = (WeakReference)i.next();
                        listener = (Listener)wref.get();
                        if (listener != null) {
                            if (listener != listenerToRemove) continue;
                            i.remove();
                            break;
                        }
                        i.remove();
                    }
                }
            }
        }
    }

    public interface Listener {
        public void updateRendererFactory(RendererFactory var1);
    }
}

