/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibws.JAXRPCHandler;
import com.ibm.websphere.models.config.sibws.JAXRPCHandlerList;
import com.ibm.websphere.models.config.sibws.JAXRPCHeader;
import com.ibm.websphere.models.config.sibws.UDDIReference;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.HashSet;

public class WSValidator_60
extends WebSphereLevelValidator
implements SibwsValidationConstants_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";
    protected HashSet jaxListNames = new HashSet();
    protected HashSet jaxNames = new HashSet();
    protected HashSet uddiNames = new HashSet();
    protected WSAttributeHelper attributeHelper;

    public WSValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
        this.trace("WSValidator_60");
    }

    public WSAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "WSValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof JAXRPCHandlerList) {
            this.trace("JAXRPCHandlerList");
            this.validateLocalHandlerList((JAXRPCHandlerList)object);
        } else if (object instanceof JAXRPCHandler) {
            this.trace("JAXRPCHandler");
            this.validateLocalHandler((JAXRPCHandler)object);
        } else if (object instanceof JAXRPCHeader) {
            this.trace("JAXRPCHeader");
            this.validateLocalHeader((JAXRPCHeader)object);
        } else if (object instanceof UDDIReference) {
            this.trace("UDDIReference");
            this.validateLocalUDDIRef((UDDIReference)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateLocalHandlerList(JAXRPCHandlerList jAXRPCHandlerList) {
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string = jAXRPCHandlerList.getName();
        this.traceBegin("validateLocalHandlerList(JAXRPCHandlerList)", string);
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "JAXRPCHandlerList", "name", this.jaxListNames, jAXRPCHandlerList);
        this.traceEnd();
    }

    protected void validateLocalHandler(JAXRPCHandler jAXRPCHandler) {
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string = jAXRPCHandler.getName();
        this.traceBegin("validateLocalHandler(JADRPCHandler)", string);
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "JAXRPCHandler", "name", this.jaxNames, jAXRPCHandler);
        boolean bl2 = wSAttributeHelper.isSet(jAXRPCHandler.getHandlerClassName(), "JAXRPCHandler", "handlerClassName", jAXRPCHandler);
        this.traceEnd();
    }

    protected void validateLocalHeader(JAXRPCHeader jAXRPCHeader) {
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string = jAXRPCHeader.getNamespaceURI();
        this.traceBegin("validateLocalHeader(JAXRPCHeader)", string);
        boolean bl = wSAttributeHelper.isSet(string, "JAXRPCHeader", "namespaceURI", jAXRPCHeader);
        String string2 = jAXRPCHeader.getLocalPart();
        boolean bl2 = wSAttributeHelper.isSet(string2, "JAXRPCHeader", "localpart", jAXRPCHeader);
        this.traceEnd();
    }

    protected void validateLocalUDDIRef(UDDIReference uDDIReference) {
        String string;
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string2 = uDDIReference.getName();
        this.traceBegin("validateLocalUDDIRef(UDDIReference)", string2);
        boolean bl = wSAttributeHelper.isSetAndUnique(string2, "UDDIReference", "name", this.uddiNames, uDDIReference);
        String string3 = uDDIReference.getInquiryURL();
        boolean bl2 = wSAttributeHelper.isSet(string3, "UDDIReference", "inquiryURL", uDDIReference);
        String string4 = uDDIReference.getPublishURL();
        if (string4 != null && string4.length() > 0 && ((string = uDDIReference.getAuthAlias()) == null || string.length() == 0)) {
            this.trace("authAlias not set, adding error 5003E");
            this.addError("ERROR_REQUIRED_ATTRIBUTE_WHEN_SET", new String[]{"UDDIReference", "authAlias", "publishURL"}, uDDIReference);
        }
        this.traceEnd();
    }
}

