/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSOutboundPort;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSOutboundService;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSServiceLocationKind;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSWSDLLocation;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.HashSet;
import java.util.Iterator;

public class SibwsOutboundValidator_60
extends WebSphereLevelValidator
implements SibwsValidationConstants_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";
    protected HashSet outboundServiceNames;
    protected HashSet outboundPortNames;
    protected HashSet wsdlNames;
    protected WSAttributeHelper attributeHelper = new WSAttributeHelper(this);

    public SibwsOutboundValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
        this.outboundServiceNames = new HashSet();
        this.outboundPortNames = new HashSet();
        this.wsdlNames = new HashSet();
        this.trace("SibwsOutboundValidator_60");
    }

    public WSAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SibwsOutboundValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBWSOutboundService) {
            this.validateLocalOutboundService((SIBWSOutboundService)object);
        } else if (object instanceof SIBWSOutboundPort) {
            this.validateLocalOutboundPort((SIBWSOutboundPort)object);
        } else if (object instanceof SIBWSWSDLLocation) {
            this.validateLocalWSDLLoc((SIBWSWSDLLocation)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateLocalOutboundService(SIBWSOutboundService sIBWSOutboundService) {
        String string = sIBWSOutboundService.getName();
        this.traceBegin("validateLocalOutboundService()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "SIBWSOutboundService", "name", this.outboundServiceNames, sIBWSOutboundService);
        boolean bl2 = wSAttributeHelper.isSet(sIBWSOutboundService.getServiceDestinationName(), "SIBWSOutboundService", "ServiceDestinationName", sIBWSOutboundService);
        boolean bl3 = wSAttributeHelper.isPresent(sIBWSOutboundService.getWSDLLocation(), "SIBWSOutboundService", "SIBWSWSDLLocation", sIBWSOutboundService);
        Iterator iterator = sIBWSOutboundService.getPort().iterator();
        while (iterator.hasNext()) {
            SIBWSOutboundPort sIBWSOutboundPort = (SIBWSOutboundPort)iterator.next();
            String string2 = sIBWSOutboundPort.getName();
            if (this.outboundPortNames.contains(string2)) {
                this.trace("Duplicate name, adding error 5008E");
                this.addError("ERROR_DUPLICATE_NAME", new String[]{"SIBWSoutboundPort", string2}, sIBWSOutboundService);
                continue;
            }
            this.outboundPortNames.add(string2);
        }
        this.traceEnd();
    }

    protected void validateLocalOutboundPort(SIBWSOutboundPort sIBWSOutboundPort) {
        String string = sIBWSOutboundPort.getName();
        this.traceBegin("validateLocalOutboundPort()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSet(string, "SIBWSOutboundPort", "name", sIBWSOutboundPort);
        this.traceEnd();
    }

    protected void validateLocalWSDLLoc(SIBWSWSDLLocation sIBWSWSDLLocation) {
        String string;
        String string2 = sIBWSWSDLLocation.getWSDLServiceName();
        this.traceBegin("validateLocalWSDLLoc()", string2);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string2, "SIBWSWSDLLocation", "WSDLServiceName", this.wsdlNames, sIBWSWSDLLocation);
        boolean bl2 = wSAttributeHelper.isSet(sIBWSWSDLLocation.getWSDLServiceNamespace(), "SIBWSWSDLLocation", "WSDLServiceNamespace", sIBWSWSDLLocation);
        boolean bl3 = wSAttributeHelper.isSet(sIBWSWSDLLocation.getWSDLLocation(), "SIBWSWSDLLocation", "WSDLLocation", sIBWSWSDLLocation);
        SIBWSServiceLocationKind sIBWSServiceLocationKind = sIBWSWSDLLocation.getWSDLLocationKind();
        if (sIBWSServiceLocationKind == SIBWSServiceLocationKind.get(0) && ((string = sIBWSWSDLLocation.getWSDLUDDIReference()) == null || string.length() == 0)) {
            this.trace("uddiref not set, adding error 5006E");
            String[] stringArray = new String[]{"SIBWSWSDLLocation", "UDDIReference", "SIBWSServiceLocationKind", "UDDI_REFERENCE"};
            this.addError("ERROR_REQUIRED_ATTRIBUTE_WHEN_SET", stringArray, sIBWSWSDLLocation);
        }
        this.traceEnd();
    }
}

