/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibresources.SIBDestination;
import com.ibm.websphere.models.config.sibws.JAXRPCHandlerList;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSOutboundPort;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSOutboundService;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsCrossValidator_60;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.List;

public class SibwsOutboundCrossValidator_60
extends SibwsCrossValidator_60
implements SibwsValidationConstants_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";

    public SibwsOutboundCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
        this.trace("SibwsOutboundCrossValidator_60");
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SibwsOutboundCrossValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBWSOutboundService) {
            this.trace("SIBWSOutboundService");
            this.validateAcrossOutboundService((SIBWSOutboundService)object);
        } else if (object instanceof SIBWSOutboundPort) {
            this.trace("SIBWSOutboundPort");
            this.validateAcrossOutboundPort((SIBWSOutboundPort)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcrossOutboundService(SIBWSOutboundService sIBWSOutboundService) throws ValidationException {
        String string = sIBWSOutboundService.getServiceDestinationName();
        this.traceBegin("validateAcrossOutboundService()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        List list = this.getCurrentBusDestination();
        SIBDestination sIBDestination = (SIBDestination)wSAttributeHelper.testFindWithName(string, list, "SIBWSOutboundService", "ServiceDestinationName", sIBWSOutboundService);
        this.traceEnd();
    }

    protected void validateAcrossOutboundPort(SIBWSOutboundPort sIBWSOutboundPort) throws ValidationException {
        Object object;
        Object object2;
        String string = sIBWSOutboundPort.getJAXRPCHandlerListName();
        this.trace("validateAcrossOutboundPort()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        if (string != null) {
            object2 = this.loadCellPeer("sibws-webservices.xml");
            object = (JAXRPCHandlerList)wSAttributeHelper.testFindWithName(string, (List)object2, "SIBWSOutboundPort", "JAXRPCHandlerList", sIBWSOutboundPort);
        }
        if ((object2 = sIBWSOutboundPort.getPortDestinationName()) != null) {
            object = this.loadCellPeer("sib-destinations.xml");
            SIBDestination sIBDestination = (SIBDestination)wSAttributeHelper.testFindWithName((String)object2, (List)object, "SIBWSOutboundPort", "PortDestinationName", sIBWSOutboundPort);
        }
        this.traceEnd();
    }
}

