/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibresources.SIBDestination;
import com.ibm.websphere.models.config.sibws.JAXRPCHandlerList;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSEndpointListenerReference;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSInboundPort;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSInboundService;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsCrossValidator_60;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.List;

public class SibwsInboundCrossValidator_60
extends SibwsCrossValidator_60
implements SibwsValidationConstants_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";

    public SibwsInboundCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
        this.trace("SibwsInboundCrossValidator");
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SibwsInboundCrossValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBWSInboundService) {
            this.trace("SIBWSInboundService");
            this.validateAcrossInboundService((SIBWSInboundService)object);
        } else if (object instanceof SIBWSInboundPort) {
            this.trace("SIBWSInboundPort");
            this.validateAcrossInboundPort((SIBWSInboundPort)object);
        } else if (object instanceof SIBWSEndpointListenerReference) {
            this.trace("SIBWSEndpointListenerReference");
            this.validateAcrossEPLRef((SIBWSEndpointListenerReference)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcrossInboundService(SIBWSInboundService sIBWSInboundService) throws ValidationException {
        String string = sIBWSInboundService.getServiceDestinationName();
        this.traceBegin("validateAcrossInboundService()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        List list = this.getCurrentBusDestination();
        SIBDestination sIBDestination = (SIBDestination)wSAttributeHelper.testFindWithName(string, list, "SIBWSInboundService", "ServiceDestinationName", sIBWSInboundService);
        this.traceEnd();
    }

    protected void validateAcrossInboundPort(SIBWSInboundPort sIBWSInboundPort) throws ValidationException {
        String string = sIBWSInboundPort.getJAXRPCHandlerListName();
        this.traceBegin("validateAcrossInboundPort()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        if (string != null) {
            List list = this.loadCellPeer("sibws-webservices.xml");
            JAXRPCHandlerList jAXRPCHandlerList = (JAXRPCHandlerList)wSAttributeHelper.testFindWithName(string, list, "SIBWSInboundPort", "JAXRPCHandlerList", sIBWSInboundPort);
        }
        this.traceEnd();
    }
}

