/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSEndpointListenerReference;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSWSDLLocation;
import com.ibm.websphere.models.config.wsgw.WSGWGatewayService;
import com.ibm.websphere.models.config.wsgw.WSGWInstance;
import com.ibm.websphere.models.config.wsgw.WSGWProxyService;
import com.ibm.websphere.models.config.wsgw.WSGWTargetService;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsInboundValidator_60;
import com.ibm.websphere.validation.sibws.level60.SibwsOutboundValidator_60;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.HashSet;

public class SibwsGatewayValidator_60
extends WebSphereLevelValidator
implements SibwsValidationConstants_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";
    protected HashSet gatewayServiceNames;
    protected HashSet gatewayInstanceNames;
    protected HashSet proxyServiceNames;
    protected WSAttributeHelper attributeHelper = new WSAttributeHelper(this);

    public SibwsGatewayValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
        this.gatewayServiceNames = new HashSet();
        this.gatewayInstanceNames = new HashSet();
        this.proxyServiceNames = new HashSet();
        this.trace("SibwsGatewayValidator_60");
    }

    public WSAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SibwsGatewayValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof WSGWInstance) {
            this.validateLocalGatewayInstance((WSGWInstance)object);
        } else if (object instanceof WSGWGatewayService) {
            this.validateLocalGatewayService((WSGWGatewayService)object);
        } else if (object instanceof WSGWTargetService) {
            this.validateLocalTargetService((WSGWTargetService)object);
        } else if (object instanceof WSGWProxyService) {
            this.validateLocalProxyService((WSGWProxyService)object);
        } else if (object instanceof SIBWSEndpointListenerReference) {
            this.validateLocalEPLRef((SIBWSEndpointListenerReference)object);
        } else if (object instanceof SIBWSWSDLLocation) {
            this.validateLocalWSDLLoc((SIBWSWSDLLocation)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(WSGWInstance wSGWInstance) {
    }

    protected void validateLocalGatewayInstance(WSGWInstance wSGWInstance) {
        String string = wSGWInstance.getName();
        this.traceBegin("validateLocalGatewayInstance()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "WSGWInstance", "name", this.gatewayInstanceNames, wSGWInstance);
        boolean bl2 = wSAttributeHelper.isSet(wSGWInstance.getWsdlServiceNamespace(), "WSGWInstance", "WsdlServiceNamespace", wSGWInstance);
        boolean bl3 = wSAttributeHelper.isPresent(wSGWInstance.getDefaultProxyWSDLLocation(), "WSGWInstance", "defaultSIBWSWSDLLocation", wSGWInstance);
        this.traceEnd();
    }

    protected void validateLocalGatewayService(WSGWGatewayService wSGWGatewayService) {
        String string = wSGWGatewayService.getName();
        this.traceBegin("validateLocalGatewayService()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "WSGWGatewayService", "name", this.gatewayServiceNames, wSGWGatewayService);
        boolean bl2 = wSAttributeHelper.isSet(wSGWGatewayService.getDefaultTargetName(), "WSGWGatewayService", "defaultTargetName", wSGWGatewayService);
        this.traceEnd();
    }

    protected void validateLocalTargetService(WSGWTargetService wSGWTargetService) {
        String string = wSGWTargetService.getTargetDestinationName();
        this.traceBegin("validateLocalTargetService()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSet(string, "WSGWTargetService", "targetDestinationName", wSGWTargetService);
        boolean bl2 = wSAttributeHelper.isSet(wSGWTargetService.getTargetServiceIdentity(), "WSGWTargetService", "targetServiceIdentity", wSGWTargetService);
        this.traceEnd();
    }

    protected void validateLocalProxyService(WSGWProxyService wSGWProxyService) {
        String string = wSGWProxyService.getName();
        this.traceBegin("validateLocalProxyService()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "WSGWProxyService", "name", this.proxyServiceNames, wSGWProxyService);
        this.traceEnd();
    }

    protected void validateLocalEPLRef(SIBWSEndpointListenerReference sIBWSEndpointListenerReference) throws ValidationException {
        SibwsInboundValidator_60 sibwsInboundValidator_60 = new SibwsInboundValidator_60(this);
        sibwsInboundValidator_60.visit(sIBWSEndpointListenerReference);
    }

    protected void validateLocalWSDLLoc(SIBWSWSDLLocation sIBWSWSDLLocation) throws ValidationException {
        SibwsOutboundValidator_60 sibwsOutboundValidator_60 = new SibwsOutboundValidator_60(this);
        sibwsOutboundValidator_60.visit(sIBWSWSDLLocation);
    }
}

