/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.pme.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.pmecluster.PMEClusterExtension;
import com.ibm.websphere.models.config.topology.cluster.BackupCluster;
import com.ibm.websphere.models.config.wlmadvisor.ClusterAdvisor;
import com.ibm.websphere.models.config.wlmadvisor.ClusterWeightType;
import com.ibm.websphere.models.config.wlmadvisor.WeightAdvisor;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.pme.config.level60.PMEValidationConstants_60;
import java.util.Iterator;
import java.util.List;

public class PMEClusterValidator_60
extends WebSpherePlatformValidator
implements PMEValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected boolean _pastTopList = false;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$pmecluster$PMEClusterExtension;

    public String getBundleId() {
        return "com.ibm.websphere.validation.pme.config.level60.pmevalidation_60";
    }

    public String getTraceName() {
        return "PMEClusterValidator";
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
    }

    protected void visitList(List list) throws ValidationException {
        if (!this._pastTopList) {
            this._pastTopList = true;
            this.validateRootClusterExtension(list);
        }
        super.visitList(list);
    }

    protected void validateRootClusterExtension(List list) {
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            this.addError("ERROR_PME_EMPTY_DOCUMENT", new String[]{this.getCurrentFileName()}, null);
        } else {
            Object e = iterator.next();
            if (!(e instanceof PMEClusterExtension)) {
                this.addError("ERROR_PME_INVALID_ROOT_OBJECT", new String[]{this.getCurrentFileName(), e.getClass().getName(), (class$com$ibm$websphere$models$config$pmecluster$PMEClusterExtension == null ? (class$com$ibm$websphere$models$config$pmecluster$PMEClusterExtension = PMEClusterValidator_60.class$("com.ibm.websphere.models.config.pmecluster.PMEClusterExtension")) : class$com$ibm$websphere$models$config$pmecluster$PMEClusterExtension).getName()}, e);
            }
            if (iterator.hasNext()) {
                this.addError("ERROR_PME_DOCUMENT_HAS_MULTIPLE_ROOTS", new String[]{this.getCurrentFileName()}, null);
            }
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof PMEClusterExtension) {
            this.trace("Object recognized as a PMEClusterExtension; validating");
            this.validateLocal((PMEClusterExtension)object);
            this.validateAcross((PMEClusterExtension)object);
        } else if (object instanceof BackupCluster) {
            this.trace("Object recognized as a BackupCluster; validating");
            this.validateLocal((BackupCluster)object);
            this.validateAcross((BackupCluster)object);
        } else if (object instanceof WeightAdvisor) {
            this.trace("Object recognized as a WeightAdvisor; validating");
            this.validateLocal((WeightAdvisor)object);
            this.validateAcross((WeightAdvisor)object);
        } else if (object instanceof ClusterAdvisor) {
            this.trace("Object recognized as a ClusterAdvisor; validating");
            this.validateLocal((ClusterAdvisor)object);
            this.validateAcross((ClusterAdvisor)object);
        } else {
            bl = super.basicValidate(object);
            if (!bl) {
                this.trace("Object not recognized");
                this.addError("ERROR_PME_RECOGNITION_FAILED", new String[]{this.getCurrentFileName(), object.getClass().getName()}, object);
            }
        }
        return bl;
    }

    public void validateAcross(PMEClusterExtension pMEClusterExtension) {
    }

    public void validateLocal(PMEClusterExtension pMEClusterExtension) {
    }

    public void validateAcross(BackupCluster backupCluster) {
        if (backupCluster != null && backupCluster.getDomainBootstrapAddress() == null) {
            this.addError("ERROR_PME_REQUIRED_RELATIONSHIP", new String[]{backupCluster.getClass().getName(), "domainBootstrapAddress"}, backupCluster);
        }
    }

    public void validateLocal(BackupCluster backupCluster) {
        String string;
        if (backupCluster != null && ((string = backupCluster.getBackupClusterName()) == null || string.length() == 0)) {
            this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{backupCluster.getClass().getName(), "backupClusterName"}, backupCluster);
        }
    }

    public void validateAcross(ClusterAdvisor clusterAdvisor) {
    }

    public void validateLocal(ClusterAdvisor clusterAdvisor) {
    }

    public void validateAcross(WeightAdvisor weightAdvisor) {
        this.validateAcross((ClusterAdvisor)weightAdvisor);
    }

    public void validateLocal(WeightAdvisor weightAdvisor) {
        this.validateLocal((ClusterAdvisor)weightAdvisor);
        if (weightAdvisor != null) {
            ClusterWeightType clusterWeightType = weightAdvisor.getAdvisorType();
            String string = clusterWeightType != null ? clusterWeightType.getName() : null;
            if (clusterWeightType == null || string == null || string.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{weightAdvisor.getClass().getName(), "advisorType"}, weightAdvisor);
            } else if (!string.equals("FixedWeight") && !string.equals("WebSphereDynamicWeighting")) {
                this.addError("ERROR_PME_INVALID_ATTRIBUTE_VALUE", new String[]{weightAdvisor.getClass().getName(), "advisorType", "FixedWeight, WebSphereDynamicWeighting"}, weightAdvisor);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

