/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.pme.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.pmecluster.PMEClusterExtension;
import com.ibm.websphere.models.config.pmiservice.PMIService;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.wlmadvisor.ClusterWeightType;
import com.ibm.websphere.models.config.wlmadvisor.WeightAdvisor;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.pme.config.level60.PMEValidationConstants_60;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class PMEClusterCrossValidator_60
extends WebSpherePlatformCrossValidator
implements PMEValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public String getBundleId() {
        return "com.ibm.websphere.validation.pme.config.level60.pmevalidation_60";
    }

    public String getTraceName() {
        return "PMEClusterCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof PMEClusterExtension) {
            this.trace("Object recognized as a PMEClusterExtension; validating");
            EList eList = ((PMEClusterExtension)object).getAdvisors();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof WeightAdvisor)) continue;
                this.validateAcross((WeightAdvisor)e);
            }
        }
        return true;
    }

    public void validateAcross(WeightAdvisor weightAdvisor) {
        ClusterWeightType clusterWeightType;
        if (weightAdvisor != null && (clusterWeightType = weightAdvisor.getAdvisorType()) != null && ((Object)((Object)clusterWeightType)).equals((Object)ClusterWeightType.WEB_SPHERE_DYNAMIC_WEIGHTING_LITERAL)) {
            this.validateClusterMembersPMI(weightAdvisor);
        }
    }

    public void validateClusterMembersPMI(WeightAdvisor weightAdvisor) {
        Object object = this.loadSiblingModel("cluster.xml");
        if (object instanceof List) {
            Object object2;
            Object object3;
            List list = (List)object;
            ManagedObject managedObject = null;
            if (list != null) {
                object3 = list.iterator();
                if (managedObject == null && object3.hasNext() && (object2 = object3.next()) instanceof ServerCluster) {
                    managedObject = (ServerCluster)object2;
                }
            }
            if (managedObject != null) {
                object3 = managedObject.getName();
                object2 = managedObject.getMembers();
                Iterator iterator = object2.iterator();
                boolean bl = false;
                while (!bl && iterator.hasNext()) {
                    Object e = iterator.next();
                    ClusterMember clusterMember = (ClusterMember)e;
                    String string = clusterMember.getMemberName();
                    String string2 = clusterMember.getNodeName();
                    bl = this.validateNodePMI(string2, string);
                }
                if (bl) {
                    this.addError("ERROR_PME_CLUSTER_DYNAMIC_WEIGHTING_REQUIRES_PMI", new String[]{object3}, weightAdvisor);
                }
            }
        }
    }

    public boolean validateNodePMI(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        String string3 = this.getCellUri() + "/nodes/" + string + "/servers/";
        String string4 = string3 + "nodeagent/server.xml";
        Object object5 = this.loadModel(string4);
        if (object5 instanceof List) {
            object4 = null;
            object3 = (List)object5;
            if (object3 != null && (object2 = object3.iterator()).hasNext() && (object = object2.next()) instanceof Server) {
                object4 = (Server)object;
            }
            if (object4 != null) {
                bl = this.validateServerPMI((Server)object4);
            }
        }
        if ((object3 = this.loadModel((String)(object4 = string3 + string2 + "/server.xml"))) instanceof List) {
            Object e;
            Iterator iterator;
            object2 = null;
            object = (List)object3;
            if (object != null && (iterator = object.iterator()).hasNext() && (e = iterator.next()) instanceof Server) {
                object2 = (Server)e;
            }
            if (object2 != null) {
                bl |= this.validateServerPMI((Server)object2);
            }
        }
        return bl;
    }

    public boolean validateServerPMI(Server server) {
        boolean bl = false;
        EList eList = server.getServices();
        Iterator iterator = eList.iterator();
        while (!bl && iterator.hasNext()) {
            Object e = iterator.next();
            Service service = (Service)e;
            if (!(service instanceof PMIService)) continue;
            PMIService pMIService = (PMIService)service;
            bl = !pMIService.isEnable();
        }
        return bl;
    }
}

