/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.jsr109;

import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import com.ibm.websphere.validation.jsr109.JSR109ClientValidator;
import com.ibm.websphere.validation.jsr109.JSR109CommonValidator;
import com.ibm.websphere.validation.jsr109.JSR109MessageConstants;
import com.ibm.websphere.validation.jsr109.JSR109ServerValidator;
import com.ibm.websphere.validation.jsr109.JSR109ValidatorContext;
import java.util.List;

public class JSR109ModuleValidator
extends JSR109ValidatorContext
implements JSR109MessageConstants {
    protected Archive moduleFile;

    public String getBaseName() {
        return this.getBundleId();
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.jsr109.resources.jsr109NLS";
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        if (iReporter == null || iHelper == null) {
            return;
        }
        this.setReporter(iReporter);
        iReporter.removeAllMessages(this);
        try {
            this.moduleFile = (Archive)iHelper.loadModel("MODULE_VALIDATION");
            if (this.moduleFile == null) {
                return;
            }
            this.displaySubtask("INFO_VALIDATING", new String[]{this.moduleFile.getURI()});
            JSR109ClientValidator jSR109ClientValidator = new JSR109ClientValidator(this, this.moduleFile);
            jSR109ClientValidator.validateClient();
            if (this.moduleFile.isWARFile() || this.moduleFile.isEJBJarFile()) {
                JSR109ServerValidator jSR109ServerValidator = new JSR109ServerValidator(this, this.moduleFile);
                jSR109ServerValidator.validateServer();
            }
        }
        catch (Exception exception) {
            String string = exception.getClass().getName() + ": " + (exception.getMessage() == null ? exception.toString() : exception.getMessage());
            Message message = new Message(this.getBundleId(), 1, "ERROR_JSR109_VALIDATION_FAILED", new String[]{string});
            throw new ValidationException(message, (Throwable)exception);
        }
    }

    protected String getResourceName() {
        return this.moduleFile.getURI();
    }

    public void validateModules(EARFile eARFile, IReporter iReporter) throws ValidationException {
        PassthruHelper passthruHelper = new PassthruHelper(null);
        List list = eARFile.getModuleFiles();
        for (int i = 0; i < list.size(); ++i) {
            File file = (File)list.get(i);
            passthruHelper.setObject(file);
            this.validate(passthruHelper, iReporter, null);
        }
    }

    public static void main(String[] stringArray) {
        block3: {
            if (stringArray.length == 0) {
                System.out.println("Usage: first arg specifies full path to ear file.");
            }
            JSR109CommonValidator.registerXML();
            String string = stringArray[0];
            try {
                EARFile eARFile = CommonarchiveFactoryImpl.getActiveFactory().openEARFile(string);
                FullReporter fullReporter = new FullReporter();
                JSR109ModuleValidator jSR109ModuleValidator = new JSR109ModuleValidator();
                jSR109ModuleValidator.validateModules(eARFile, fullReporter);
            }
            catch (Exception exception) {
                System.out.println(exception);
                if (!(exception instanceof ValidationException)) break block3;
                ((ValidationException)exception).getAssociatedException().printStackTrace();
            }
        }
    }
}

