/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.extensions.handler;

import com.ibm.etools.application.Application;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Session;
import com.ibm.etools.ejb.SessionType;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.exception.ResourceLoadException;
import com.ibm.etools.j2ee.init.J2EEInit;
import com.ibm.etools.j2ee.validation.J2EEValidator;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.descriptor.handler.EJBHandlerDD;
import com.ibm.websphere.models.descriptor.handler.HandlerListRef;
import com.ibm.websphere.models.descriptor.handler.impl.HandlerPackageImpl;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.base.extensions.handler.HandlerMessageConstants;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class HandlerValidator
extends J2EEValidator
implements HandlerMessageConstants {
    public static final String HANDLER_DD = "META-INF/ws-handler.xmi";
    EARFile earFile;
    Application appDD;

    public String getBaseName() {
        return "com.ibm.websphere.validation.base.extensions.handler.handlervalidation";
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray, EARFile eARFile) throws ValidationException {
        this.earFile = eARFile;
        if (eARFile == null) {
            return;
        }
        super.validate(iHelper, iReporter, iFileDeltaArray);
        List list = eARFile.getEJBJarFiles();
        for (int i = 0; i < list.size(); ++i) {
            this.validateEJBJar((EJBJarFile)list.get(i));
        }
    }

    private void validateEJBJar(EJBJarFile eJBJarFile) {
        String string = eJBJarFile.getName();
        Resource resource = this.loadHandlerDD(eJBJarFile);
        if (resource == null) {
            return;
        }
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (eObject == null) {
                this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_NULL_HANDLER_RESOURCE", new String[]{string});
                continue;
            }
            if (!(eObject instanceof EJBHandlerDD)) {
                this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_NOT_EJB_HANDLER", new String[]{string, eObject.toString()});
                continue;
            }
            this.validateEJBHandlerDD((EJBHandlerDD)eObject, string);
        }
    }

    private Resource loadHandlerDD(Archive archive) {
        Resource resource;
        String string = archive.getName();
        try {
            resource = archive.getMofResource(HANDLER_DD);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addInfo("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "INFO_HANDLER_DD_NOT_FOUND", new String[]{string});
            return null;
        }
        catch (ResourceLoadException resourceLoadException) {
            this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_HANDLER_DD_LOAD_FAILED", new String[]{string, resourceLoadException.toString()});
            return null;
        }
        return resource;
    }

    private void validateEJBHandlerDD(EJBHandlerDD eJBHandlerDD, String string) {
        String string2 = eJBHandlerDD.getName();
        if (string2 == null || string2.length() == 0) {
            this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_HANDLER_NAME", new String[]{string});
            string2 = "<<null>>";
        }
        this.validateEnterpriseBeanReference(eJBHandlerDD.getEjb(), string, string2);
        this.validateHandlerListRefs((List)eJBHandlerDD.getLists(), string, string2);
    }

    private void validateEnterpriseBeanReference(EnterpriseBean enterpriseBean, String string, String string2) {
        if (enterpriseBean == null || enterpriseBean.getName() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_EJB_REFERENCE", new String[]{string, string2});
        } else {
            String string3 = enterpriseBean.getName();
            boolean bl = enterpriseBean.isSession();
            String string4 = enterpriseBean.getLocalHomeInterfaceName();
            if (!bl) {
                this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_HANDLER_EJB_NOT_SLSB", new String[]{string, string2, string3});
            } else if (string4 == null || string4.length() == 0) {
                this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_HANDLER_EJB_NO_LOCAL_INTERFACES", new String[]{string, string2, string3});
            } else {
                Session session = (Session)enterpriseBean;
                if (session.getSessionType() != SessionType.STATELESS_LITERAL) {
                    this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_HANDLER_EJB_NOT_SLSB", new String[]{string, string2, string3});
                }
            }
        }
    }

    private void validateHandlerListRefs(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            int n;
            String string3;
            HandlerListRef handlerListRef = (HandlerListRef)iterator.next();
            String string4 = string3 = handlerListRef.getListName();
            boolean bl = true;
            if (string3 == null || string3.length() == 0) {
                this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_HANDLER_LIST_NAME", new String[]{string, string2});
                string4 = "<<null>>";
                bl = false;
            }
            if (bl) {
                if (hashMap.containsKey(string3)) {
                    this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_DUPLICATE_HANDLER_LIST_NAME", new String[]{string, string2, string3});
                } else {
                    hashMap.put(string3, null);
                }
            }
            if ((n = handlerListRef.getSequence()) >= 0) continue;
            this.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_HANDLER_LIST_SEQUENCE", new String[]{string, string2, string4, new Integer(n).toString()});
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        ArchiveInit.init();
        J2EEInit.init();
        HandlerPackageImpl.init();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to ear file.");
            return;
        }
        HandlerValidator handlerValidator = null;
        try {
            stringArray2 = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
            EARFile eARFile = stringArray2.openEARFile(stringArray[0]);
            PassthruHelper passthruHelper = new PassthruHelper();
            FullReporter fullReporter = new FullReporter();
            handlerValidator = new HandlerValidator();
            handlerValidator.validate(passthruHelper, fullReporter, null, eARFile);
            System.out.println("Validation successful");
        }
        catch (Exception exception) {
            System.out.println("Exception occured: " + exception);
            exception.printStackTrace();
        }
        try {
            System.out.println("Testing all NLS messages...");
            stringArray2 = new String[]{"<<MyTestEJBModule>>", "<<TestHandlerOrList>>", "<<TestEJB>>", "<<Param_4>>"};
            handlerValidator.addInfo("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "INFO_HANDLER_DD_NOT_FOUND", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_HANDLER_DD_LOAD_FAILED", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_NULL_HANDLER_RESOURCE", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_NOT_EJB_HANDLER", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_HANDLER_NAME", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_EJB_REFERENCE", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_HANDLER_EJB_NOT_SLSB", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_HANDLER_EJB_NO_LOCAL_INTERFACES", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_HANDLER_LIST_NAME", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_DUPLICATE_HANDLER_LIST_NAME", stringArray2);
            handlerValidator.addError("com.ibm.websphere.validation.base.extensions.handler.handlervalidation", "ERROR_INVALID_HANDLER_LIST_SEQUENCE", stringArray2);
            System.out.println("NLS Message testing complete.");
        }
        catch (Exception exception) {
            System.out.println("NLS Message test error: " + exception);
        }
    }
}

