/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level60.ServerContextCrossValidator_60;
import com.ibm.websphere.validation.base.config.level60.VariablesValidationConstants_60;
import java.util.Iterator;

public class VariablesCrossValidator_60_Default
extends ServerContextCrossValidator_60
implements VariablesValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    public static final String WAS_INSTALL_ROOT = "WAS_INSTALL_ROOT";
    public static final String USER_INSTALL_ROOT = "USER_INSTALL_ROOT";
    public static final int WAS_ROOT_OFFSET = 0;
    public static final int USER_ROOT_OFFSET = 1;

    public VariablesCrossValidator_60_Default(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.variablesvalidation_60_NLS";
    }

    public String getTraceName() {
        return "VariablesCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof VariableMap) {
            this.trace("Object recognized as a variable map; validating");
            this.validateAcross((VariableMap)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(VariableMap variableMap) {
        if (this.getServerName() != null) {
            this.checkServerForInstallPath(variableMap);
        } else if (this.getNodeName() != null) {
            this.checkNodeForInstallPath(variableMap);
        } else if (this.getCellName() != null) {
            // empty if block
        }
    }

    protected void checkServerForInstallPath(VariableMap variableMap) {
        String[] stringArray = this.selectInstallRoots(variableMap);
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (string != null) {
            this.addInfo("INFO_VARIABLE_MAP_ROOT_OVERLOADED", new String[]{WAS_INSTALL_ROOT, this.getServerName(), string}, variableMap);
        }
        if (string2 != null) {
            this.addInfo("INFO_VARIABLE_MAP_ROOT_OVERLOADED", new String[]{USER_INSTALL_ROOT, this.getServerName(), string2}, variableMap);
        }
    }

    protected void checkNodeForInstallPath(VariableMap variableMap) {
        String string;
        String string2;
        String[] stringArray = this.selectInstallRoots(variableMap);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        VariableMap variableMap2 = this.loadCellVariablesMap();
        if (variableMap2 != null) {
            String[] stringArray2 = this.selectInstallRoots(variableMap2);
            string2 = stringArray2[0];
            string = stringArray2[1];
        } else {
            string2 = null;
            string = null;
        }
        if ((string2 != null || string3 != null) && string2 != null && string3 != null) {
            if (string2.equals(string3)) {
                this.addInfo("INFO_VARIABLE_MAP_WAS_INSTALL_ROOT_OVERLOADED", new String[]{WAS_INSTALL_ROOT, this.getCellName(), this.getNodeName()}, variableMap);
            } else {
                this.addError("ERROR_VARIABLE_MAP_WAS_INSTALL_ROOT_REDEFINED", new String[]{WAS_INSTALL_ROOT, this.getCellName(), this.getNodeName(), string, string4}, variableMap);
            }
        }
        if ((string != null || string4 != null) && string != null && string3 != null) {
            if (string.equals(string4)) {
                this.addInfo("INFO_VARIABLE_MAP_USER_INSTALL_ROOT_OVERLOADED", new String[]{USER_INSTALL_ROOT, this.getCellName(), this.getNodeName()}, variableMap);
            } else {
                this.addError("ERROR_VARIABLE_MAP_USER_INSTALL_ROOT_REDEFINED", new String[]{USER_INSTALL_ROOT, this.getCellName(), this.getNodeName(), string, string4}, variableMap);
            }
        }
    }

    protected String[] selectInstallRoots(VariableMap variableMap) {
        String string = null;
        String string2 = null;
        Iterator iterator = variableMap.getEntries().iterator();
        while (iterator.hasNext()) {
            VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)iterator.next();
            String string3 = variableSubstitutionEntry.getSymbolicName();
            if (string3 == null) continue;
            if (string3.equals(WAS_INSTALL_ROOT)) {
                string = variableSubstitutionEntry.getValue();
                continue;
            }
            if (!string3.equals(USER_INSTALL_ROOT)) continue;
            string2 = variableSubstitutionEntry.getValue();
        }
        return new String[]{string, string2};
    }
}

