/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.LibraryValidationConstants_60;
import java.util.HashSet;
import java.util.Iterator;

public class LibraryValidator_60
extends WebSphereLevelValidator
implements LibraryValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public LibraryValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.libraryvalidation_60_NLS";
    }

    public String getTraceName() {
        return "LibraryValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof Library) {
            this.trace("Target identified as a Library");
            this.validateLocal((Library)object);
            this.validateAcross((Library)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(Library library) {
        String string = library.getName();
        this.traceBegin("validateAcross(Library): ", string);
        Iterator iterator = library.getClassPath().iterator();
        Iterator iterator2 = library.getNativePath().iterator();
        if (!iterator.hasNext() && !iterator2.hasNext()) {
            this.addError("ERROR_LIBRARY_NO_ENTRIES", new String[]{string}, library);
        } else {
            Object object;
            HashSet<Object> hashSet = new HashSet<Object>();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (object == null || ((String)object).length() == 0) continue;
                if (hashSet.contains(object)) {
                    if (hashSet2.contains(object)) continue;
                    hashSet2.add(object);
                    this.addError("ERROR_LIBRARY_CLASSPATH_DUPLICATION", new String[]{string, object}, library);
                    continue;
                }
                hashSet.add(object);
            }
            object = new HashSet();
            HashSet<String> hashSet3 = new HashSet<String>();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 == null || string2.length() == 0) continue;
                if (((HashSet)object).contains(string2)) {
                    if (hashSet3.contains(string2)) continue;
                    hashSet3.add(string2);
                    this.addError("ERROR_LIBRARY_NATIVECLASSPATH_DUPLICATION", new String[]{string, string2}, library);
                    continue;
                }
                ((HashSet)object).add(string2);
            }
        }
        this.traceEnd();
    }

    public void validateLocal(Library library) {
        String string = library.getName();
        this.traceBegin("validateLocal(Library): ", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_LIBRARY_MISSING_NAME", new String[]{this.getCurrentFileName()}, library);
        }
        this.traceEnd();
    }
}

