/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.coregroup.AllActivePolicy;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.models.config.coregroup.HAManagerPolicy;
import com.ibm.websphere.models.config.coregroup.MOfNPolicy;
import com.ibm.websphere.models.config.coregroup.MatchCriteria;
import com.ibm.websphere.models.config.coregroup.NoOpPolicy;
import com.ibm.websphere.models.config.coregroup.OneOfNPolicy;
import com.ibm.websphere.models.config.coregroup.PreferredServerPolicy;
import com.ibm.websphere.models.config.coregroup.StaticPolicy;
import com.ibm.websphere.models.config.coregroup.TransportType;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.CoreGroupValidationConstants_60;
import com.ibm.websphere.validation.base.config.level60.CoreGroupValidatorUtil_60;
import com.ibm.websphere.validation.base.config.level60.PolicyWorkBench;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;

public class CoreGroupValidator_60
extends WebSphereLevelValidator
implements CoreGroupValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    private List filteredCoreGroupServersList = null;
    private CoreGroupValidatorUtil_60 coreGroupValidatorUtil = new CoreGroupValidatorUtil_60(this, true);
    private static final Pattern pattern = Pattern.compile("^[^ _=|][^=|]*$");

    public CoreGroupValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.coregroupvalidation_60_NLS";
    }

    public String getTraceName() {
        return "CoreGroupValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof CoreGroup) {
            this.trace("Object recognized as an instance of CoreGroup; validating");
            CoreGroup coreGroup = (CoreGroup)object;
            this.validateLocal(coreGroup);
            this.validateAcross(coreGroup);
        } else {
            bl = object instanceof CoreGroupServer ? true : (object instanceof HAManagerPolicy ? true : (object instanceof MatchCriteria ? true : super.basicValidate(object)));
        }
        return bl;
    }

    public void validateLocal(CoreGroup coreGroup) throws ValidationException {
        EList eList;
        String string;
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = coreGroup.getName();
        if (string3 == null || string3.length() == 0) {
            this.addError("ERROR_NULL_OR_EMPTY_COREGROUP_NAME", new String[]{this.getCurrentFileName()}, coreGroup);
        } else if (!this.testName(string3)) {
            this.addError("ERROR_INVALID_COREGROUP_NAME", new String[]{string3}, coreGroup);
        }
        TransportType transportType = coreGroup.getTransportType();
        if (transportType == TransportType.CHANNEL_FRAMEWORK_LITERAL) {
            bl2 = true;
        } else if (transportType == TransportType.MULTICAST_LITERAL) {
            bl = true;
        } else if (transportType != TransportType.UNICAST_LITERAL) {
            this.addError("ERROR_INVALID_TRANSPORT_TYPE", new String[]{String.valueOf((Object)transportType), string3}, coreGroup);
        }
        if (bl) {
            String string4;
            int n = coreGroup.getMultiCastPort();
            if (n < 1025) {
                this.addError("ERROR_INVALID_MULTICASTPORT", new String[]{String.valueOf(n), string3, String.valueOf(1025)}, coreGroup);
            }
            if ((string4 = coreGroup.getMultiCastGroupIPStart()) == null || string4.length() == 0) {
                this.addError("ERROR_NULL_OR_EMPTY_MULTICASTGROUPIP_START", new String[]{string3}, coreGroup);
            }
            if ((string2 = coreGroup.getMultiCastGroupIPEnd()) == null || string2.length() == 0) {
                this.addError("ERROR_NULL_OR_EMPTY_MULTICASTGROUPIP_END", new String[]{string3}, coreGroup);
            }
        } else if (bl2 && ((string = coreGroup.getChannelChainName()) == null || string.length() == 0)) {
            this.addError("ERROR_NULL_OR_EMPTY_CHANNEL_CHAIN_NAME", new String[]{string3}, coreGroup);
        }
        if ((eList = coreGroup.getCoreGroupServers()).isEmpty()) {
            this.addInfo("INFO_EMPTY_COREGROUP_SERVERS_LIST", new String[]{string3}, coreGroup);
        }
        this.filteredCoreGroupServersList = this.coreGroupValidatorUtil.validateCoreGroupServers((List)eList, coreGroup, 1);
        int n = coreGroup.getNumCoordinators();
        if (n < 1 || n > this.filteredCoreGroupServersList.size()) {
            this.addInfo("INFO_NUM_OF_COORDINATORS_OUT_OF_RANGE", new String[]{String.valueOf(n), string3}, coreGroup);
        }
        string2 = coreGroup.getPreferredCoordinatorServers();
        List list = null;
        if (string2.isEmpty()) {
            this.addInfo("INFO_EMPTY_PREFERRED_COORDINATOR_SERVERS_LIST", new String[]{string3}, coreGroup);
        }
        list = this.coreGroupValidatorUtil.validateCoreGroupServers((List)((Object)string2), coreGroup, 2);
        this.validateCoreGroupServerContainment(list, this.filteredCoreGroupServersList, coreGroup, 2);
        EList eList2 = coreGroup.getPolicies();
        Object var11_14 = null;
        if (eList2.isEmpty()) {
            this.addInfo("INFO_EMPTY_POLICIES_LIST", new String[]{string3}, coreGroup);
        } else {
            List list2 = this.validateHAManagerPolicies((List)eList2, coreGroup);
            int n2 = list2.size();
            HAManagerPolicy hAManagerPolicy = null;
            for (int i = 0; i < n2; ++i) {
                hAManagerPolicy = (HAManagerPolicy)list2.get(i);
                this.validateLocal(hAManagerPolicy);
                this.validateAcross(hAManagerPolicy);
            }
        }
    }

    private void validateLocal(HAManagerPolicy hAManagerPolicy) throws ValidationException {
        String string;
        int n = hAManagerPolicy.getIsAlivePeriodSec();
        if (n < -1) {
            this.addError("ERROR_INVALID_ISALIVEPERIODSEC", new String[]{String.valueOf(n), hAManagerPolicy.getName(), String.valueOf(-1)}, hAManagerPolicy);
        }
        if ((string = hAManagerPolicy.getPolicyFactory()) == null || string.length() == 0) {
            this.addError("ERROR_NULL_OR_EMPTY_POLICYFACTORY", new String[]{hAManagerPolicy.getName()}, hAManagerPolicy);
        }
        if (hAManagerPolicy instanceof AllActivePolicy) {
            this.trace("Object recognized as an instance of AllActivePolicy; validating.");
            this.validateLocal((AllActivePolicy)hAManagerPolicy);
            this.validateAcross((AllActivePolicy)hAManagerPolicy);
        } else if (hAManagerPolicy instanceof NoOpPolicy) {
            this.trace("Object recognized as an instance of NoOpPolicy; validating.");
            this.validateLocal((NoOpPolicy)hAManagerPolicy);
            this.validateAcross((NoOpPolicy)hAManagerPolicy);
        } else if (hAManagerPolicy instanceof PreferredServerPolicy) {
            this.trace("Object recognized as an instance of PreferredServerPolicy; validating.");
            this.validateLocal((PreferredServerPolicy)hAManagerPolicy);
            this.validateAcross((PreferredServerPolicy)hAManagerPolicy);
        } else if (hAManagerPolicy instanceof StaticPolicy) {
            this.trace("Object recognized as an instance of StaticPolicy; validating.");
            this.validateLocal((StaticPolicy)hAManagerPolicy);
            this.validateAcross((StaticPolicy)hAManagerPolicy);
        } else {
            super.basicValidate(hAManagerPolicy);
            return;
        }
    }

    private void validateLocal(AllActivePolicy allActivePolicy) {
        String string = allActivePolicy.getPolicyFactory();
        if (string != null && string.length() != 0 && !string.equals("com.ibm.ws.hamanager.coordinator.policy.impl.AllActivePolicyFactory")) {
            this.addError("ERROR_INVALID_POLICYFACTORY_NAME", new String[]{string, allActivePolicy.getName(), "com.ibm.ws.hamanager.coordinator.policy.impl.AllActivePolicyFactory"}, allActivePolicy);
        }
    }

    private void validateLocal(NoOpPolicy noOpPolicy) {
        String string = noOpPolicy.getPolicyFactory();
        if (string != null && string.length() != 0 && !string.equals("com.ibm.ws.hamanager.coordinator.policy.impl.NOOPPolicyFactory")) {
            this.addError("ERROR_INVALID_POLICYFACTORY_NAME", new String[]{string, noOpPolicy.getName(), "com.ibm.ws.hamanager.coordinator.policy.impl.NOOPPolicyFactory"}, noOpPolicy);
        }
    }

    private void validateLocal(PreferredServerPolicy preferredServerPolicy) throws ValidationException {
        if (preferredServerPolicy instanceof OneOfNPolicy) {
            this.trace("Object recognized as an instance of OneOfNPolicy; validating.");
            this.validateLocal((OneOfNPolicy)preferredServerPolicy);
            this.validateAcross((OneOfNPolicy)preferredServerPolicy);
        } else if (preferredServerPolicy instanceof MOfNPolicy) {
            this.trace("Object recognized as an instance of MOfNPolicy; validating.");
            this.validateLocal((MOfNPolicy)preferredServerPolicy);
            this.validateAcross((MOfNPolicy)preferredServerPolicy);
        } else {
            super.basicValidate(preferredServerPolicy);
        }
    }

    private void validateLocal(OneOfNPolicy oneOfNPolicy) {
        String string = oneOfNPolicy.getPolicyFactory();
        if (string != null && string.length() != 0 && !string.equals("com.ibm.ws.hamanager.coordinator.policy.impl.OneOfNPolicyFactory")) {
            this.addError("ERROR_INVALID_POLICYFACTORY_NAME", new String[]{string, oneOfNPolicy.getName(), "com.ibm.ws.hamanager.coordinator.policy.impl.OneOfNPolicyFactory"}, oneOfNPolicy);
        }
    }

    private void validateLocal(MOfNPolicy mOfNPolicy) {
        int n;
        String string = mOfNPolicy.getPolicyFactory();
        if (string != null && string.length() != 0 && !string.equals("com.ibm.ws.hamanager.coordinator.policy.impl.MOfNPolicyFactory")) {
            this.addError("ERROR_INVALID_POLICYFACTORY_NAME", new String[]{string, mOfNPolicy.getName(), "com.ibm.ws.hamanager.coordinator.policy.impl.MOfNPolicyFactory"}, mOfNPolicy);
        }
        if ((n = mOfNPolicy.getNumActive()) < 1 || n > this.filteredCoreGroupServersList.size()) {
            this.addInfo("INFO_NUMACTIVE_OUT_OF_RANGE", new String[]{String.valueOf(n), mOfNPolicy.getName()}, mOfNPolicy);
        }
    }

    private void validateLocal(StaticPolicy staticPolicy) {
        String string = staticPolicy.getPolicyFactory();
        if (string != null && string.length() != 0 && !string.equals("com.ibm.ws.hamanager.coordinator.policy.impl.StaticPolicyFactory")) {
            this.addError("ERROR_INVALID_POLICYFACTORY_NAME", new String[]{string, staticPolicy.getName(), "com.ibm.ws.hamanager.coordinator.policy.impl.StaticPolicyFactory"}, staticPolicy);
        }
    }

    private List validateHAManagerPolicies(List list, CoreGroup coreGroup) throws ValidationException {
        int n = list.size();
        Object var4_4 = null;
        HAManagerPolicy hAManagerPolicy = null;
        String string = null;
        ArrayList<PolicyWorkBench> arrayList = new ArrayList<PolicyWorkBench>();
        Map map = null;
        int n2 = 0;
        while (n2 < n) {
            var4_4 = list.get(n2);
            if (!(var4_4 instanceof HAManagerPolicy)) {
                super.basicValidate(var4_4);
                ++n2;
                continue;
            }
            hAManagerPolicy = var4_4;
            string = hAManagerPolicy.getName();
            if (string == null || string.length() == 0) {
                this.addError("ERROR_NULL_OR_EMPTY_POLICY_NAME", new String[]{coreGroup.getName()}, hAManagerPolicy);
                ++n2;
                continue;
            }
            if (!this.testName(string)) {
                this.addError("ERROR_INVALID_POLICY_NAME", new String[]{string, coreGroup.getName()}, hAManagerPolicy);
                ++n2;
                continue;
            }
            map = this.createUniqueNameValuePairs(hAManagerPolicy);
            if (map.isEmpty()) {
                this.addInfo("INFO_EMPTY_MATCHCRITERIA_NAME_VALUE_PAIRS", new String[]{string}, hAManagerPolicy);
            }
            arrayList.add(new PolicyWorkBench(hAManagerPolicy, map));
            ++n2;
        }
        PolicyWorkBench policyWorkBench = null;
        PolicyWorkBench policyWorkBench2 = null;
        int n3 = arrayList.size();
        int n4 = 0;
        n2 = 0;
        while (n2 < n3) {
            policyWorkBench = (PolicyWorkBench)arrayList.get(n2);
            if (!policyWorkBench.consider()) {
                ++n2;
                continue;
            }
            n4 = n2 + 1;
            while (n4 < n3) {
                policyWorkBench2 = (PolicyWorkBench)arrayList.get(n4);
                if (!policyWorkBench2.consider()) {
                    ++n4;
                    continue;
                }
                if (((Object)policyWorkBench.getNameValuePairs()).equals(policyWorkBench2.getNameValuePairs())) {
                    this.addError("ERROR_DUPLICATE_POLICY_MATCHCRITERIA", new String[]{policyWorkBench.getHAManagerPolicy().getName(), policyWorkBench2.getHAManagerPolicy().getName()}, coreGroup);
                    policyWorkBench2.dontConsider();
                }
                ++n4;
            }
            ++n2;
        }
        n2 = 0;
        n4 = 0;
        policyWorkBench = null;
        policyWorkBench2 = null;
        String string2 = null;
        string = null;
        while (n2 < n3) {
            policyWorkBench = (PolicyWorkBench)arrayList.get(n2);
            if (!policyWorkBench.consider()) {
                ++n2;
                continue;
            }
            n4 = n2 + 1;
            while (n4 < n3) {
                policyWorkBench2 = (PolicyWorkBench)arrayList.get(n4);
                if (!policyWorkBench2.consider()) {
                    ++n4;
                    continue;
                }
                string = policyWorkBench.getHAManagerPolicy().getName();
                if (string.equals(string2 = policyWorkBench2.getHAManagerPolicy().getName())) {
                    this.addError("ERROR_DUPLICATE_POLICY_POLICY_NAME", new String[]{string, coreGroup.getName()}, coreGroup);
                    policyWorkBench2.dontConsider();
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList<HAManagerPolicy> arrayList2 = new ArrayList<HAManagerPolicy>();
        hAManagerPolicy = null;
        n2 = 0;
        while (n2 < n3) {
            policyWorkBench = (PolicyWorkBench)arrayList.get(n2);
            if (!policyWorkBench.consider()) {
                ++n2;
                continue;
            }
            arrayList2.add(policyWorkBench.getHAManagerPolicy());
            ++n2;
        }
        return arrayList2;
    }

    private Map createUniqueNameValuePairs(HAManagerPolicy hAManagerPolicy) throws ValidationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EList eList = hAManagerPolicy.getMatchCriteria();
        if (eList.isEmpty()) {
            this.addInfo("INFO_EMPTY_MATCHCRITERIA_LIST", new String[]{hAManagerPolicy.getName()}, hAManagerPolicy);
            return hashMap;
        }
        int n = eList.size();
        Object var5_5 = null;
        MatchCriteria matchCriteria = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            var5_5 = eList.get(n2);
            bl = false;
            if (!(var5_5 instanceof MatchCriteria)) {
                super.basicValidate(var5_5);
                ++n2;
                continue;
            }
            matchCriteria = var5_5;
            string = matchCriteria.getName();
            string2 = matchCriteria.getValue();
            if (string == null || string.length() == 0) {
                this.addError("ERROR_NULL_OR_EMPTY_MATCHCRITERIA_NAME", new String[]{string2, hAManagerPolicy.getName()}, matchCriteria);
                bl = true;
            } else if (!this.isAValidMatchCriteriaElement(string)) {
                this.addError("ERROR_INVALID_MATCHCRITERIA_NAME", new String[]{string2, hAManagerPolicy.getName()}, matchCriteria);
                bl = true;
            }
            if (string2 == null || string2.length() == 0) {
                this.addError("ERROR_NULL_OR_EMPTY_MATCHCRITERIA_VALUE", new String[]{string, hAManagerPolicy.getName()}, matchCriteria);
                bl = true;
            } else if (!this.isAValidMatchCriteriaElement(string2)) {
                this.addError("ERROR_INVALID_MATCHCRITERIA_VALUE", new String[]{string, hAManagerPolicy.getName()}, matchCriteria);
                bl = true;
            }
            if (bl) {
                ++n2;
                continue;
            }
            if (hashMap.containsKey(string)) {
                this.addError("ERROR_DUPLICATE_MATCHCRITERIA_NAME", new String[]{string, hAManagerPolicy.getName()}, hAManagerPolicy);
            }
            hashMap.put(string, string2);
            ++n2;
        }
        return hashMap;
    }

    private void validateCoreGroupServerContainment(List list, List list2, Object object, int n) {
        int n2 = list.size();
        int n3 = list2.size();
        CoreGroupServer coreGroupServer = null;
        String string = null;
        String string2 = null;
        CoreGroupServer coreGroupServer2 = null;
        boolean bl = false;
        int n4 = 0;
        block5: for (int i = 0; i < n2; ++i) {
            coreGroupServer = (CoreGroupServer)list.get(i);
            string = coreGroupServer.getNodeName();
            string2 = coreGroupServer.getServerName();
            bl = false;
            for (n4 = 0; n4 < n3; ++n4) {
                coreGroupServer2 = (CoreGroupServer)list2.get(n4);
                if (!coreGroupServer2.getNodeName().equals(string) || !coreGroupServer2.getServerName().equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            switch (n) {
                case 2: {
                    this.addError("ERROR_PREFERRED_COORDINATOR_SERVER_IS_NOT_A_COREGROUP_SERVER", new String[]{string, string2, ((CoreGroup)object).getName()}, object);
                    continue block5;
                }
                case 3: {
                    this.addError("ERROR_PREFERRED_SERVER_IS_NOT_A_COREGROUP_SERVER", new String[]{string, string2, ((PreferredServerPolicy)object).getName()}, object);
                    continue block5;
                }
                case 4: {
                    this.addError("ERROR_STATIC_SERVER_IS_NOT_A_COREGROUP_SERVER", new String[]{string, string2, ((StaticPolicy)object).getName()}, object);
                    continue block5;
                }
            }
        }
    }

    private void validateAcross(CoreGroup coreGroup) {
        EList eList = coreGroup.getCustomProperties();
        if (!eList.isEmpty()) {
            this.validateProperties(coreGroup, coreGroup.getName(), (List)eList, "ERROR_CUSTOMPROPERTY_DUPLICATION", "ERROR_CUSTOMPROPERTY_NAME_REQUIRED");
        }
    }

    private void validateAcross(HAManagerPolicy hAManagerPolicy) {
        EList eList = hAManagerPolicy.getCustomProperties();
        if (!eList.isEmpty()) {
            this.validateProperties(hAManagerPolicy, hAManagerPolicy.getName(), (List)eList, "ERROR_CUSTOMPROPERTY_DUPLICATION", "ERROR_CUSTOMPROPERTY_NAME_REQUIRED");
        }
    }

    private void validateAcross(AllActivePolicy allActivePolicy) {
    }

    private void validateAcross(NoOpPolicy noOpPolicy) {
    }

    private void validateAcross(PreferredServerPolicy preferredServerPolicy) throws ValidationException {
        EList eList = preferredServerPolicy.getPreferredServers();
        if (eList.isEmpty()) {
            this.addInfo("INFO_EMPTY_PREFERRED_SERVERS_LIST", new String[]{preferredServerPolicy.getName()}, preferredServerPolicy);
            return;
        }
        List list = this.coreGroupValidatorUtil.validateCoreGroupServers((List)eList, preferredServerPolicy, 3);
        this.validateCoreGroupServerContainment(list, this.filteredCoreGroupServersList, preferredServerPolicy, 3);
    }

    private void validateAcross(OneOfNPolicy oneOfNPolicy) {
    }

    private void validateAcross(MOfNPolicy mOfNPolicy) {
    }

    private void validateAcross(StaticPolicy staticPolicy) throws ValidationException {
        EList eList = staticPolicy.getServers();
        if (eList.isEmpty()) {
            this.addError("ERROR_EMPTY_STATIC_SERVERS_LIST", new String[]{staticPolicy.getName()}, staticPolicy);
            return;
        }
        List list = this.coreGroupValidatorUtil.validateCoreGroupServers((List)eList, staticPolicy, 4);
        this.validateCoreGroupServerContainment(list, this.filteredCoreGroupServersList, staticPolicy, 4);
    }

    private boolean isAValidMatchCriteriaElement(String string) {
        return pattern.matcher(string).matches();
    }
}

