/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level60.CoreGroupValidationConstants_60;
import com.ibm.websphere.validation.base.config.level60.CoreGroupValidatorUtil_60;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class CoreGroupCrossValidator_60
extends WebSphereLevelCrossValidator
implements CoreGroupValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    private CoreGroupValidatorUtil_60 coreGroupValidatorUtil = new CoreGroupValidatorUtil_60(this, false);
    private Map cellNodeServers = null;
    private Object[] cellNodeURIArray = null;
    private String[] cellNodeNameArray = null;

    public CoreGroupCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.coregroupvalidation_60_NLS";
    }

    public String getTraceName() {
        return "CoreGroupCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof CoreGroup) {
            this.trace("Object recognized as an instance of CoreGroup; validating");
            this.locateExistingNodeServers();
            this.validateAcross((CoreGroup)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(CoreGroup coreGroup) throws ValidationException {
        EList eList = coreGroup.getCoreGroupServers();
        if (!eList.isEmpty()) {
            List list = this.coreGroupValidatorUtil.validateCoreGroupServers((List)eList, coreGroup, 1);
            this.checkCoreGroupServerExistence(list, coreGroup);
        }
    }

    private void checkCoreGroupServerExistence(List list, CoreGroup coreGroup) {
        int n = list.size();
        CoreGroupServer coreGroupServer = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            coreGroupServer = (CoreGroupServer)list.get(i);
            string = coreGroupServer.getNodeName();
            string2 = coreGroupServer.getServerName();
            bl = false;
            for (n2 = 0; n2 < this.cellNodeNameArray.length; ++n2) {
                if (!string.equals(this.cellNodeNameArray[n2]) || !((HashSet)this.cellNodeServers.get(this.cellNodeURIArray[n2])).contains(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.addError("ERROR_NON_EXISTENT_COREGROUP_SERVER", new String[]{string, string2, coreGroup.getName()}, coreGroup);
        }
    }

    private void locateExistingNodeServers() {
        this.cellNodeServers = this.getNodeServerNames();
        Set set = this.cellNodeServers.keySet();
        this.cellNodeURIArray = set.toArray(new String[0]);
        this.cellNodeNameArray = new String[this.cellNodeURIArray.length];
        for (int i = 0; i < this.cellNodeURIArray.length; ++i) {
            this.cellNodeNameArray[i] = this.nabEndOf((String)this.cellNodeURIArray[i]).substring(1);
        }
    }
}

