/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.AuthorizationConfig;
import com.ibm.websphere.models.config.security.AuthorizationProvider;
import com.ibm.websphere.models.config.security.AuthorizationTableImpl;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.LDAPSearchFilter;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.RoleBasedAuthorization;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SWAMAuthentication;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SingleSignon;
import com.ibm.websphere.models.config.security.TAInterceptor;
import com.ibm.websphere.models.config.security.TrustAssociation;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level51.SecurityValidationConstants_51;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class SecurityNDValidator_51
extends WebSphereLevelValidator
implements SecurityValidationConstants_51 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected AuthorizationConfig _boundAuthorizationConfig;
    protected TrustAssociation _boundTrustAssociation;
    protected AuthMechanism _boundAuthMechanism;
    protected UserRegistry _boundUserRegistry;

    public SecurityNDValidator_51(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
        this.clearBindings();
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.securityvalidation_51_NLS";
    }

    public String getTraceName() {
        return "SecurityNDValidator_51";
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this.clearBindings();
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this.clearBindings();
    }

    protected void clearBindings() {
        this._boundAuthorizationConfig = null;
        this._boundTrustAssociation = null;
        this._boundAuthMechanism = null;
        this._boundUserRegistry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Object object) throws ValidationException {
        Object object2 = object;
        if (object2 instanceof AuthorizationConfig) {
            this._boundAuthorizationConfig = (AuthorizationConfig)object2;
        } else if (object2 instanceof TrustAssociation) {
            this._boundTrustAssociation = (TrustAssociation)object2;
        } else if (object2 instanceof UserRegistry) {
            this._boundUserRegistry = (UserRegistry)object2;
        }
        try {
            super.visit(object);
            Object var4_3 = null;
            if (this._boundAuthorizationConfig != null) {
                this._boundAuthorizationConfig = null;
            } else if (this._boundTrustAssociation != null) {
                this._boundTrustAssociation = null;
            } else if (this._boundUserRegistry != null) {
                this._boundUserRegistry = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this._boundAuthorizationConfig != null) {
                this._boundAuthorizationConfig = null;
            } else if (this._boundTrustAssociation != null) {
                this._boundTrustAssociation = null;
            } else if (this._boundUserRegistry != null) {
                this._boundUserRegistry = null;
            }
            throw throwable;
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof JAASConfiguration || object instanceof JAASConfigurationEntry || object instanceof JAASLoginModule) {
            return true;
        }
        boolean bl = true;
        if (object instanceof AuthorizationConfig) {
            this.trace("Object recognized as an authorization configuration; validating");
            this.validateLocal((AuthorizationConfig)object);
            this.validateAcross((AuthorizationConfig)object);
        } else if (object instanceof AuthorizationTableImpl) {
            this.trace("Object recognized as an authorization table; validating");
            this.validateLocal((AuthorizationTableImpl)object);
            this.validateAcross((AuthorizationTableImpl)object);
        } else if (object instanceof AuthorizationProvider) {
            this.trace("Object recognized as an authorization provider; validating");
            this.validateLocal((AuthorizationProvider)object);
            this.validateAcross((AuthorizationProvider)object);
        } else if (object instanceof CustomUserRegistry) {
            this.trace("Object recognized as a custom user registry; validating");
            this.validateLocal((CustomUserRegistry)object);
            this.validateAcross((CustomUserRegistry)object);
        } else if (object instanceof LDAPSearchFilter) {
            this.trace("Object recognized as an LDAP search filter; validating");
            this.validateLocal((LDAPSearchFilter)object);
            this.validateAcross((LDAPSearchFilter)object);
        } else if (object instanceof LDAPUserRegistry) {
            this.trace("Object recognized as an LDAP user registry; validating");
            this.validateLocal((LDAPUserRegistry)object);
            this.validateAcross((LDAPUserRegistry)object);
        } else if (object instanceof LTPA) {
            this.trace("Object recognized as an LTPA; validating");
            this.validateLocal((LTPA)object);
            this.validateAcross((LTPA)object);
        } else if (object instanceof LocalOSUserRegistry) {
            this.trace("Object recognized as a local OS user registry; validating");
            this.validateLocal((LocalOSUserRegistry)object);
            this.validateAcross((LocalOSUserRegistry)object);
        } else if (object instanceof RoleBasedAuthorization) {
            this.trace("Object recognized as an role based authorization; validating");
            this.validateLocal((RoleBasedAuthorization)object);
            this.validateAcross((RoleBasedAuthorization)object);
        } else if (object instanceof SWAMAuthentication) {
            this.trace("Object recognized as a security; validating");
            this.validateLocal((SWAMAuthentication)object);
            this.validateAcross((SWAMAuthentication)object);
        } else if (object instanceof Security) {
            this.trace("Object recognized as a security; validating");
            this.validateLocal((Security)object);
            this.validateAcross((Security)object);
        } else if (object instanceof SingleSignon) {
            this.trace("Object recognized as a security; validating");
            this.validateLocal((SingleSignon)object);
            this.validateAcross((SingleSignon)object);
        } else if (object instanceof SSLConfig) {
            this.trace("Object recognized as an SSL config; validating");
            this.validateLocal((SSLConfig)object);
            this.validateAcross((SSLConfig)object);
        } else if (object instanceof TrustAssociation) {
            this.trace("Object recognized as a trust association; validating");
            this.validateLocal((TrustAssociation)object);
            this.validateAcross((TrustAssociation)object);
        } else if (object instanceof TAInterceptor) {
            this.trace("Object recognized as a TA interceptor; validating");
            this.validateLocal((TAInterceptor)object);
            this.validateAcross((TAInterceptor)object);
        } else if (object instanceof AuthMechanism) {
            this.trace("Object recognized as an authentication mechanism; validating");
            this.validateLocal((AuthMechanism)object);
            this.validateAcross((AuthMechanism)object);
        } else if (object instanceof UserRegistry) {
            this.trace("Object recognized as a user registry; validating");
            this.validateLocal((UserRegistry)object);
            this.validateAcross((UserRegistry)object);
        } else if (object instanceof CryptoHardwareToken) {
            this.trace("Object recognized as a crypto-hardware token; validating");
            this.validateLocal((CryptoHardwareToken)object);
            this.validateAcross((CryptoHardwareToken)object);
        } else if (object instanceof SecureSocketLayer) {
            this.trace("Object recognized as a secure socket layer; validating");
            this.validateLocal((SecureSocketLayer)object);
            this.validateAcross((SecureSocketLayer)object);
        } else if (object instanceof JAASAuthData) {
            this.trace("Object recognized as a user registry; validating");
            this.validateLocal((JAASAuthData)object);
            this.validateAcross((JAASAuthData)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcross(AuthorizationConfig authorizationConfig) {
        this.validateProviderNameDuplication(authorizationConfig);
    }

    protected void validateProviderNameDuplication(AuthorizationConfig authorizationConfig) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((AuthorizationProvider)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_AUTHORIZATION_PROVIDER_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)authorizationConfig.getAuthorizationProviders(), false, this, authorizationConfig);
    }

    protected void validateAcross(AuthorizationTableImpl authorizationTableImpl) {
    }

    public void validateAcross(AuthMechanism authMechanism) {
    }

    protected void validateAcross(AuthorizationProvider authorizationProvider) {
    }

    public void validateAcross(CustomUserRegistry customUserRegistry) {
        this.validateAcross((UserRegistry)customUserRegistry);
    }

    public void validateAcross(LDAPSearchFilter lDAPSearchFilter) {
    }

    public void validateAcross(LDAPUserRegistry lDAPUserRegistry) {
        LDAPSearchFilter lDAPSearchFilter = lDAPUserRegistry.getSearchFilter();
        if (lDAPSearchFilter == null) {
            this.addError("ERROR_LDAP_USER_REGISTRY_LDAP_SEARCH_FILTER_ABSENT", new String[]{lDAPUserRegistry.getServerId()}, lDAPUserRegistry);
        }
        if (lDAPUserRegistry.getHosts().isEmpty()) {
            this.addError("ERROR_LDAP_USER_REGISTRY_HOST_REQUIRED", new String[]{lDAPUserRegistry.getServerId()}, lDAPUserRegistry);
        }
        this.validateLDAPHosts(lDAPUserRegistry);
        this.validateAcross((UserRegistry)lDAPUserRegistry);
    }

    protected void validateLDAPHosts(LDAPUserRegistry lDAPUserRegistry) {
        this.traceBegin("validateLDAPHosts(LDAPUserRegistry)");
        HashMap hashMap = new HashMap();
        Iterator iterator = lDAPUserRegistry.getHosts().iterator();
        while (iterator.hasNext()) {
            EndPoint endPoint = (EndPoint)iterator.next();
            if (endPoint.getHost() == null) continue;
            this.checkLDAPEndPoint(lDAPUserRegistry, hashMap, endPoint);
        }
        this.traceEnd();
    }

    protected void checkLDAPEndPoint(LDAPUserRegistry lDAPUserRegistry, HashMap hashMap, EndPoint endPoint) {
        String string = lDAPUserRegistry.getServerId();
        String string2 = endPoint.getHost();
        int n = endPoint.getPort();
        this.traceBegin("checkDLAPEndPoint(Hashtable, EndPoint)");
        this.trace("Host: ", string2);
        this.trace("Port: ", String.valueOf(n));
        Hashtable<String, EndPoint> hashtable = (Hashtable<String, EndPoint>)hashMap.get(String.valueOf(n));
        if (hashtable == null) {
            this.trace("First host using port");
            hashtable = new Hashtable<String, EndPoint>();
            hashtable.put(string2, endPoint);
            hashMap.put(String.valueOf(n), hashtable);
        } else {
            String string3;
            if (string2.equals("*")) {
                this.trace("Conflict of global host with existing host");
                string3 = "ERROR_LDAP_GLOBAL_PORT_CONFLICT";
            } else if (hashtable.containsKey("*")) {
                this.trace("Conflict of host with existing global host");
                string3 = "ERROR_LDAP_CONFLICT_WITH_GLOBAL_PORT";
            } else if (hashtable.containsKey(string2)) {
                this.trace("Conflict of host with existing host");
                string3 = "ERROR_LDAP_PORT_CONFLICT";
            } else {
                this.trace("New occurrance on host");
                string3 = null;
            }
            if (string3 != null) {
                this.addError(string3, new String[]{string, string2, String.valueOf(n)}, endPoint);
            } else {
                hashtable.put(string2, endPoint);
            }
        }
        this.traceEnd();
    }

    public void validateAcross(LTPA lTPA) {
        if (lTPA.getShared() == null) {
            this.addError("ERROR_LTPA_SHARED_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        if (lTPA.getPublic() == null) {
            this.addError("ERROR_LTPA_PUBLIC_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        if (lTPA.getPrivate() == null) {
            this.addError("ERROR_LTPA_PRIVATE_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        this.validateAcross((AuthMechanism)lTPA);
    }

    public void validateAcross(LocalOSUserRegistry localOSUserRegistry) {
        this.validateAcross((UserRegistry)localOSUserRegistry);
    }

    protected void validateAcross(RoleBasedAuthorization roleBasedAuthorization) {
    }

    public void validateAcross(SWAMAuthentication sWAMAuthentication) {
        this.traceStub("Cross validation of SWAMAuthentication values.");
        this.validateAcross((AuthMechanism)sWAMAuthentication);
    }

    public void validateAcross(Security security) {
        UserRegistry userRegistry;
        String string;
        if (security.getCSI() == null) {
            this.addError("ERROR_SECURITY_CSI_REQUIRED", new String[]{this.getCurrentFileName()}, security);
        }
        if (security.getIBM() == null) {
            this.addError("ERROR_SECURITY_IBM_REQUIRED", new String[]{this.getCurrentFileName()}, security);
        }
        if (security.getSystemLoginConfig() == null) {
            this.addError("ERROR_SECURITY_SYSTEM_LOGIN_CONFIGURATION_REQUIRED", new String[]{this.getCurrentFileName()}, security);
        } else {
            this.validateAcross(security.getSystemLoginConfig(), true);
        }
        if (security.getApplicationLoginConfig() == null) {
            this.addError("ERROR_SECURITY_APPLICATION_LOGIN_CONFIGURATION_REQUIRED", new String[]{this.getCurrentFileName()}, security);
        } else {
            this.validateAcross(security.getApplicationLoginConfig(), false);
        }
        boolean bl = security.isEnabled();
        if (bl && ((string = (userRegistry = security.getActiveUserRegistry()).getServerId()) == null || string.length() == 0)) {
            this.addError("ERROR_USER_REGISTRY_SERVER_ID_REQUIRED", new String[]{this.getCurrentFileName()}, userRegistry);
        }
        this.validateCacheTimeouts(security);
        this.validateSSLConfigAliasDuplication(security);
        this.validateSSLAuthenticationOIDDuplication(security);
        this.validateUserIDDuplication(security);
        this.validateRoleNameDuplication(security);
    }

    protected void validateCacheTimeouts(Security security) {
        int n = security.getCacheTimeout();
        if (n < 1) {
            return;
        }
        Iterator iterator = security.getAuthMechanisms().iterator();
        while (iterator.hasNext()) {
            LTPA lTPA;
            long l;
            AuthMechanism authMechanism = (AuthMechanism)iterator.next();
            if (!(authMechanism instanceof LTPA) || (l = (lTPA = (LTPA)authMechanism).getTimeout()) <= 0L || (long)n >= l) continue;
            this.addError("ERROR_LTPA_SECURITY_CACHE_TIMEOUT_LESS_THAN_LTPA_TIMEOUT", new String[]{this.getCurrentFileName(), String.valueOf(n), lTPA.getOID(), String.valueOf(l)}, lTPA);
        }
    }

    protected void validateSSLConfigAliasDuplication(Security security) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((SSLConfig)eObject).getAlias().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_SSL_CONFIG_ALIAS_DUPLICATION";
            }
        };
        duplicationTester.test((List)security.getRepertoire(), false, this, security);
    }

    protected void validateSSLAuthenticationOIDDuplication(Security security) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((AuthMechanism)eObject).getOID();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_AUTH_MECHANISM_OID_DUPLICATION";
            }
        };
        duplicationTester.test((List)security.getAuthMechanisms(), false, this, security);
    }

    protected void validateUserIDDuplication(Security security) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((JAASAuthData)eObject).getUserId().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_JAAS_AUTH_DATA_USER_ID_DUPLICATION";
            }
        };
        duplicationTester.test((List)security.getAuthDataEntries(), false, this, security);
    }

    protected void validateRoleNameDuplication(Security security) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((RoleBasedAuthorization)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_ROLE_AUTHORIZATION_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security.getRoleBasedAuthorization(), false, this, security);
    }

    protected HashSet getAliasTable(Security security) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = security.getRepertoire().iterator();
        while (iterator.hasNext()) {
            SSLConfig sSLConfig = (SSLConfig)iterator.next();
            String string = sSLConfig.getAlias();
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void validateAcross(SingleSignon singleSignon) {
    }

    protected void validateAcross(TrustAssociation trustAssociation) {
        this.validateInterceptorClassNameDuplication(trustAssociation);
    }

    protected void validateInterceptorClassNameDuplication(TrustAssociation trustAssociation) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((TAInterceptor)eObject).getInterceptorClassName();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_TA_INTERCEPTOR_CLASS_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)trustAssociation.getInterceptors(), false, this, trustAssociation);
    }

    protected void validateAcross(TAInterceptor tAInterceptor) {
        this.validateProperties(tAInterceptor, null, (List)tAInterceptor.getTrustProperties(), "ERROR_TA_INTERCEPTOR_PROPERTY_DUPLICATION", "ERROR_TA_INTERCEPTOR_PROPERTY_NAME_ABSENT");
    }

    protected void validateAcross(UserRegistry userRegistry) {
        this.validateProperties(userRegistry, null, (List)userRegistry.getProperties(), "ERROR_USER_REGISTRY_PROPERTY_DUPLICATION", "ERROR_USER_REGISTRY_PROPERTY_NAME_ABSENT");
    }

    public void validateAcross(CryptoHardwareToken cryptoHardwareToken) {
    }

    public void validateAcross(SecureSocketLayer secureSocketLayer) {
        this.traceStub("validateAcross(SecureSocketLayer)");
    }

    protected void validateAcross(JAASAuthData jAASAuthData) {
    }

    protected void validateAcross(JAASConfiguration jAASConfiguration, boolean bl) {
        this.validateJAASAliasDuplication(jAASConfiguration, bl);
        Iterator iterator = jAASConfiguration.getEntries().iterator();
        while (iterator.hasNext()) {
            JAASConfigurationEntry jAASConfigurationEntry = (JAASConfigurationEntry)iterator.next();
            this.validateLocal(jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    protected void validateJAASAliasDuplication(JAASConfiguration jAASConfiguration, final boolean bl) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((JAASConfigurationEntry)eObject).getAlias();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                if (bl) {
                    return "ERROR_SYSTEM_JAAS_CONFIGURATION_ENTRY_ALIAS_DUPLICATION";
                }
                return "ERROR_APPLICATION_JAAS_CONFIGURATION_ENTRY_ALIAS_DUPLICATION";
            }
        };
        duplicationTester.test((List)jAASConfiguration.getEntries(), false, this, jAASConfiguration);
    }

    public void validateAcross(JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        Iterator iterator = jAASConfigurationEntry.getLoginModules().iterator();
        while (iterator.hasNext()) {
            JAASLoginModule jAASLoginModule = (JAASLoginModule)iterator.next();
            this.validateAcross(jAASLoginModule, jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    public void validateAcross(JAASLoginModule jAASLoginModule, JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        String string = bl ? "ERROR_SYSTEM_JAAS_LOGIN_MODULE_PROPERTY_DUPLICATION" : "ERROR_APPLICATION_JAAS_LOGIN_MODULE_PROPERTY_DUPLICATION";
        String string2 = bl ? "ERROR_SYSTEM_JAAS_LOGIN_MODULE_PROPERTY_NAME_ABSENT" : "ERROR_APPLICATION_JAAS_LOGIN_MODULE_PROPERTY_NAME_ABSENT";
        this.validateProperties(jAASLoginModule, null, (List)jAASLoginModule.getOptions(), string, string2);
    }

    protected void validateAcross(SSLConfig sSLConfig) {
        if (sSLConfig.getSetting() == null) {
            this.addError("ERROR_SSL_CONFIG_SETTING_REQUIRED", new String[]{sSLConfig.getAlias()}, sSLConfig);
        }
    }

    protected void validateLocal(AuthorizationConfig authorizationConfig) {
    }

    protected void validateLocal(AuthorizationTableImpl authorizationTableImpl) {
        String string = authorizationTableImpl.getClassName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_TABLE_CLASS_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, authorizationTableImpl);
        }
    }

    public void validateLocal(AuthMechanism authMechanism) {
        String string = authMechanism.getOID();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_AUTH_MECHANISM_OID_REQUIRED", authMechanism);
        }
    }

    protected void validateLocal(AuthorizationProvider authorizationProvider) {
        String string;
        String string2;
        String string3;
        String string4 = authorizationProvider.getName();
        if (string4 == null || string4.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_PROVIDER_NAME_REQUIRED", authorizationProvider);
        }
        if ((string3 = authorizationProvider.getJ2eePolicyImplClassName()) == null || string3.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_PROVIDER_POLICY_CLASS_NAME_REQUIRED", new String[]{string4}, authorizationProvider);
        }
        if ((string2 = authorizationProvider.getPolicyConfigurationImplClassName()) == null || string2.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_PROVIDER_POLICY_CONFIGURATION_CLASS_NAME_REQUIRED", new String[]{string4}, authorizationProvider);
        }
        if ((string = authorizationProvider.getRoleAssignmentConfigImplClassName()) == null || string.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_PROVIDER_ROLE_CONFIGURATION_CLASS_NAME_REQUIRED", new String[]{string4}, authorizationProvider);
        }
    }

    public void validateLocal(CustomUserRegistry customUserRegistry) {
        this.validateLocal((UserRegistry)customUserRegistry);
    }

    public void validateLocal(LDAPSearchFilter lDAPSearchFilter) {
        this.traceStub("Local validation of LDAP search filter values.");
    }

    public void validateLocal(LDAPUserRegistry lDAPUserRegistry) {
        int n = lDAPUserRegistry.getType().getValue();
        if (!this.testLDAPDirectoryType(n)) {
            this.addError("ERROR_LDAP_USER_REGISTRY_TYPE_INVALID", new String[]{lDAPUserRegistry.getServerId(), String.valueOf(n)}, lDAPUserRegistry);
        }
    }

    public void validateLocal(LTPA lTPA) {
        this.traceStub("Local validation of LTPA values; (advanced edition).");
        this.validateLocal((AuthMechanism)lTPA);
    }

    public void validateLocal(LocalOSUserRegistry localOSUserRegistry) {
        this.validateLocal((UserRegistry)localOSUserRegistry);
    }

    protected void validateLocal(RoleBasedAuthorization roleBasedAuthorization) {
        String string = roleBasedAuthorization.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_ROLE_BASED_AUTHORIZATION_NAME_REQUIRED", roleBasedAuthorization);
        }
    }

    public void validateLocal(SWAMAuthentication sWAMAuthentication) {
        this.traceStub("Local validation of SWAMAuthentication values.");
        this.validateLocal((AuthMechanism)sWAMAuthentication);
    }

    public void validateLocal(Security security) {
        boolean bl = security.isEnabled();
        int n = security.getActiveProtocol().getValue();
        if (!this.testIIOPSecurityProtocolKind(n)) {
            this.addError("ERROR_SECURITY_ACTIVE_PROTOCOL_INVALID", new String[]{this.getCurrentFileName(), String.valueOf(n)}, security);
        }
        int n2 = security.getCacheTimeout();
        this.testIntegerMin(new Integer(n2), "ERROR_SECURITY_CACHE_TIMEOUT_REQUIRED", 1, "ERROR_SECURITY_CACHE_TIMEOUT_INVALID", (Object)security);
        if (n2 > 0 && n2 < 30) {
            this.addWarning("WARNING_SECURITY_CACHE_TIMEOUT_TOO_LOW", new String[]{this.getCurrentFileName(), String.valueOf(n2), new Integer(30).toString()}, security);
        }
        if (security.getSystemLoginConfig() != null) {
            this.validateLocal(security.getSystemLoginConfig(), true);
        }
        if (security.getApplicationLoginConfig() != null) {
            this.validateLocal(security.getApplicationLoginConfig(), false);
        }
    }

    public void validateLocal(SingleSignon singleSignon) {
    }

    protected void validateLocal(SSLConfig sSLConfig) {
        String string = sSLConfig.getAlias();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_SSL_CONFIG_ALIAS_REQUIRED", sSLConfig);
        }
    }

    protected void validateLocal(TrustAssociation trustAssociation) {
    }

    protected void validateLocal(TAInterceptor tAInterceptor) {
        String string = tAInterceptor.getInterceptorClassName();
        if (string == null || string.length() == 0) {
            if (this._boundAuthMechanism == null) {
                this.addError("ERROR_SECURITY_TA_INTERCEPTOR_CLASS_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, tAInterceptor);
            } else {
                this.addError("ERROR_AUTH_MECHANISM_TA_INTERCEPTOR_CLASS_NAME_REQUIRED", new String[]{this._boundAuthMechanism.getOID()}, tAInterceptor);
            }
        }
    }

    public void validateLocal(UserRegistry userRegistry) {
    }

    public void validateLocal(CryptoHardwareToken cryptoHardwareToken) {
        this.traceStub("Local validation of crypto-hardware token values.");
    }

    public void validateLocal(SecureSocketLayer secureSocketLayer) {
        this.traceStub("Local validation of secure socket layer values.");
    }

    public void validateLocal(JAASAuthData jAASAuthData) {
        String string = jAASAuthData.getAlias();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_JAAS_AUTH_DATA_ALIAS_REQUIRED", jAASAuthData);
        }
    }

    public void validateLocal(JAASConfiguration jAASConfiguration, boolean bl) {
        this.traceStub("Local validation of JAASConfiguration values.");
        Iterator iterator = jAASConfiguration.getEntries().iterator();
        while (iterator.hasNext()) {
            JAASConfigurationEntry jAASConfigurationEntry = (JAASConfigurationEntry)iterator.next();
            this.validateLocal(jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    public void validateLocal(JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        String string = jAASConfigurationEntry.getAlias();
        if (string == null || string.length() == 0) {
            if (bl) {
                this.addError("ERROR_SYSTEM_JAAS_CONFIGURATION_ENTRY_ALIAS_REQUIRED", jAASConfigurationEntry);
            } else {
                this.addError("ERROR_APPLICATION_JAAS_CONFIGURATION_ENTRY_ALIAS_REQUIRED", jAASConfigurationEntry);
            }
        }
        Iterator iterator = jAASConfigurationEntry.getLoginModules().iterator();
        while (iterator.hasNext()) {
            JAASLoginModule jAASLoginModule = (JAASLoginModule)iterator.next();
            this.validateLocal(jAASLoginModule, jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    public void validateLocal(JAASLoginModule jAASLoginModule, JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        int n;
        String string = jAASLoginModule.getModuleClassName();
        if (string == null || string.length() == 0) {
            if (bl) {
                this.addError("ERROR_SYSTEM_JAAS_LOGIN_MODULE_CLASS_NAME_REQUIRED", new String[]{jAASConfigurationEntry.getAlias()}, jAASLoginModule);
            } else {
                this.addError("ERROR_APPLICATIOn_JAAS_LOGIN_MODULE_CLASS_NAME_REQUIRED", new String[]{jAASConfigurationEntry.getAlias()}, jAASLoginModule);
            }
        }
        if (!this.testJAASModuleControlFlag(n = jAASLoginModule.getAuthenticationStrategy().getValue())) {
            if (bl) {
                this.addError("ERROR_SYSTEM_JAAS_LOGIN_MODULE_AUTHENTICATION_STRATEGY_INVALID", new String[]{jAASConfigurationEntry.getAlias(), string, String.valueOf(n)}, jAASLoginModule);
            } else {
                this.addError("ERROR_APPLICATION_JAAS_LOGIN_MODULE_AUTHENTICATION_STRATEGY_INVALID", new String[]{jAASConfigurationEntry.getAlias(), string, String.valueOf(n)}, jAASLoginModule);
            }
        }
    }

    public boolean testJAASModuleControlFlag(int n) {
        return true;
    }

    public boolean testIIOPSecurityProtocolKind(int n) {
        return true;
    }

    public boolean testLDAPDirectoryType(int n) {
        return true;
    }
}

