/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level502;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.ForeignCell;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level502.CellValidationConstants_502;
import java.util.List;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;

public class CellValidator_502
extends WebSphereLevelValidator
implements CellValidationConstants_502 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected Cell _boundCell = null;

    public CellValidator_502(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._boundCell = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._boundCell = null;
    }

    protected void bindCell(Cell cell) {
        this._boundCell = cell;
    }

    protected Cell getBoundCell() {
        return this._boundCell;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level502.cellvalidation_502_NLS";
    }

    public String getTraceName() {
        return "CellValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof Cell) {
            this.trace("Object recognized as an cell; validating");
            this.bindCell((Cell)object);
            this.validateLocal((Cell)object);
            this.validateAcross((Cell)object);
        } else if (object instanceof ForeignCell) {
            this.trace("Object recognized as an foreign cell; validating");
            this.validateLocal((ForeignCell)object);
            this.validateAcross((ForeignCell)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(ForeignCell foreignCell) {
        if (foreignCell.getBootstrapAddress() == null) {
            this.addError("ERROR_CELL_BOOTSTRAP_ADDRESS_REQUIRED", new String[]{foreignCell.getName()}, foreignCell);
        }
    }

    public void validateAcross(Cell cell) {
        this.validateProperties(cell, cell.getName(), (List)cell.getProperties(), "ERROR_CELL_PROPERTY_DUPLICATION", "ERROR_CELL_PROPERTY_NAME_REQUIRED");
        this.validateCellForeignCellNames(cell);
    }

    public void validateCellForeignCellNames(Cell cell) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((ForeignCell)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_CELL_FOREIGN_CELL_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)cell.getForeignCells(), false, this, cell);
    }

    public void validateLocal(ForeignCell foreignCell) {
        String string = foreignCell.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_FOREIGN_CELL_NAME_REQUIRED", new String[]{this.getBoundCell().getName()}, foreignCell);
        }
    }

    public void validateLocal(Cell cell) {
        IpcPackage ipcPackage;
        EEnum eEnum;
        int n;
        String string = cell.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_CELL_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, cell);
        }
        if (!this.isEnumValueValid(n = cell.getCellDiscoveryProtocol().getValue(), eEnum = (ipcPackage = IpcPackage.eINSTANCE).getTCPIPProtocolType())) {
            this.addError("ERROR_CELL_DISCOVERY_PROTOCOL_INVALID", new String[]{String.valueOf(n), string}, cell);
        }
    }
}

