/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.datareplicationserver.SystemMessageServer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.validation.base.config.MOFValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class WorkSpaceHelper {
    public static final String pgmVersion = "%G%";
    public static final String pgmUpdate = "%I%";
    protected MOFValidator _parentValidator;
    public boolean _computedCellData;
    protected String _cellPath;
    protected String _cellName;
    protected String _nodePath;
    protected String _nodeName;
    protected String _serverPath;
    protected String _serverName;
    protected List _clusterPaths;
    protected List _clusterNames;
    protected List _nodeGroupPaths;
    protected List _nodeGroupNames;
    protected HashMap _nodePaths;
    protected HashSet _nodeNames;
    protected List _applicationPaths;
    protected List _applicationNames;
    protected HashSet _coreGroupNames;
    protected HashMap _coreGroupPaths;
    protected boolean _loadedAllServerIndices;
    protected HashSet _loadedServerIndexNames;
    protected HashMap _loadedServerIndices;
    protected boolean _computedNodeServerIndex;
    protected ServerIndex _nodeServerIndex;
    protected boolean _computedNodeServerType;
    protected ServerEntry _nodeServerEntry;
    protected String _nodeServerType;
    protected boolean _computedMultiBrokerData;
    protected List _multibrokerDomains;
    protected boolean _computedNodeServerData;
    protected HashMap _nodeServerPaths;
    protected HashMap _nodeServerNames;
    protected List _nodeSystemMessageServers;
    protected HashMap _nodeNodeAgents;
    protected boolean _computedDeploymentMap;
    protected HashMap _deploymentMap;
    protected boolean _computedCellSecurityData;
    protected Security _cellSecurity;
    protected HashSet _cellSecurityAliasTable;
    protected HashSet _cellSecurityJAASAuthDataTable;
    protected boolean _loadedAllCoreGroups;
    protected HashSet _loadedCoreGroupNames;
    protected HashMap _loadedCoreGroups;
    public static final int SYSTEM_MESSAGE_SERVER_DATA_NODE_NAME_OFFSET = 0;
    public static final int SYSTEM_MESSAGE_SERVER_DATA_SERVER_NAME_OFFSET = 1;
    public static final int SYSTEM_MESSAGE_SERVER_DATA_SERVER_OFFSET = 2;
    public static final int SYSTEM_MESSAGE_SERVER_DATA_COMPONENT_OFFSET = 3;
    public static final String CELL_DOCUMENT_NAME = "cell.xml";
    public static final String CLUSTERS_DOCUMENT_NAME = "clusters.xml";
    public static final String VARIABLES_XML = "variables.xml";
    public static final String MULTIBROKER_XML = "multibroker.xml";
    public static final String SECURITY_XML = "security.xml";
    public static final String SERVERINDEX_XML = "serverindex.xml";
    public static final String SERVER_XML = "server.xml";
    public static final String DEPLOYMENT_XML = "deployment.xml";
    protected HashSet _directAttempts;
    protected HashMap _directDocuments;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$variables$VariableMap;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$security$Security;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$multibroker$MultibrokerDomain;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$coregroup$CoreGroup;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$serverindex$ServerIndex;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$process$Server;

    public WorkSpaceHelper(MOFValidator mOFValidator) {
        this._parentValidator = mOFValidator;
        this.clear();
    }

    public void clear() {
        this.clearCellData();
        this.clearServerIndexStorage();
        this.clearServerTypeData();
        this.clearMultiBrokerData();
        this.clearCellSecurityData();
        this.clearNodeServerData();
        this.clearDeploymentMap();
        this.clearCoreGroupStorage();
        this.clearDirectDocuments();
    }

    public MOFValidator getParentValidator() {
        return this._parentValidator;
    }

    public String getCurrentFileName() {
        return this._parentValidator.getCurrentFileName();
    }

    public String nabHeadOf(String string) {
        return this._parentValidator.nabHeadOf(string);
    }

    public String nabEndOf(String string) {
        return this._parentValidator.nabEndOf(string);
    }

    public String nabEndOfNoSlash(String string) {
        return this._parentValidator.nabEndOfNoSlash(string);
    }

    public Object loadModel(String string) {
        return this._parentValidator.loadModel(string);
    }

    public Object loadModel(String string, Class clazz) {
        return this._parentValidator.loadModel(string, clazz);
    }

    public void addError(String string, String string2, String[] stringArray, Object object) {
        this._parentValidator.addError(string, string2, stringArray, object);
    }

    public void trace(Object object, Object object2) {
        this._parentValidator.trace(object, object2);
    }

    public void trace(Object object) {
        this._parentValidator.trace(object);
    }

    public boolean isTemplate(String string) {
        return string.startsWith("templates");
    }

    public void clearCellData() {
        this._computedCellData = false;
        this._cellPath = null;
        this._cellName = null;
        this._nodePath = null;
        this._nodeName = null;
        this._serverPath = null;
        this._serverName = null;
        this._nodePaths = null;
        this._nodeNames = null;
        this._clusterPaths = null;
        this._clusterNames = null;
        this._nodeGroupPaths = null;
        this._nodeGroupNames = null;
        this._applicationPaths = null;
        this._applicationNames = null;
        this._coreGroupNames = null;
        this._coreGroupPaths = null;
    }

    public void ensureCellData() {
        if (!this._computedCellData) {
            this._computedCellData = true;
            this.computeCellData();
        }
    }

    public void computeCellData() {
        Iterator iterator;
        this.trace("Computing cell data:");
        String string = this.getCurrentFileName();
        this.trace("Current file path: ", string);
        if (!string.startsWith("cells/")) {
            this.trace("Not beneath cells: ", string);
            return;
        }
        string = string.substring("cells/".length());
        this._cellName = this.nabHeadOf(string);
        this._cellPath = "cells/" + this._cellName;
        this.trace("Cell name: " + this._cellName);
        this.trace("Cell path: " + this._cellPath);
        if (string.length() > this._cellName.length()) {
            if ((string = string.substring(this._cellName.length() + 1)).startsWith("nodes/")) {
                string = string.substring("nodes/".length());
                this._nodeName = this.nabHeadOf(string);
                this._nodePath = this._cellPath + "/nodes/" + this._nodeName;
                this.trace("Node name: " + this._nodeName);
                this.trace("Node path: " + this._nodePath);
                if (string.length() > this._nodeName.length() && (string = string.substring(this._nodeName.length() + 1)).startsWith("servers/")) {
                    string = string.substring("servers/".length());
                    this._serverName = this.nabHeadOf(string);
                    this._serverPath = this._nodePath + "/servers/" + this._serverName;
                    this.trace("Server name: " + this._serverName);
                    this.trace("Server path: " + this._serverPath);
                }
                if (this._serverName == null) {
                    this.trace("Not beneath a server");
                }
            } else {
                this.trace("Not beneath a node");
            }
        } else {
            this.trace("Not beneath a node");
        }
        this._nodePaths = new HashMap();
        this._nodeNames = new HashSet();
        this._clusterPaths = new ArrayList();
        this._clusterNames = new ArrayList();
        this._nodeGroupPaths = new ArrayList();
        this._nodeGroupNames = new ArrayList();
        this._applicationPaths = new ArrayList();
        this._applicationNames = new ArrayList();
        this._coreGroupNames = new HashSet();
        this._coreGroupPaths = new HashMap();
        int n = this._cellPath.length() + 1;
        Object object = this.loadModel(this._cellPath);
        if (object instanceof List) {
            iterator = ((List)object).iterator();
        } else {
            this.trace("Unable to load cell context listing.");
            iterator = new ArrayList().iterator();
        }
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            String string4 = string3.substring(n);
            this.trace("Cell listing: ", string3);
            if (string4.startsWith("nodes/")) {
                string2 = string4.substring("nodes/".length());
                this._nodeNames.add(string2);
                this._nodePaths.put(string2, string3);
                this.trace("Added node: ", string2);
                continue;
            }
            if (string4.startsWith("clusters/")) {
                this._clusterPaths.add(string3);
                string2 = string4.substring("clusters/".length());
                this._clusterNames.add(string2);
                this.trace("Added cluster: ", string2);
                continue;
            }
            if (string4.startsWith("nodegroups/")) {
                this._nodeGroupPaths.add(string3);
                string2 = string4.substring("nodegroups/".length());
                this._nodeGroupNames.add(string2);
                this.trace("Added node group: ", string2);
                continue;
            }
            if (string4.startsWith("applications/")) {
                this._applicationPaths.add(string3);
                string2 = string4.substring("applications/".length());
                this._applicationNames.add(string2);
                this.trace("Added application: ", string2);
                continue;
            }
            if (!string4.startsWith("coregroups/")) continue;
            string2 = string4.substring("coregroups/".length());
            this._coreGroupNames.add(string2);
            this._coreGroupPaths.put(string2, string3);
            this.trace("Added core group: ", string2);
        }
    }

    public String getCellUri() {
        this.ensureCellData();
        return this._cellPath;
    }

    public String getCellName() {
        this.ensureCellData();
        return this._cellName;
    }

    public String getNodeUri() {
        this.ensureCellData();
        return this._nodePath;
    }

    public String getNodeName() {
        this.ensureCellData();
        return this._nodeName;
    }

    public String getServerUri() {
        this.ensureCellData();
        return this._serverPath;
    }

    public String getServerName() {
        this.ensureCellData();
        return this._serverName;
    }

    public String getNodeUri(String string) {
        return (String)this.getNodeUris().get(string);
    }

    public HashMap getNodeUris() {
        this.ensureCellData();
        return this._nodePaths;
    }

    public HashSet getNodeNames() {
        this.ensureCellData();
        return this._nodeNames;
    }

    public List getClusterUris() {
        this.ensureCellData();
        return this._clusterPaths;
    }

    public List getNodeGroupUris() {
        this.ensureCellData();
        return this._nodeGroupPaths;
    }

    public List getNodeGroupNames() {
        this.ensureCellData();
        return this._nodeGroupNames;
    }

    public List getClusterNames() {
        this.ensureCellData();
        return this._clusterNames;
    }

    public List getApplicationUris() {
        this.ensureCellData();
        return this._applicationPaths;
    }

    public List getApplicationNames() {
        this.ensureCellData();
        return this._applicationNames;
    }

    public HashSet getCoreGroupNames() {
        this.ensureCellData();
        return this._coreGroupNames;
    }

    public boolean hasNamedCoreGroup(String string) {
        return this.getCoreGroupNames().contains(string);
    }

    public HashMap getCoreGroupUris() {
        this.ensureCellData();
        return this._coreGroupPaths;
    }

    public String getCoreGroupUri(String string) {
        return (String)this.getCoreGroupUris().get(string);
    }

    public ServerEntry getServerEntry(String string, String string2) {
        ServerIndex serverIndex = this.getServerIndex(string);
        if (serverIndex == null) {
            return null;
        }
        Iterator iterator = serverIndex.getServerEntries().iterator();
        ServerEntry serverEntry = null;
        while (serverEntry == null && iterator.hasNext()) {
            ServerEntry serverEntry2 = (ServerEntry)iterator.next();
            String string3 = serverEntry2.getServerName();
            if (!string3.equals(string3)) continue;
            serverEntry = serverEntry2;
        }
        return serverEntry;
    }

    public void clearServerIndexStorage() {
        this._loadedAllServerIndices = false;
        this._loadedServerIndexNames = null;
        this._loadedServerIndices = null;
    }

    public void ensureServerIndexStorage() {
        if (this._loadedServerIndexNames == null) {
            this._loadedAllServerIndices = false;
            this._loadedServerIndexNames = new HashSet();
            this._loadedServerIndices = new HashMap();
        }
    }

    public ServerIndex getServerIndex(String string) {
        this.ensureServerIndexStorage();
        if (this._loadedServerIndexNames.contains(string)) {
            return (ServerIndex)this._loadedServerIndices.get(string);
        }
        return this.loadServerIndex(string);
    }

    public ServerIndex loadServerIndex(String string) {
        this._loadedServerIndexNames.add(string);
        String string2 = this.getServerIndexUri(string);
        ServerIndex serverIndex = this.basicLoadServerIndex(string2);
        if (serverIndex != null) {
            this._loadedServerIndices.put(string, serverIndex);
        }
        return serverIndex;
    }

    public void loadServerIndices() {
        if (!this._loadedAllServerIndices) {
            this._loadedAllServerIndices = true;
            Iterator iterator = this.getNodeNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ServerIndex serverIndex = this.loadServerIndex(string);
            }
        }
    }

    public HashMap getServerIndices() {
        this.loadServerIndices();
        return this._loadedServerIndices;
    }

    public void clearServerTypeData() {
        this._computedNodeServerIndex = false;
        this._nodeServerIndex = null;
        this._computedNodeServerType = false;
        this._nodeServerEntry = null;
        this._nodeServerType = null;
    }

    public String getServerType() {
        if (!this._computedNodeServerType) {
            this._computedNodeServerType = true;
            this.computeServerType();
        }
        return this._nodeServerType;
    }

    public ServerEntry getServerEntry() {
        if (!this._computedNodeServerType) {
            this._computedNodeServerType = true;
            this.computeServerType();
        }
        return this._nodeServerEntry;
    }

    public void computeServerType() {
        String string = this.getNodeName();
        String string2 = this.getServerName();
        if (string == null || string2 == null) {
            this._nodeServerEntry = null;
            this._nodeServerType = null;
        } else {
            this._nodeServerEntry = this.getServerEntry(string, string2);
            this._nodeServerType = this._nodeServerEntry == null ? null : this._nodeServerEntry.getServerType();
        }
    }

    public ServerIndex getServerIndex() {
        if (!this._computedNodeServerIndex) {
            this._computedNodeServerIndex = true;
            String string = this.getNodeName();
            this._nodeServerIndex = string == null ? null : this.getServerIndex(string);
        }
        return this._nodeServerIndex;
    }

    public void clearMultiBrokerData() {
        this._computedMultiBrokerData = false;
        this._multibrokerDomains = null;
    }

    public List getMultibrokerDomains() {
        if (!this._computedMultiBrokerData) {
            this._computedMultiBrokerData = true;
            this._multibrokerDomains = this.computeMultibrokerDomains();
        }
        return this._multibrokerDomains;
    }

    public List computeMultibrokerDomains() {
        MultibrokerDomain multibrokerDomain = this.basicLoadMultiBrokerDomain(this.getCellMultiBrokerUri());
        ArrayList<MultibrokerDomain> arrayList = new ArrayList<MultibrokerDomain>();
        if (multibrokerDomain != null) {
            arrayList.add(multibrokerDomain);
        }
        return arrayList;
    }

    public void clearNodeServerData() {
        this._computedNodeServerData = false;
        this._nodeServerPaths = null;
        this._nodeServerNames = null;
        this._nodeSystemMessageServers = null;
        this._nodeNodeAgents = null;
    }

    public void ensureNodeServerData() {
        if (!this._computedNodeServerData) {
            this._computedNodeServerData = true;
            this.computeNodeServers();
            this.computeNodeSystemMessageServers();
        }
    }

    public void computeNodeServers() {
        this.trace("Computing node servers ...");
        this._nodeServerPaths = new HashMap();
        this._nodeServerNames = new HashMap();
        Iterator iterator = this.getNodeUris().values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            Object object = this.loadModel(string);
            Iterator iterator2 = object instanceof List ? ((List)object).iterator() : new ArrayList().iterator();
            int n = string.length() + 1;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = string2.substring(n);
                if (!string3.startsWith("servers/")) continue;
                hashSet.add(string2);
                String string4 = string3.substring("servers/".length());
                hashSet2.add(string4);
            }
            this._nodeServerPaths.put(string, hashSet);
            this._nodeServerNames.put(string, hashSet2);
        }
        this.trace("Computing node servers ... done");
    }

    public void computeNodeSystemMessageServers() {
        this.trace("Computing node message servers ...");
        this.trace("Computing node node agents ...");
        this._nodeSystemMessageServers = new ArrayList();
        this._nodeNodeAgents = new HashMap();
        HashMap hashMap = this.getNodeServerUris();
        Iterator iterator = this.getNodeUris().values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.nabEndOfNoSlash(string);
            HashSet hashSet = (HashSet)hashMap.get(string);
            if (hashSet == null) continue;
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                String string4 = this.nabEndOfNoSlash(string3);
                String string5 = string3 + "/" + SERVER_XML;
                Server server = this.basicLoadServer(string5);
                if (server != null) {
                    this.fillMessageServers(this._nodeSystemMessageServers, (List)server.getComponents(), string2, string4, server);
                    this.fillNodeAgents(this._nodeNodeAgents, string2, string4, server);
                    continue;
                }
                this.trace("Failed to load server: ", string5);
            }
        }
        this.trace("Computing node message servers ... done");
    }

    public void fillMessageServers(List list, List list2, String string, String string2, Server server) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!(component instanceof SystemMessageServer)) continue;
            Object[] objectArray = new Object[]{string, string2, server, component};
            list.add(objectArray);
        }
    }

    public void fillNodeAgents(HashMap hashMap, String string, String string2, Server server) {
        Object object;
        Iterator iterator = server.getComponents().iterator();
        NodeAgent nodeAgent = null;
        while (nodeAgent == null && iterator.hasNext()) {
            object = (ServerComponent)iterator.next();
            if (!(object instanceof NodeAgent)) continue;
            nodeAgent = (NodeAgent)object;
        }
        if (nodeAgent != null) {
            object = (ArrayList)hashMap.get(string);
            if (object == null) {
                object = new ArrayList<Server>();
                hashMap.put(string, object);
            }
            ((ArrayList)object).add(server);
        }
    }

    public void fillMessageServers(List list, List list2, String string) {
        Iterator iterator = this.getNodeSystemMessageServers().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            SystemMessageServer systemMessageServer = (SystemMessageServer)objectArray[2];
            String string2 = systemMessageServer.getBrokerName();
            if (!string.equals(string2)) continue;
            if (this.isSetToStart(systemMessageServer)) {
                list.add(systemMessageServer);
                continue;
            }
            list2.add(systemMessageServer);
        }
    }

    public HashMap getNodeServerUris() {
        this.ensureNodeServerData();
        return this._nodeServerPaths;
    }

    public HashMap getNodeServerNames() {
        this.ensureNodeServerData();
        return this._nodeServerNames;
    }

    public List getNodeSystemMessageServers() {
        this.ensureNodeServerData();
        return this._nodeSystemMessageServers;
    }

    public HashMap getNodeNodeAgents() {
        this.ensureNodeServerData();
        return this._nodeNodeAgents;
    }

    public boolean isFederated() {
        String string = this.getNodeName();
        if (string == null) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.getNodeNodeAgents().get(string);
        return !arrayList.isEmpty();
    }

    public void clearDeploymentMap() {
        this._computedDeploymentMap = false;
        this._deploymentMap = null;
    }

    public void ensureDeploymentMap() {
        if (!this._computedDeploymentMap) {
            this._computedDeploymentMap = true;
            this.computeDeploymentMap();
        }
    }

    public void computeDeploymentMap() {
        this.trace("Computing deployment map");
        this._deploymentMap = new HashMap();
        Iterator iterator = this.getApplicationUris().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.trace("Next application root PATH: ", string);
            Object object = this.loadModel(string);
            if (!(object instanceof List)) {
                this.trace("Unable to load deployment context: ", string);
                continue;
            }
            String string2 = this.nabEndOfNoSlash(string);
            String string3 = string2.toUpperCase().endsWith(".EAR") ? string2.substring(0, string2.length() - ".EAR".length()) : string2;
            String string4 = string + "/" + "deployments" + "/" + string3 + "/" + DEPLOYMENT_XML;
            Object object2 = this.loadModel(string4);
            if (object2 instanceof List) {
                this._deploymentMap.put(string2, string4);
                this.trace("Loaded deployment.xml: ", string4);
                continue;
            }
            this.trace("Unable to load deployment.xml: ", string4);
        }
    }

    public HashMap getDeploymentMap() {
        this.ensureDeploymentMap();
        return this._deploymentMap;
    }

    public boolean isDeployed(String string) {
        return this.getDeploymentMap().containsKey(string);
    }

    public void clearCellSecurityData() {
        this._computedCellSecurityData = false;
        this._cellSecurity = null;
        this._cellSecurityAliasTable = null;
        this._cellSecurityJAASAuthDataTable = null;
    }

    public void ensureCellSecurityData() {
        if (!this._computedCellSecurityData) {
            this._computedCellSecurityData = true;
            this.computeCellSecurity();
            this.computeCellSecurityAliasTable();
            this.computeCellSecurityJAASAuthDataTable();
        }
    }

    public void computeCellSecurity() {
        this._cellSecurity = this.basicLoadSecurity(this.getCellSecurityUri());
    }

    public void computeCellSecurityAliasTable() {
        this._cellSecurityAliasTable = new HashSet();
        if (this._cellSecurity == null) {
            return;
        }
        Iterator iterator = this._cellSecurity.getRepertoire().iterator();
        while (iterator.hasNext()) {
            SSLConfig sSLConfig = (SSLConfig)iterator.next();
            String string = sSLConfig.getAlias();
            if (string == null) continue;
            this._cellSecurityAliasTable.add(string);
        }
    }

    public void computeCellSecurityJAASAuthDataTable() {
        this._cellSecurityJAASAuthDataTable = new HashSet();
        if (this._cellSecurity == null) {
            return;
        }
        Iterator iterator = this._cellSecurity.getAuthDataEntries().iterator();
        while (iterator.hasNext()) {
            JAASAuthData jAASAuthData = (JAASAuthData)iterator.next();
            String string = jAASAuthData.getAlias();
            if (string == null) continue;
            this._cellSecurityJAASAuthDataTable.add(string);
        }
    }

    public Security getCellSecurity() {
        this.ensureCellSecurityData();
        return this._cellSecurity;
    }

    public HashSet getCellSecurityAliasTable() {
        this.ensureCellSecurityData();
        return this._cellSecurityAliasTable;
    }

    public HashSet getCellSecurityJAASAuthDataTable() {
        this.ensureCellSecurityData();
        return this._cellSecurityJAASAuthDataTable;
    }

    public void clearCoreGroupStorage() {
        this._loadedAllCoreGroups = false;
        this._loadedCoreGroupNames = null;
        this._loadedCoreGroups = null;
    }

    public void ensureCoreGroupStorage() {
        if (this._loadedCoreGroupNames == null) {
            this._loadedAllCoreGroups = false;
            this._loadedCoreGroupNames = new HashSet();
            this._loadedCoreGroups = new HashMap();
        }
    }

    public CoreGroup getCoreGroup(String string) {
        this.ensureCoreGroupStorage();
        if (this._loadedCoreGroupNames.contains(string)) {
            return (CoreGroup)this._loadedCoreGroups.get(string);
        }
        return this.loadCoreGroup(string);
    }

    public CoreGroup loadCoreGroup(String string) {
        this._loadedCoreGroupNames.add(string);
        String string2 = this.getCoreGroupUri(string);
        CoreGroup coreGroup = this.basicLoadCoreGroup(string2);
        if (coreGroup != null) {
            this._loadedCoreGroups.put(string, coreGroup);
        }
        return coreGroup;
    }

    public void loadCoreGroups() {
        if (!this._loadedAllCoreGroups) {
            this._loadedAllCoreGroups = true;
            Iterator iterator = this.getCoreGroupNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CoreGroup coreGroup = this.loadCoreGroup(string);
            }
        }
    }

    public HashMap getCoreGroups() {
        this.loadCoreGroups();
        return this._loadedCoreGroups;
    }

    public String getCellVariablesUri() {
        String string = this.getCellUri();
        if (string == null) {
            return null;
        }
        return string + "/" + VARIABLES_XML;
    }

    public String getNodeVariablesUri() {
        String string = this.getNodeUri();
        if (string == null) {
            return null;
        }
        return string + "/" + VARIABLES_XML;
    }

    public String getServerVariablesUri() {
        String string = this.getServerUri();
        if (string == null) {
            return null;
        }
        return string + "/" + VARIABLES_XML;
    }

    public String getCellMultiBrokerUri() {
        String string = this.getCellUri();
        if (string == null) {
            return null;
        }
        return string + "/" + MULTIBROKER_XML;
    }

    public String getCellSecurityUri() {
        String string = this.getCellUri();
        if (string == null) {
            return null;
        }
        return string + "/" + SECURITY_XML;
    }

    public String getServerIndexUri(String string) {
        String string2 = this.getNodeUri(string);
        if (string2 == null) {
            return null;
        }
        return string2 + "/" + SERVERINDEX_XML;
    }

    public VariableMap loadCellVariablesMap() {
        return this.basicLoadVariablesMap(this.getCellVariablesUri());
    }

    public VariableMap loadNodeVariablesMap() {
        return this.basicLoadVariablesMap(this.getNodeVariablesUri());
    }

    public VariableMap loadServerVariablesMap() {
        return this.basicLoadVariablesMap(this.getServerVariablesUri());
    }

    public VariableMap basicLoadVariablesMap(String string) {
        return (VariableMap)this.loadModel(string, class$com$ibm$websphere$models$config$variables$VariableMap == null ? (class$com$ibm$websphere$models$config$variables$VariableMap = WorkSpaceHelper.class$("com.ibm.websphere.models.config.variables.VariableMap")) : class$com$ibm$websphere$models$config$variables$VariableMap);
    }

    public Security basicLoadSecurity(String string) {
        return (Security)this.loadModel(string, class$com$ibm$websphere$models$config$security$Security == null ? (class$com$ibm$websphere$models$config$security$Security = WorkSpaceHelper.class$("com.ibm.websphere.models.config.security.Security")) : class$com$ibm$websphere$models$config$security$Security);
    }

    public MultibrokerDomain basicLoadMultiBrokerDomain(String string) {
        return (MultibrokerDomain)this.loadModel(string, class$com$ibm$websphere$models$config$multibroker$MultibrokerDomain == null ? (class$com$ibm$websphere$models$config$multibroker$MultibrokerDomain = WorkSpaceHelper.class$("com.ibm.websphere.models.config.multibroker.MultibrokerDomain")) : class$com$ibm$websphere$models$config$multibroker$MultibrokerDomain);
    }

    public CoreGroup basicLoadCoreGroup(String string) {
        return (CoreGroup)this.loadModel(string, class$com$ibm$websphere$models$config$coregroup$CoreGroup == null ? (class$com$ibm$websphere$models$config$coregroup$CoreGroup = WorkSpaceHelper.class$("com.ibm.websphere.models.config.coregroup.CoreGroup")) : class$com$ibm$websphere$models$config$coregroup$CoreGroup);
    }

    public ServerIndex basicLoadServerIndex(String string) {
        return (ServerIndex)this.loadModel(string, class$com$ibm$websphere$models$config$serverindex$ServerIndex == null ? (class$com$ibm$websphere$models$config$serverindex$ServerIndex = WorkSpaceHelper.class$("com.ibm.websphere.models.config.serverindex.ServerIndex")) : class$com$ibm$websphere$models$config$serverindex$ServerIndex);
    }

    public Server basicLoadServer(String string) {
        return (Server)this.loadModel(string, class$com$ibm$websphere$models$config$process$Server == null ? (class$com$ibm$websphere$models$config$process$Server = WorkSpaceHelper.class$("com.ibm.websphere.models.config.process.Server")) : class$com$ibm$websphere$models$config$process$Server);
    }

    public boolean isSetToStart(StateManageable stateManageable) {
        int n = stateManageable.getInitialState().getValue();
        return n == 0;
    }

    public boolean isSetToStart(ManagedObject managedObject) {
        StateManageable stateManageable = managedObject.getStateManagement();
        if (stateManageable == null) {
            return false;
        }
        return this.isSetToStart(stateManageable);
    }

    protected void clearDirectDocuments() {
        this._directAttempts = null;
        this._directDocuments = null;
    }

    protected List loadDirect(String string) {
        List list;
        boolean bl;
        if (this._directAttempts == null) {
            this._directAttempts = new HashSet();
            this._directDocuments = new HashMap();
            bl = false;
        } else {
            bl = this._directAttempts.contains(string);
        }
        if (bl) {
            list = (List)this._directDocuments.get(string);
        } else {
            this._directAttempts.add(string);
            list = (List)this.loadModel(string);
            if (list != null) {
                this._directDocuments.put(string, list);
            }
        }
        return list;
    }

    protected List loadServerPeer(String string) {
        String string2 = this.getCellName();
        if (string2 == null) {
            return null;
        }
        String string3 = this.getNodeName();
        if (string3 == null) {
            return null;
        }
        String string4 = this.getServerName();
        if (string4 == null) {
            return null;
        }
        String string5 = "cells/" + string2 + "/" + "nodes" + "/" + string3 + "/" + "servers" + "/" + string4 + "/" + string;
        return this.loadDirect(string5);
    }

    protected List loadCellPeer(String string) {
        String string2 = this.getCellName();
        if (string2 == null) {
            return null;
        }
        String string3 = "cells/" + string2 + "/" + string;
        return this.loadDirect(string3);
    }

    public WebServer getWebServer(Server server) {
        Iterator iterator = server.getComponents().iterator();
        WebServer webServer = null;
        while (webServer == null && iterator.hasNext()) {
            ServerComponent serverComponent = (ServerComponent)iterator.next();
            if (!(serverComponent instanceof WebServer) || !this.isSetToStart(serverComponent)) continue;
            webServer = (WebServer)serverComponent;
        }
        return webServer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

