/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.OutputSupport;
import com.ibm.websphere.validation.base.config.WorkSpaceHelper;
import com.ibm.websphere.validation.nodefeatures.NodeFeatures;
import com.ibm.websphere.validation.nodefeatures.NodeFeaturesFactoryImpl;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class FeaturesHelper {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected MOFValidator parentValidator;
    protected WorkSpaceHelper workSpaceHelper;
    protected boolean namesAreSet;
    protected String cellPath;
    protected String cellName;
    protected String nodePath;
    protected String nodeName;
    protected String serverPath;
    protected String serverName;
    protected boolean nodeFeaturesNamesAreSet;
    protected String nodeFeaturesCell;
    protected String nodeFeaturesNode;
    protected NodeFeatures nodeFeatures;
    public static final String LOCAL_DEBUG_PROPERTY_NAME = "com.ibm.websphere.validation.features.debug";
    protected OutputSupport _localTrace;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$serverindex$ServerIndex;

    public FeaturesHelper(MOFValidator mOFValidator, WorkSpaceHelper workSpaceHelper) {
        this.parentValidator = mOFValidator;
        this.workSpaceHelper = workSpaceHelper;
        this.clear();
        this.maybeEnableLocalTrace();
    }

    public void clear() {
        this.localTrace("Clearing cached node features information.");
        this.clearNames();
        this.clearNodeFeaturesNames();
        this.clearNodeFeatures();
    }

    public MOFValidator getParentValidator() {
        return this.parentValidator;
    }

    public String getCurrentFileName() {
        return this.getParentValidator().getCurrentFileName();
    }

    public String nabHeadOf(String string) {
        return this.getParentValidator().nabHeadOf(string);
    }

    public String nabTailOf(String string) {
        return this.getParentValidator().nabTailOf(string);
    }

    public Object loadModel(String string) {
        return this.getParentValidator().loadModel(string);
    }

    public String getExceptionText(Exception exception) {
        return this.getParentValidator().getExceptionText(exception);
    }

    public WorkSpaceHelper getWorkSpaceHelper() {
        return this.workSpaceHelper;
    }

    protected void clearNames() {
        this.namesAreSet = false;
        this.cellPath = null;
        this.cellName = null;
        this.nodePath = null;
        this.nodeName = null;
        this.serverPath = null;
        this.serverName = null;
    }

    public boolean namesAreSet() {
        return this.namesAreSet;
    }

    public String getServerPath() {
        if (!this.namesAreSet) {
            this.computeNames();
        }
        return this.serverPath;
    }

    public String getServerName() {
        if (!this.namesAreSet) {
            this.computeNames();
        }
        return this.serverName;
    }

    public String getNodePath() {
        if (!this.namesAreSet) {
            this.computeNames();
        }
        return this.nodePath;
    }

    public String getNodeName() {
        if (!this.namesAreSet) {
            this.computeNames();
        }
        return this.nodeName;
    }

    public String getCellPath() {
        if (!this.namesAreSet) {
            this.computeNames();
        }
        return this.cellPath;
    }

    public String getCellName() {
        if (!this.namesAreSet) {
            this.computeNames();
        }
        return this.cellName;
    }

    protected void computeNames() {
        this.localTrace("FeaturesHelper.computeNames");
        this.namesAreSet = true;
        String string = this.getCurrentFileName();
        if (!string.startsWith("cells")) {
            this.localTrace("Not under cells; no feature names were set.");
            return;
        }
        string = this.nabTailOf(string);
        this.cellName = this.nabHeadOf(string);
        this.cellPath = "cells/" + this.cellName;
        this.localTrace("Cell path: ", this.cellPath);
        string = this.nabTailOf(string);
        if (!string.startsWith("nodes")) {
            this.localTrace("Not under nodes; no node level names were set.");
            return;
        }
        string = this.nabTailOf(string);
        this.nodeName = this.nabHeadOf(string);
        this.nodePath = this.cellPath + "/nodes/" + this.nodeName;
        this.localTrace("Node path: ", this.nodePath);
        string = this.nabTailOf(string);
        if (!string.startsWith("servers")) {
            this.localTrace("Not under servers; no server level names were set.");
            return;
        }
        string = this.nabTailOf(string);
        this.serverName = this.nabHeadOf(string);
        this.serverPath = this.nodePath + "/servers/" + this.serverName;
        this.localTrace("Server path: ", this.serverPath);
        string = this.nabTailOf(string);
        this.localTrace("Residual path: ", string);
    }

    public boolean nodeFeaturesNamesAreSet() {
        return this.nodeFeaturesNamesAreSet;
    }

    protected void clearNodeFeaturesNames() {
        this.nodeFeaturesNamesAreSet = false;
        this.nodeFeaturesCell = null;
        this.nodeFeaturesNode = null;
    }

    public String getNodeFeaturesCell() {
        if (!this.nodeFeaturesNamesAreSet) {
            this.computeNodeFeaturesNames();
        }
        return this.nodeFeaturesCell;
    }

    public String getNodeFeaturesNode() {
        if (!this.nodeFeaturesNamesAreSet) {
            this.computeNodeFeaturesNames();
        }
        return this.nodeFeaturesNode;
    }

    protected void computeNodeFeaturesNames() {
        this.nodeFeaturesNamesAreSet = true;
        this.nodeFeaturesCell = this.getCellName();
        this.nodeFeaturesNode = this.getNodeName();
        if (this.nodeFeaturesNode == null) {
            this.nodeFeaturesNode = this.computeNodeFeaturesNode();
        }
    }

    protected String computeNodeFeaturesNode() {
        this.localTrace("Computing node features node:");
        Iterator iterator = this.getWorkSpaceHelper().getNodeNames().iterator();
        if (!iterator.hasNext()) {
            this.localTrace("No names are available; answering null.");
            return null;
        }
        MOFValidator mOFValidator = this.getParentValidator();
        WorkSpaceHelper workSpaceHelper = this.getWorkSpaceHelper();
        String string = workSpaceHelper.getCellUri();
        this.localTrace("Cell path: ", string);
        String string2 = string + "/nodes/";
        int n = 0;
        String string3 = null;
        String string4 = null;
        while (string4 == null && iterator.hasNext()) {
            String string5 = (String)iterator.next();
            this.localTrace("Examining node: ", string5);
            String string6 = string2 + string5 + "/serverindex.xml";
            this.localTrace("Loading index: ", string6);
            ServerIndex serverIndex = (ServerIndex)mOFValidator.loadModel(string6, class$com$ibm$websphere$models$config$serverindex$ServerIndex == null ? FeaturesHelper.class$("com.ibm.websphere.models.config.serverindex.ServerIndex") : class$com$ibm$websphere$models$config$serverindex$ServerIndex, MOFValidator.FORBID_EMPTY_COLLECTION);
            if (serverIndex == null) {
                this.localTrace("Failed to load server index: ", string6);
                continue;
            }
            this.localTrace("Loaded server index: ", string6);
            Iterator iterator2 = serverIndex.getServerEntries().iterator();
            String string7 = null;
            String string8 = null;
            while (string8 == null && iterator2.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator2.next();
                String string9 = serverEntry.getServerName();
                String string10 = serverEntry.getServerType();
                this.localTrace("Examining server: ", string9);
                this.localTrace("Server type: ", string10);
                if (string7 == null && string10.equals("APPLICATION_SERVER")) {
                    string7 = string9;
                    if (string3 == null) {
                        string3 = string5;
                    }
                    ++n;
                    this.localTrace("Another application server node: ", string5);
                }
                if (string10 == null || !string10.equals("DEPLOYMENT_MANAGER")) continue;
                string8 = string9;
                string4 = string5;
                this.localTrace("Located deployment manager server: ", string8);
                this.localTrace("Located deployment manager node: ", string4);
            }
        }
        if (string4 == null) {
            this.localTrace("No deployment manager; using first server node.");
            if (string3 == null) {
                this.localTrace("Found no server node; answering null.");
            } else {
                if (n > 1) {
                    this.localTrace("Warning: Found multiple application server nodes,");
                    this.localTrace("But found no deployment manager node.");
                }
                string4 = string3;
            }
        }
        return string4;
    }

    public void clearNodeFeatures() {
        this.nodeFeatures = null;
    }

    public boolean nodeFeaturesAreLoaded() {
        return this.nodeFeatures != null;
    }

    public NodeFeatures getNodeFeatures() {
        if (this.nodeFeatures == null) {
            this.loadNodeFeatures();
        }
        return this.nodeFeatures;
    }

    protected void loadNodeFeatures() {
        IOException iOException;
        Properties properties;
        this.localTrace("Loading node features.");
        NodeFeaturesFactoryImpl nodeFeaturesFactoryImpl = new NodeFeaturesFactoryImpl();
        String string = this.getNodeFeaturesCell();
        String string2 = this.getNodeFeaturesNode();
        this.localTrace("Node features cell: ", string);
        this.localTrace("Node features node: ", string2);
        String string3 = nodeFeaturesFactoryImpl.getFeaturesPath(string, string2);
        this.localTrace("Node features path: ", string3);
        String string4 = nodeFeaturesFactoryImpl.getConfigRoot();
        if (string4 == null || string4.length() == 0) {
            string4 = ".";
            this.localTrace("No available configuration root; using: ", string4);
        } else {
            this.localTrace("Config root: ", string4);
        }
        String string5 = string4 + "/" + string3;
        try {
            properties = nodeFeaturesFactoryImpl.loadProperties(string5);
            iOException = null;
        }
        catch (IOException iOException2) {
            properties = null;
            iOException = iOException2;
        }
        if (properties == null) {
            if (iOException != null) {
                this.localTrace("Load of features failed with exception: ", string5);
                this.localTraceException("Load of features failed with exception: " + string5 + ": ", iOException);
                String string6 = this.parentValidator.getExceptionText(iOException);
                this.getParentValidator().addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_FEATURES_LOAD_EXCEPTION", new String[]{string5, string6}, this.getCurrentFileName());
            } else {
                this.localTrace("Unable to load features: ", string5);
                this.getParentValidator().addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_FEATURES_LOAD_FAILURE", new String[]{string5}, this.getCurrentFileName());
            }
            this.localTrace("Using features for the current node.");
            this.nodeFeatures = nodeFeaturesFactoryImpl.getCurrentFeatures(string, string2);
        } else {
            this.localTrace("Creating node features from loaded properties.");
            this.nodeFeatures = nodeFeaturesFactoryImpl.createNodeFeatures(string, string2, properties);
        }
        this.localTrace("Product version: ", this.nodeFeatures.getBaseProductVersion());
        this.localTrace("Major version  : ", this.nodeFeatures.getMajorVersion());
        this.localTrace("Minor version  : ", this.nodeFeatures.getMinorVersion());
        this.localTrace("Platform OS    : ", this.nodeFeatures.getPlatformOS());
        this.localTrace("Is Z/OS        : ", this.nodeFeatures.isZOS() ? "true" : "false");
    }

    public String getPlatformOS() {
        return this.getNodeFeatures().getPlatformOS();
    }

    public boolean isZOS() {
        return this.getNodeFeatures().isZOS();
    }

    public String getBaseProductVersion() {
        return this.getNodeFeatures().getBaseProductVersion();
    }

    public String getMajorVersion() {
        return this.getNodeFeatures().getMajorVersion();
    }

    public String getMinorVersion() {
        return this.getNodeFeatures().getMinorVersion();
    }

    public String getTraceName() {
        return this.getClass().getName();
    }

    protected void maybeEnableLocalTrace() {
        if (Boolean.getBoolean(LOCAL_DEBUG_PROPERTY_NAME)) {
            this.enableLocalTrace();
        }
    }

    public void setTrace(OutputSupport outputSupport) {
        this._localTrace = outputSupport;
    }

    public OutputSupport getLocalTrace() {
        return this._localTrace;
    }

    public boolean isLocalTraceEnabled() {
        return this._localTrace != null;
    }

    public void enableLocalTrace() {
        if (this._localTrace == null) {
            this._localTrace = new OutputSupport(System.out);
            this.localTrace("Enabled features trace");
        }
    }

    public void disableLocalTrace() {
        if (this._localTrace != null) {
            this.localTrace("Disabling features trace");
            this._localTrace = null;
        }
    }

    public void localTrace(Object object) {
        if (this._localTrace != null) {
            this._localTrace.printlnBeginning(object);
        }
    }

    public void localTrace(Object object, Object object2) {
        if (this._localTrace != null) {
            this._localTrace.printlnBeginning(object, object2);
        }
    }

    public void localTraceException(String string, Throwable throwable) {
        if (this._localTrace != null) {
            this._localTrace.displayException(string, throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

