/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.bindings.ejbbnd;

import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.j2ee.validation.J2EEValidator;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.base.bindings.ejbbnd.EJBJarBindingMessageConstants;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class EJBJarBindingValidator
extends J2EEValidator
implements EJBJarBindingMessageConstants {
    public String getBaseName() {
        return "com.ibm.websphere.validation.base.bindings.ejbbnd.ejbbndvalidation";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to ear file.");
        }
        String string = stringArray[0];
        try {
            EJBJarFile eJBJarFile = CommonarchiveFactoryImpl.getActiveFactory().openEJBJarFile(string);
            EJBJarBinding eJBJarBinding = eJBJarFile.getBindings();
            PassthruHelper passthruHelper = new PassthruHelper(eJBJarBinding);
            FullReporter fullReporter = new FullReporter();
            EJBJarBindingValidator eJBJarBindingValidator = new EJBJarBindingValidator();
            eJBJarBindingValidator.validate(passthruHelper, fullReporter, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void validate(EJBJarBinding eJBJarBinding) {
        boolean bl;
        String string;
        Object object;
        Object object2;
        EJBJar eJBJar = eJBJarBinding.getEjbJar();
        if (eJBJar == null) {
            this.addError("NULL_EJBJAR_REFERENCE");
            return;
        }
        int n = 0;
        int n2 = 0;
        HashMap<EnterpriseBean, EnterpriseBeanBinding> hashMap = new HashMap<EnterpriseBean, EnterpriseBeanBinding>();
        EList eList = eJBJarBinding.getEjbBindings();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string2;
            Object object3;
            Object object4;
            Object object5;
            EnterpriseBeanBinding enterpriseBeanBinding = (EnterpriseBeanBinding)iterator.next();
            object2 = enterpriseBeanBinding.getEnterpriseBean();
            if (object2 == null) {
                this.addError("NULL_EJB_REFERENCE");
                return;
            }
            hashMap.put((EnterpriseBean)object2, enterpriseBeanBinding);
            object = object2.getDisplayName();
            if (object == null) {
                object = "?";
            }
            if ((string = enterpriseBeanBinding.getJndiName()) == null || string.length() == 0) {
                this.addWarning("NO_JNDINAME_FOR_EJB", new String[]{string});
            }
            Iterator iterator2 = enterpriseBeanBinding.getEjbRefBindings().iterator();
            while (iterator2.hasNext()) {
                object5 = (EjbRefBinding)iterator2.next();
                object4 = object5.getBindingEjbRef();
                if (object4 == null) {
                    this.addError("NULL_EJBREF_REFERENCE", new String[]{object});
                    continue;
                }
                object3 = object4.getHome();
                if (object3 == null || ((String)object3).length() == 0) {
                    object3 = "?";
                }
                if ((string2 = object5.getJndiName()) != null && string2.length() != 0) continue;
                this.addWarning("NO_JNDINAME_FOR_EJBREF", new String[]{object3, object});
            }
            object5 = enterpriseBeanBinding.getResRefBindings().iterator();
            while (object5.hasNext()) {
                String string3;
                String string4;
                object4 = (ResourceRefBinding)object5.next();
                object3 = object4.getBindingResourceRef();
                if (object3 == null) {
                    this.addError("NULL_RESOURCEREF_REFERENCE", new String[]{object});
                    continue;
                }
                string2 = object3.getType();
                if (string2 == null || string2.length() == 0) {
                    string2 = "?";
                }
                if ((string4 = object3.getName()) == null || string4.length() == 0) {
                    string4 = "?";
                }
                if ((string3 = object4.getJndiName()) != null && string3.length() != 0) continue;
                this.addWarning("NO_JNDINAME_FOR_RESOURCEREF", new String[]{string4, string2, object});
            }
            if (!object2.isEntity() || !((object4 = (Entity)object2) instanceof ContainerManagedEntity)) continue;
            ++n;
            if (enterpriseBeanBinding.getDatasource() == null) {
                this.addWarning("NO_DATASOURCE_FOR_CMPBEAN", new String[]{object});
                continue;
            }
            if (enterpriseBeanBinding.getDatasource().getJndiName() == null || enterpriseBeanBinding.getDatasource().getJndiName().length() == 0) {
                this.addWarning("NO_DATASOURCE_JNDINAME_FOR_CMPBEAN", new String[]{object});
                continue;
            }
            ++n2;
        }
        boolean bl2 = bl = eJBJarBinding.getDefaultDatasource() == null || eJBJarBinding.getDefaultDatasource().getJndiName() == null || eJBJarBinding.getDefaultDatasource().getJndiName().length() == 0;
        if (bl && n != n2) {
            this.addWarning("REQUIRES_DEFAULT_CMP_DATASOURCE");
        }
        object2 = eJBJar.getEnterpriseBeans().iterator();
        while (object2.hasNext()) {
            object = (EnterpriseBean)object2.next();
            if (hashMap.containsKey(object)) continue;
            string = object.getDisplayName();
            if (!(string != null && string.length() != 0 || (string = object.getName()) != null && string.length() != 0)) {
                string = "---";
            }
            this.addError("NO_BINDING_FOR_EJB", new String[]{string});
        }
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        this._reporter = iReporter;
        this._helper = iHelper;
        if (this._reporter == null || this._helper == null) {
            return;
        }
        try {
            Object object = this._helper.loadModel("EJBJarBinding");
            if (object == null) {
                return;
            }
            this.validate((EJBJarBinding)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_EJBBND_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }
}

