/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.bindings.applicationbnd;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.etools.application.Application;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.validation.J2EEValidator;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.base.bindings.applicationbnd.ApplicationBindingMessageConstants;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class ApplicationBindingValidator
extends J2EEValidator
implements ApplicationBindingMessageConstants {
    public String getBaseName() {
        return "com.ibm.websphere.validation.base.bindings.applicationbnd.applicationbndvalidation";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to ear file.");
        }
        String string = stringArray[0];
        try {
            EARFile eARFile = CommonarchiveFactoryImpl.getActiveFactory().openEARFile(string);
            ApplicationBinding applicationBinding = eARFile.getBindings();
            PassthruHelper passthruHelper = new PassthruHelper(applicationBinding);
            FullReporter fullReporter = new FullReporter();
            ApplicationBindingValidator applicationBindingValidator = new ApplicationBindingValidator();
            applicationBindingValidator.validate(passthruHelper, fullReporter, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void validate(ApplicationBinding applicationBinding) {
        Application application = applicationBinding.getApplication();
        if (application == null) {
            this.addError("NULL_APPLICATION_REFERENCE");
            return;
        }
        if (application.getDisplayName() == null) {
            this.addError("MISSING_APPLICATION_REFERENCE");
        }
        if (applicationBinding.getRunAsMap() != null) {
            this.validateRunAsBindings(applicationBinding);
        }
        if (applicationBinding.getAuthorizationTable() != null) {
            this.validateAuthorizations(applicationBinding);
        }
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        this._reporter = iReporter;
        this._helper = iHelper;
        if (this._reporter == null || this._helper == null) {
            return;
        }
        try {
            Object object = this._helper.loadModel("ApplicationBinding");
            if (object == null) {
                return;
            }
            this.validate((ApplicationBinding)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_APPLICATIONBND_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }

    public void validateAuthorizations(ApplicationBinding applicationBinding) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        EList eList = applicationBinding.getApplication().getSecurityRoles();
        AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
        EList eList2 = authorizationTable.getAuthorizations();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object4 = (SecurityRole)iterator.next();
            if (object4 == null || (object3 = object4.getRoleName()) == null || ((String)object3).length() <= 0) continue;
            hashMap.put(object3, object4);
        }
        object4 = hashMap.keySet();
        object3 = new HashSet();
        Iterator iterator2 = eList2.iterator();
        while (iterator2.hasNext()) {
            String string;
            object2 = (RoleAssignment)iterator2.next();
            object = object2.getRole();
            if (object == null || (string = object.getRoleName()) == null || string.length() <= 0) continue;
            if (!object3.contains(string)) {
                object3.add(string);
                continue;
            }
            this.addError("MULTIPLE_ROLEASSIGNMENTS_FOR_SECURITY_ROLE", new String[]{string});
        }
        object2 = object4.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (object3.contains(object) || ((String)object).toUpperCase().equals("DENYALLROLE")) continue;
            this.addWarning("UNASSIGNED_SECURITY_ROLE", new String[]{object});
        }
    }

    public void validateRunAsBindings(ApplicationBinding applicationBinding) {
        EList eList = applicationBinding.getRunAsMap().getRunAsBindings();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            RunAsBinding runAsBinding = (RunAsBinding)iterator.next();
            SecurityRole securityRole = runAsBinding.getSecurityRole();
            if (securityRole != null) continue;
            this.addError("MISSING_SECURITY_ROLE");
        }
    }
}

