/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation;

import com.ibm.etools.j2ee.validation.J2EEValidationResourceHandler;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.IMessageAccess;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.IValidator;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.MessageFilter;
import com.ibm.websphere.validation.FullReporterConstants;
import com.ibm.websphere.validation.ValidationMessage;
import com.ibm.websphere.validation.ValidationMessageManager;
import com.ibm.websphere.validation.ValidatorStub;
import com.ibm.wtp.emf.utilities.IDUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

public class IncrementalReporter
implements IReporter,
IMessageAccess,
FullReporterConstants {
    public void addMessage(IValidator iValidator, IMessage iMessage) {
        if (iValidator == null || iMessage == null) {
            return;
        }
        ValidationMessage validationMessage = ValidationMessageManager.getManager().getMessages(iValidator);
        if (validationMessage != null) {
            validationMessage.addValidationMessage(iValidator, iMessage);
        }
    }

    protected String annotateMessage(IMessage iMessage, Locale locale) {
        String string = iMessage.getText(locale);
        Object object = iMessage.getTargetObject();
        if (object != null) {
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                String string2 = IDUtil.getOrAssignID(eObject);
                string = this.getMessage("com.ibm.websphere.validation.fullreporterNLS", "INFO_MOF_BANNER", new String[]{string2, string}, locale);
            } else {
                string = this.getMessage("com.ibm.websphere.validation.fullreporterNLS", "INFO_NON_MOF_BANNER", new String[]{object.toString(), object.getClass().getName()}, locale);
            }
        }
        return string;
    }

    public void displaySubtask(IValidator iValidator, IMessage iMessage) {
        System.err.println(iMessage.getText());
    }

    public String getMessage(String string, String string2, String[] stringArray, Locale locale) {
        return J2EEValidationResourceHandler.getExternalizedMessage(string, string2, this.getClass(), stringArray, locale);
    }

    public String getMessage(String string, String string2, Locale locale) {
        return J2EEValidationResourceHandler.getExternalizedMessage(string, string2, this.getClass(), locale);
    }

    public IMessageAccess getMessageAccess() {
        return this;
    }

    public List getMessages(MessageFilter messageFilter) {
        int n = messageFilter != null ? messageFilter.getSeverity() : 7;
        return ValidationMessageManager.getManager().getMessages(n);
    }

    public List getMessagesAsText(MessageFilter messageFilter, Locale locale) {
        List list = this.getMessages(messageFilter);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IMessage iMessage = (IMessage)list.get(i);
            String string = this.annotateMessage(iMessage, locale);
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean isCancelled() {
        return false;
    }

    public static void main(String[] stringArray) {
        IncrementalReporter incrementalReporter = new IncrementalReporter();
        IMessageAccess iMessageAccess = incrementalReporter.getMessageAccess();
        if (iMessageAccess == null) {
            System.err.println("Error: null message access");
            System.exit(-1);
        }
        ValidatorStub validatorStub = new ValidatorStub();
        Message message = new Message("com.ibm.websphere.validation.fullreporterNLS", 1, "INFO_COMPONENT_NAME");
        Message message2 = new Message("com.ibm.websphere.validation.fullreporterNLS", 2, "INFO_COMPONENT_NAME");
        Message message3 = new Message("com.ibm.websphere.validation.fullreporterNLS", 4, "INFO_COMPONENT_NAME");
        incrementalReporter.removeAllMessages(validatorStub);
        if (!iMessageAccess.getMessages(null).isEmpty()) {
            System.err.println("Error: removeAllMessages(validator) failed.");
            System.err.println("Reporter Contents:");
            incrementalReporter.report();
            System.exit(-1);
        }
        incrementalReporter.addMessage(validatorStub, message);
        incrementalReporter.addMessage(validatorStub, message2);
        incrementalReporter.addMessage(validatorStub, message3);
        List list = iMessageAccess.getMessages(null);
        if (list.size() != 3) {
            System.err.println("Error: Get all messages failed.");
            System.exit(-1);
        }
        System.out.println("\nAll Messages:");
        for (int i = 0; i < list.size(); ++i) {
            String string = ((IMessage)list.get(i)).getText();
            System.out.println(string);
        }
        List list2 = iMessageAccess.getMessagesAsText(null, Locale.getDefault());
        System.out.println("\nAll Messages as Text:");
        for (int i = 0; i < list2.size(); ++i) {
            System.out.println(list2.get(i));
        }
        incrementalReporter.removeAllMessages(validatorStub);
        if (!iMessageAccess.getMessages(null).isEmpty()) {
            System.err.println("Error: removeAllMessages(validator) failed.");
            System.err.println("Reporter Contents:");
            incrementalReporter.report();
            System.exit(-1);
        }
    }

    public void print(int n) {
    }

    public void removeAllMessages() {
        ValidationMessageManager.getManager().removeAllMessages();
    }

    public void removeAllMessages(IValidator iValidator) {
        ValidationMessageManager.getManager().removeAllMessages(iValidator);
    }

    public void removeAllMessages(IValidator iValidator, Object object) {
        ValidationMessageManager.getManager().removeAllMessages(iValidator, object);
    }

    public void removeMessageSubset(IValidator iValidator, Object object, String string) {
    }

    public void report() {
        List list = this.getMessages(null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            System.out.println((IMessage)iterator.next());
        }
    }

    public void setCancelled(boolean bl) {
    }
}

