/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.roseparser;

import com.ibm.psh.roseparser.RoseComponent;
import com.ibm.psh.roseparser.RoseNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Vector;

public class RoseWriter
extends RoseComponent {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private BufferedWriter buffWriter;
    private RoseNode versionTree;
    private RoseNode modelTree;
    private int justIndex;
    private static int counter = 0;
    public static final String PROGRESS = "ROSE_WRITE_PROGRESS";
    private int lower = 0;
    private int upper = 100;
    private int oldValue;
    private int progressIncrement = 10;

    public RoseWriter(String string, RoseNode roseNode, RoseNode roseNode2) throws Exception {
        this.buffWriter = new BufferedWriter(new FileWriter(string));
        this.versionTree = roseNode;
        this.modelTree = roseNode2;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public void setLower(int n) {
        this.lower = n;
        this.oldValue = n;
    }

    public void setProgressIncrement(int n) {
        this.progressIncrement = n;
    }

    public void setUpper(int n) {
        this.upper = n;
    }

    public void write() throws Exception {
        if (this.buffWriter == null) {
            return;
        }
        counter = 0;
        this.oldValue = this.lower;
        this.justIndex = 0;
        this.buffWriter.newLine();
        this.writeObject(this.versionTree);
        this.buffWriter.newLine();
        this.buffWriter.newLine();
        if (this.modelTree.getType() == 2) {
            this.writeObject(this.modelTree);
        } else {
            this.writeList(this.modelTree);
        }
        this.buffWriter.newLine();
        this.buffWriter.close();
        int n = this.upper;
        this.firePropertyChange(PROGRESS, this.oldValue, n);
    }

    private void writeExpr(RoseNode roseNode) throws Exception {
        if (roseNode.getType() == 0) {
            this.buffWriter.write(9);
            this.buffWriter.write(roseNode.getValue());
        } else if (roseNode.getType() == 1) {
            Vector vector = roseNode.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
                this.buffWriter.newLine();
                this.buffWriter.write(124);
                this.buffWriter.write(roseNode2.getValue());
            }
            this.buffWriter.newLine();
        } else if (roseNode.getType() == 3) {
            this.buffWriter.write(32);
            this.writeList(roseNode);
        } else if (roseNode.getType() == 2) {
            this.buffWriter.write(32);
            this.writeObject(roseNode);
        } else if (roseNode.getType() == 4) {
            this.buffWriter.write(9);
            this.writeValue(roseNode);
        }
    }

    private void writeList(RoseNode roseNode) throws Exception {
        String string = roseNode.getKey();
        if (!string.equals("collection")) {
            ++this.justIndex;
            this.buffWriter.write("(list ");
            this.buffWriter.write(roseNode.getValue());
        }
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            this.buffWriter.newLine();
            for (int j = 0; j < this.justIndex; ++j) {
                this.buffWriter.write(9);
            }
            if (roseNode2.getType() == 2) {
                this.writeObject(roseNode2);
                continue;
            }
            if (roseNode2.getType() == 0) {
                this.buffWriter.write(roseNode2.getValue());
                continue;
            }
            System.out.println("!!!!! error in writeLists !!!!! " + roseNode2.getType());
            System.exit(0);
        }
        if (!string.equals("collection")) {
            this.buffWriter.write(41);
            --this.justIndex;
        }
    }

    public void writeObject(RoseNode roseNode) throws Exception {
        int n;
        if (this.modelTree.localCounter > 0 && (n = this.lower + ++counter * (this.upper - this.lower) / this.modelTree.localCounter) >= this.oldValue + this.progressIncrement && n < this.upper) {
            this.firePropertyChange(PROGRESS, this.oldValue, n);
            this.oldValue = n;
        }
        ++this.justIndex;
        this.buffWriter.write("(object ");
        this.buffWriter.write(roseNode.getValue());
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            this.writePair(roseNode2);
        }
        this.buffWriter.write(41);
        --this.justIndex;
    }

    public void writePair(RoseNode roseNode) throws Exception {
        this.buffWriter.newLine();
        for (int i = 0; i < this.justIndex; ++i) {
            this.buffWriter.write(9);
        }
        this.buffWriter.write(roseNode.getKey());
        this.writeExpr(roseNode);
    }

    public void writeValue(RoseNode roseNode) throws Exception {
        ++this.justIndex;
        this.buffWriter.write("(value ");
        this.buffWriter.write(roseNode.getValue());
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            this.writeExpr(roseNode2);
        }
        this.buffWriter.write(41);
        --this.justIndex;
    }
}

