/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.roseparser;

import com.ibm.psh.roseparser.RoseLexer;
import com.ibm.psh.roseparser.RoseLoader;
import com.ibm.psh.roseparser.RoseNode;
import com.ibm.psh.roseparser.RoseToken;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;

public class RoseParser {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private RoseLexer lexer;
    private RoseNode versionTree;
    private RoseNode modelTree;
    private String baseId = "";
    private Stack idStack = new Stack();
    private boolean isTreeOnly = false;
    private boolean isAllowed = true;
    private boolean isRoot = true;
    private boolean isListMapping = true;
    private boolean noLogicalPresentation = false;
    private boolean mapProperties = true;

    public RoseParser(RoseLexer roseLexer) {
        this(roseLexer, false, false);
    }

    public RoseParser(RoseLexer roseLexer, boolean bl) {
        this(roseLexer, bl, false);
    }

    public RoseParser(RoseLexer roseLexer, boolean bl, boolean bl2) {
        this.lexer = roseLexer;
        this.isTreeOnly = bl;
        this.noLogicalPresentation = bl2;
    }

    public RoseNode getModelTree() {
        return this.modelTree;
    }

    public RoseNode getVersionTree() {
        return this.versionTree;
    }

    public void parse() {
        this.baseId = null;
        this.idStack.push(new Integer(0));
        this.versionTree = this.parseExpr("");
        this.idStack.push(new Integer(0));
        this.baseId = null;
        RoseNode.counter = 0;
        this.modelTree = this.parseExpr("");
        this.modelTree.localCounter = RoseNode.counter + 1;
        RoseLoader roseLoader = this.lexer.roseLoader;
        roseLoader.firePropertyChange("ROSE_LOADER_PROGRESS", roseLoader.oldValue, roseLoader.upper);
    }

    private RoseNode parseExpr(String string) {
        RoseToken roseToken = this.lexer.peekNext();
        if (roseToken.getType() == 2) {
            RoseNode roseNode;
            roseToken = this.lexer.getNext();
            roseToken = this.lexer.peekNext();
            if (roseToken.getType() == 0) {
                roseNode = this.parseObject(string);
                if (!this.isTreeOnly && roseNode == null) {
                    return null;
                }
            } else if (roseToken.getType() == 7) {
                roseNode = this.parseValue(string);
                if (!this.isTreeOnly && roseNode == null) {
                    return null;
                }
            } else if (roseToken.getType() == 1) {
                roseNode = this.parseList(string);
                if (!this.isTreeOnly && roseNode == null) {
                    return null;
                }
            } else {
                System.out.println("  Parsing error in parseExpr - expecting object or list");
                return null;
            }
            if ((roseToken = this.lexer.getNext()).getType() != 3) {
                System.out.println("  Parsing error in parseExpr - expecting right parenthesis");
                return null;
            }
            return roseNode;
        }
        return this.parseS_prime(string);
    }

    private RoseNode parseList(String string) {
        boolean bl = this.isAllowed;
        this.isAllowed = this.noLogicalPresentation ? !string.equals("logical_presentations") : true;
        if (!this.isListMapping) {
            this.isAllowed = false;
        }
        RoseNode roseNode = null;
        RoseToken roseToken = this.lexer.getNext();
        if (roseToken.getType() != 1) {
            System.out.println("  Parsing error in parseList - expecting list token");
            return null;
        }
        roseToken = this.lexer.getNext();
        if (roseToken.getType() != 6) {
            System.out.println("  Parsing error in parseList - expecting string");
            return null;
        }
        String string2 = roseToken.getValue();
        roseToken = this.lexer.peekNext();
        if (roseToken.getType() == 2) {
            roseNode = null;
            if (!this.isTreeOnly || this.isAllowed) {
                roseNode = new RoseNode(string, string2, 3);
            }
            do {
                if ((roseToken = this.lexer.getNext()).getType() != 2) {
                    System.out.println("  Parsing error in parseList - expecting left parenthesis");
                    return null;
                }
                RoseNode roseNode2 = this.parseObject("");
                if (this.isTreeOnly) {
                    if (roseNode != null && roseNode2 != null) {
                        roseNode.addNode(roseNode2);
                    }
                } else {
                    if (roseNode2 == null) {
                        return null;
                    }
                    roseNode.addNode(roseNode2);
                }
                if ((roseToken = this.lexer.getNext()).getType() == 3) continue;
                System.out.println("  Parsing error in parseList - expecting right parenthesis");
                return null;
            } while ((roseToken = this.lexer.peekNext()).getType() != 3);
        } else if (roseToken.getType() == 3) {
            roseNode = null;
            if (!this.isTreeOnly || this.isAllowed) {
                roseNode = new RoseNode(string, string2, 3);
            }
        } else if (roseToken.getType() == 6) {
            roseNode = null;
            if (!this.isTreeOnly || this.isAllowed) {
                roseNode = new RoseNode(string, string2, 3);
            }
            do {
                if ((roseToken = this.lexer.getNext()).getType() != 6) {
                    System.out.println("  Parsing error in parseList - expecting string");
                    return null;
                }
                RoseNode roseNode3 = null;
                roseNode3 = new RoseNode("", roseToken.getValue(), 0);
                if (roseNode == null) continue;
                roseNode.addNode(roseNode3);
            } while ((roseToken = this.lexer.peekNext()).getType() != 3);
        } else {
            this.lexer.getNext();
            System.out.println("  Parsing error in parseList - expecting left/right parenthesis or string " + roseToken.lineNum);
            roseNode = null;
        }
        this.isAllowed = bl;
        return roseNode;
    }

    private RoseNode parseObject(String string) {
        Integer n = (Integer)this.idStack.pop();
        int n2 = n;
        this.idStack.push(new Integer(++n2));
        this.idStack.push(new Integer(0));
        if (this.baseId == null) {
            this.baseId = "id";
        } else {
            this.baseId = this.baseId + ".";
            this.baseId = this.baseId + n.toString();
        }
        RoseToken roseToken = this.lexer.getNext();
        if (roseToken.getType() != 0) {
            System.out.println("  Parsing error in parseObject - expecting object token");
            return null;
        }
        roseToken = this.lexer.getNext();
        if (roseToken.getType() != 6) {
            System.out.println("  Parsing error in parseObject - expecting string");
            return null;
        }
        String string2 = roseToken.getValue();
        RoseNode roseNode = null;
        if (this.isTreeOnly) {
            if (string.equals("root_usecase_package") || string.equals("root_subsystem") || !this.mapProperties && string.equals("properties") && string2.equals("Properties")) {
                this.isListMapping = false;
            } else if (string.equals("root_category") || string.equals("process_structure") && string2.equals("Processes")) {
                this.isListMapping = true;
            }
        }
        roseNode = new RoseNode(string, string2, 2);
        roseNode.setId(this.baseId);
        while ((roseToken = this.lexer.peekNext()).getType() != 3) {
            roseToken = this.lexer.getNext();
            if (roseToken.getType() != 5) {
                System.out.println("  Parsing error in parseObject - expecting key " + roseToken.lineNum);
                return null;
            }
            String string3 = roseToken.getValue();
            RoseNode roseNode2 = this.parseExpr(string3);
            if (this.isTreeOnly) {
                if (roseNode == null || roseNode2 == null) continue;
                roseNode.addNode(roseNode2);
                continue;
            }
            if (roseNode2 == null) {
                return null;
            }
            roseNode.addNode(roseNode2);
        }
        this.idStack.pop();
        if (this.baseId.lastIndexOf(46) > 0) {
            this.baseId = this.baseId.substring(0, this.baseId.lastIndexOf(46));
        }
        return roseNode;
    }

    private RoseNode parseS_prime(String string) {
        RoseToken roseToken = this.lexer.peekNext();
        if (roseToken.getType() == 6) {
            roseToken = this.lexer.getNext();
            RoseNode roseNode = null;
            roseNode = new RoseNode(string, roseToken.getValue(), 0);
            return roseNode;
        }
        if (roseToken.getType() == 4) {
            RoseNode roseNode = null;
            roseNode = new RoseNode(string, "", 1);
            while ((roseToken = this.lexer.peekNext()).getType() == 4) {
                roseToken = this.lexer.getNext();
                roseToken = this.lexer.getNext();
                if (roseToken.getType() != 6) {
                    System.out.println("  Parsing error in parseS_prime - expecting string");
                    return null;
                }
                RoseNode roseNode2 = null;
                roseNode2 = new RoseNode("", roseToken.getValue(), 0);
                if (roseNode == null) continue;
                roseNode.addNode(roseNode2);
            }
            return roseNode;
        }
        this.lexer.printNeighbors();
        System.out.println("  Parsing error in parseS_prime - expecting string or | " + roseToken.lineNum);
        return null;
    }

    private RoseNode parseValue(String string) {
        Integer n = (Integer)this.idStack.pop();
        int n2 = n;
        this.idStack.push(new Integer(++n2));
        this.idStack.push(new Integer(0));
        if (this.baseId == null) {
            this.baseId = "id";
        } else {
            this.baseId = this.baseId + ".";
            this.baseId = this.baseId + n.toString();
        }
        RoseToken roseToken = this.lexer.getNext();
        if (roseToken.getType() != 7) {
            System.out.println("  Parsing error in parseValue - expecting value token");
            return null;
        }
        roseToken = this.lexer.getNext();
        if (roseToken.getType() != 6) {
            System.out.println("  Parsing error in parseValue - expecting string");
            return null;
        }
        String string2 = roseToken.getValue();
        RoseNode roseNode = null;
        roseNode = new RoseNode(string, string2, 4);
        roseNode.setId(this.baseId);
        RoseNode roseNode2 = this.parseS_prime("");
        if (this.isTreeOnly) {
            if (roseNode != null && roseNode2 != null) {
                roseNode.addNode(roseNode2);
            }
        } else {
            if (roseNode2 == null) {
                return null;
            }
            roseNode.addNode(roseNode2);
        }
        this.idStack.pop();
        if (this.baseId.lastIndexOf(46) > 0) {
            this.baseId = this.baseId.substring(0, this.baseId.lastIndexOf(46));
        }
        return roseNode;
    }

    public void traverseTree(Vector vector) {
        Object object;
        Object object2;
        RoseNode roseNode = this.modelTree;
        if (roseNode == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (roseNode.getType() == 0) {
                return;
            }
            object2 = roseNode.getNodes();
            object = (Integer)vector.elementAt(i);
            int n = (Integer)object;
            if (n < 1 || n > ((Vector)object2).size()) break;
            roseNode = (RoseNode)((Vector)object2).elementAt(n - 1);
        }
        String string = roseNode.getId();
        object2 = roseNode.getAtId();
        if (string == null) {
            string = "";
        }
        if (object2 == null) {
            object2 = "";
        }
        object = "";
        if (roseNode.getType() == 0) {
            object = "(STRING)";
        } else if (roseNode.getType() == 3) {
            object = "(LIST)";
        } else if (roseNode.getType() == 2) {
            object = "(OBJECT)";
        } else if (roseNode.getType() == 1) {
            object = "(STRING_SEQ)";
        } else if (roseNode.getType() == 4) {
            object = "(VALUE)";
        }
        System.out.println((String)object + "\t" + roseNode.getKey() + " --- " + roseNode.getValue() + " - " + string + " - " + (String)object2);
        Vector vector2 = roseNode.getNodes();
        int n = 1;
        for (int i = 0; i < vector2.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector2.elementAt(i);
            String string2 = "";
            if (roseNode2.getType() == 0) {
                string2 = "(STRING)";
            } else if (roseNode2.getType() == 3) {
                string2 = "(LIST)";
            } else if (roseNode2.getType() == 2) {
                string2 = "(OBJECT)";
            } else if (roseNode2.getType() == 1) {
                string2 = "(STRING_SEQ)";
            } else if (roseNode2.getType() == 4) {
                string2 = "(VALUE)";
            }
            System.out.println(n + " " + string2 + "\t" + roseNode2.getKey() + " --- " + roseNode2.getValue());
            ++n;
        }
    }

    public static void traverseTree(Vector vector, RoseNode roseNode) {
        int n;
        Serializable serializable;
        Object object;
        RoseNode roseNode2 = roseNode;
        if (roseNode2 == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (roseNode2.getType() == 0) {
                return;
            }
            object = roseNode2.getNodes();
            serializable = (Integer)vector.elementAt(i);
            n = (Integer)serializable;
            if (n < 1 || n > ((Vector)object).size()) break;
            roseNode2 = (RoseNode)((Vector)object).elementAt(n - 1);
        }
        String string = roseNode2.getId();
        object = roseNode2.getAtId();
        if (string == null) {
            string = "";
        }
        if (object == null) {
            object = "";
        }
        System.out.println(roseNode2.getKey() + " --- " + roseNode2.getValue() + " - " + string + " - " + (String)object);
        serializable = roseNode2.getNodes();
        n = 1;
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            RoseNode roseNode3 = (RoseNode)((Vector)serializable).elementAt(i);
            String string2 = "";
            if (roseNode3.getType() == 0) {
                string2 = "(STRING)";
            } else if (roseNode3.getType() == 3) {
                string2 = "(LIST)";
            } else if (roseNode3.getType() == 2) {
                string2 = "(OBJECT)";
            } else if (roseNode3.getType() == 1) {
                string2 = "(STRING_SEQ)";
            } else if (roseNode3.getType() == 4) {
                string2 = "(VALUE)";
            }
            System.out.println(n + " " + string2 + "\t" + roseNode3.getKey() + " --- " + roseNode3.getValue());
            ++n;
        }
    }
}

