/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.roseparser;

import com.ibm.psh.roseparser.Util;
import java.util.StringTokenizer;
import java.util.Vector;

public class RoseNode {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String key;
    private String value;
    private RoseNode parent;
    private Vector nodes = new Vector();
    private int type;
    private String id;
    private boolean commit = true;
    private Object node = null;
    public static int counter = 0;
    public int localCounter = 0;
    public static final int STRING = 0;
    public static final int STRING_SEQ = 1;
    public static final int OBJECT = 2;
    public static final int LIST = 3;
    public static final int VALUE = 4;

    public RoseNode(String string, String string2, int n) {
        if (n == 2) {
            ++counter;
        }
        this.key = string;
        this.value = string2;
        this.type = n;
    }

    public void addNode(RoseNode roseNode) {
        roseNode.parent = this;
        if (roseNode.getType() == 0 || roseNode.getType() == 1 || roseNode.getType() == 4) {
            this.nodes.addElement(roseNode);
        } else {
            this.nodes.addElement(roseNode);
        }
    }

    public void addNode(RoseNode roseNode, boolean bl) {
        roseNode.parent = this;
        this.nodes.addElement(roseNode);
    }

    public void deleteNode(RoseNode roseNode) {
        if (roseNode == null) {
            return;
        }
        this.nodes.removeElement(roseNode);
    }

    public RoseNode findNodeWithKey(String string) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RoseNode roseNode = (RoseNode)this.nodes.elementAt(i);
            if (!string.equals(roseNode.getKey())) continue;
            return roseNode;
        }
        return null;
    }

    public RoseNode findNodeWithValue(String string) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RoseNode roseNode = (RoseNode)this.nodes.elementAt(i);
            if (!string.equals(roseNode.getValue())) continue;
            return roseNode;
        }
        return null;
    }

    public RoseNode findNodeWithWord(String string) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RoseNode roseNode = (RoseNode)this.nodes.elementAt(i);
            String string2 = roseNode.getValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string)) continue;
                return roseNode;
            }
        }
        return null;
    }

    public String getAllValues() {
        return this.getAllValues(false);
    }

    public String getAllValues(boolean bl) {
        if (this.type == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.nodes.size(); ++i) {
                RoseNode roseNode = (RoseNode)this.nodes.elementAt(i);
                stringBuffer.append(roseNode.getValue());
                if (!bl || i >= this.nodes.size() - 1) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        if (bl) {
            return Util.trimQuotes(this.value);
        }
        return this.value;
    }

    public String getAtId() {
        int n = this.value.lastIndexOf("@");
        if (n != -1) {
            return this.value.substring(n + 1);
        }
        return null;
    }

    public boolean getCommit() {
        return this.commit;
    }

    public String getFilteredValues(String string) {
        if (this.type == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.nodes.size(); ++i) {
                RoseNode roseNode = (RoseNode)this.nodes.elementAt(i);
                if (i == 0 && Util.getWord(roseNode.getValue(), 1).equals(string)) continue;
                stringBuffer.append(roseNode.getValue());
                if (i >= this.nodes.size() - 1) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        String string2 = Util.trimQuotes(this.value);
        if (Util.getWord(string2, 1).equals(string)) {
            return "";
        }
        return string2;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public Object getNode() {
        if (this.node != null) {
            return this.node;
        }
        return null;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public RoseNode getParent() {
        return this.parent;
    }

    public String getRoseId() {
        RoseNode roseNode = this.findNodeWithKey("quid");
        if (roseNode != null) {
            return roseNode.getValue();
        }
        return null;
    }

    public String getRoseRefId() {
        RoseNode roseNode = this.findNodeWithKey("quidu");
        if (roseNode != null) {
            return roseNode.getValue();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setCommit(boolean bl) {
        this.commit = bl;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setNode(Object object) {
        this.node = object;
    }

    public void setValue(String string) {
        this.value = string;
    }
}

