/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.roseparser;

import com.ibm.psh.roseparser.RoseComponent;
import com.ibm.psh.roseparser.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class RoseLoader
extends RoseComponent {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private BufferedReader buffReader;
    private long length = 0L;
    private long currLength = 0L;
    private int progressIncrement = 10;
    int oldValue;
    int lower = 0;
    int upper = 100;
    public static final String PROGRESS = "ROSE_LOADER_PROGRESS";

    public RoseLoader(String string) throws Exception {
        if (!string.startsWith("\\\\")) {
            string = Util.updateFileName(string, "\\\\");
        }
        string = Util.updateFileName(string, "\\");
        string = Util.updateFileName(string, "/");
        this.buffReader = new BufferedReader(new FileReader(string));
        this.length = new File(string).length();
        this.currLength = 0L;
        this.oldValue = this.lower;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public String readLine() {
        try {
            int n;
            String string = this.buffReader.readLine();
            this.currLength += (long)string.length();
            if (this.length > 0L && (n = this.lower + (int)(this.currLength * (long)(this.upper - this.lower) / this.length)) >= this.oldValue + this.progressIncrement && n < this.upper) {
                this.firePropertyChange(PROGRESS, this.oldValue, n);
                this.oldValue = n;
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setLower(int n) {
        this.lower = n;
        this.oldValue = n;
    }

    public void setProgressIncrement(int n) {
        this.progressIncrement = n;
    }

    public void setUpper(int n) {
        this.upper = n;
    }
}

