/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.roseparser;

import com.ibm.psh.roseparser.RoseLoader;
import com.ibm.psh.roseparser.RoseToken;
import java.util.StringTokenizer;
import java.util.Vector;

public class RoseLexer {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    RoseLoader roseLoader;
    private Vector tokens = new Vector();
    private int currElement = 0;
    private boolean isList = false;
    private int lineCounter = 0;

    public RoseLexer(RoseLoader roseLoader) {
        this.roseLoader = roseLoader;
    }

    public RoseToken getNext() {
        if (this.currElement >= this.tokens.size()) {
            this.getNextBlock();
        }
        if (this.currElement < this.tokens.size()) {
            RoseToken roseToken = (RoseToken)this.tokens.elementAt(this.currElement);
            ++this.currElement;
            return roseToken;
        }
        return null;
    }

    private void getNextBlock() {
        RoseToken roseToken = null;
        if (this.tokens.size() > this.currElement) {
            roseToken = (RoseToken)this.tokens.elementAt(this.currElement);
        }
        this.tokens.removeAllElements();
        if (roseToken != null) {
            this.tokens.addElement(roseToken);
        }
        this.currElement = 0;
        System.gc();
        this.readLines();
    }

    public RoseToken peekNext() {
        if (this.currElement >= this.tokens.size()) {
            this.getNextBlock();
        }
        if (this.currElement < this.tokens.size()) {
            return (RoseToken)this.tokens.elementAt(this.currElement);
        }
        return null;
    }

    public void printNeighbors() {
        int n = 100;
        if (this.currElement < 100) {
            n = this.currElement;
        }
        for (int i = this.currElement - n; i <= this.currElement; ++i) {
            RoseToken roseToken = (RoseToken)this.tokens.elementAt(i);
            System.out.println(roseToken.getToken());
        }
    }

    private void processToTheEnd(String string, int n) {
        int n2 = this.tokens.size();
        if (string.length() == 0) {
            RoseToken roseToken = new RoseToken(6, string);
            roseToken.lineNum = n;
            this.tokens.addElement(roseToken);
            return;
        }
        int n3 = string.indexOf("\"");
        int n4 = string.lastIndexOf("\"");
        if (n3 != -1 && n3 == n4) {
            String string2 = this.roseLoader.readLine();
            string = string + string2;
            while (string2.indexOf("\"") == -1) {
                string2 = this.roseLoader.readLine();
                string = string + string2;
            }
        }
        int n5 = 0;
        while (string.charAt(string.length() - 1) == ')') {
            ++n5;
            string = string.substring(0, string.length() - 1);
        }
        if (string.charAt(0) == '(') {
            --n5;
            string = string + ")";
        }
        RoseToken roseToken = new RoseToken(6, string);
        roseToken.lineNum = n;
        this.tokens.addElement(roseToken);
        for (int i = 0; i < n5; ++i) {
            this.isList = false;
            roseToken = new RoseToken(3, "");
            roseToken.lineNum = n;
            this.tokens.addElement(roseToken);
        }
    }

    private void processValueToTheEnd(String string, int n) {
        String string2;
        String string3;
        int n2;
        int n3 = this.tokens.size();
        if (string.length() == 0) {
            RoseToken roseToken = new RoseToken(6, string);
            roseToken.lineNum = n;
            this.tokens.addElement(roseToken);
            return;
        }
        int n4 = 0;
        while (string.charAt(string.length() - 1) == ')') {
            ++n4;
            string = string.substring(0, string.length() - 1);
        }
        if (string.charAt(0) == '(') {
            --n4;
            string = string + ")";
        }
        if ((n2 = string.indexOf(" ")) == -1) {
            n2 = string.indexOf("\t");
        }
        if (n2 != -1) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2).trim();
        } else {
            string3 = string;
            string2 = "";
        }
        RoseToken roseToken = new RoseToken(6, string3);
        roseToken.lineNum = n;
        this.tokens.addElement(roseToken);
        if (string2.length() > 0) {
            roseToken = new RoseToken(6, string2);
            roseToken.lineNum = n;
            this.tokens.addElement(roseToken);
        }
        for (int i = 0; i < n4; ++i) {
            this.isList = false;
            roseToken = new RoseToken(3, "");
            roseToken.lineNum = n;
            this.tokens.addElement(roseToken);
        }
    }

    public void readLines() {
        block0: for (int i = 0; i < 1000; ++i) {
            String string;
            RoseToken roseToken;
            String string2 = this.roseLoader.readLine();
            if (string2 == null) {
                return;
            }
            ++this.lineCounter;
            if (this.lineCounter % 1000 == 0) {
                // empty if block
            }
            if (string2.length() == 0) {
                --i;
                continue;
            }
            if (string2.charAt(0) == '|') {
                roseToken = new RoseToken(4, "");
                roseToken.lineNum = this.lineCounter;
                this.tokens.addElement(roseToken);
                string2 = string2.substring(1);
                roseToken = new RoseToken(6, string2);
                roseToken.lineNum = this.lineCounter;
                this.tokens.addElement(roseToken);
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = 0;
            while (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals("#")) {
                int n2;
                String string3;
                int n3;
                string2 = string2.substring(string2.indexOf(string));
                if (string.equals("(object")) {
                    this.isList = false;
                    roseToken = new RoseToken(2, "");
                    roseToken.lineNum = this.lineCounter;
                    this.tokens.addElement(roseToken);
                    roseToken = new RoseToken(0, "");
                    roseToken.lineNum = this.lineCounter;
                    this.tokens.addElement(roseToken);
                    string2 = string2.substring(7).trim();
                    this.processToTheEnd(string2, this.lineCounter);
                    continue block0;
                }
                if (string.equals("(list")) {
                    this.isList = true;
                    roseToken = new RoseToken(2, "");
                    roseToken.lineNum = this.lineCounter;
                    this.tokens.addElement(roseToken);
                    roseToken = new RoseToken(1, "");
                    roseToken.lineNum = this.lineCounter;
                    this.tokens.addElement(roseToken);
                    string2 = string2.substring(5).trim();
                    this.processToTheEnd(string2, this.lineCounter);
                    continue block0;
                }
                if (string.equals("(value")) {
                    this.isList = false;
                    roseToken = new RoseToken(2, "");
                    roseToken.lineNum = this.lineCounter;
                    this.tokens.addElement(roseToken);
                    roseToken = new RoseToken(7, "");
                    roseToken.lineNum = this.lineCounter;
                    this.tokens.addElement(roseToken);
                    string2 = string2.substring(6).trim();
                    this.processValueToTheEnd(string2, this.lineCounter);
                    continue block0;
                }
                if (n == 0 && string.charAt(0) == ')') {
                    n3 = 0;
                    string3 = string;
                    while (string3.length() > 0 && string3.charAt(string3.length() - 1) == ')') {
                        ++n3;
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.isList = false;
                        roseToken = new RoseToken(3, "");
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.addElement(roseToken);
                    }
                    continue block0;
                }
                if (n == 0) {
                    if (this.isList) {
                        n3 = 0;
                        string3 = string2.trim();
                        while (string3.charAt(string3.length() - 1) == ')') {
                            ++n3;
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        if (string2.charAt(0) == '(') {
                            --n3;
                            string3 = string3 + ")";
                        }
                        roseToken = new RoseToken(6, string3);
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.addElement(roseToken);
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.isList = false;
                            roseToken = new RoseToken(3, "");
                            roseToken.lineNum = this.lineCounter;
                            this.tokens.addElement(roseToken);
                        }
                        continue block0;
                    }
                } else {
                    this.isList = false;
                    string2 = string2.trim();
                    this.processToTheEnd(string2, this.lineCounter);
                    continue block0;
                }
                this.isList = false;
                roseToken = new RoseToken(5, string);
                roseToken.lineNum = this.lineCounter;
                this.tokens.addElement(roseToken);
                ++n;
            }
        }
    }
}

