/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.rb30;

import com.ibm.psh.rb30.ModelElements;
import com.ibm.psh.rb30.ResourceUtil;
import com.ibm.psh.rb30.RoseUtil;
import com.ibm.psh.rb30.TableObject;
import com.ibm.psh.rb30.UnitTreeNode;
import com.ibm.psh.roseparser.RoseNode;
import com.ibm.psh.roseparser.Util;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UMLException;
import java.util.Enumeration;
import java.util.Vector;

public class RoseVisitorTNG {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Id sessionId;
    private Id dataTypePkgId;
    private UnitTreeNode currentUnitTreeNode;
    private boolean bContinue;

    public RoseVisitorTNG(Id id, Id id2, UnitTreeNode unitTreeNode) {
        this.sessionId = id;
        this.dataTypePkgId = id2;
        this.currentUnitTreeNode = unitTreeNode;
        this.bContinue = true;
    }

    private void createAssociationEndAEType(Id id, String string, String string2) {
        if (string2 != null) {
            Id id2 = this.getIdFromQUID_IdTable(string2);
            if (id2 != null) {
                ModelElements.add(id, Link.AE_TYPE, id2);
                ModelElements.add(id2, Link.CL_ASSOCIATION_END, id);
            } else {
                RoseUtil.Role_AETypeTable.put(id, string2);
                if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                    int n = string.indexOf("::");
                    string = string.substring(n + 2, string.length());
                }
                ModelElements.set(id, "", "supplier", string);
                ModelElements.set(id, "", "quidu", string2);
            }
        } else {
            if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                int n = string.indexOf("::");
                string = string.substring(n + 2, string.length());
            }
            ModelElements.set(id, "", "supplier", string);
        }
    }

    private void createDependencySupplier(Id id, String string, String string2) {
        if (string2 != null) {
            Id id2 = this.getIdFromQUID_IdTable(string2);
            if (id2 != null) {
                ModelElements.add(id, Link.SUPPLIER, id2);
                ModelElements.add(id2, Link.PROVISION, id);
            } else {
                RoseUtil.Dependency_SupplierTable.put(id, string2);
                if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                    int n = string.indexOf("::");
                    string = string.substring(n + 2, string.length());
                }
                ModelElements.set(id, "", "supplier", string);
                ModelElements.set(id, "", "quidu", string2);
            }
        } else {
            if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                int n = string.indexOf("::");
                string = string.substring(n + 2, string.length());
            }
            ModelElements.set(id, "Rose", "supplier", string);
        }
    }

    private void createEnumerationLiteral(Id id, String string, RoseNode roseNode) {
        String string2;
        Id id2;
        int n = string.trim().indexOf(" ");
        String string3 = "";
        String string4 = RoseUtil.getUUID(roseNode);
        while (n != -1) {
            string3 = string.substring(0, n);
            string = string.substring(n + 1, string.length()).trim();
            id2 = ModelElements.addConstruct(id, Type.ENUMERATION_LITERAL, string3);
            string2 = string4 + "/" + string3;
            ModelElements.setUUID(id2, string2);
            n = string.indexOf(" ");
        }
        if (!string.equals("")) {
            id2 = ModelElements.addConstruct(id, Type.ENUMERATION_LITERAL, string);
            string2 = string4 + "/" + string;
            ModelElements.setUUID(id2, string2);
        }
    }

    private void createGeneralizationSuperType(Id id, String string, String string2) {
        if (string2 != null) {
            Id id2 = this.getIdFromQUID_IdTable(string2);
            if (id2 != null) {
                ModelElements.add(id, Link.SUPERTYPE, id2);
                ModelElements.add(id2, Link.SPECIALIZATION, id);
            } else {
                RoseUtil.Generalization_SuperTypeTable.put(id, string2);
                if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                    int n = string.indexOf("::");
                    string = string.substring(n + 2, string.length());
                }
                ModelElements.set(id, "", "supplier", string);
                ModelElements.set(id, "", "quidu", string2);
            }
        } else {
            if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                int n = string.indexOf("::");
                string = string.substring(n + 2, string.length());
            }
            ModelElements.set(id, "", "supplier", string);
        }
    }

    private void createLinkBetweenSupplierAndLinkConstruct(Id id, TableObject tableObject) {
        String string = tableObject.getQUID();
        Vector vector = (Vector)RoseUtil.supplier_LinkTable.get(string);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                TableObject tableObject2 = (TableObject)RoseUtil.uuid_InfoTable.get(string2);
                if (tableObject2.getXMIBaseFileName().equals(tableObject.getXMIBaseFileName())) continue;
                Id id2 = null;
                id2 = tableObject2.getName() == null ? ModelElements.addConstruct(this.sessionId, tableObject2.getType()) : ModelElements.addConstruct(this.sessionId, tableObject2.getType(), tableObject2.getName());
                if (id2 == null) continue;
                ModelElements.setUUID(id2, tableObject2.getUUID());
                if (!RoseUtil.bNoExtension) {
                    ModelElements.set(id2, "Rose", "quid", tableObject2.getQUID());
                }
                if (RoseUtil.bSetXMIFILETag) {
                    ModelElements.set(id2, "", "xmiFile", tableObject2.getXMIBaseFileName());
                    ModelElements.set(id2, "", "is_unit", tableObject2.getUnit());
                }
                if (id2.getType() == Type.GENERALIZATION) {
                    ModelElements.add(id, Link.SPECIALIZATION, id2);
                    continue;
                }
                if (id2.getType() == Type.ASSOCIATION_END) {
                    ModelElements.add(id, Link.CL_ASSOCIATION_END, id2);
                    continue;
                }
                if (id2.getType() != Type.DEPENDENCY) continue;
                ModelElements.add(id, Link.PROVISION, id2);
            }
        }
    }

    private void createPresentations(Id id, RoseNode roseNode) {
        Id id2 = null;
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            Id id3;
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            String string = roseNode2.getKey();
            String string2 = Util.getType(roseNode2.getValue());
            String string3 = Util.getName(roseNode2.getValue());
            if (roseNode2.getType() != 2) continue;
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(Property.XMI_EXTENDER);
            vector2.addElement("UMLNotation");
            vector2.addElement(Property.XMI_EXTENDER_ID);
            vector2.addElement("UMLNotation");
            Vector vector3 = ModelElements.get(id, Type.XMI_EXTENSION, vector2, false);
            if (vector3 == null) {
                id2 = ModelElements.addConstruct(id, Type.XMI_EXTENSION, null);
                if (id2 != null) {
                    ModelElements.set(id2, Property.XMI_EXTENDER, "UMLNotation");
                    ModelElements.set(id2, Property.XMI_EXTENDER_ID, "UMLNotation");
                }
            } else if (vector3.size() == 1) {
                id2 = (Id)vector3.elementAt(0);
            }
            if (id2 == null) continue;
            if (RoseUtil.debug) {
                System.out.println("key - value: " + string + ", " + roseNode2.getValue());
                System.out.println("Create Type.PRESENTATION under XMI_EXTENSION");
            }
            if ((id3 = ModelElements.addConstruct(id2, Type.PRESENTATION)) == null) continue;
            if (id.getType() == Type.VIEW_ELEMENT) {
                ModelElements.add(id, Link.VE_PRESENTATION, id3);
                ModelElements.add(id3, Link.PR_VIEW, id);
            }
            roseNode2.setNode(id3);
            String string4 = roseNode2.getRoseRefId();
            if (string4 != null) {
                Id id4 = this.getIdFromQUID_IdTable(string4 = string4.substring(1, string4.length() - 1));
                if (id4 != null) {
                    if (id4.getType() == Type.EXTENSION) {
                        Id id5 = ModelElements.addConstruct(id3, Type.XMI_EXTENSION, null);
                        if (id5 != null) {
                            ModelElements.set(id5, Property.XMI_EXTENDER, "Rose");
                            ModelElements.set(id5, Property.XMI_EXTENDER_ID, "Rose");
                            Id id6 = ModelElements.addConstruct(id5, Type.EXTENSION);
                            if (id6 != null) {
                                ModelElements.add(id6, Link.EXTENSION_REFERENCE, id4);
                            }
                        }
                    } else {
                        ModelElements.add(id3, Link.P_MODEL, id4);
                        ModelElements.add(id4, Link.PRESENTATION, id3);
                    }
                } else {
                    RoseUtil.Presentation_ModelElementTable.put(id3, string4);
                }
            }
            this.setProperty(id3, roseNode2);
            this.createSubPresentations(id3, roseNode2);
        }
    }

    private void createRealizeSupplier(Id id, Id id2, String string, String string2) {
        if (string2 != null) {
            Id id3 = this.getIdFromQUID_IdTable(string2);
            if (id3 != null) {
                ModelElements.add(id, Link.CL_SPECIFICATION, id3);
                ModelElements.add(id3, Link.REALIZATION, id);
                ModelElements.add(id2, Link.EXTENSION_REFERENCE, id3);
            } else {
                RoseUtil.Realization_SupplierTable.put(id2, string2);
                RoseUtil.ClassId_RealizationTable.put(id2, id);
                if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                    int n = string.indexOf("::");
                    string = string.substring(n + 2, string.length());
                }
                ModelElements.set(id2, "", "supplier", string);
                ModelElements.set(id2, "", "quidu", string2);
            }
        } else {
            if (string.startsWith(ResourceUtil.getString("LOGICAL_VIEW"))) {
                int n = string.indexOf("::");
                string = string.substring(n + 2, string.length());
            }
            ModelElements.set(id2, "", "supplier", string);
        }
    }

    private void createReturnParameter(Id id, String string) {
        Id id2;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(Property.PA_KIND);
        vector.addElement("return");
        Vector vector2 = ModelElements.get(id, Type.PARAMETER, vector, false);
        Id id3 = null;
        if (vector2 == null) {
            id3 = ModelElements.addConstruct(id, Type.PARAMETER);
            if (id3 != null) {
                ModelElements.set(id3, Property.PA_KIND, "return");
                ModelElements.setUUID(id3, id.getUUID() + ":" + "return");
                if (RoseUtil.debug) {
                    System.out.println("Return parameter's UUID: " + id3.getUUID());
                }
            }
        } else if (vector2.size() == 1) {
            id3 = (Id)vector2.elementAt(0);
        }
        if (id3 != null && (id2 = ModelElements.getDataTypeId(this.dataTypePkgId, string)) != null) {
            Id id4;
            Vector vector3 = ModelElements.get(id3, Link.PARM_TYPE, false);
            if (vector3 == null) {
                ModelElements.add(id3, Link.PARM_TYPE, id2);
                ModelElements.add(id2, Link.CL_PARAMETER, id3);
            } else if (vector3.size() == 1 && !ModelElements.get(id4 = (Id)vector3.elementAt(0), Property.NAME).equals(string)) {
                ModelElements.delete(id3, Link.PARM_TYPE, id4);
                ModelElements.delete(id4, Link.CL_PARAMETER, id3);
                ModelElements.add(id3, Link.PARM_TYPE, id2);
                ModelElements.add(id2, Link.CL_PARAMETER, id3);
            }
        }
    }

    private void createSubPresentations(Id id, RoseNode roseNode) {
        Id id2 = null;
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            if (roseNode2.getType() == 2) {
                Id id3;
                Vector<Object> vector2 = new Vector<Object>();
                vector2.addElement(Property.XMI_EXTENDER);
                vector2.addElement("UMLNotation");
                vector2.addElement(Property.XMI_EXTENDER_ID);
                vector2.addElement("UMLNotation");
                Vector vector3 = ModelElements.get(id, Type.XMI_EXTENSION, vector2, false);
                if (vector3 == null) {
                    id2 = ModelElements.addConstruct(id, Type.XMI_EXTENSION, null);
                    if (id2 != null) {
                        ModelElements.set(id2, Property.XMI_EXTENDER, "UMLNotation");
                        ModelElements.set(id2, Property.XMI_EXTENDER_ID, "UMLNotation");
                    }
                } else if (vector3.size() == 1) {
                    id2 = (Id)vector3.elementAt(0);
                }
                if (id2 == null) continue;
                if (RoseUtil.debug) {
                    System.out.println("key - value: " + roseNode2.getKey() + ", " + roseNode2.getValue());
                    System.out.println("Create Type.PRESENTATION under XMI_EXTENSION");
                }
                if ((id3 = ModelElements.addConstruct(id2, Type.PRESENTATION)) == null) continue;
                ModelElements.set(id3, "UMLNotation", "name", roseNode2.getValue());
                ModelElements.set(id3, "Rose", "presentationFor", roseNode2.getKey());
                roseNode2.setNode(id3);
                this.setProperty(id3, roseNode2);
                this.createSubPresentations(id3, roseNode2);
                continue;
            }
            if (roseNode2.getType() != 3 || !roseNode2.getKey().equals("roleview_list")) continue;
            this.createPresentations(id, roseNode2);
        }
    }

    private Vector findClassInPackage(Id id) {
        Vector vector = null;
        if (id != null) {
            try {
                vector = id.get(Type.CLASS, true);
            }
            catch (UMLException uMLException) {
                // empty catch block
            }
        }
        return vector;
    }

    private String findMatchInClass(Vector vector, String string, Id id) {
        String string2 = string;
        if (vector != null) {
            if (RoseUtil.debug) {
                System.out.println("---> findMatchInClass classes === " + vector);
            }
            boolean bl = false;
            for (int i = 0; i < vector.size() && !bl; ++i) {
                Id id2 = (Id)vector.elementAt(i);
                try {
                    String string3 = id2.get(Property.NAME);
                    if (!string3.equals(string)) continue;
                    String string4 = id.get(Property.NAME);
                    string2 = string4 + "/" + string3;
                    bl = true;
                    continue;
                }
                catch (UMLException uMLException) {
                    // empty catch block
                }
            }
        }
        return string2;
    }

    private Id findPackageId(Id id) {
        Id id2 = null;
        try {
            Id id3;
            Vector vector;
            Id id4 = null;
            Vector vector2 = null;
            if (id.getType() == Type.ATTRIBUTE) {
                vector2 = id.get(Link.OWNER, false);
            } else if (id.getType() == Type.PARAMETER && (vector = id.get(Link.BEHAVIORAL_FEATURE, false)) != null && vector.size() > 0 && (id3 = (Id)vector.elementAt(0)) != null) {
                vector2 = id3.get(Link.OWNER, false);
            }
            if (RoseUtil.debug) {
                System.out.println("---> findPackageId,  this id name == " + id.get(Property.NAME));
                System.out.println("---> findPackageId,  ownerIds == " + vector2);
            }
            if (vector2 != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    id3 = (Id)vector2.elementAt(i);
                    if (id3.getType() != Type.CLASS) continue;
                    id4 = id3;
                }
            }
            if (id4 != null) {
                vector = id4.get(Link.NAMESPACE, false);
                if (vector != null && vector.size() > 0) {
                    id2 = id3 = (Id)vector.elementAt(0);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> findPackageId,  classOwnerId name == " + id4.get(Property.NAME));
                    System.out.println("---> findPackageId,  packageid = " + id2 + " and it's name =" + id2.get(Property.NAME));
                }
            }
        }
        catch (UMLException uMLException) {
            // empty catch block
        }
        return id2;
    }

    private Id getIdFromQUID_IdTable(String string) {
        if (string != null) {
            return (Id)RoseUtil.QUID_IdTable.get(string);
        }
        return null;
    }

    private Id getStereoTypeId(RoseNode roseNode, String string) {
        Id id = null;
        RoseNode roseNode2 = roseNode;
        RoseNode roseNode3 = roseNode2.getParent();
        while (roseNode3 != null) {
            if (roseNode3.getNode() != null) {
                id = (Id)roseNode3.getNode();
            }
            roseNode2 = roseNode3;
            roseNode3 = roseNode2.getParent();
        }
        Id id2 = null;
        if (id != null && (id.getType() == Type.PACKAGE || id.getType() == Type.MODEL)) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(Property.NAME);
            vector.addElement(string);
            Vector vector2 = ModelElements.get(id, Type.STEREOTYPE, vector, false);
            if (vector2 != null && vector2.size() == 1) {
                id2 = (Id)vector2.elementAt(0);
            } else {
                id2 = ModelElements.addConstruct(id, Type.STEREOTYPE, string);
                ModelElements.setUUID(id2, string);
            }
        }
        return id2;
    }

    private void setAEIDLDefaultProperties(Id id) {
        if (RoseUtil.IDLForAETable != null && RoseUtil.IDLForAETable.size() > 0) {
            Enumeration enumeration = RoseUtil.IDLForAETable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)RoseUtil.IDLForAETable.get(string);
                ModelElements.set(id, "IDL", string, string2);
            }
        }
    }

    private void setAggregationProperty(Id id, RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithKey("is_aggregate");
        String string = "";
        if (roseNode2 == null) {
            string = "none";
        } else {
            RoseNode roseNode3 = roseNode.getParent();
            Vector vector = roseNode3.getNodes();
            RoseNode roseNode4 = null;
            if (vector != null) {
                for (int i = 0; i < vector.size() && (roseNode4 = (RoseNode)vector.elementAt(i)) == roseNode; ++i) {
                }
            }
            RoseNode roseNode5 = null;
            if (roseNode4 != null) {
                roseNode5 = roseNode4.findNodeWithKey("Containment");
            }
            string = "shared";
            if (roseNode5 != null) {
                String string2 = roseNode5.getValue();
                if ((string2 = string2.substring(1, string2.length() - 1)).equals("By Value")) {
                    string = "composite";
                }
            }
        }
        ModelElements.set(id, Property.AGGREGATION, string);
    }

    private void setAttrDDLDefaultProperties(Id id) {
        if (RoseUtil.DDLForAttrTable != null && RoseUtil.DDLForAttrTable.size() > 0) {
            Enumeration enumeration = RoseUtil.DDLForAttrTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)RoseUtil.DDLForAttrTable.get(string);
                ModelElements.set(id, "DDL", string, string2);
            }
        }
    }

    private void setAttrIDLDefaultProperties(Id id) {
        if (RoseUtil.IDLForAttrTable != null && RoseUtil.IDLForAttrTable.size() > 0) {
            Enumeration enumeration = RoseUtil.IDLForAttrTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)RoseUtil.IDLForAttrTable.get(string);
                ModelElements.set(id, "IDL", string, string2);
            }
        }
    }

    private void setClsIDLDefaultProperties(Id id) {
        if (RoseUtil.IDLForClsTable != null && RoseUtil.IDLForClsTable.size() > 0) {
            Enumeration enumeration = RoseUtil.IDLForClsTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)RoseUtil.IDLForClsTable.get(string);
                ModelElements.set(id, "IDL", string, string2);
            }
        }
    }

    private void setOprIDLDefaultProperties(Id id) {
        if (RoseUtil.IDLForOprTable != null && RoseUtil.IDLForOprTable.size() > 0) {
            Enumeration enumeration = RoseUtil.IDLForOprTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)RoseUtil.IDLForOprTable.get(string);
                ModelElements.set(id, "IDL", string, string2);
            }
        }
    }

    private void setPkgIDLDefaultProperties(Id id) {
        if (RoseUtil.IDLForPkgTable != null && RoseUtil.IDLForPkgTable.size() > 0) {
            Enumeration enumeration = RoseUtil.IDLForPkgTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)RoseUtil.IDLForPkgTable.get(string);
                ModelElements.set(id, "IDL", string, string2);
            }
        }
    }

    private void setProperty(Id id, RoseNode roseNode) {
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            if (roseNode2.getType() == 0) {
                this.visitString(id, roseNode2);
                continue;
            }
            if (roseNode2.getType() == 1) {
                this.visitStringSeq(id, roseNode2);
                continue;
            }
            if (roseNode2.getType() != 4) continue;
            this.visitValue(id, roseNode2);
        }
    }

    private void setPropertyAttributes(Id id, RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
        if (roseNode2 != null && !RoseUtil.bNoExtension) {
            Vector vector;
            if (RoseUtil.debug) {
                System.out.println("setPropertyAttributes");
            }
            if ((vector = roseNode2.getNodes()) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    RoseNode roseNode3 = (RoseNode)vector.elementAt(i);
                    Vector vector2 = roseNode3.getNodes();
                    if (vector2 == null) continue;
                    Object object = "";
                    Object object2 = "";
                    Object object3 = "";
                    for (int j = 0; j < vector2.size(); ++j) {
                        Object object4;
                        RoseNode roseNode4 = (RoseNode)vector2.elementAt(j);
                        if (roseNode4.getType() == 0) {
                            object4 = roseNode4.getValue();
                            if (((String)object4).startsWith("\"") && ((String)object4).endsWith("\"")) {
                                object4 = ((String)object4).substring(1, ((String)object4).length() - 1);
                            }
                            if (roseNode4.getKey().equals("tool")) {
                                object = object4;
                                continue;
                            }
                            if (roseNode4.getKey().equals("name")) {
                                object2 = object4;
                                continue;
                            }
                            if (!roseNode4.getKey().equals("value")) continue;
                            object3 = object4;
                            continue;
                        }
                        if (roseNode4.getType() != 4 || (object4 = roseNode4.getNodes()) == null || ((Vector)object4).size() != 1) continue;
                        RoseNode roseNode5 = (RoseNode)((Vector)object4).elementAt(0);
                        String string = roseNode5.getValue();
                        if (string.startsWith("\"") && string.endsWith("\"")) {
                            string = string.substring(1, string.length() - 1);
                        }
                        if (roseNode4.getKey().equals("tool")) {
                            object = string;
                            continue;
                        }
                        if (roseNode4.getKey().equals("name")) {
                            object2 = string;
                            continue;
                        }
                        if (!roseNode4.getKey().equals("value")) continue;
                        object3 = string;
                    }
                    if (((String)object).equals("Java") && ((String)object2).equals("Static") && ((String)object3).equals("TRUE")) {
                        if (id.getType() == Type.ATTRIBUTE) {
                            if (RoseUtil.debug) {
                                System.out.println("---> store classifier as Porperty.OWNER_SCOPE");
                            }
                            ModelElements.set(id, Property.OWNER_SCOPE, "classifier");
                            continue;
                        }
                        if (RoseUtil.debug) {
                            System.out.println("---> store " + (String)object2 + ", " + (String)object3 + " in " + (String)object);
                        }
                        ModelElements.set(id, (String)object, (String)object2, (String)object3);
                        continue;
                    }
                    if (RoseUtil.debug) {
                        System.out.println("---> store " + (String)object2 + ", " + (String)object3 + " in " + (String)object);
                    }
                    ModelElements.set(id, (String)object, (String)object2, (String)object3);
                }
            }
        }
    }

    private void setQUID(Id id, RoseNode roseNode) {
        String string = roseNode.getRoseId();
        if (string != null && !RoseUtil.bNoExtension) {
            string = string.substring(1, string.length() - 1);
            if (RoseUtil.debug) {
                System.out.println("set quid " + string + " for id " + ModelElements.get(id, Property.NAME));
            }
            ModelElements.set(id, "Rose", "quid", string);
        }
    }

    private void updateRoseWithUUID(RoseNode roseNode, String string) {
        RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
        if (roseNode2 == null) {
            roseNode2 = new RoseNode("attributes", "Attribute_Set", 3);
            roseNode.addNode(roseNode2, false);
            RoseNode roseNode3 = new RoseNode("", "Attribute", 2);
            roseNode2.addNode(roseNode3, false);
            RoseNode roseNode4 = new RoseNode("tool", "\"IDL\"", 0);
            RoseNode roseNode5 = new RoseNode("name", "\"uuid\"", 0);
            RoseNode roseNode6 = new RoseNode("value", "Text", 4);
            RoseNode roseNode7 = new RoseNode("", "\"" + string + "\"", 0);
            roseNode6.addNode(roseNode7, false);
            roseNode3.addNode(roseNode4, false);
            roseNode3.addNode(roseNode5, false);
            roseNode3.addNode(roseNode6, false);
        } else {
            RoseNode roseNode8;
            Object object;
            RoseNode roseNode9;
            boolean bl = false;
            Vector vector = roseNode2.getNodes();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    roseNode9 = (RoseNode)vector.elementAt(i);
                    object = roseNode9.getNodes();
                    if (object == null) continue;
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        roseNode8 = (RoseNode)((Vector)object).elementAt(j);
                        if (roseNode8.getType() != 0 || !roseNode8.getKey().equals("name") || !roseNode8.getValue().equals("\"uuid\"")) continue;
                        bl = true;
                    }
                }
            }
            if (!bl) {
                RoseNode roseNode10 = new RoseNode("", "Attribute", 2);
                roseNode2.addNode(roseNode10, false);
                roseNode9 = new RoseNode("tool", "\"IDL\"", 0);
                object = new RoseNode("name", "\"uuid\"", 0);
                RoseNode roseNode11 = new RoseNode("value", "Text", 4);
                roseNode8 = new RoseNode("", "\"" + string + "\"", 0);
                roseNode11.addNode(roseNode8, false);
                roseNode10.addNode(roseNode9, false);
                roseNode10.addNode((RoseNode)object, false);
                roseNode10.addNode(roseNode11, false);
            }
        }
    }

    public void visitList(RoseNode roseNode) {
    }

    public void visitObject(RoseNode roseNode) {
        String string = roseNode.getKey();
        String string2 = Util.getType(roseNode.getValue());
        String string3 = Util.getName(roseNode.getValue());
        if (RoseUtil.debug) {
            System.out.println("visitObject,,, objKey - objType - objName: " + string + ", " + string2 + ", " + string3 + ", " + this.bContinue);
        }
        RoseNode roseNode2 = roseNode;
        Id id = (Id)roseNode2.getNode();
        while (id == null) {
            roseNode2 = roseNode2.getParent();
            id = (Id)roseNode2.getNode();
        }
        if (string.equals("root_usecase_package") && string2.equals("Class_Category") || string.equals("root_category") && string2.equals("Class_Category") && string3.equals(ResourceUtil.getString("LOGICAL_VIEW")) || string.equals("root_subsystem") && string2.equals("SubSystem") || string.equals("process_structure") && string2.equals("Processes") || string.equals("properties") && string2.equals("Properties")) {
            if (!RoseUtil.bNoExtension) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(Property.XMI_EXTENDER);
                vector.addElement("Rose");
                vector.addElement(Property.XMI_EXTENDER_ID);
                vector.addElement("Rose");
                Vector vector2 = ModelElements.get(id, Type.XMI_EXTENSION, vector, false);
                Id id2 = null;
                if (vector2 != null && vector2.size() == 1) {
                    id2 = (Id)vector2.elementAt(0);
                } else {
                    id2 = ModelElements.addConstruct(id, Type.XMI_EXTENSION, null);
                    ModelElements.set(id2, Property.XMI_EXTENDER, "Rose");
                    ModelElements.set(id2, Property.XMI_EXTENDER_ID, "Rose");
                }
                if (RoseUtil.debug) {
                    System.out.println("create EXTENSION under XMI_EXTENSION " + id2);
                }
                Id id3 = null;
                id3 = string3 != null ? ModelElements.addConstruct(id2, Type.EXTENSION, string3) : ModelElements.addConstruct(id2, Type.EXTENSION, string);
                this.setQUID(id3, roseNode);
                if (string.equals("root_category") && string2.equals("Class_Category") && string3.equals(ResourceUtil.getString("LOGICAL_VIEW"))) {
                    this.setPropertyAttributes(id, roseNode);
                }
                this.setProperty(id3, roseNode);
                roseNode.setNode(id3);
            }
            if (string.equals("root_category") && string2.equals("Class_Category") && string3.equals(ResourceUtil.getString("LOGICAL_VIEW"))) {
                roseNode.setNode(id);
            }
            if (string.equals("root_usecase_package") && string2.equals("Class_Category") || string.equals("root_subsystem") && string2.equals("SubSystem") || string.equals("properties") && string2.equals("Properties")) {
                this.bContinue = false;
            } else if (string.equals("root_category") && string2.equals("Class_Category") && string3.equals(ResourceUtil.getString("LOGICAL_VIEW")) || string.equals("process_structure") && string2.equals("Processes")) {
                this.bContinue = true;
            }
        } else if (string2.equals("Process_Diagram")) {
            if (!RoseUtil.bNoExtension && ModelElements.get(id, Property.EXTENSION_NAME).equals("process_structure")) {
                if (RoseUtil.debug) {
                    System.out.println("create EXTENSION under XMI_EXTENSION " + id);
                }
                Id id4 = ModelElements.addConstruct(id, Type.EXTENSION, string3);
                this.setQUID(id4, roseNode);
                this.setProperty(id4, roseNode);
                roseNode.setNode(id4);
            }
            this.bContinue = false;
        } else if (string.equals("") && string2.equals("Class_Category") && this.bContinue) {
            if (!RoseUtil.bNoPkg) {
                String string4;
                Object object;
                Object object2;
                Id id5 = (Id)roseNode.getNode();
                RoseNode roseNode3 = roseNode.findNodeWithKey("is_unit");
                if (id5 == null) {
                    if (roseNode3 != null) {
                        object2 = roseNode.findNodeWithKey("file_name");
                        object = ((RoseNode)object2).getValue();
                        string4 = Util.resolveFileName((String)object);
                        if (!(string4.endsWith("boim.cat") || string4.endsWith("managed.cat") || string4.endsWith("services.cat") || string4.endsWith("java.cat") || string4.endsWith("sun.cat"))) {
                            if (RoseUtil.debug) {
                                System.out.println("Create Type.PACKAGE under session id");
                            }
                            id5 = ModelElements.addConstruct(this.sessionId, Type.PACKAGE, string3);
                            ModelElements.add(id, Link.OWNED_ELEMENT, id5);
                        }
                        if (string4.endsWith("java.cat")) {
                            RoseUtil.withJDK116 = true;
                            ModelElements.set(id, "java.cat", (String)object, roseNode.getRoseId());
                        } else if (string4.endsWith("sun.cat")) {
                            RoseUtil.withJDK116 = true;
                            ModelElements.set(id, "sun.cat", (String)object, roseNode.getRoseId());
                        }
                    } else if (id.getType() == Type.MODEL || id.getType() == Type.PACKAGE) {
                        if (RoseUtil.debug) {
                            System.out.println("Create Type.PACKAGE under " + ModelElements.get(id, Property.NAME));
                        }
                        id5 = ModelElements.addConstruct(id, Type.PACKAGE, string3);
                    }
                }
                if (id5 != null) {
                    this.setQUID(id5, roseNode);
                    this.setPkgIDLDefaultProperties(id5);
                    this.setPropertyAttributes(id5, roseNode);
                    this.setProperty(id5, roseNode);
                    roseNode.setNode(id5);
                    object2 = roseNode.getRoseId();
                    if (object2 == null) {
                        if (roseNode3 != null) {
                            object = roseNode.findNodeWithKey("file_name");
                            string4 = ((RoseNode)object).getValue();
                            String string5 = Util.resolveFileName(string4);
                            object2 = RoseUtil.getQUIDFromUnitTree(this.currentUnitTreeNode, string5);
                            ModelElements.set(id5, "Rose", "quid", (String)object2);
                        }
                    } else {
                        object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                    }
                    object = (TableObject)RoseUtil.quid_InfoTable.get(object2);
                    ModelElements.setUUID(id5, ((TableObject)object).getUUID());
                    this.updateRoseWithUUID(roseNode, id5.getUUID());
                    if (RoseUtil.bSetXMIFILETag) {
                        ModelElements.set(id5, "", "xmiFile", ((TableObject)object).getXMIBaseFileName());
                        ModelElements.set(id5, "", "is_unit", ((TableObject)object).getUnit());
                    }
                    RoseUtil.QUID_IdTable.put(object2, id5);
                    if (roseNode3 == null) {
                        this.createLinkBetweenSupplierAndLinkConstruct(id5, (TableObject)object);
                    }
                }
            } else {
                roseNode.setNode(id);
            }
        } else if (string2.equals("Class") && this.bContinue) {
            if (id.getType() == Type.MODEL || id.getType() == Type.PACKAGE || id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE) {
                Object object;
                Type type = Type.CLASS;
                RoseNode roseNode4 = roseNode.findNodeWithKey("stereotype");
                if (roseNode4 != null) {
                    object = roseNode4.getValue();
                    if (((String)(object = ((String)object).substring(1, ((String)object).length() - 1))).equals("Interface")) {
                        type = Type.INTERFACE;
                    } else if (((String)object).equals("primitive")) {
                        type = Type.PRIMITIVE;
                    } else if (((String)object).equals("enumeration")) {
                        type = Type.ENUMERATION;
                    } else if (((String)object).equals("structure")) {
                        type = Type.STRUCTURE;
                    }
                    if (RoseUtil.debug) {
                        System.out.println("Create " + (String)object + " under " + ModelElements.get(id, Property.NAME));
                    }
                } else if (RoseUtil.debug) {
                    System.out.println("Create Type.CLASS under " + ModelElements.get(id, Property.NAME));
                }
                if ((object = ModelElements.addConstruct(id, type, string3)) != null) {
                    ModelElements.set((Id)object, Property.ME_VISIBILITY, "public");
                    this.setQUID((Id)object, roseNode);
                    this.setClsIDLDefaultProperties((Id)object);
                    this.setPropertyAttributes((Id)object, roseNode);
                    this.setProperty((Id)object, roseNode);
                    roseNode.setNode(object);
                    String string6 = roseNode.getRoseId();
                    string6 = string6.substring(1, string6.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string6);
                    ModelElements.setUUID((Id)object, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, ((Id)object).getUUID());
                    if (RoseUtil.bSetXMIFILETag) {
                        ModelElements.set((Id)object, "", "xmiFile", tableObject.getXMIBaseFileName());
                        ModelElements.set((Id)object, "", "is_unit", tableObject.getUnit());
                    }
                    RoseUtil.className_IdTable.put(string3, object);
                    RoseUtil.classFullName_IdTable.put(ModelElements.getJavaFullName((Id)object), object);
                    RoseUtil.QUID_IdTable.put(string6, object);
                    this.createLinkBetweenSupplierAndLinkConstruct((Id)object, tableObject);
                }
            }
        } else if (string2.equals("Operation") && this.bContinue) {
            if (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE) {
                Id id6;
                if (RoseUtil.debug) {
                    System.out.println("Create Type.OPERATION under " + ModelElements.get(id, Property.NAME));
                }
                if ((id6 = ModelElements.addConstruct(id, Type.OPERATION, string3)) != null) {
                    ModelElements.set(id6, Property.ME_VISIBILITY, "public");
                    ModelElements.set(id6, Property.OWNER_SCOPE, "instance");
                    this.setQUID(id6, roseNode);
                    String string7 = roseNode.getRoseId();
                    string7 = string7.substring(1, string7.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string7);
                    ModelElements.setUUID(id6, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, id6.getUUID());
                    this.setOprIDLDefaultProperties(id6);
                    this.setPropertyAttributes(id6, roseNode);
                    this.setProperty(id6, roseNode);
                    roseNode.setNode(id6);
                }
            }
        } else if (string2.equals("ClassAttribute") && this.bContinue) {
            if (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE || id.getType() == Type.ASSOCIATION_END) {
                Id id7;
                if (RoseUtil.debug) {
                    System.out.println("Create Type.ATTRIBUTE under " + ModelElements.get(id, Property.NAME));
                }
                if ((id7 = ModelElements.addConstruct(id, Type.ATTRIBUTE, string3)) != null) {
                    ModelElements.set(id7, Property.ME_VISIBILITY, "private");
                    ModelElements.set(id7, Property.OWNER_SCOPE, "instance");
                    this.setQUID(id7, roseNode);
                    this.setAttrIDLDefaultProperties(id7);
                    this.setAttrDDLDefaultProperties(id7);
                    this.setPropertyAttributes(id7, roseNode);
                    this.setProperty(id7, roseNode);
                    roseNode.setNode(id7);
                    String string8 = roseNode.getRoseId();
                    string8 = string8.substring(1, string8.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string8);
                    ModelElements.setUUID(id7, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, id7.getUUID());
                }
            }
        } else if (string2.equals("Parameter") && this.bContinue) {
            if (id.getType() == Type.OPERATION) {
                Id id8;
                if (RoseUtil.debug) {
                    System.out.println("Create Type.PARAMETER under " + ModelElements.get(id, Property.NAME));
                }
                if ((id8 = ModelElements.addConstruct(id, Type.PARAMETER, string3)) != null) {
                    String string9 = RoseUtil.getUUID(roseNode);
                    ModelElements.setUUID(id8, string9);
                    this.setQUID(id8, roseNode);
                    roseNode.setNode(id8);
                    this.setPropertyAttributes(id8, roseNode);
                    this.setProperty(id8, roseNode);
                }
            }
        } else if (string2.equals("Inheritance_Relationship") && this.bContinue) {
            Id id9 = id;
            if (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE) {
                roseNode2 = roseNode2.getParent();
                id = (Id)roseNode2.getNode();
                while (id == null) {
                    roseNode2 = roseNode2.getParent();
                    id = (Id)roseNode2.getNode();
                }
            }
            if (id.getType() == Type.PACKAGE || id.getType() == Type.MODEL) {
                Id id10;
                if (RoseUtil.debug) {
                    System.out.println("Create Type.GENERALIZATION under " + ModelElements.get(id, Property.NAME));
                }
                if ((id10 = ModelElements.addConstruct(id, Type.GENERALIZATION)) != null) {
                    String string10;
                    this.setQUID(id10, roseNode);
                    this.setPropertyAttributes(id10, roseNode);
                    this.setProperty(id10, roseNode);
                    roseNode.setNode(id10);
                    String string11 = roseNode.getRoseId();
                    string11 = string11.substring(1, string11.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string11);
                    ModelElements.setUUID(id10, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, id10.getUUID());
                    if (RoseUtil.bSetXMIFILETag) {
                        ModelElements.set(id10, "", "xmiFile", tableObject.getXMIBaseFileName());
                        ModelElements.set(id10, "", "is_unit", tableObject.getUnit());
                    }
                    ModelElements.add(id10, Link.SUBTYPE, id9);
                    ModelElements.add(id9, Link.GENERALIZATION, id10);
                    RoseNode roseNode5 = roseNode.findNodeWithKey("supplier");
                    String string12 = "";
                    if (roseNode5 != null) {
                        string12 = roseNode5.getValue();
                        string12 = string12.substring(1, string12.length() - 1);
                    }
                    if ((string10 = roseNode.getRoseRefId()) != null) {
                        string10 = string10.substring(1, string10.length() - 1);
                    }
                    this.createGeneralizationSuperType(id10, string12, string10);
                    RoseUtil.QUID_IdTable.put(string11, id10);
                }
            }
        } else if (string2.equals("Visibility_Relationship") && this.bContinue) {
            Id id11 = id;
            if (id11.getType() == Type.PACKAGE) {
                Id id12;
                if (RoseUtil.debug) {
                    System.out.println("Create Type.DEPENDENCY under " + ModelElements.get(id, Property.NAME));
                }
                if ((id12 = ModelElements.addConstruct(id, Type.DEPENDENCY)) != null) {
                    String string13;
                    this.setQUID(id12, roseNode);
                    this.setPropertyAttributes(id12, roseNode);
                    this.setProperty(id12, roseNode);
                    roseNode.setNode(id12);
                    String string14 = roseNode.getRoseId();
                    string14 = string14.substring(1, string14.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string14);
                    ModelElements.setUUID(id12, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, id12.getUUID());
                    if (RoseUtil.bSetXMIFILETag) {
                        ModelElements.set(id12, "", "xmiFile", tableObject.getXMIBaseFileName());
                        ModelElements.set(id12, "", "is_unit", tableObject.getUnit());
                    }
                    ModelElements.add(id12, Link.CLIENT, id11);
                    ModelElements.add(id11, Link.REQUIREMENT, id12);
                    RoseNode roseNode6 = roseNode.findNodeWithKey("supplier");
                    String string15 = "";
                    if (roseNode6 != null) {
                        string15 = roseNode6.getValue();
                        string15 = string15.substring(1, string15.length() - 1);
                    }
                    if ((string13 = roseNode.getRoseRefId()) != null) {
                        string13 = string13.substring(1, string13.length() - 1);
                    }
                    this.createDependencySupplier(id12, string15, string13);
                    RoseUtil.QUID_IdTable.put(string14, id12);
                }
            }
        } else if (string2.equals("Uses_Relationship") && this.bContinue) {
            Id id13 = id;
            if (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE) {
                roseNode2 = roseNode2.getParent();
                id = (Id)roseNode2.getNode();
                while (id == null) {
                    roseNode2 = roseNode2.getParent();
                    id = (Id)roseNode2.getNode();
                }
            }
            if (id.getType() == Type.PACKAGE || id.getType() == Type.MODEL) {
                Id id14;
                if (RoseUtil.debug) {
                    System.out.println("Create Type.DEPENDENCY under " + ModelElements.get(id, Property.NAME));
                }
                if ((id14 = ModelElements.addConstruct(id, Type.DEPENDENCY)) != null) {
                    String string16;
                    this.setQUID(id14, roseNode);
                    this.setPropertyAttributes(id14, roseNode);
                    this.setProperty(id14, roseNode);
                    roseNode.setNode(id14);
                    String string17 = roseNode.getRoseId();
                    string17 = string17.substring(1, string17.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string17);
                    ModelElements.setUUID(id14, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, id14.getUUID());
                    if (RoseUtil.bSetXMIFILETag) {
                        ModelElements.set(id14, "", "xmiFile", tableObject.getXMIBaseFileName());
                        ModelElements.set(id14, "", "is_unit", tableObject.getUnit());
                    }
                    ModelElements.add(id14, Link.CLIENT, id13);
                    ModelElements.add(id13, Link.REQUIREMENT, id14);
                    RoseNode roseNode7 = roseNode.findNodeWithKey("supplier");
                    String string18 = "";
                    if (roseNode7 != null) {
                        string18 = roseNode7.getValue();
                        string18 = string18.substring(1, string18.length() - 1);
                    }
                    if ((string16 = roseNode.getRoseRefId()) != null) {
                        string16 = string16.substring(1, string16.length() - 1);
                    }
                    this.createDependencySupplier(id14, string18, string16);
                    RoseUtil.QUID_IdTable.put(string17, id14);
                }
            }
        } else if (string2.equals("Association") && this.bContinue) {
            if (id.getType() == Type.MODEL || id.getType() == Type.PACKAGE) {
                Id id15;
                if (string3.startsWith("$UNNAMED")) {
                    string3 = "";
                }
                if (RoseUtil.debug) {
                    System.out.println("Create Type.ASSOCIATION under " + ModelElements.get(id, Property.NAME));
                }
                if ((id15 = ModelElements.addConstruct(id, Type.ASSOCIATION, string3)) != null) {
                    this.setQUID(id15, roseNode);
                    this.setPropertyAttributes(id15, roseNode);
                    this.setProperty(id15, roseNode);
                    roseNode.setNode(id15);
                    String string19 = roseNode.getRoseId();
                    string19 = string19.substring(1, string19.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string19);
                    ModelElements.setUUID(id15, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, id15.getUUID());
                    if (RoseUtil.bSetXMIFILETag) {
                        ModelElements.set(id15, "", "xmiFile", tableObject.getXMIBaseFileName());
                        ModelElements.set(id15, "", "is_unit", tableObject.getUnit());
                    }
                    RoseUtil.QUID_IdTable.put(string19, id15);
                }
            }
        } else if (string2.equals("Role") && this.bContinue) {
            if (id.getType() == Type.ASSOCIATION) {
                Id id16;
                if (string3.startsWith("$UNNAMED")) {
                    string3 = "";
                }
                if (RoseUtil.debug) {
                    System.out.println("Create Type.ASSOCIATION_END under " + ModelElements.get(id, Property.NAME));
                }
                if ((id16 = ModelElements.addConstruct(id, Type.ASSOCIATION_END, string3)) != null) {
                    String string20;
                    ModelElements.set(id16, Property.IS_NAVIGABLE, "false");
                    ModelElements.set(id16, Property.ME_VISIBILITY, "public");
                    this.setQUID(id16, roseNode);
                    this.setAEIDLDefaultProperties(id16);
                    this.setAggregationProperty(id16, roseNode);
                    this.setPropertyAttributes(id16, roseNode);
                    this.setProperty(id16, roseNode);
                    roseNode.setNode(id16);
                    String string21 = roseNode.getRoseId();
                    string21 = string21.substring(1, string21.length() - 1);
                    TableObject tableObject = (TableObject)RoseUtil.quid_InfoTable.get(string21);
                    ModelElements.setUUID(id16, tableObject.getUUID());
                    this.updateRoseWithUUID(roseNode, id16.getUUID());
                    if (RoseUtil.bSetXMIFILETag) {
                        ModelElements.set(id16, "", "xmiFile", tableObject.getXMIBaseFileName());
                        ModelElements.set(id16, "", "is_unit", tableObject.getUnit());
                    }
                    RoseNode roseNode8 = roseNode.findNodeWithKey("supplier");
                    String string22 = "";
                    if (roseNode8 != null) {
                        string22 = roseNode8.getValue();
                        string22 = string22.substring(1, string22.length() - 1);
                    }
                    if ((string20 = roseNode.getRoseRefId()) != null) {
                        string20 = string20.substring(1, string20.length() - 1);
                    }
                    this.createAssociationEndAEType(id16, string22, string20);
                    RoseUtil.QUID_IdTable.put(string21, id16);
                }
            }
        } else if (string2.equals("Realize_Relationship") && this.bContinue) {
            if (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE) {
                String string23;
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(Property.XMI_EXTENDER);
                vector.addElement("Rose");
                vector.addElement(Property.XMI_EXTENDER_ID);
                vector.addElement("Rose");
                Vector vector3 = ModelElements.get(id, Type.XMI_EXTENSION, vector, false);
                Id id17 = null;
                if (vector3 != null && vector3.size() == 1) {
                    id17 = (Id)vector3.elementAt(0);
                } else {
                    id17 = ModelElements.addConstruct(id, Type.XMI_EXTENSION, null);
                    ModelElements.set(id17, Property.XMI_EXTENDER, "Rose");
                    ModelElements.set(id17, Property.XMI_EXTENDER_ID, "Rose");
                    ModelElements.setUUID(id17, id.getUUID() + ":" + "Realize_Relationship");
                }
                if (RoseUtil.debug) {
                    System.out.println("Create Type.EXTENSION under XMI_EXTENSION for realize relationship");
                }
                Id id18 = ModelElements.addConstruct(id17, Type.EXTENSION, string2);
                String string24 = roseNode.getRoseId();
                RoseUtil.QUID_IdTable.put(string24.substring(1, string24.length() - 1), id18);
                this.setQUID(id18, roseNode);
                RoseNode roseNode9 = roseNode.findNodeWithKey("supplier");
                String string25 = "";
                if (roseNode9 != null) {
                    string25 = roseNode9.getValue();
                    string25 = string25.substring(1, string25.length() - 1);
                }
                if ((string23 = roseNode.getRoseRefId()) != null) {
                    string23 = string23.substring(1, string23.length() - 1);
                }
                this.createRealizeSupplier(id, id18, string25, string23);
            }
        } else if (string2.equals("ClassDiagram") && this.bContinue && (id.getType() == Type.MODEL || id.getType() == Type.PACKAGE) && !RoseUtil.bNoExtension) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(Property.XMI_EXTENDER);
            vector.addElement("UMLNotation");
            vector.addElement(Property.XMI_EXTENDER_ID);
            vector.addElement("UMLNotation");
            Vector vector4 = ModelElements.get(id, Type.XMI_EXTENSION, vector, false);
            Id id19 = null;
            if (vector4 == null) {
                id19 = ModelElements.addConstruct(id, Type.XMI_EXTENSION, null);
                if (id19 != null) {
                    ModelElements.set(id19, Property.XMI_EXTENDER, "UMLNotation");
                    ModelElements.set(id19, Property.XMI_EXTENDER_ID, "UMLNotation");
                }
            } else if (vector4.size() == 1) {
                id19 = (Id)vector4.elementAt(0);
            }
            if (id19 != null) {
                Id id20;
                if (RoseUtil.debug) {
                    System.out.println("Create Type.VIEW_ELEMENT under XMI_EXTENSION");
                }
                if ((id20 = ModelElements.addConstruct(id19, Type.VIEW_ELEMENT)) != null) {
                    ModelElements.set(id20, "UMLNotation", "name", string3);
                    ModelElements.add(id, Link.VIEW, id20);
                    ModelElements.add(id20, Link.V_MODEL, id);
                    this.setQUID(id20, roseNode);
                    roseNode.setNode(id20);
                    this.setProperty(id20, roseNode);
                    RoseNode roseNode10 = roseNode.findNodeWithKey("items");
                    if (roseNode10 != null) {
                        this.createPresentations(id20, roseNode10);
                    }
                }
            }
        }
    }

    public void visitString(Id id, RoseNode roseNode) {
        String string = roseNode.getKey();
        String string2 = roseNode.getValue();
        if (RoseUtil.debug) {
            System.out.println("visitString,,, objKey - objValue: " + string + ", " + string2);
        }
        if (string.equals("result")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            this.createReturnParameter(id, string2);
        } else if (string.equals("documentation")) {
            if (id.getType() == Type.ENUMERATION) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                this.createEnumerationLiteral(id, string2, roseNode);
            } else {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store as documentation property in default set");
                }
                ModelElements.set(id, "", "documentation", string2);
            }
        } else if (string.equals("derived")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (RoseUtil.debug) {
                System.out.println("---> store as " + string + " property in default set");
            }
            ModelElements.set(id, "", string, string2);
        } else if (string.equals("exceptions")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (RoseUtil.debug) {
                System.out.println("---> store as " + string + " property in default set");
            }
            ModelElements.set(id, "", string, string2);
        } else if (string.equals("language")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (RoseUtil.debug) {
                System.out.println("---> store as " + string + " property in default set");
            }
            ModelElements.set(id, "", string, string2);
        } else if (string.equals("zoom")) {
            if (!RoseUtil.bNoExtension) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store as " + string + " property in UMLNotation set");
                }
                ModelElements.set(id, "UMLNotation", string, string2);
            }
        } else if (string.equals("max_height") || string.equals("height")) {
            if (!RoseUtil.bNoExtension) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store as height property in UMLNotation set");
                }
                ModelElements.set(id, "UMLNotation", "height", string2);
            }
        } else if (string.equals("max_width") || string.equals("width")) {
            if (!RoseUtil.bNoExtension) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store as width property in UMLNotation set");
                }
                ModelElements.set(id, "UMLNotation", "width", string2);
            }
        } else if (string.equals("origin_x")) {
            if (!RoseUtil.bNoExtension) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store as originX property in UMLNotation set");
                }
                ModelElements.set(id, "UMLNotation", "originX", string2);
            }
        } else if (string.equals("origin_y")) {
            if (!RoseUtil.bNoExtension) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store as originY property in UMLNotation set");
                }
                ModelElements.set(id, "UMLNotation", "originY", string2);
            }
        } else if (string.equals("location")) {
            if (!RoseUtil.bNoExtension) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store as location property in UMLNotation set");
                }
                ModelElements.set(id, "UMLNotation", "location", string2);
            }
        } else if (string.equals("type")) {
            Id id2;
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if ((id2 = ModelElements.getDataTypeId(this.dataTypePkgId, string2, true)) != null) {
                if (id.getType() == Type.ATTRIBUTE) {
                    Id id3;
                    Vector vector = ModelElements.get(id, Link.SF_TYPE, false);
                    if (vector == null) {
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.SF_TYPE from " + ModelElements.get(id, Property.NAME) + " to " + ModelElements.get(id2, Property.NAME));
                        }
                        ModelElements.add(id, Link.SF_TYPE, id2);
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.STRUCTURAL_FEATURE from " + ModelElements.get(id2, Property.NAME) + " to " + ModelElements.get(id, Property.NAME));
                        }
                        ModelElements.add(id2, Link.STRUCTURAL_FEATURE, id);
                    } else if (vector.size() == 1 && !ModelElements.get(id3 = (Id)vector.elementAt(0), Property.NAME).equals(string2)) {
                        if (RoseUtil.debug) {
                            System.out.println("---> delete Link.SF_TYPE and Link.STRUCTURAL_FEATURE  between " + ModelElements.get(id3, Property.NAME) + " and " + ModelElements.get(id, Property.NAME));
                        }
                        ModelElements.delete(id, Link.SF_TYPE, id3);
                        ModelElements.delete(id3, Link.STRUCTURAL_FEATURE, id);
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.SF_TYPE from " + ModelElements.get(id, Property.NAME) + " to " + ModelElements.get(id2, Property.NAME));
                        }
                        ModelElements.add(id, Link.SF_TYPE, id2);
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.STRUCTURAL_FEATURE from " + ModelElements.get(id2, Property.NAME) + " to " + ModelElements.get(id, Property.NAME));
                        }
                        ModelElements.add(id2, Link.STRUCTURAL_FEATURE, id);
                    }
                } else if (id.getType() == Type.PARAMETER) {
                    Id id4;
                    Vector vector = ModelElements.get(id, Link.PARM_TYPE, false);
                    if (vector == null) {
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.PARM_TYPE from " + ModelElements.get(id, Property.NAME) + " to " + ModelElements.get(id2, Property.NAME));
                        }
                        ModelElements.add(id, Link.PARM_TYPE, id2);
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.CL_PARAMETER from " + ModelElements.get(id2, Property.NAME) + " to " + ModelElements.get(id, Property.NAME));
                        }
                        ModelElements.add(id2, Link.CL_PARAMETER, id);
                    } else if (vector.size() == 1 && !ModelElements.get(id4 = (Id)vector.elementAt(0), Property.NAME).equals(string2)) {
                        if (RoseUtil.debug) {
                            System.out.println("---> delete Link.PARM_TYPE and Link.CL_PARAMETER  between " + ModelElements.get(id4, Property.NAME) + " and " + ModelElements.get(id, Property.NAME));
                        }
                        ModelElements.delete(id, Link.PARM_TYPE, id4);
                        ModelElements.delete(id4, Link.CL_PARAMETER, id);
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.PARM_TYPE from " + ModelElements.get(id, Property.NAME) + " to " + ModelElements.get(id2, Property.NAME));
                        }
                        ModelElements.add(id, Link.PARM_TYPE, id2);
                        if (RoseUtil.debug) {
                            System.out.println("---> create Link.CL_PARAMETER from " + ModelElements.get(id2, Property.NAME) + " to " + ModelElements.get(id, Property.NAME));
                        }
                        ModelElements.add(id2, Link.CL_PARAMETER, id);
                    }
                }
            }
        } else if (string.equals("initv")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (RoseUtil.debug) {
                System.out.println("---> set attribute initial_value or parameter default_value as: " + string2);
            }
            if (id.getType() == Type.ATTRIBUTE) {
                ModelElements.setComplicatedProperty(RoseUtil.umlForRoseLoad, id, Property.INITIAL_VALUE, string2);
            } else if (id.getType() == Type.PARAMETER) {
                ModelElements.setComplicatedProperty(RoseUtil.umlForRoseLoad, id, Property.DEFAULT_VALUE, string2);
            }
        } else if (string.equals("concurrency")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if ((string2 = string2.toLowerCase()).equals("synchronous")) {
                string2 = "concurrent";
            }
            if (RoseUtil.debug) {
                System.out.println("---> store " + string2 + " as Porperty.CONCURRENCY");
            }
            ModelElements.set(id, Property.CONCURRENCY, string2);
        } else if (string.equals("opExportControl") || string.equals("exportControl")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!((string2 = string2.toLowerCase()).equals("public") || string2.equals("private") || string2.equals("protected"))) {
                if (ModelElements.get(id, Property.ME_VISIBILITY) != null) {
                    ModelElements.set(id, Property.ME_VISIBILITY, null);
                }
                if (!RoseUtil.bNoExtension) {
                    if (RoseUtil.debug) {
                        System.out.println("---> store " + string + ", " + string2 + " in Rose set");
                    }
                    ModelElements.set(id, "Rose", string, "\"" + string2 + "\"");
                }
            } else {
                if (RoseUtil.debug) {
                    System.out.println("---> store " + string2 + " as Porperty.ME_VISIBILITY");
                }
                ModelElements.set(id, Property.ME_VISIBILITY, string2);
            }
        } else if (string.equals("abstract")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            string2 = string2.toLowerCase();
            if (RoseUtil.debug) {
                System.out.println("---> store " + string2 + " as Porperty.IS_ABSTRACT");
            }
            ModelElements.set(id, Property.IS_ABSTRACT, string2);
        } else if (string.equals("is_navigable")) {
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            string2 = string2.toLowerCase();
            if (id.getType() == Type.ASSOCIATION_END) {
                if (RoseUtil.debug) {
                    System.out.println("---> store " + string2 + " as Porperty.IS_NAVIGABLE");
                }
                ModelElements.set(id, Property.IS_NAVIGABLE, string2);
            }
        } else if (string.equals("static")) {
            if (string2.equals("TRUE")) {
                if (id.getType() == Type.ATTRIBUTE) {
                    if (RoseUtil.debug) {
                        System.out.println("---> store classifier as Porperty.OWNER_SCOPE");
                    }
                    ModelElements.set(id, Property.OWNER_SCOPE, "classifier");
                } else if (id.getType() == Type.ASSOCIATION_END) {
                    if (RoseUtil.debug) {
                        System.out.println("---> store " + string + ", " + string2 + " in defaultset");
                    }
                    ModelElements.set(id, "", string, string2);
                }
            }
        } else if (string.equals("quidu")) {
            if (id.getType() != Type.GENERALIZATION && id.getType() != Type.ASSOCIATION_END && id.getType() != Type.DEPENDENCY && id.getType() != Type.PRESENTATION && !RoseUtil.bNoExtension) {
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store " + string + ", " + string2 + " in Rose set");
                }
                ModelElements.set(id, "Rose", string, string2);
            }
        } else if (string.equals("supplier")) {
            if (id.getType() != Type.GENERALIZATION && id.getType() != Type.ASSOCIATION_END && id.getType() != Type.DEPENDENCY && id.getType() != Type.PRESENTATION && !RoseUtil.bNoExtension) {
                if (RoseUtil.debug) {
                    System.out.println("---> store " + string + ", " + string2 + " in Rose set");
                }
                ModelElements.set(id, "Rose", string, string2);
            }
        } else if (string.equals("client") || string.equals("Parent_View")) {
            if (id.getType() != Type.PRESENTATION && !RoseUtil.bNoExtension) {
                if (RoseUtil.debug) {
                    System.out.println("---> store " + string + ", " + string2 + " in Rose set");
                }
                ModelElements.set(id, "Rose", string, string2);
            }
        } else if (string.equals("label")) {
            if (id.getType() == Type.GENERALIZATION) {
                ModelElements.set(id, Property.NAME, string2.substring(1, string2.length() - 1));
            }
        } else if (string.equals("stereotype")) {
            if (id.getType() == Type.PACKAGE || id.getType() == Type.CLASS || id.getType() == Type.ATTRIBUTE || id.getType() == Type.OPERATION || id.getType() == Type.ASSOCIATION || id.getType() == Type.GENERALIZATION || id.getType() == Type.DEPENDENCY) {
                Id id5 = this.getStereoTypeId(roseNode, string2.substring(1, string2.length() - 1));
                ModelElements.add(id, Link.ME_STEREOTYPE, id5);
            } else if (!RoseUtil.bNoExtension) {
                if (RoseUtil.debug) {
                    System.out.println("---> store " + string + ", " + string2 + " in Rose set");
                }
                ModelElements.set(id, "Rose", string, string2);
            }
        } else if (!(string.equals("quid") || string.equals("is_aggregate") || string.equals("drawSupplier") || RoseUtil.bNoExtension)) {
            if (RoseUtil.debug) {
                System.out.println("---> store " + string + ", " + string2 + " in Rose set");
            }
            ModelElements.set(id, "Rose", string, string2);
        }
    }

    public void visitStringSeq(Id id, RoseNode roseNode) {
        int n;
        String string = roseNode.getKey();
        if (RoseUtil.debug) {
            System.out.println("visitStringSeq: " + string + ", " + roseNode.getValue());
        }
        Vector vector = roseNode.getNodes();
        String string2 = "";
        for (n = 0; n < vector.size(); ++n) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(n);
            if (roseNode2.getType() != 0) continue;
            string2 = roseNode2.getValue().equals("") ? string2 + "|#" : (string2.equals("") ? roseNode2.getValue() : string2 + "|#" + roseNode2.getValue());
        }
        if (string.equals("documentation")) {
            if (id.getType() == Type.ENUMERATION) {
                n = string2.indexOf("|#");
                while (n != -1) {
                    string2 = string2.substring(0, n) + " " + string2.substring(n + 2, string2.length());
                    n = string2.indexOf("|#");
                }
                this.createEnumerationLiteral(id, string2, roseNode);
            } else {
                if (RoseUtil.debug) {
                    System.out.println("---> store as documentation property in default set");
                }
                ModelElements.set(id, "", "documentation", string2);
            }
        } else if (string.equals("initv")) {
            n = string2.indexOf("|#");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if (RoseUtil.debug) {
                System.out.println("---> set attribute initial_value or parameter default_value as: " + string2);
            }
            if (id.getType() == Type.ATTRIBUTE) {
                ModelElements.setComplicatedProperty(RoseUtil.umlForRoseLoad, id, Property.INITIAL_VALUE, string2);
            } else if (id.getType() == Type.PARAMETER) {
                ModelElements.setComplicatedProperty(RoseUtil.umlForRoseLoad, id, Property.DEFAULT_VALUE, string2);
            }
        } else if (!RoseUtil.bNoExtension) {
            if (RoseUtil.debug) {
                System.out.println("---> store " + string + ", " + string2 + " in Rose set");
            }
            ModelElements.set(id, "Rose", string, string2);
        }
    }

    public void visitValue(Id id, RoseNode roseNode) {
        String string = roseNode.getKey();
        String string2 = Util.getType(roseNode.getValue());
        String string3 = Util.getName(roseNode.getValue());
        if (RoseUtil.debug) {
            System.out.println("visitValue,,, objKey - objType - objName: " + string + ", " + string2 + ", " + string3);
        }
        if (string.equals("client_cardinality") && string2.equals("cardinality") && id.getType() == Type.ASSOCIATION_END) {
            Vector vector = roseNode.getNodes();
            String string4 = "";
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
                if (roseNode2.getType() == 0) {
                    string4 = roseNode2.getValue();
                    string4 = string4.substring(1, string4.length() - 1);
                } else if (roseNode2.getType() == 1) {
                    Vector vector2 = roseNode2.getNodes();
                    for (int j = 0; j < vector2.size(); ++j) {
                        RoseNode roseNode3 = (RoseNode)vector2.elementAt(j);
                        if (roseNode3.getType() != 0) continue;
                        string4 = roseNode3.getValue() + "|#" + string4;
                    }
                }
                if (RoseUtil.debug) {
                    System.out.println("---> store " + string4 + " as Porperty.AE_MULTIPLICITY");
                }
                ModelElements.set(id, Property.AE_MULTIPLICITY, string4);
            }
        }
    }
}

