/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.rb30;

import com.ibm.psh.diffmerge.DiffMergeTool;
import com.ibm.psh.rb30.ModelElements;
import com.ibm.psh.rb30.NameConflictException;
import com.ibm.psh.rb30.ResourceUtil;
import com.ibm.psh.rb30.RoseFirstTraverse;
import com.ibm.psh.rb30.RoseSave;
import com.ibm.psh.rb30.RoseSecondTraverse;
import com.ibm.psh.rb30.RoseVisitorTNG;
import com.ibm.psh.rb30.TableObject;
import com.ibm.psh.rb30.UnitTreeNode;
import com.ibm.psh.roseparser.RoseComponent;
import com.ibm.psh.roseparser.RoseLexer;
import com.ibm.psh.roseparser.RoseLoader;
import com.ibm.psh.roseparser.RoseNode;
import com.ibm.psh.roseparser.RoseParser;
import com.ibm.psh.roseparser.RoseWriter;
import com.ibm.psh.roseparser.Util;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.ProgressListener;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UML;
import com.ibm.xmi.utility.FileUtil;
import com.ibm.xmi.xmi10.IDLUtil;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class RoseUtil {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static UML umlForRoseLoad;
    public static Id modelId;
    public static boolean bLogicalViewOnly;
    public static boolean bNoPresentation;
    public static boolean bNoExtension;
    public static boolean bNoPkg;
    public static boolean bNoIDLPkg;
    public static boolean debug;
    public static boolean bSetXMIFILETag;
    public static boolean bNamespaceUUID;
    public static String generatedPackageName;
    public static PropertyChangeListener propertyChangeListener;
    public static ProgressListener progressListener;
    public static UnitTreeNode unitTree;
    public static Hashtable xmiFileName_Table;
    public static Hashtable quid_InfoTable;
    public static Hashtable uuid_InfoTable;
    public static Hashtable className_InfoTable;
    public static Hashtable classFullName_InfoTable;
    public static Hashtable supplier_LinkTable;
    public static Hashtable QUID_IdTable;
    public static Hashtable className_IdTable;
    public static Hashtable classFullName_IdTable;
    public static Hashtable Generalization_SuperTypeTable;
    public static Hashtable Dependency_SupplierTable;
    public static Hashtable Role_AETypeTable;
    public static Hashtable Realization_SupplierTable;
    public static Hashtable ClassId_RealizationTable;
    public static Hashtable Presentation_ModelElementTable;
    public static Hashtable pkgUUID_QUIDTable;
    public static Hashtable genPkgTable;
    public static boolean bForCB;
    public static String OBProjectDirs;
    public static String OBBaseProjectDir;
    public static Vector OBXMIFileVector;
    public static Hashtable IDLForPkgTable;
    public static Hashtable IDLForClsTable;
    public static Hashtable DDLForAttrTable;
    public static Hashtable IDLForAttrTable;
    public static Hashtable IDLForOprTable;
    public static Hashtable IDLForAETable;
    public static boolean withJDK116;
    public static boolean bDefaultXML;
    public static boolean bCatAsXML;
    public static boolean bInXmiDir;
    public static boolean bModelXML;
    public static boolean bCheckConsole;
    public int numOfRoseFile;
    public int numOfXMIFile;
    private int incrementNum;
    private int indicatorLowerNum;
    public ZipOutputStream zipOutputStream;
    public String inputFile;
    public String outputFile;
    public String xmiZipFile;
    public String oldXmiZipFile;
    public static String xmiDir;
    public Id IDLDataTypePkgId;
    public String filePathForUMLLoad;
    public boolean doMerge;
    public boolean bNoDTD = false;
    public boolean bValidate = false;
    public boolean bUpdateRose = false;
    public int iLower = 0;
    public int iUpper = 100;
    public String headerInfo;

    public void addAETypeToAssociationEnd(Id id) {
        Enumeration enumeration = Role_AETypeTable.keys();
        while (enumeration.hasMoreElements()) {
            Id id2 = (Id)enumeration.nextElement();
            String string = (String)Role_AETypeTable.get(id2);
            Id id3 = (Id)QUID_IdTable.get(string);
            if (id3 != null) {
                ModelElements.add(id2, Link.AE_TYPE, id3);
                ModelElements.add(id3, Link.CL_ASSOCIATION_END, id2);
                ModelElements.set(id2, "", "supplier", null);
                if (ModelElements.get(id2, "", "quidu") == null) continue;
                ModelElements.set(id2, "", "quidu", null);
                continue;
            }
            TableObject tableObject = (TableObject)quid_InfoTable.get(string);
            if (tableObject == null) continue;
            Vector vector = ModelElements.get(id, tableObject.getType(), false);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2;
                    Id id4 = (Id)vector.elementAt(i);
                    String string3 = id4.getUUID();
                    if (!string3.equals(tableObject.getUUID()) || (string2 = ModelElements.get(id4, "Rose", "quid")) == null || !string2.equals(string)) continue;
                    id3 = id4;
                    break;
                }
            }
            if (id3 == null) {
                id3 = ModelElements.addConstruct(id, tableObject.getType(), tableObject.getName());
                ModelElements.setUUID(id3, tableObject.getUUID());
                if (!bNoExtension) {
                    ModelElements.set(id3, "Rose", "quid", tableObject.getQUID());
                }
                if (bSetXMIFILETag) {
                    ModelElements.set(id3, "", "xmiFile", tableObject.getXMIBaseFileName());
                    ModelElements.set(id3, "", "is_unit", tableObject.getUnit());
                }
            }
            ModelElements.add(id2, Link.AE_TYPE, id3);
            ModelElements.add(id3, Link.CL_ASSOCIATION_END, id2);
            ModelElements.set(id2, "", "supplier", null);
            if (ModelElements.get(id2, "", "quidu") == null) continue;
            ModelElements.set(id2, "", "quidu", null);
        }
    }

    public void addModelElementToPresentation(Id id) {
        Enumeration enumeration = Presentation_ModelElementTable.keys();
        while (enumeration.hasMoreElements()) {
            Id id2;
            Id id3 = (Id)enumeration.nextElement();
            String string = (String)Presentation_ModelElementTable.get(id3);
            if (debug) {
                System.out.println("add ModelElement to Presentation: " + string);
            }
            if ((id2 = (Id)QUID_IdTable.get(string)) != null) {
                ModelElements.add(id3, Link.P_MODEL, id2);
                ModelElements.add(id2, Link.PRESENTATION, id3);
                continue;
            }
            TableObject tableObject = (TableObject)quid_InfoTable.get(string);
            if (tableObject == null) continue;
            Vector vector = ModelElements.get(id, tableObject.getType(), false);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2;
                    Id id4 = (Id)vector.elementAt(i);
                    String string3 = id4.getUUID();
                    if (!string3.equals(tableObject.getUUID()) || (string2 = ModelElements.get(id4, "Rose", "quid")) == null || !string2.equals(string)) continue;
                    id2 = id4;
                    break;
                }
            }
            if (id2 == null) {
                id2 = ModelElements.addConstruct(id, tableObject.getType(), tableObject.getName());
                ModelElements.setUUID(id2, tableObject.getUUID());
                if (!bNoExtension) {
                    ModelElements.set(id2, "Rose", "quid", tableObject.getQUID());
                }
                if (bSetXMIFILETag) {
                    ModelElements.set(id2, "", "xmiFile", tableObject.getXMIBaseFileName());
                    ModelElements.set(id2, "", "is_unit", tableObject.getUnit());
                }
            }
            ModelElements.add(id3, Link.P_MODEL, id2);
            ModelElements.add(id2, Link.PRESENTATION, id3);
        }
    }

    public void addSuperTypeToGeneralizationLink(Id id) {
        Enumeration enumeration = Generalization_SuperTypeTable.keys();
        while (enumeration.hasMoreElements()) {
            Id id2 = (Id)enumeration.nextElement();
            String string = (String)Generalization_SuperTypeTable.get(id2);
            Id id3 = (Id)QUID_IdTable.get(string);
            if (id3 != null) {
                ModelElements.add(id2, Link.SUPERTYPE, id3);
                ModelElements.add(id3, Link.SPECIALIZATION, id2);
                ModelElements.set(id2, "", "supplier", null);
                if (ModelElements.get(id2, "", "quidu") == null) continue;
                ModelElements.set(id2, "", "quidu", null);
                continue;
            }
            TableObject tableObject = (TableObject)quid_InfoTable.get(string);
            if (tableObject == null) continue;
            Vector vector = ModelElements.get(id, tableObject.getType(), false);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2;
                    Id id4 = (Id)vector.elementAt(i);
                    String string3 = id4.getUUID();
                    if (!string3.equals(tableObject.getUUID()) || (string2 = ModelElements.get(id4, "Rose", "quid")) == null || !string2.equals(string)) continue;
                    id3 = id4;
                    break;
                }
            }
            if (id3 == null) {
                id3 = ModelElements.addConstruct(id, tableObject.getType(), tableObject.getName());
                ModelElements.setUUID(id3, tableObject.getUUID());
                if (!bNoExtension) {
                    ModelElements.set(id3, "Rose", "quid", tableObject.getQUID());
                }
                if (bSetXMIFILETag) {
                    ModelElements.set(id3, "", "xmiFile", tableObject.getXMIBaseFileName());
                    ModelElements.set(id3, "", "is_unit", tableObject.getUnit());
                }
            }
            ModelElements.add(id2, Link.SUPERTYPE, id3);
            ModelElements.add(id3, Link.SPECIALIZATION, id2);
            ModelElements.set(id2, "", "supplier", null);
            if (ModelElements.get(id2, "", "quidu") == null) continue;
            ModelElements.set(id2, "", "quidu", null);
        }
    }

    public void addSupplierToDependencyLink(Id id) {
        Enumeration enumeration = Dependency_SupplierTable.keys();
        while (enumeration.hasMoreElements()) {
            Id id2 = (Id)enumeration.nextElement();
            String string = (String)Dependency_SupplierTable.get(id2);
            Id id3 = (Id)QUID_IdTable.get(string);
            if (id3 != null) {
                ModelElements.add(id2, Link.SUPPLIER, id3);
                ModelElements.add(id3, Link.PROVISION, id2);
                ModelElements.set(id2, "", "supplier", null);
                if (ModelElements.get(id2, "", "quidu") == null) continue;
                ModelElements.set(id2, "", "quidu", null);
                continue;
            }
            TableObject tableObject = (TableObject)quid_InfoTable.get(string);
            if (tableObject == null) continue;
            Vector vector = ModelElements.get(id, tableObject.getType(), false);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2;
                    Id id4 = (Id)vector.elementAt(i);
                    String string3 = id4.getUUID();
                    if (!string3.equals(tableObject.getUUID()) || (string2 = ModelElements.get(id4, "Rose", "quid")) == null || !string2.equals(string)) continue;
                    id3 = id4;
                    break;
                }
            }
            if (id3 == null) {
                id3 = ModelElements.addConstruct(id, tableObject.getType(), tableObject.getName());
                ModelElements.setUUID(id3, tableObject.getUUID());
                if (!bNoExtension) {
                    ModelElements.set(id3, "Rose", "quid", tableObject.getQUID());
                }
                if (bSetXMIFILETag) {
                    ModelElements.set(id3, "", "xmiFile", tableObject.getXMIBaseFileName());
                    ModelElements.set(id3, "", "is_unit", tableObject.getUnit());
                }
            }
            ModelElements.add(id2, Link.SUPPLIER, id3);
            ModelElements.add(id3, Link.PROVISION, id2);
            ModelElements.set(id2, "", "supplier", null);
            if (ModelElements.get(id2, "", "quidu") == null) continue;
            ModelElements.set(id2, "", "quidu", null);
        }
    }

    public void addSupplierToRealizeLink(Id id) {
        Enumeration enumeration = Realization_SupplierTable.keys();
        while (enumeration.hasMoreElements()) {
            Id id2 = (Id)enumeration.nextElement();
            String string = (String)Realization_SupplierTable.get(id2);
            Id id3 = (Id)ClassId_RealizationTable.get(id2);
            Id id4 = (Id)QUID_IdTable.get(string);
            if (id4 != null) {
                ModelElements.add(id3, Link.CL_SPECIFICATION, id4);
                ModelElements.add(id4, Link.REALIZATION, id3);
                ModelElements.add(id2, Link.EXTENSION_REFERENCE, id4);
                ModelElements.set(id2, "", "supplier", null);
                if (ModelElements.get(id2, "", "quidu") == null) continue;
                ModelElements.set(id2, "", "quidu", null);
                continue;
            }
            TableObject tableObject = (TableObject)quid_InfoTable.get(string);
            if (tableObject == null) continue;
            Vector vector = ModelElements.get(id, tableObject.getType(), false);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2;
                    Id id5 = (Id)vector.elementAt(i);
                    String string3 = id5.getUUID();
                    if (!string3.equals(tableObject.getUUID()) || (string2 = ModelElements.get(id5, "Rose", "quid")) == null || !string2.equals(string)) continue;
                    id4 = id5;
                    break;
                }
            }
            if (id4 == null) {
                id4 = ModelElements.addConstruct(id, tableObject.getType(), tableObject.getName());
                ModelElements.setUUID(id4, tableObject.getUUID());
                if (!bNoExtension) {
                    ModelElements.set(id4, "Rose", "quid", tableObject.getQUID());
                }
                if (bSetXMIFILETag) {
                    ModelElements.set(id4, "", "xmiFile", tableObject.getXMIBaseFileName());
                    ModelElements.set(id4, "", "is_unit", tableObject.getUnit());
                }
            }
            ModelElements.add(id3, Link.CL_SPECIFICATION, id4);
            ModelElements.add(id4, Link.REALIZATION, id3);
            ModelElements.add(id2, Link.EXTENSION_REFERENCE, id4);
            ModelElements.set(id2, "", "supplier", null);
            if (ModelElements.get(id2, "", "quidu") == null) continue;
            ModelElements.set(id2, "", "quidu", null);
        }
    }

    public void cleanUp(UML uML, boolean bl) {
        ModelElements.delete(uML.getSession());
        if (bl) {
            if (modelId != null) {
                modelId = null;
            }
            if (xmiDir != null) {
                xmiDir = null;
            }
            IDLUtil iDLUtil = IDLUtil.instance();
            iDLUtil.initIDLPackage();
            this.IDLDataTypePkgId = null;
            if (QUID_IdTable.size() != 0) {
                QUID_IdTable.clear();
            }
            if (className_IdTable.size() != 0) {
                className_IdTable.clear();
            }
            if (classFullName_IdTable.size() != 0) {
                classFullName_IdTable.clear();
            }
            if (Generalization_SuperTypeTable.size() != 0) {
                Generalization_SuperTypeTable.clear();
            }
            if (Role_AETypeTable.size() != 0) {
                Role_AETypeTable.clear();
            }
            if (Dependency_SupplierTable.size() != 0) {
                Dependency_SupplierTable.clear();
            }
            if (Realization_SupplierTable.size() != 0) {
                Realization_SupplierTable.clear();
            }
            if (ClassId_RealizationTable.size() != 0) {
                ClassId_RealizationTable.clear();
            }
            if (Presentation_ModelElementTable.size() != 0) {
                Presentation_ModelElementTable.clear();
            }
        }
    }

    public static void createRoseUnitTreeAndTable(String string, UnitTreeNode unitTreeNode, String string2) throws Exception {
        String string3 = string;
        if (string3.indexOf("$") != -1) {
            string3 = Util.resolveFileName(string3);
        } else if (string3.startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        String string4 = System.getProperty("file.separator");
        if (!string3.startsWith(string4 + string4)) {
            int n;
            while ((n = string3.indexOf(string4 + string4)) != -1) {
                string3 = string3.substring(0, n + 1) + string3.substring(n + 2, string3.length());
            }
        }
        if (debug) {
            System.out.println("createRoseUntiTreeAndTable, process file: " + string3);
        }
        RoseLoader roseLoader = new RoseLoader(string3);
        RoseLexer roseLexer = new RoseLexer(roseLoader);
        RoseParser roseParser = new RoseParser(roseLexer, bLogicalViewOnly, bNoPresentation);
        roseParser.parse();
        RoseNode roseNode = roseParser.getModelTree();
        RoseFirstTraverse roseFirstTraverse = new RoseFirstTraverse(string3);
        if (unitTreeNode == null) {
            if (roseNode.getKey().equals("") && Util.getType(roseNode.getValue()).equals("Class_Category")) {
                String string5 = roseNode.getRoseId();
                string5 = string5.substring(1, string5.length() - 1);
                unitTree = new UnitTreeNode(Util.getName(roseNode.getValue()), string5, string3, string);
                Vector vector = RoseUtil.getXMIFileVector(string, roseNode);
                TableObject tableObject = new TableObject(unitTree.getName(), string5, (String)vector.elementAt(0), (String)vector.elementAt(1), RoseUtil.getUUID(roseNode), Type.PACKAGE, null, "true");
                quid_InfoTable.put(string5, tableObject);
                uuid_InfoTable.put(tableObject.getUUID(), tableObject);
                roseNode.setNode(tableObject.getUUID());
            } else {
                int n = string3.lastIndexOf(System.getProperty("file.separator"));
                int n2 = string3.lastIndexOf(".");
                String string6 = n2 != -1 ? string3.substring(n + 1, n2) : string3.substring(n + 1, string3.length());
                String string7 = roseNode.getRoseId();
                if (string7 != null) {
                    string7 = string7.substring(1, string7.length() - 1);
                    unitTree = new UnitTreeNode(string6, string7, string3, "");
                } else {
                    unitTree = new UnitTreeNode(string6, "", string3, "");
                }
            }
            roseFirstTraverse.traverse(roseNode, unitTree);
        } else {
            String string8 = roseNode.getRoseId();
            if (string8 != null) {
                string8 = string8.substring(1, string8.length() - 1);
                unitTreeNode.setQUID(string8);
                TableObject tableObject = (TableObject)quid_InfoTable.get(string8);
                if (tableObject == null) {
                    Vector vector = RoseUtil.getXMIFileVector(string, roseNode);
                    tableObject = new TableObject(Util.getName(roseNode.getValue()), string8, (String)vector.elementAt(0), (String)vector.elementAt(1), RoseUtil.getUUID(roseNode), Type.PACKAGE, string2, "true");
                    quid_InfoTable.put(string8, tableObject);
                    uuid_InfoTable.put(tableObject.getUUID(), tableObject);
                } else {
                    if (tableObject.getUUID().equals("")) {
                        tableObject.setUUID(RoseUtil.getUUID(roseNode));
                        uuid_InfoTable.put(tableObject.getUUID(), tableObject);
                    }
                    Vector vector = RoseUtil.getXMIFileVector(string, roseNode);
                    String string9 = (String)vector.elementAt(0);
                    String string10 = (String)vector.elementAt(1);
                    if (!tableObject.getXMIBaseFileName().equals(string9)) {
                        tableObject.setXMIBaseFileName(string9);
                    }
                    if (!tableObject.getXMIFileName().equals(string10)) {
                        tableObject.setXMIFileName(string10);
                    }
                }
                roseFirstTraverse.setXMIBaseFileName(tableObject.getXMIBaseFileName());
                roseFirstTraverse.setXMIFileName(tableObject.getXMIFileName());
                roseNode.setNode(tableObject.getUUID());
            }
            roseFirstTraverse.traverse(roseNode, unitTreeNode);
        }
    }

    public static String extractName(String string) {
        String string2 = "";
        int n = string.indexOf(34);
        if (n != -1 && (n = (string = string.substring(n + 1)).indexOf(34)) != -1) {
            string2 = string.substring(0, n);
        }
        if (string2.equals("Logical View")) {
            string2 = "";
        }
        return string2;
    }

    public Vector getFilesFromDirectory(String string, File file, boolean bl) {
        Vector vector = new Vector();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            File file2 = new File(file.getPath() + File.separator + string2);
            if (bl) {
                string2 = file.getPath() + File.separator + string2;
            }
            if (!file2.exists()) continue;
            if (file2.isDirectory()) {
                Vector vector2 = this.getFilesFromDirectory(string, file2, true);
                if (vector2.size() == 0) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.addElement(vector2.elementAt(j));
                }
                continue;
            }
            if (!file2.isFile() || string2.lastIndexOf(".xml") == -1) continue;
            int n = string2.indexOf(string);
            if (n != -1) {
                string2 = string2.substring(string.length() + 1, string2.length());
            }
            vector.addElement(string2);
        }
        return vector;
    }

    public static String getNamespaceUUID(RoseNode roseNode) {
        String string = "";
        if (roseNode != null) {
            RoseNode roseNode2 = roseNode;
            RoseNode roseNode3 = roseNode2.getParent();
            String string2 = RoseUtil.extractName(roseNode2.getValue());
            if (debug) {
                System.out.println(" --------------currentNode.getValue = " + roseNode2.getValue() + "  value = " + string2);
            }
            if (!(roseNode3 == null || roseNode2.getValue().startsWith("Class_Category") && genPkgTable.get(string2) != null)) {
                string = RoseUtil.getNamespaceUUID(roseNode3);
            }
            if (string != null && !string.trim().equals("")) {
                if (string2 != null && !string2.trim().equals("")) {
                    string = string + "/" + string2;
                }
            } else {
                string = string2;
            }
        }
        return string;
    }

    public static String getPackageName(RoseNode roseNode) {
        if (roseNode != null) {
            RoseNode roseNode2 = roseNode;
            RoseNode roseNode3 = roseNode2.getParent();
            String string = roseNode2.getValue();
            if (string.startsWith("Class_Category")) {
                return RoseUtil.extractName(string);
            }
            if (roseNode3 != null) {
                return RoseUtil.getPackageName(roseNode3);
            }
        }
        return "";
    }

    public static String getQUIDFromUnitTree(UnitTreeNode unitTreeNode, String string) {
        Vector vector = unitTreeNode.getNodes();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                UnitTreeNode unitTreeNode2 = (UnitTreeNode)vector.elementAt(i);
                if (!unitTreeNode2.getFileName().equals(string)) continue;
                return unitTreeNode2.getQUID();
            }
        }
        return null;
    }

    public static String getUUID(RoseNode roseNode) {
        Vector vector;
        if (bNamespaceUUID) {
            String string = RoseUtil.getNamespaceUUID(roseNode);
            String string2 = "";
            if (unitTree != null) {
                string2 = unitTree.getName();
            }
            String string3 = "";
            String string4 = RoseUtil.getPackageName(roseNode);
            String string5 = (String)genPkgTable.get(string4);
            string3 = string5 != null ? "Name:" + string5 + "/" : "Name:";
            string3 = string.equals("") ? string3 + string2 : string3 + string;
            if (debug) {
                System.out.println(" ------ UUID =" + string3 + "----");
            }
            return string3;
        }
        RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
        if (roseNode2 != null && (vector = roseNode2.getNodes()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3 = (RoseNode)vector.elementAt(i);
                Vector vector2 = roseNode3.getNodes();
                if (vector2 == null) continue;
                Object object = "";
                Object object2 = "";
                Object object3 = "";
                for (int j = 0; j < vector2.size(); ++j) {
                    Object object4;
                    RoseNode roseNode4 = (RoseNode)vector2.elementAt(j);
                    if (roseNode4.getType() == 0) {
                        object4 = roseNode4.getValue();
                        if (((String)object4).startsWith("\"") && ((String)object4).endsWith("\"")) {
                            object4 = ((String)object4).substring(1, ((String)object4).length() - 1);
                        }
                        if (roseNode4.getKey().equals("tool")) {
                            object = object4;
                            continue;
                        }
                        if (roseNode4.getKey().equals("name")) {
                            object2 = object4;
                            continue;
                        }
                        if (!roseNode4.getKey().equals("value")) continue;
                        object3 = object4;
                        continue;
                    }
                    if (roseNode4.getType() != 4 || (object4 = roseNode4.getNodes()) == null || ((Vector)object4).size() != 1) continue;
                    RoseNode roseNode5 = (RoseNode)((Vector)object4).elementAt(0);
                    String string = roseNode5.getValue();
                    if (string.startsWith("\"") && string.endsWith("\"")) {
                        string = string.substring(1, string.length() - 1);
                    }
                    if (roseNode4.getKey().equals("tool")) {
                        object = string;
                        continue;
                    }
                    if (roseNode4.getKey().equals("name")) {
                        object2 = string;
                        continue;
                    }
                    if (!roseNode4.getKey().equals("value")) continue;
                    object3 = string;
                }
                if (!((String)object).equals("IDL") || !((String)object2).equals("uuid") || ((String)object3).equals("")) continue;
                return object3;
            }
        }
        return Id.createUUID();
    }

    public static Vector getXMIFileVector(String string, RoseNode roseNode) {
        Object object;
        Object object2;
        File file;
        int n;
        boolean bl = false;
        if (string.lastIndexOf(".mdl") != -1) {
            bl = true;
        }
        String string2 = Util.getName(roseNode.getValue());
        string2 = string2.replace('\\', '-');
        string2 = string2.replace('/', '-');
        string2 = string2.replace(' ', '_');
        Vector<String> vector = new Vector<String>();
        String string3 = "\\";
        String string4 = "/";
        string = string.replace(string3.charAt(0), File.separatorChar);
        string = string.replace(string4.charAt(0), File.separatorChar);
        String string5 = System.getProperty("file.separator");
        String string6 = string.substring(1, string.length() - 1);
        while ((n = string6.indexOf(string5 + string5)) != -1) {
            string6 = string6.substring(0, n + 1) + string6.substring(n + 2, string6.length());
        }
        if (string5.equals("/")) {
            while ((n = string.indexOf(string5 + string5)) != -1) {
                string = string.substring(0, n + 1) + string.substring(n + 2, string.length());
            }
        }
        if ((n = string6.indexOf("$")) != -1) {
            string = Util.resolveFileName(string);
            while (n != -1) {
                if ((n = (string6 = string6.substring(n + 1, string6.length())).indexOf(string5)) != -1) {
                    string6 = string6.substring(n + 1, string6.length());
                }
                n = string6.indexOf("$");
            }
        } else {
            n = string6.lastIndexOf(string5);
            if (n != -1) {
                string6 = string6.substring(n + 1, string6.length());
            }
        }
        if (bInXmiDir && (n = string6.lastIndexOf(string5)) != -1) {
            string6 = string6.substring(n + 1, string6.length());
        }
        if ((file = new File(string.substring(1, string.length() - 1))).isFile()) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                RoseUtil.handleException(iOException, null);
            }
        }
        String string7 = "";
        n = string.indexOf(string6);
        if (n != -1) {
            string7 = string.substring(0, n - 1);
        }
        if (xmiDir != null && ((File)(object2 = new File(xmiDir))).isDirectory()) {
            try {
                string7 = ((File)object2).getCanonicalPath();
            }
            catch (IOException iOException) {
                RoseUtil.handleException(iOException, null);
            }
        }
        if (!bCatAsXML) {
            n = string6.lastIndexOf(string5);
            int n2 = string6.lastIndexOf(".");
            if (!string2.equals(ResourceUtil.getString("LOGICAL_VIEW").replace(' ', '_'))) {
                string6 = n != -1 ? string6.substring(0, n + 1) + string2 + string6.substring(n2, string6.length()) : string2 + string6.substring(n2, string6.length());
            }
        }
        if (bForCB) {
            Object object3;
            Object object4;
            Object object5;
            String string8;
            Object object6;
            Object object7;
            int n3;
            Serializable serializable;
            boolean bl2 = false;
            object = roseNode.findNodeWithKey("attributes");
            if (object != null) {
                serializable = ((RoseNode)object).getNodes();
                for (n3 = 0; n3 < ((Vector)serializable).size(); ++n3) {
                    object7 = (RoseNode)((Vector)serializable).elementAt(n3);
                    object6 = ((RoseNode)object7).findNodeWithKey("name");
                    if (object6 == null || !(string8 = ((RoseNode)object6).getValue()).equals("\"OBProjectDirectory\"") || (object5 = ((RoseNode)object7).findNodeWithKey("value")) == null) continue;
                    object4 = "";
                    if (((RoseNode)object5).getType() == 0) {
                        object4 = ((RoseNode)object5).getValue();
                    } else if (((RoseNode)object5).getType() == 4 && (object3 = ((RoseNode)object5).getNodes()) != null && ((Vector)object3).size() == 1) {
                        RoseNode roseNode2 = (RoseNode)((Vector)object3).elementAt(0);
                        object4 = roseNode2.getValue();
                    }
                    object4 = Util.resolveFileName((String)object4);
                    if (File.separator.equals("\\")) {
                        if (((String)object4).charAt(1) != ':') {
                            object4 = OBBaseProjectDir + File.separator + (String)object4;
                        }
                    } else if (!((String)object4).substring(0, 1).equals(File.separator)) {
                        object4 = OBBaseProjectDir + File.separator + (String)object4;
                    }
                    if (!((File)(object3 = new File((String)object4))).exists()) {
                        ((File)object3).mkdirs();
                    }
                    if (((File)object3).isDirectory()) {
                        try {
                            string7 = ((File)object3).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            RoseUtil.handleException(iOException, null);
                        }
                    }
                    OBProjectDirs = OBProjectDirs.equals("") ? string7 : OBProjectDirs + ";" + string7;
                    int n4 = string6.lastIndexOf(File.separator);
                    if (n4 != -1) {
                        string6 = string6.substring(n4 + 1, string6.length());
                    }
                    string6 = "xmi" + string5 + string6;
                    bl2 = true;
                }
            }
            if (!bl2 && !OBBaseProjectDir.equals("")) {
                if (string.lastIndexOf(".mdl") != -1) {
                    int n5;
                    serializable = new File(OBBaseProjectDir);
                    n3 = 0;
                    if (!((File)serializable).exists()) {
                        ((File)serializable).mkdirs();
                        n3 = 1;
                    }
                    if (((File)serializable).isDirectory()) {
                        try {
                            string7 = ((File)serializable).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            RoseUtil.handleException(iOException, null);
                        }
                    }
                    object7 = roseNode.findNodeWithKey("is_loaded");
                    object6 = roseNode.findNodeWithKey("is_unit");
                    string8 = "";
                    object5 = "";
                    if (object7 != null) {
                        string8 = ((RoseNode)object7).getValue();
                    }
                    if (object6 != null) {
                        object5 = ((RoseNode)object6).getValue();
                    }
                    boolean bl3 = false;
                    if (string8.equals("FALSE") && ((String)object5).equals("TRUE") && n3 != 0) {
                        ((File)serializable).delete();
                        bl3 = true;
                    }
                    if (!bl3) {
                        OBProjectDirs = OBProjectDirs.equals("") ? string7 : OBProjectDirs + ";" + string7;
                    }
                    if ((n5 = string6.lastIndexOf(File.separator)) != -1) {
                        string6 = string6.substring(n5 + 1, string6.length());
                    }
                    string6 = "xmi" + string5 + string6;
                } else if (string.lastIndexOf(".cat") != -1) {
                    int n6;
                    String string9 = Util.getName(roseNode.getValue());
                    string9 = string9.replace('\\', '-');
                    string9 = string9.replace('/', '-');
                    object7 = OBBaseProjectDir + string5 + string9;
                    object6 = new File((String)object7);
                    boolean bl4 = false;
                    if (!((File)object6).exists()) {
                        ((File)object6).mkdirs();
                        bl4 = true;
                    }
                    if (((File)object6).isDirectory()) {
                        try {
                            string7 = ((File)object6).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            RoseUtil.handleException(iOException, null);
                        }
                    }
                    object5 = roseNode.findNodeWithKey("is_loaded");
                    object4 = roseNode.findNodeWithKey("is_unit");
                    object3 = "";
                    String string10 = "";
                    if (object5 != null) {
                        object3 = ((RoseNode)object5).getValue();
                    }
                    if (object4 != null) {
                        string10 = ((RoseNode)object4).getValue();
                    }
                    boolean bl5 = false;
                    if (((String)object3).equals("FALSE") && string10.equals("TRUE") && bl4) {
                        ((File)object6).delete();
                        bl5 = true;
                    }
                    if (!bl5) {
                        OBProjectDirs = OBProjectDirs.equals("") ? string7 : OBProjectDirs + ";" + string7;
                    }
                    if ((n6 = string6.lastIndexOf(File.separator)) != -1) {
                        string6 = string6.substring(n6 + 1, string6.length());
                    }
                    string6 = "xmi" + string5 + string6;
                }
            }
        }
        if ((n = string6.lastIndexOf(".")) != -1) {
            string6 = string6.substring(0, n);
        }
        string6 = string6 + ".xml";
        if (bl && bModelXML && !bDefaultXML && (n = string6.lastIndexOf(".")) != -1) {
            string6 = string6.substring(0, n) + "Model" + string6.substring(n + 1, string6.length());
        }
        if (bl && bDefaultXML) {
            string6 = bForCB ? "xmi" + string5 + "ROSEMODEL.xml" : "ROSEMODEL.xml";
        }
        if (bForCB && !OBXMIFileVector.contains(string6)) {
            OBXMIFileVector.addElement(string6);
        }
        object2 = string7 + string5 + string6;
        object2 = ((String)object2).toLowerCase();
        if (xmiFileName_Table == null) {
            xmiFileName_Table = new Hashtable();
        }
        object = (String)xmiFileName_Table.get(object2);
        if (debug) {
            System.out.println(" ---- fileName ----" + string);
            System.out.println(" ---- xmiFullName ----" + (String)object2);
            System.out.println(" ---- modelFileName ----" + (String)object);
        }
        if (object != null) {
            if (!((String)object).equals(string)) {
                throw new NameConflictException();
            }
        } else {
            xmiFileName_Table.put(object2, string);
        }
        vector.addElement(string6);
        vector.addElement(string7 + string5 + string6);
        return vector;
    }

    public static void handleException(Throwable throwable, String string) {
        if (string != null) {
            System.out.println(string);
        }
        if (debug) {
            throwable.printStackTrace();
        } else if (string == null) {
            throwable.printStackTrace();
        }
        bCheckConsole = true;
    }

    public static void initGenPkgTable() {
        if (generatedPackageName == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(generatedPackageName, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                int n = string.indexOf("=");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                if (debug) {
                    System.out.println("Register package " + string2 + " value " + string3);
                }
                genPkgTable.put(string2, string3);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("GenPackage syntax is a=b,c=d");
            throw stringIndexOutOfBoundsException;
        }
    }

    public Id load(UnitTreeNode unitTreeNode, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string = unitTreeNode.getName();
        String string2 = unitTreeNode.getQUID();
        String string3 = unitTreeNode.getFileName();
        TableObject tableObject = (TableObject)quid_InfoTable.get(string2);
        if (debug) {
            System.out.println("==== Load Rose file: " + string3);
        }
        Id id = umlForRoseLoad.getSession();
        Id id2 = null;
        if (!bNoPkg || bNoPkg && tableObject.getType() != Type.PACKAGE) {
            object6 = new Vector<Property>();
            ((Vector)object6).addElement(Property.NAME);
            ((Vector)object6).addElement(string);
            object5 = ModelElements.get(id, tableObject.getType(), (Vector)object6, false);
            if (object5 != null && ((Vector)object5).size() == 1) {
                id2 = (Id)((Vector)object5).elementAt(0);
            } else {
                id2 = ModelElements.addConstruct(id, tableObject.getType(), string);
                ModelElements.setUUID(id2, tableObject.getUUID());
                if (!bNoExtension) {
                    ModelElements.set(id2, "Rose", "quid", string2);
                    if (id2.getType() == Type.MODEL) {
                        object4 = string3;
                        int n = ((String)object4).lastIndexOf(System.getProperty("file.separator"));
                        if (n != -1) {
                            object4 = ((String)object4).substring(n + 1, ((String)object4).length());
                        }
                        ModelElements.set(id2, "Rose", "file_name", (String)object4);
                    } else if (id2.getType() == Type.PACKAGE) {
                        ModelElements.set(id2, "Rose", "file_name", unitTreeNode.getFileNodeName());
                    }
                }
                if (bSetXMIFILETag) {
                    ModelElements.set(id2, "", "xmiFile", tableObject.getXMIBaseFileName());
                    ModelElements.set(id2, "", "is_unit", "true");
                }
                if (IDLForPkgTable != null && IDLForPkgTable.size() > 0) {
                    object4 = IDLForPkgTable.keys();
                    while (object4.hasMoreElements()) {
                        String string4 = (String)object4.nextElement();
                        object3 = (String)IDLForPkgTable.get(string4);
                        ModelElements.set(id2, "IDL", string4, (String)object3);
                    }
                }
            }
            if (id2.getType() == Type.MODEL) {
                modelId = id2;
            }
            if (tableObject.getParentUUID() != null) {
                object4 = tableObject.getParentUUID();
                TableObject tableObject2 = (TableObject)uuid_InfoTable.get(object4);
                object3 = null;
                ((Vector)object6).removeAllElements();
                ((Vector)object6).addElement(Property.NAME);
                ((Vector)object6).addElement(tableObject2.getName());
                object2 = ModelElements.get(id, tableObject2.getType(), (Vector)object6, false);
                if (object2 != null && ((Vector)object2).size() == 1) {
                    object3 = (Id)((Vector)object2).elementAt(0);
                } else {
                    object3 = ModelElements.addConstruct(id, tableObject2.getType(), tableObject2.getName());
                    ModelElements.setUUID((Id)object3, tableObject2.getUUID());
                    if (!bNoExtension) {
                        ModelElements.set((Id)object3, "Rose", "quid", tableObject2.getQUID());
                    }
                    if (bSetXMIFILETag) {
                        ModelElements.set((Id)object3, "", "xmiFile", tableObject2.getXMIBaseFileName());
                        ModelElements.set((Id)object3, "", "is_unit", tableObject2.getUnit());
                    }
                }
                ModelElements.add(id2, Link.NAMESPACE, (Id)object3);
            }
        }
        object6 = new RoseLoader(string3);
        if (propertyChangeListener != null) {
            ((RoseComponent)object6).addPropertyChangeListener(propertyChangeListener);
            ((RoseLoader)object6).setLower(this.indicatorLowerNum);
            ((RoseLoader)object6).setUpper(this.indicatorLowerNum + this.incrementNum);
            this.indicatorLowerNum = ((RoseLoader)object6).getUpper();
        }
        object5 = new RoseLexer((RoseLoader)object6);
        object4 = new RoseParser((RoseLexer)object5, bLogicalViewOnly, bNoPresentation);
        ((RoseParser)object4).parse();
        RoseNode roseNode = ((RoseParser)object4).getVersionTree();
        object3 = ((RoseParser)object4).getModelTree();
        if (id2 != null) {
            ((RoseNode)object3).setNode(id2);
        } else if (bNoPkg) {
            ((RoseNode)object3).setNode(modelId);
        }
        if (this.IDLDataTypePkgId == null) {
            if (!bNoIDLPkg) {
                object2 = IDLUtil.instance();
                if (((IDLUtil)object2).createIDLDatatype(id2)) {
                    this.IDLDataTypePkgId = ((IDLUtil)object2).getIDLDatatypePackage();
                    if (!bNoExtension) {
                        ModelElements.set(this.IDLDataTypePkgId, "Rose", "IsFromModel", "FALSE");
                    }
                }
            } else {
                this.IDLDataTypePkgId = ModelElements.addConstruct(id2, Type.PACKAGE, "DataTypePackageForModel");
                if (!bNoExtension) {
                    ModelElements.set(this.IDLDataTypePkgId, "Rose", "IsFromModel", "FALSE");
                }
            }
        }
        object2 = new RoseSecondTraverse((RoseNode)object3);
        RoseVisitorTNG roseVisitorTNG = new RoseVisitorTNG(id, this.IDLDataTypePkgId, unitTreeNode);
        ((RoseSecondTraverse)object2).traverse(roseVisitorTNG);
        if (bl) {
            if (!Generalization_SuperTypeTable.isEmpty()) {
                this.addSuperTypeToGeneralizationLink(id);
            }
            if (!Dependency_SupplierTable.isEmpty()) {
                this.addSupplierToDependencyLink(id);
            }
            if (!Role_AETypeTable.isEmpty()) {
                this.addAETypeToAssociationEnd(id);
            }
            if (!Realization_SupplierTable.isEmpty()) {
                this.addSupplierToRealizeLink(id);
            }
            if (!Presentation_ModelElementTable.isEmpty()) {
                this.addModelElementToPresentation(id);
            }
            this.resetAttrOrParamType(id, this.IDLDataTypePkgId);
        }
        if (roseNode != null) {
            this.visitVersionTree(id2, roseNode);
        }
        if (bForCB && (object = ModelElements.get(id2, "IDL", "OBProjectDirectory")) == null && id2.getType() == Type.PACKAGE) {
            ModelElements.set(id2, "IDL", "OBProjectDirectory", ModelElements.getName(id2));
        }
        if (this.bUpdateRose) {
            object = new File(string3);
            String string5 = ((File)object).getCanonicalPath();
            String string6 = string5.substring(0, string5.length() - 1) + "~";
            File file = new File(string6);
            if (file.exists()) {
                file.delete();
            }
            FileUtil.copyTilde(string3);
            RoseWriter roseWriter = new RoseWriter(string3, roseNode, (RoseNode)object3);
            roseWriter.write();
        }
        return id2;
    }

    public Id loadXMIFile(UML uML, String string) {
        if (debug) {
            System.out.println("==== Load XMI file: " + string);
        }
        try {
            if (progressListener != null) {
                progressListener.setLower(this.indicatorLowerNum);
                progressListener.setUpper(this.indicatorLowerNum + this.incrementNum);
                this.indicatorLowerNum = progressListener.getUpper();
            }
            Vector vector = null;
            vector = this.bValidate ? uML.load(string, new Vector(), 1, true) : uML.load(string, new Vector(), 1, false);
            if (vector != null && vector.size() == 1) {
                Id id = (Id)vector.elementAt(0);
                return id;
            }
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, null);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        if (stringArray.length == 0) {
            System.out.println("Valid arguments are:");
            System.out.println("-rLoad      -- Load Rose model");
            System.out.println("-i          -- Path name of Rose input MDL file");
            System.out.println("-icat       -- Directory of Rose input CAT file");
            System.out.println("-noExt      -- Specify no Extension object is created in Model");
            System.out.println("-noUI       -- Specify no UI stored in Model");
            System.out.println("-noPkg      -- Specify no Type.PACKAGE construct is created");
            System.out.println("-noIDLPkg   -- Specify not include IDL DataType Package");
            System.out.println("-xml\t -- Specify xml file that contains model info");
            System.out.println("-dtd        -- Specify dtd file name");
            System.out.println("");
            System.out.println("-rSave      -- Save to Rose file");
            System.out.println("-xml        -- Specify xml file that needs to be loaded");
            System.out.println("-o          -- Path name of Rose output MDL file");
            System.out.println("-ocat       -- Directory of Rose output CAT file");
            System.out.println("");
            System.out.println("-r2x        -- Load Rose model and generate xml files");
            System.out.println("-i          -- Path name of Rose input MDL file");
            System.out.println("-icat       -- Directory of Rose input CAT file");
            System.out.println("-xmiDir     -- Directory to store xml files");
            System.out.println("-xmiZip     -- Zip file that contains xml files");
            System.out.println("-noExt      -- Specify no Extension object is created in Model");
            System.out.println("-noUI       -- Specify no UI stored in Model");
            System.out.println("-noPkg      -- Specify no Type.PACKAGE construct is created");
            System.out.println("-noIDLPkg   -- Specify not include IDL DataType Package");
            System.out.println("-CB         -- Specify OB base directory");
            System.out.println("-CopyRight  -- Specify CopyRight info file");
            System.out.println("-updateRose -- Update Rose file with uuid");
            System.out.println("-defaultXML -- Use ROSEMODEL.xml filename for rose mdl in r2x option");
            System.out.println("-catAsXML   -- Use cat filename as xml filename; default is package name as xml filename");
            System.out.println("-inXmiDir\t -- All xml files are generated in directory specified in xmiDir option, no subdirectories are generated under it");
            System.out.println("-modelXML   -- Append Model to rose mdl file as its xml filename");
            System.out.println("");
            System.out.println("-x2r        -- Load xml file and generate Rose file");
            System.out.println("-modelPath  -- ModelPath variable to search xml file");
            System.out.println("-xml        -- XML file name");
            System.out.println("-inputXmiDir-- Directory that contains all xml files");
            System.out.println("-inptXmiZip -- Zip file that contains all xml files");
            System.out.println("-o          -- Path name of Rose output MDL file");
            System.out.println("-ocat       -- Directory of Rose output CAT file");
            System.out.println("");
            System.out.println("-merge      -- Turn merge mode on");
            System.out.println("-noDTD      -- Turn off DTD reference field in XML File");
            System.out.println("-validate   -- Turn on validate XML file mode");
            System.out.println("-debug      -- Turn debug mode on");
            System.out.println("");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-i") && i + 1 < stringArray.length) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-o") && i + 1 < stringArray.length) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-icat") && i + 1 < stringArray.length) {
                string3 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-ocat") && i + 1 < stringArray.length) {
                string4 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-xmiDir") && i + 1 < stringArray.length) {
                string5 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-xmiZip") && i + 1 < stringArray.length) {
                string7 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-inputXmiDir") && i + 1 < stringArray.length) {
                string6 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-inputXmiZip") && i + 1 < stringArray.length) {
                string8 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-xml") && i + 1 < stringArray.length) {
                string9 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-dtd") && i + 1 < stringArray.length) {
                string10 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-modelPath") && i + 1 < stringArray.length) {
                string11 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-CB") && i + 1 < stringArray.length) {
                bl7 = true;
                string12 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-CopyRight") && i + 1 < stringArray.length) {
                string13 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-r2x")) {
                bl8 = true;
                continue;
            }
            if (stringArray[i].equals("-x2r")) {
                bl9 = true;
                continue;
            }
            if (stringArray[i].equals("-rLoad")) {
                bl10 = true;
                continue;
            }
            if (stringArray[i].equals("-rSave")) {
                bl11 = true;
                continue;
            }
            if (stringArray[i].equals("-noExt")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-noUI")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-noPkg")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-noIDLPkg")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-merge")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-validate")) {
                bl14 = true;
                continue;
            }
            if (stringArray[i].equals("-updateRose")) {
                bl13 = true;
                continue;
            }
            if (stringArray[i].equals("-defaultXML")) {
                bl15 = true;
                continue;
            }
            if (stringArray[i].equals("-catAsXML")) {
                bl16 = true;
                continue;
            }
            if (stringArray[i].equals("-inXmiDir")) {
                bl17 = true;
                continue;
            }
            if (stringArray[i].equals("-modelXML")) {
                bl18 = true;
                continue;
            }
            if (!stringArray[i].equals("-noDTD")) continue;
            bl12 = true;
        }
        try {
            Id id;
            Vector vector;
            Object object;
            RoseUtil roseUtil = new RoseUtil();
            if (bl5) {
                roseUtil.setDebug(true);
            }
            if (bl6) {
                roseUtil.setDoMerge(true);
            }
            if (bl14) {
                roseUtil.setValidate(bl14);
            }
            if (bl12) {
                roseUtil.setNoDTD(bl12);
            }
            if (bl13) {
                roseUtil.setRoseUpdate(bl13);
            }
            if (bl15) {
                roseUtil.setDefaultXML(bl15);
            }
            if (bl16) {
                roseUtil.setCatAsXML(bl16);
            }
            if (bl17) {
                roseUtil.setInXmiDir(bl17);
            }
            if (bl18) {
                roseUtil.setModelXML(bl18);
            }
            if (!string5.equals("")) {
                roseUtil.setXMIFileDirectory(string5);
            }
            if (!string7.equals("")) {
                roseUtil.setXMIZipFileName(string7);
            }
            if (!string11.equals("")) {
                roseUtil.setModelPath(string11);
            }
            if (!string13.equals("")) {
                roseUtil.setCopyRightHeaderInfo(string13);
            }
            if (bl10) {
                roseUtil.rLoad(string, true, string3, bl2, bl, bl4, bl3);
                object = umlForRoseLoad.getSession();
                vector = ModelElements.get((Id)object, Type.MODEL, false);
                id = null;
                if (vector != null && vector.size() == 1) {
                    id = (Id)vector.elementAt(0);
                }
                if (id != null && !string10.equals("") && !string9.equals("")) {
                    id.save(string9, 1);
                }
            }
            if (bl11 && !string9.equals("")) {
                object = new UML();
                vector = null;
                vector = bl14 ? ((UML)object).load(string9, new Vector(), 1, true) : ((UML)object).load(string9, new Vector(), 1, false);
                if (vector != null && vector.size() == 1) {
                    id = (Id)vector.elementAt(0);
                    roseUtil.rSave(string2, id, string4);
                }
            }
            if (bl8) {
                if (bl7) {
                    OBBaseProjectDir = string12;
                    bForCB = true;
                    roseUtil.rLoadAndxSave(string, true, string3, bl2, bl, bl4, bl3);
                    object = OBXMIFileVector;
                    if (object != null && ((Vector)object).size() > 0) {
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            System.out.println("OBXMIFileVector: " + (String)((Vector)object).elementAt(i));
                        }
                    }
                } else {
                    roseUtil.rLoadAndxSave(string, true, string3, bl2, bl, bl4, bl3);
                }
            }
            if (bl9) {
                if (!string8.equals("")) {
                    roseUtil.xLoadAndrSave(string8, string2, string4);
                } else if (!string6.equals("")) {
                    roseUtil.xLoadAndrSave(string6, string2, string4);
                } else if (!string9.equals("")) {
                    roseUtil.xLoadAndrSave(string9, string2, string4);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public Id merging(Id id, TableObject tableObject) {
        Object object = id;
        String string = tableObject.getXMIFileName();
        String string2 = tableObject.getXMIBaseFileName();
        File file = new File(string);
        if (file.exists()) {
            Object object2;
            Object object3;
            UML uML = new UML();
            int n = string.indexOf(string2);
            String string3 = "";
            if (n != -1) {
                string3 = string.substring(0, n - 1);
            }
            String string4 = string3;
            if (bForCB) {
                try {
                    object3 = string3 + File.separator + "xmi" + File.separator + "umlfilepath.dat";
                    object2 = new BufferedReader(new FileReader((String)object3));
                    string4 = ((BufferedReader)object2).readLine();
                    ((BufferedReader)object2).close();
                }
                catch (Exception exception) {
                    RoseUtil.handleException(exception, exception + " thrown when reading umlfilepath.dat file");
                }
            }
            if (!string4.equals("")) {
                uML.setFilePath(string4);
            }
            if ((object3 = this.loadXMIFile(uML, string2)) != null) {
                DiffMergeTool.stopAtUnit = true;
                object2 = new DiffMergeTool((Id)object3, id, 0);
                ((DiffMergeTool)object2).differencing();
                ((DiffMergeTool)object2).merging();
                object = object3;
            }
        } else if (this.oldXmiZipFile != null && !this.oldXmiZipFile.equals("")) {
            UML uML = new UML();
            uML.setFilePath(this.oldXmiZipFile);
            Id id2 = this.loadXMIFile(uML, string2);
            if (id2 != null) {
                DiffMergeTool.stopAtUnit = true;
                DiffMergeTool diffMergeTool = new DiffMergeTool(id2, id, 0);
                diffMergeTool.differencing();
                diffMergeTool.merging();
                object = id2;
            }
        }
        if (object != id) {
            ModelElements.delete(umlForRoseLoad.getSession());
        }
        return object;
    }

    public static void processDefaultProperties(RoseNode roseNode) {
        Vector vector = roseNode.getNodes();
        RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
        if (roseNode2 != null) {
            Vector vector2 = roseNode2.getNodes();
            for (int i = 0; i < vector2.size(); ++i) {
                RoseNode roseNode3 = (RoseNode)vector2.elementAt(i);
                RoseNode roseNode4 = roseNode3.findNodeWithKey("name");
                RoseNode roseNode5 = roseNode3.findNodeWithKey("tool");
                String string = "";
                if (roseNode4 != null && (string = roseNode4.getValue()).startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                String string2 = "";
                if (roseNode5 != null && (string2 = roseNode5.getValue()).startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (string2 == null || string2.equals("") || string == null || string.equals("")) continue;
                if (string2.equals("IDL")) {
                    if (string.equals("default__Category")) {
                        RoseUtil.storeIDLPkgDefaultProperties(roseNode3);
                        continue;
                    }
                    if (string.equals("default__Class")) {
                        RoseUtil.storeIDLClsDefaultProperties(roseNode3);
                        continue;
                    }
                    if (string.equals("default__Attribute")) {
                        RoseUtil.storeIDLAttrDefaultProperties(roseNode3);
                        continue;
                    }
                    if (string.equals("default__Operation")) {
                        RoseUtil.storeIDLOprDefaultProperties(roseNode3);
                        continue;
                    }
                    if (!string.equals("default__Role")) continue;
                    RoseUtil.storeIDLAEDefaultProperties(roseNode3);
                    continue;
                }
                if (!string2.equals("DDL") || !string.equals("default__Attribute")) continue;
                RoseUtil.storeDDLAttrDefaultProperties(roseNode3);
            }
        }
    }

    private void processUnitTree() throws Exception {
        if (unitTree != null) {
            this.processUnitTreeNode(unitTree, true);
        }
    }

    private void processUnitTree(boolean bl) throws Exception {
        if (unitTree != null) {
            this.processUnitTreeNode(unitTree, bl);
        }
        if (!bl) {
            Id id = umlForRoseLoad.getSession();
            if (!Generalization_SuperTypeTable.isEmpty()) {
                this.addSuperTypeToGeneralizationLink(id);
            }
            if (!Dependency_SupplierTable.isEmpty()) {
                this.addSupplierToDependencyLink(id);
            }
            if (!Role_AETypeTable.isEmpty()) {
                this.addAETypeToAssociationEnd(id);
            }
            if (!Realization_SupplierTable.isEmpty()) {
                this.addSupplierToRealizeLink(id);
            }
            if (!Presentation_ModelElementTable.isEmpty()) {
                this.addModelElementToPresentation(id);
            }
            this.resetAttrOrParamType(id, this.IDLDataTypePkgId);
        }
    }

    private void processUnitTreeNode(UnitTreeNode unitTreeNode, boolean bl) throws Exception {
        Object object;
        Object object2;
        Id id = this.load(unitTreeNode, bl);
        if (id != null) {
            if (withJDK116) {
                ModelElements.set(id, "Java", "WithJDK116", "TRUE");
            }
            if (bl) {
                object2 = id.getUUID();
                TableObject tableObject = (TableObject)uuid_InfoTable.get(object2);
                object = tableObject.getXMIFileName();
                String string = tableObject.getXMIBaseFileName();
                String string2 = ModelElements.get(id, "", "xmiFile");
                if (this.doMerge) {
                    id = this.merging(id, tableObject);
                }
                if (string2.equals(string)) {
                    if (this.xmiZipFile != null && !this.xmiZipFile.equals("") && this.zipOutputStream != null) {
                        this.saveAsXMIFile(id, this.zipOutputStream);
                    } else {
                        int n = ((String)object).indexOf(string);
                        if (n != -1) {
                            String string3 = ((String)object).substring(0, n - 1);
                            this.saveAsXMIFile(id, string3);
                            if (bForCB && !OBProjectDirs.equals("")) {
                                this.saveUMLFilePathToFile(string3);
                            }
                        }
                    }
                }
                this.cleanUp(id.getAPI(), true);
            }
        }
        if ((object2 = unitTreeNode.getNodes()) != null) {
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                object = (UnitTreeNode)((Vector)object2).elementAt(i);
                this.processUnitTreeNode((UnitTreeNode)object, bl);
            }
        }
    }

    public void resetAttrOrParamType(Id id, Id id2) {
        Vector vector;
        if (debug) {
            System.out.println("resetAttrOrParamType");
        }
        if ((vector = ModelElements.get(id2, Type.PRIMITIVE, false)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Id id3;
                int n;
                Vector vector2;
                Object object;
                Id id4 = (Id)vector.elementAt(i);
                boolean bl = false;
                String string = ModelElements.get(id4, Property.NAME);
                Id id5 = (Id)className_IdTable.get(string);
                if (id5 == null && (id5 = (Id)classFullName_IdTable.get(string)) == null) {
                    object = (TableObject)className_InfoTable.get(string);
                    if (object == null) {
                        object = (TableObject)classFullName_InfoTable.get(string);
                    }
                    if (object != null) {
                        vector2 = ModelElements.get(id, ((TableObject)object).getType(), false);
                        if (vector2 != null) {
                            for (n = 0; n < vector2.size(); ++n) {
                                String string2;
                                id3 = (Id)vector2.elementAt(n);
                                String string3 = id3.getUUID();
                                if (!string3.equals(((TableObject)object).getUUID()) || (string2 = ModelElements.get(id3, "Rose", "quid")) == null || !string2.equals(((TableObject)object).getQUID())) continue;
                                id5 = id3;
                                break;
                            }
                        }
                        if (id5 == null) {
                            id5 = ModelElements.addConstruct(id, ((TableObject)object).getType(), ((TableObject)object).getName());
                            ModelElements.setUUID(id5, ((TableObject)object).getUUID());
                            if (!bNoExtension) {
                                ModelElements.set(id5, "Rose", "quid", ((TableObject)object).getQUID());
                            }
                            if (bSetXMIFILETag) {
                                ModelElements.set(id5, "", "xmiFile", ((TableObject)object).getXMIBaseFileName());
                                ModelElements.set(id5, "", "is_unit", ((TableObject)object).getUnit());
                            }
                        }
                    }
                }
                if (id5 != null) {
                    if (debug) {
                        System.out.println("find class for data type " + ModelElements.get(id4, Property.NAME));
                    }
                    if ((object = ModelElements.get(id4, Link.STRUCTURAL_FEATURE, false)) != null) {
                        for (int j = 0; j < ((Vector)object).size(); ++j) {
                            Id id6 = (Id)((Vector)object).elementAt(j);
                            if (debug) {
                                System.out.println("replace attribute " + ModelElements.get(id6, Property.NAME) + " data type to class");
                            }
                            ModelElements.delete(id6, Link.SF_TYPE, id4);
                            ModelElements.delete(id4, Link.STRUCTURAL_FEATURE, id6);
                            ModelElements.add(id6, Link.SF_TYPE, id5);
                            ModelElements.add(id5, Link.STRUCTURAL_FEATURE, id6);
                        }
                    }
                    if ((vector2 = ModelElements.get(id4, Link.CL_PARAMETER, false)) != null) {
                        for (n = 0; n < vector2.size(); ++n) {
                            id3 = (Id)vector2.elementAt(n);
                            if (debug) {
                                System.out.println("replace parameter " + ModelElements.get(id3, Property.NAME) + " type");
                            }
                            ModelElements.delete(id3, Link.PARM_TYPE, id4);
                            ModelElements.delete(id4, Link.CL_PARAMETER, id3);
                            ModelElements.add(id3, Link.PARM_TYPE, id5);
                            ModelElements.add(id5, Link.CL_PARAMETER, id3);
                        }
                    }
                    ModelElements.delete(id4);
                    bl = true;
                }
                if (bl) continue;
                object = ModelElements.get(id4, Link.STRUCTURAL_FEATURE, false);
                if (object != null) {
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        Id id7 = (Id)((Vector)object).elementAt(j);
                        ModelElements.delete(id4, Link.STRUCTURAL_FEATURE, id7);
                    }
                }
                if ((vector2 = ModelElements.get(id4, Link.CL_PARAMETER, false)) == null) continue;
                for (n = 0; n < vector2.size(); ++n) {
                    id3 = (Id)vector2.elementAt(n);
                    ModelElements.delete(id4, Link.CL_PARAMETER, id3);
                }
            }
        }
    }

    public void rLoad(String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.rLoad(string, bl, string2, bl2, bl3, bl4, bl5, false);
    }

    public void rLoad(String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.roseLoadInit();
        this.setRoseLoadOptions(string, bl, string2, bl2, bl3, bl4, bl5);
        bSetXMIFILETag = bl6;
        try {
            Date date;
            if (debug) {
                date = new Date();
                System.out.println("Begin build tree and table: " + date.toString());
            }
            RoseUtil.createRoseUnitTreeAndTable(string, null, null);
            if (debug) {
                date = new Date();
                System.out.println("End build tree and table: " + date.toString());
            }
            this.showRoseUnitTreeAndTableInfo();
            if (debug) {
                date = new Date();
                System.out.println("Begin loading: " + date.toString());
            }
            this.processUnitTree(false);
            if (debug) {
                date = new Date();
                System.out.println("End loading: " + date.toString());
            }
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, null);
        }
    }

    public void rLoadAndxSave(String string, boolean bl, String string2, boolean bl2, boolean bl3) {
        this.rLoadAndxSave(string, bl, string2, bl2, bl3, false, false);
    }

    public void rLoadAndxSave(String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.roseLoadInit();
        this.setRoseLoadOptions(string, bl, string2, bl2, bl3, bl4, bl5);
        try {
            Date date;
            if (debug) {
                date = new Date();
                System.out.println("Begin build tree and table: " + date.toString());
            }
            RoseUtil.createRoseUnitTreeAndTable(string, null, null);
            if (debug) {
                date = new Date();
                System.out.println("End build tree and table: " + date.toString());
            }
            this.showRoseUnitTreeAndTableInfo();
            if (debug) {
                date = new Date();
                System.out.println("Begin loading: " + date.toString());
            }
            this.processUnitTree();
            if (debug) {
                date = new Date();
                System.out.println("End loading: " + date.toString());
            }
            if (this.zipOutputStream != null) {
                this.zipOutputStream.close();
                this.zipOutputStream = null;
            }
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, null);
        }
    }

    public void roseLoadCleanUp() {
        umlForRoseLoad = null;
        modelId = null;
        unitTree = null;
        if (quid_InfoTable != null && quid_InfoTable.size() != 0) {
            quid_InfoTable.clear();
        }
        if (uuid_InfoTable != null && uuid_InfoTable.size() != 0) {
            uuid_InfoTable.clear();
        }
        if (className_InfoTable != null && className_InfoTable.size() != 0) {
            className_InfoTable.clear();
        }
        if (classFullName_InfoTable != null && classFullName_InfoTable.size() != 0) {
            classFullName_InfoTable.clear();
        }
        if (supplier_LinkTable != null && supplier_LinkTable.size() != 0) {
            supplier_LinkTable.clear();
        }
        if (QUID_IdTable != null && QUID_IdTable.size() != 0) {
            QUID_IdTable.clear();
        }
        if (className_IdTable != null && className_IdTable.size() != 0) {
            className_IdTable.clear();
        }
        if (classFullName_IdTable != null && classFullName_IdTable.size() != 0) {
            classFullName_IdTable.clear();
        }
        if (Generalization_SuperTypeTable != null && Generalization_SuperTypeTable.size() != 0) {
            Generalization_SuperTypeTable.clear();
        }
        if (Dependency_SupplierTable != null && Dependency_SupplierTable.size() != 0) {
            Dependency_SupplierTable.clear();
        }
        if (Role_AETypeTable != null && Role_AETypeTable.size() != 0) {
            Role_AETypeTable.clear();
        }
        if (Realization_SupplierTable != null && Realization_SupplierTable.size() != 0) {
            Realization_SupplierTable.clear();
        }
        if (ClassId_RealizationTable != null && ClassId_RealizationTable.size() != 0) {
            ClassId_RealizationTable.clear();
        }
        if (Presentation_ModelElementTable != null && Presentation_ModelElementTable.size() != 0) {
            Presentation_ModelElementTable.clear();
        }
        this.zipOutputStream = null;
        xmiDir = null;
        progressListener = null;
        propertyChangeListener = null;
        if (bForCB) {
            OBProjectDirs = "";
            OBXMIFileVector = new Vector();
            if (IDLForPkgTable != null && IDLForPkgTable.size() != 0) {
                IDLForPkgTable.clear();
            }
            if (IDLForClsTable != null && IDLForClsTable.size() != 0) {
                IDLForClsTable.clear();
            }
            if (DDLForAttrTable != null && DDLForAttrTable.size() != 0) {
                DDLForAttrTable.clear();
            }
            if (IDLForAttrTable != null && IDLForAttrTable.size() != 0) {
                IDLForAttrTable.clear();
            }
            if (IDLForOprTable != null && IDLForOprTable.size() != 0) {
                IDLForOprTable.clear();
            }
            if (IDLForAETable != null && IDLForAETable.size() != 0) {
                IDLForAETable.clear();
            }
        }
        withJDK116 = false;
        bCheckConsole = false;
    }

    public void roseLoadInit() {
        if (umlForRoseLoad == null) {
            umlForRoseLoad = new UML();
        }
        modelId = null;
        unitTree = null;
        quid_InfoTable = new Hashtable();
        uuid_InfoTable = new Hashtable();
        className_InfoTable = new Hashtable();
        classFullName_InfoTable = new Hashtable();
        supplier_LinkTable = new Hashtable();
        QUID_IdTable = new Hashtable();
        className_IdTable = new Hashtable();
        classFullName_IdTable = new Hashtable();
        Generalization_SuperTypeTable = new Hashtable();
        Dependency_SupplierTable = new Hashtable();
        Role_AETypeTable = new Hashtable();
        Realization_SupplierTable = new Hashtable();
        ClassId_RealizationTable = new Hashtable();
        Presentation_ModelElementTable = new Hashtable();
        genPkgTable = new Hashtable();
        RoseUtil.initGenPkgTable();
        bLogicalViewOnly = true;
        bNoPresentation = false;
        bNoExtension = false;
        bNoPkg = false;
        bNoIDLPkg = false;
        bSetXMIFILETag = true;
        if (bForCB) {
            OBProjectDirs = "";
            OBXMIFileVector = new Vector();
            if (IDLForPkgTable == null) {
                IDLForPkgTable = new Hashtable();
            }
            if (IDLForClsTable == null) {
                IDLForClsTable = new Hashtable();
            }
            if (DDLForAttrTable == null) {
                DDLForAttrTable = new Hashtable();
            }
            if (IDLForAttrTable == null) {
                IDLForAttrTable = new Hashtable();
            }
            if (IDLForOprTable == null) {
                IDLForOprTable = new Hashtable();
            }
            if (IDLForAETable == null) {
                IDLForAETable = new Hashtable();
            }
        }
        withJDK116 = false;
    }

    public void rSave(String string, Id id, String string2) {
        this.setRoseSaveOptions(string2);
        try {
            if (propertyChangeListener != null) {
                RoseSave.propertyChangeListener = propertyChangeListener;
                RoseSave.lower = 0;
                RoseSave.upper = 100;
            }
            if (debug) {
                System.out.println("saving to rose file: " + string);
            }
            RoseSave roseSave = new RoseSave(id, string, true);
            roseSave.cleanUp();
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, null);
        }
    }

    public void saveAsXMIFile(Id id, String string) {
        if (debug) {
            System.out.println("==== Save xmi file to directory " + string);
        }
        try {
            if (progressListener != null) {
                progressListener.setLower(this.indicatorLowerNum);
                progressListener.setUpper(this.indicatorLowerNum + this.incrementNum);
                this.indicatorLowerNum = progressListener.getUpper();
            }
            if (this.bNoDTD) {
                if (this.headerInfo != null && !this.headerInfo.equals("")) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement("XMI.notice");
                    vector.addElement(this.headerInfo);
                    id.save(string, 4, new Vector(), vector);
                } else {
                    id.save(string, 4);
                }
            } else if (this.headerInfo != null && !this.headerInfo.equals("")) {
                Vector<String> vector = new Vector<String>();
                vector.addElement("XMI.notice");
                vector.addElement(this.headerInfo);
                id.save(string, 1, new Vector(), vector);
            } else {
                id.save(string, 1);
            }
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, null);
        }
    }

    public void saveAsXMIFile(Id id, ZipOutputStream zipOutputStream) {
        if (debug && this.xmiZipFile != null && !this.xmiZipFile.equals("")) {
            System.out.println("==== Save to zip file" + this.xmiZipFile);
        }
        try {
            if (progressListener != null) {
                progressListener.setLower(this.indicatorLowerNum);
                progressListener.setUpper(this.indicatorLowerNum + this.incrementNum);
                this.indicatorLowerNum = progressListener.getUpper();
            }
            if (this.bNoDTD) {
                if (this.headerInfo != null && !this.headerInfo.equals("")) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement("XMI.notice");
                    vector.addElement(this.headerInfo);
                    id.save(zipOutputStream, 4, new Vector(), vector);
                } else {
                    id.save(zipOutputStream, 4, new Vector());
                }
            } else if (this.headerInfo != null && !this.headerInfo.equals("")) {
                Vector<String> vector = new Vector<String>();
                vector.addElement("XMI.notice");
                vector.addElement(this.headerInfo);
                id.save(zipOutputStream, 1, new Vector(), vector);
            } else {
                id.save(zipOutputStream, 1, new Vector());
            }
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, null);
        }
    }

    public void saveUMLFilePathToFile(String string) {
        String string2 = string + File.separator + "xmi" + File.separator + "umlfilepath.dat";
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
            bufferedWriter.write(OBProjectDirs);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, exception + " on file " + string2);
        }
    }

    public void setCatAsXML(boolean bl) {
        bCatAsXML = bl;
    }

    public void setCopyRightHeaderInfo(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (this.headerInfo == null) {
                    this.headerInfo = string2 + "\n";
                    continue;
                }
                this.headerInfo = this.headerInfo + string2 + "\n";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            RoseUtil.handleException(exception, exception + " thrown when reading file " + string);
        }
    }

    public void setDebug(boolean bl) {
        if (bl) {
            System.out.println("debug mode is on");
        }
        debug = bl;
    }

    public void setDefaultXML(boolean bl) {
        bDefaultXML = bl;
    }

    public void setDoMerge(boolean bl) {
        this.doMerge = bl;
    }

    public static void setGeneratedPackageName(String string) {
        generatedPackageName = string;
    }

    public void setInXmiDir(boolean bl) {
        bInXmiDir = bl;
    }

    public void setLogicalViewOnly(boolean bl) {
        bLogicalViewOnly = bl;
    }

    public void setLower(int n) {
        this.iLower = n;
    }

    public void setModelPath(String string) {
        this.filePathForUMLLoad = string;
    }

    public void setModelXML(boolean bl) {
        bModelXML = bl;
    }

    public static void setNamespaceUUID(boolean bl) {
        bNamespaceUUID = bl;
    }

    public void setNoDTD(boolean bl) {
        this.bNoDTD = bl;
    }

    public void setNoExtension(boolean bl) {
        bNoExtension = bl;
    }

    public void setNoIDLDataTypePackage(boolean bl) {
        bNoIDLPkg = bl;
    }

    public void setNoPackage(boolean bl) {
        bNoPkg = bl;
    }

    public void setNoUI(boolean bl) {
        bNoPresentation = bl;
    }

    public void setProgressListener(ProgressListener progressListener) {
        RoseUtil.progressListener = progressListener;
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        RoseUtil.propertyChangeListener = propertyChangeListener;
    }

    public void setRoseInputFile(String string) {
        this.inputFile = string;
    }

    public void setRoseLoadOptions(String string, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.setRoseInputFile(string);
        if (this.bUpdateRose && bl) {
            bl = false;
        }
        this.setLogicalViewOnly(bl);
        this.setNoUI(bl2);
        this.setNoExtension(bl3);
        this.setNoIDLDataTypePackage(bl4);
        this.setNoPackage(bl5);
        this.storeRoseVirtualSymbol(string2);
    }

    public void setRoseOutputFile(String string) {
        this.outputFile = string;
    }

    public void setRoseSaveOptions(String string) {
        this.storeRoseVirtualSymbol(string);
    }

    public void setRoseUpdate(boolean bl) {
        this.bUpdateRose = bl;
    }

    public void setUMLFilePath(UML uML, String string) {
        uML.setFilePath(string);
    }

    public void setUpper(int n) {
        this.iUpper = n;
    }

    public void setValidate(boolean bl) {
        this.bValidate = bl;
    }

    public void setXMIFileDirectory(String string) {
        File file;
        xmiDir = string;
        if (xmiDir != null && !xmiDir.equals("") && !(file = new File(xmiDir)).exists()) {
            file.mkdirs();
        }
    }

    public void setXMIZipFileName(String string) {
        this.xmiZipFile = string;
        if (this.xmiZipFile != null && !this.xmiZipFile.equals("")) {
            Object object;
            Object object2;
            File file = new File(this.xmiZipFile);
            if (file.exists()) {
                int n = this.xmiZipFile.lastIndexOf(".");
                this.oldXmiZipFile = n != -1 ? this.xmiZipFile.substring(0, n) + "_old" + this.xmiZipFile.substring(n, this.xmiZipFile.length()) : this.xmiZipFile + "_old";
                object2 = new File(this.oldXmiZipFile);
                if (((File)object2).exists()) {
                    ((File)object2).delete();
                }
                file.renameTo((File)object2);
            }
            String string2 = System.getProperty("file.separator");
            object2 = null;
            String string3 = "";
            int n = this.xmiZipFile.lastIndexOf(string2);
            if (n != -1) {
                object2 = this.xmiZipFile.substring(0, n);
                if (((String)object2).equals(".")) {
                    object2 = null;
                } else {
                    object = new File((String)object2);
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                }
                string3 = this.xmiZipFile.substring(n + 1, this.xmiZipFile.length());
            } else {
                string3 = this.xmiZipFile;
            }
            try {
                object = new FileOutputStream(new File((String)object2, string3));
                this.zipOutputStream = new ZipOutputStream((OutputStream)object);
            }
            catch (Exception exception) {
                RoseUtil.handleException(exception, exception + " thrown when try to open " + this.xmiZipFile);
            }
        }
    }

    private void showRoseUnitTreeAndTableInfo() {
        Object object;
        String string;
        this.numOfRoseFile = 0;
        this.indicatorLowerNum = this.iLower;
        if (unitTree != null) {
            this.numOfRoseFile = 1;
            if (debug) {
                System.out.println(" ");
                System.out.println("======= Unit Tree Info =============");
                System.out.println("[0]: " + unitTree.getName() + ",   " + unitTree.getQUID() + ", " + unitTree.getFileName() + ",\t" + unitTree.getFileNodeName());
            }
            int n = 1;
            this.traverseOut(unitTree, n);
            this.incrementNum = (this.iUpper - this.iLower) / (this.numOfRoseFile * 2);
        }
        if (debug) {
            System.out.println(" ");
        }
        if (debug && quid_InfoTable.size() != 0) {
            System.out.println("======= Table Info: " + quid_InfoTable.size() + " =================");
            Enumeration enumeration = quid_InfoTable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = (TableObject)quid_InfoTable.get(string);
                System.out.println(string + ",  " + ((TableObject)object).getName() + ",    " + ((TableObject)object).getXMIBaseFileName() + ",  " + ((TableObject)object).getXMIFileName() + ",\t" + ((TableObject)object).getUUID() + ", " + ((TableObject)object).getType().toString() + ", " + ((TableObject)object).getParentUUID() + ",  " + ((TableObject)object).getUnit());
            }
            System.out.println(" ");
        }
        if (debug) {
            System.out.println(" ");
        }
        if (debug && supplier_LinkTable.size() != 0) {
            System.out.println("======= Supplier-Link Table: " + supplier_LinkTable.size() + " =================");
            Enumeration enumeration = supplier_LinkTable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = (Vector)supplier_LinkTable.get(string);
                if (((Vector)object).size() <= 0) continue;
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    System.out.println(string + ", " + (String)((Vector)object).elementAt(i));
                }
            }
            System.out.println(" ");
        }
        if (debug && bForCB) {
            if (IDLForPkgTable.size() != 0) {
                System.out.println("===== Package default propertes =====");
                Enumeration enumeration = IDLForPkgTable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (String)IDLForPkgTable.get(string);
                    System.out.println(string + ",\t" + (String)object);
                }
                System.out.println(" ");
            }
            if (IDLForClsTable.size() != 0) {
                System.out.println("===== Class default propertes =====");
                Enumeration enumeration = IDLForClsTable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (String)IDLForClsTable.get(string);
                    System.out.println(string + ",\t" + (String)object);
                }
                System.out.println(" ");
            }
            if (IDLForAttrTable.size() != 0 || DDLForAttrTable.size() != 0) {
                System.out.println("===== Attribute default propertes =====");
                Enumeration enumeration = IDLForAttrTable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (String)IDLForAttrTable.get(string);
                    System.out.println(string + ",\t" + (String)object);
                }
                enumeration = DDLForAttrTable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (String)DDLForAttrTable.get(string);
                    System.out.println(string + ",\t" + (String)object);
                }
                System.out.println(" ");
            }
            if (IDLForOprTable.size() != 0) {
                System.out.println("===== Operation default propertes =====");
                Enumeration enumeration = IDLForOprTable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (String)IDLForOprTable.get(string);
                    System.out.println(string + ",\t" + (String)object);
                }
                System.out.println(" ");
            }
            if (IDLForAETable.size() != 0) {
                System.out.println("===== Role default propertes =====");
                Enumeration enumeration = IDLForAETable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (String)IDLForAETable.get(string);
                    System.out.println(string + ",\t" + (String)object);
                }
                System.out.println(" ");
            }
        }
    }

    private static void storeDDLAttrDefaultProperties(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithValue("Attribute_Set");
        if (roseNode2 != null) {
            Vector vector = roseNode2.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3;
                RoseNode roseNode4 = (RoseNode)vector.elementAt(i);
                if (roseNode4.getType() != 2 || !roseNode4.getValue().equals("Attribute")) continue;
                RoseNode roseNode5 = roseNode4.findNodeWithKey("name");
                String string = "";
                if (roseNode5 == null || roseNode5.getType() != 0) continue;
                string = roseNode5.getValue();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                if (string == null || !string.equals("PrimaryKey") && !string.equals("IsIncludedInCopyHelper") && !string.equals("IsIncludedInDataObject") || (roseNode3 = roseNode4.findNodeWithKey("value")) == null) continue;
                DDLForAttrTable.put(string, roseNode3.getValue());
            }
        }
    }

    private static void storeIDLAEDefaultProperties(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithValue("Attribute_Set");
        if (roseNode2 != null) {
            Vector vector = roseNode2.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3;
                RoseNode roseNode4 = (RoseNode)vector.elementAt(i);
                if (roseNode4.getType() != 2 || !roseNode4.getValue().equals("Attribute")) continue;
                RoseNode roseNode5 = roseNode4.findNodeWithKey("name");
                String string = "";
                if (roseNode5 == null || roseNode5.getType() != 0) continue;
                string = roseNode5.getValue();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                if (string == null || !string.equals("MapAsObjectRelationShip") && !string.equals("IsReadOnly") && !string.equals("RelationshipImplementation") || (roseNode3 = roseNode4.findNodeWithKey("value")) == null) continue;
                IDLForAETable.put(string, roseNode3.getValue());
            }
        }
    }

    private static void storeIDLAttrDefaultProperties(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithValue("Attribute_Set");
        if (roseNode2 != null) {
            Vector vector = roseNode2.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3;
                RoseNode roseNode4 = (RoseNode)vector.elementAt(i);
                if (roseNode4.getType() != 2 || !roseNode4.getValue().equals("Attribute")) continue;
                RoseNode roseNode5 = roseNode4.findNodeWithKey("name");
                String string = "";
                if (roseNode5 == null || roseNode5.getType() != 0) continue;
                string = roseNode5.getValue();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                if (string == null || !string.equals("IsReadOnly") || (roseNode3 = roseNode4.findNodeWithKey("value")) == null) continue;
                IDLForAttrTable.put(string, roseNode3.getValue());
            }
        }
    }

    private static void storeIDLClsDefaultProperties(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithValue("Attribute_Set");
        if (roseNode2 != null) {
            Vector vector = roseNode2.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3;
                RoseNode roseNode4 = (RoseNode)vector.elementAt(i);
                if (roseNode4.getType() != 2 || !roseNode4.getValue().equals("Attribute")) continue;
                RoseNode roseNode5 = roseNode4.findNodeWithKey("name");
                String string = "";
                if (roseNode5 == null || roseNode5.getType() != 0) continue;
                string = roseNode5.getValue();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                if (string == null || !string.equals("BridgeToOB") && !string.equals("CreateCopyHelper") && !string.equals("CreateKey") && !string.equals("CreateImplementation") && !string.equals("IsQueryable") && !string.equals("IDLSpecificationType") || (roseNode3 = roseNode4.findNodeWithKey("value")) == null) continue;
                IDLForClsTable.put(string, roseNode3.getValue());
            }
        }
    }

    private static void storeIDLOprDefaultProperties(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithValue("Attribute_Set");
        if (roseNode2 != null) {
            Vector vector = roseNode2.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3;
                RoseNode roseNode4 = (RoseNode)vector.elementAt(i);
                if (roseNode4.getType() != 2 || !roseNode4.getValue().equals("Attribute")) continue;
                RoseNode roseNode5 = roseNode4.findNodeWithKey("name");
                String string = "";
                if (roseNode5 == null || roseNode5.getType() != 0) continue;
                string = roseNode5.getValue();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                if (string == null || !string.equals("OperationIsOneWay") || (roseNode3 = roseNode4.findNodeWithKey("value")) == null) continue;
                IDLForOprTable.put(string, roseNode3.getValue());
            }
        }
    }

    private static void storeIDLPkgDefaultProperties(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.findNodeWithValue("Attribute_Set");
        if (roseNode2 != null) {
            Vector vector = roseNode2.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3;
                RoseNode roseNode4 = (RoseNode)vector.elementAt(i);
                if (roseNode4.getType() != 2 || !roseNode4.getValue().equals("Attribute")) continue;
                RoseNode roseNode5 = roseNode4.findNodeWithKey("name");
                String string = "";
                if (roseNode5 == null || roseNode5.getType() != 0) continue;
                string = roseNode5.getValue();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                if (string == null || !string.equals("BridgeToOB") || (roseNode3 = roseNode4.findNodeWithKey("value")) == null) continue;
                IDLForPkgTable.put(string, roseNode3.getValue());
            }
        }
    }

    public void storeRoseVirtualSymbol(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1, string2.length());
                Util.putIntoExternalFiles(string3, string4);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("Rosepath syntax is a=b,c=d");
            throw stringIndexOutOfBoundsException;
        }
    }

    private void traverseOut(UnitTreeNode unitTreeNode, int n) {
        Vector vector = unitTreeNode.getNodes();
        if (vector.size() > 0) {
            this.numOfRoseFile += vector.size();
            for (int i = 0; i < vector.size(); ++i) {
                UnitTreeNode unitTreeNode2 = (UnitTreeNode)vector.elementAt(i);
                if (debug) {
                    System.out.println("[" + n + "]: " + unitTreeNode2.getName() + ",  " + unitTreeNode2.getQUID() + ", " + unitTreeNode2.getFileName() + ",\t" + unitTreeNode2.getFileNodeName());
                }
                this.traverseOut(unitTreeNode2, n + 1);
            }
        }
    }

    public void visitVersionTree(Id id, RoseNode roseNode) {
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            if (roseNode2.getType() != 0) continue;
            ModelElements.set(id, "RosePetal", roseNode2.getKey(), roseNode2.getValue());
        }
    }

    public void xLoadAndrSave(String string, String string2, String string3) {
        Object object;
        Object object2;
        Object object3;
        if (debug) {
            object3 = new Date();
            System.out.println("Begin loading: " + ((Date)object3).toString());
        }
        this.setRoseSaveOptions(string3);
        object3 = new UML();
        Vector vector = new Vector();
        boolean bl = false;
        if (pkgUUID_QUIDTable == null) {
            pkgUUID_QUIDTable = new Hashtable();
        } else if (pkgUUID_QUIDTable.size() != 0) {
            pkgUUID_QUIDTable.clear();
        }
        File file = new File(string);
        try {
            string = file.getCanonicalPath();
            file = new File(string);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                vector = this.getFilesFromDirectory(string, file, false);
            } else if (file.isFile()) {
                try {
                    object2 = new ZipFile(file);
                    object = ((ZipFile)object2).entries();
                    if (object.hasMoreElements()) {
                        while (object.hasMoreElements()) {
                            ZipEntry zipEntry = object.nextElement();
                            vector.addElement(zipEntry.getName());
                        }
                    }
                    bl = true;
                    ((ZipFile)object2).close();
                }
                catch (ZipException zipException) {
                    vector.addElement(string);
                }
                catch (Exception exception) {
                    RoseUtil.handleException(exception, exception + " for file " + string);
                }
            }
        } else {
            vector.addElement(string);
        }
        if (vector.size() != 0) {
            Object object4;
            Object object5;
            String string4;
            this.numOfXMIFile = vector.size();
            this.indicatorLowerNum = this.iLower;
            this.incrementNum = (this.iUpper - this.iLower) / (this.numOfXMIFile * 3);
            if (this.filePathForUMLLoad != null && !this.filePathForUMLLoad.equals("")) {
                this.setUMLFilePath((UML)object3, this.filePathForUMLLoad);
            }
            object2 = "";
            object = null;
            if (bl) {
                int n = string.lastIndexOf(".");
                object2 = n != -1 ? string.substring(0, n) + "_temp" + string.substring(n, string.length()) : string + "_temp";
                try {
                    string4 = "";
                    object5 = "";
                    n = ((String)object2).lastIndexOf(File.separator);
                    if (n != -1) {
                        string4 = ((String)object2).substring(0, n);
                        object5 = ((String)object2).substring(n + 1, ((String)object2).length());
                    } else {
                        object5 = object2;
                    }
                    object4 = new FileOutputStream(new File(string4, (String)object5));
                    object = new ZipOutputStream((OutputStream)object4);
                }
                catch (Exception exception) {
                    RoseUtil.handleException(exception, exception + " thrown when try to open " + (String)object2);
                }
            }
            for (int i = 0; i < vector.size(); ++i) {
                string4 = (String)vector.elementAt(i);
                object5 = this.loadXMIFile((UML)object3, string4);
                if (object5 == null) continue;
                try {
                    Object object6;
                    if (debug) {
                        RoseSave.debug = debug;
                    }
                    if (propertyChangeListener != null) {
                        RoseSave.propertyChangeListener = propertyChangeListener;
                        RoseSave.lower = this.indicatorLowerNum;
                        RoseSave.upper = this.indicatorLowerNum + this.incrementNum;
                        this.indicatorLowerNum += this.incrementNum;
                    }
                    object4 = ModelElements.get((Id)object5, "Rose", "file_name");
                    if (((Id)object5).getType() == Type.MODEL) {
                        if (string2 != null && !string2.equals("")) {
                            if (debug) {
                                System.out.println("saving to rose file: " + string2);
                            }
                            object6 = new RoseSave((Id)object5, string2);
                            ((RoseSave)object6).cleanUp();
                        } else if (object4 != null) {
                            if (debug) {
                                System.out.println("saving to rose file: " + (String)object4);
                            }
                            object6 = new RoseSave((Id)object5, (String)object4);
                            ((RoseSave)object6).cleanUp();
                        }
                    } else if (object4 != null) {
                        int n;
                        object6 = "\\";
                        String string5 = "/";
                        object4 = ((String)object4).replace(((String)object6).charAt(0), File.separatorChar);
                        if (((String)(object4 = ((String)object4).replace(string5.charAt(0), File.separatorChar))).indexOf("$") != -1) {
                            object4 = Util.resolveFileName((String)object4);
                        } else if (((String)object4).startsWith("\"") && ((String)object4).endsWith("\"")) {
                            object4 = ((String)object4).substring(1, ((String)object4).length() - 1);
                        }
                        String string6 = System.getProperty("file.separator");
                        while ((n = ((String)object4).indexOf(string6 + string6)) != -1) {
                            object4 = ((String)object4).substring(0, n + 1) + ((String)object4).substring(n + 2, ((String)object4).length());
                        }
                        if (debug) {
                            System.out.println("saving to rose file: " + (String)object4);
                        }
                        RoseSave roseSave = new RoseSave((Id)object5, (String)object4);
                        roseSave.cleanUp();
                    }
                    if (bl && object != null) {
                        this.saveAsXMIFile((Id)object5, (ZipOutputStream)object);
                    }
                }
                catch (Exception exception) {
                    RoseUtil.handleException(exception, null);
                }
                this.cleanUp((UML)object3, false);
            }
            if (object != null) {
                try {
                    ((ZipOutputStream)object).close();
                }
                catch (Exception exception) {
                    RoseUtil.handleException(exception, null);
                }
                File file2 = new File((String)object2);
                if (file2.exists()) {
                    if (file.exists()) {
                        file.delete();
                    }
                    file2.renameTo(file);
                }
            }
        }
        if (debug) {
            object2 = new Date();
            System.out.println("End loading: " + ((Date)object2).toString());
        }
    }

    static {
        debug = System.getProperty("debug") != null;
        bNamespaceUUID = false;
        generatedPackageName = null;
        xmiFileName_Table = null;
        bDefaultXML = false;
        bCatAsXML = false;
        bInXmiDir = false;
        bModelXML = false;
        bCheckConsole = false;
    }
}

