/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.rb30;

import com.ibm.psh.rb30.ModelElements;
import com.ibm.psh.rb30.ResourceUtil;
import com.ibm.psh.rb30.RoseUtil;
import com.ibm.psh.roseparser.RoseComponent;
import com.ibm.psh.roseparser.RoseNode;
import com.ibm.psh.roseparser.RoseWriter;
import com.ibm.psh.roseparser.Util;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class RoseSave {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Id rootId;
    private RoseNode versionTree = null;
    private RoseNode modelTree = null;
    public static boolean debug;
    public static PropertyChangeListener propertyChangeListener;
    public static int lower;
    public static int upper;
    private static long quidnum;
    private static Hashtable String_QUIDTable;
    public boolean bCreateCatFile;
    public boolean withJDK116;
    private int numOfView = 0;
    private Hashtable quid_ViewIdTable = new Hashtable();

    public RoseSave(Id id, String string) throws Exception {
        this(id, string, false);
    }

    public RoseSave(Id id, String string, boolean bl) throws Exception {
        Object object;
        File file;
        int n;
        Date date = new Date();
        quidnum = date.getTime();
        this.bCreateCatFile = bl;
        this.rootId = id;
        RoseNode.counter = 0;
        this.buildTree(this.rootId);
        this.modelTree.localCounter = RoseNode.counter;
        if (debug) {
            System.out.println("write to output file: " + string);
        }
        if ((n = string.lastIndexOf(System.getProperty("file.separator"))) != -1 && !(file = new File((String)(object = string.substring(0, n)))).exists()) {
            file.mkdirs();
        }
        object = new RoseWriter(string, this.versionTree, this.modelTree);
        if (propertyChangeListener != null) {
            ((RoseComponent)object).addPropertyChangeListener(propertyChangeListener);
            ((RoseWriter)object).setLower(lower);
            ((RoseWriter)object).setUpper(upper);
        }
        ((RoseWriter)object).write();
    }

    private String buildAggregationProperty(Id id, RoseNode roseNode, Vector vector) {
        String string = ModelElements.get(id, Property.AGGREGATION);
        String string2 = ModelElements.get(id, "Rose", "Containment");
        RoseNode roseNode2 = null;
        RoseNode roseNode3 = null;
        String string3 = null;
        if (string != null) {
            if (debug) {
                System.out.println("===== buildAggregationProperty");
            }
            if (string.equals("none")) {
                if (string2 != null) {
                    roseNode2 = new RoseNode("Containment", string2, 0);
                }
            } else if (string.equals("shared")) {
                roseNode3 = new RoseNode("is_aggregate", "TRUE", 0);
                if (string2 != null) {
                    roseNode2 = new RoseNode("Containment", string2, 0);
                }
            } else if (string.equals("composite")) {
                roseNode3 = new RoseNode("is_aggregate", "TRUE", 0);
                vector.removeElement(roseNode);
                string3 = "\"By Value\"";
                if (string2 != null) {
                    roseNode2 = new RoseNode("Containment", string2, 0);
                }
            }
            if (roseNode3 != null) {
                roseNode.addNode(roseNode3, false);
            }
            if (roseNode2 != null) {
                roseNode.addNode(roseNode2, false);
            }
            if (debug) {
                System.out.println("===== End buildAggregationProperty");
            }
        }
        return string3;
    }

    private void buildAssociationEnds(Id id, RoseNode roseNode) {
        RoseNode roseNode2;
        Vector<RoseNode> vector = new Vector<RoseNode>();
        String string = "";
        Vector vector2 = ModelElements.get(id, Type.ASSOCIATION_END, false);
        if (vector2 != null && vector2.size() == 2) {
            if (debug) {
                System.out.println("===== buildAssociationEnds");
            }
            roseNode2 = new RoseNode("roles", "role_list", 3);
            roseNode.addNode(roseNode2, false);
            for (int i = 0; i < vector2.size(); ++i) {
                Id id2 = (Id)vector2.elementAt(i);
                RoseNode roseNode3 = new RoseNode("", "Role \"" + ModelElements.get(id2, Property.NAME) + "\"", 2);
                roseNode2.addNode(roseNode3, false);
                vector.addElement(roseNode3);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode3);
                String string2 = this.buildAggregationProperty(id2, roseNode3, vector);
                if (string2 != null) {
                    string = string2;
                }
                this.buildRoseProperties(id2, roseNode3);
                Vector vector3 = ModelElements.get(id2, Link.AE_TYPE, false);
                if (vector3 != null && vector3.size() == 1) {
                    Id id3 = (Id)vector3.elementAt(0);
                    if (debug) {
                        System.out.println("create supplier rosenode to " + ModelElements.get(id2, Property.NAME));
                    }
                    RoseNode roseNode4 = new RoseNode("supplier", "\"" + ModelElements.getRoseSupplierName(id3) + "\"", 0);
                    RoseSave.getQUID(id3);
                    RoseNode roseNode5 = new RoseNode("quidu", "\"" + ModelElements.get(id3, "Rose", "quid") + "\"", 0);
                    roseNode3.addNode(roseNode4, false);
                    roseNode3.addNode(roseNode5, false);
                }
                this.buildAttributeListProperties(id2, roseNode3);
                this.buildAttributes(id2, roseNode3);
            }
            if (debug) {
                System.out.println("===== End buildAssociationEnds");
            }
        }
        if (vector.size() == 1) {
            roseNode2 = (RoseNode)vector.elementAt(0);
            RoseNode roseNode6 = roseNode2.findNodeWithKey("Containment");
            if (!string.equals("")) {
                if (roseNode6 == null) {
                    roseNode6 = new RoseNode("Containment", string, 0);
                    roseNode2.addNode(roseNode6, false);
                } else {
                    roseNode6.setValue(string);
                }
            } else if (roseNode6 != null) {
                roseNode2.deleteNode(roseNode6);
            }
        }
    }

    private void buildAssociations(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.ASSOCIATION, false);
        if (vector != null) {
            if (debug) {
                System.out.println("===== buildAssociations");
            }
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                RoseNode roseNode2 = new RoseNode("", "Association \"" + ModelElements.get(id2, Property.NAME) + "\"", 2);
                roseNode.addNode(roseNode2, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode2);
                this.buildRoseProperties(id2, roseNode2);
                this.buildStereoTypeProperty(id2, roseNode2);
                this.buildAttributeListProperties(id2, roseNode2);
                this.buildAssociationEnds(id2, roseNode2);
            }
            if (debug) {
                System.out.println("===== End buildAssociations");
            }
        }
    }

    private void buildAttributeListProperties(Id id, RoseNode roseNode) {
        boolean bl = false;
        Vector vector = ModelElements.getSets(id);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2;
                String string = (String)vector.elementAt(i);
                if (!string.equals("IDL") && !string.equals("DDL") && !string.equals("Java") && !string.equals("C++") && !string.equals("CORBA") && !string.equals("Oracle8") && !string.equals("COM") && !string.equals("MSVC") && !string.equals("Visual Basic") || (vector2 = ModelElements.getTags(id, string)) == null) continue;
                RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
                if (roseNode2 == null) {
                    roseNode2 = new RoseNode("attributes", "Attribute_Set", 3);
                    roseNode.addNode(roseNode2, false);
                }
                for (int j = 0; j < vector2.size(); ++j) {
                    String string2 = (String)vector2.elementAt(j);
                    String string3 = ModelElements.get(id, string, string2);
                    if (!string.equals("Java") || !string2.equals("WithJDK116")) {
                        RoseNode roseNode3 = new RoseNode("", "Attribute", 2);
                        roseNode2.addNode(roseNode3, false);
                        RoseNode roseNode4 = new RoseNode("tool", "\"" + string + "\"", 0);
                        RoseNode roseNode5 = new RoseNode("name", "\"" + string2 + "\"", 0);
                        RoseNode roseNode6 = null;
                        if (!(string3.equals("TRUE") || string3.equals("true") || string3.equals("FALSE") || string3.equals("false") || string3.startsWith("(") || string3.endsWith(")"))) {
                            roseNode6 = new RoseNode("value", "Text", 4);
                            RoseNode roseNode7 = new RoseNode("", "\"" + string3 + "\"", 0);
                            roseNode6.addNode(roseNode7, false);
                        } else {
                            roseNode6 = new RoseNode("value", string3, 0);
                        }
                        if (roseNode4 != null && roseNode5 != null && roseNode6 != null) {
                            roseNode3.addNode(roseNode4, false);
                            roseNode3.addNode(roseNode5, false);
                            roseNode3.addNode(roseNode6, false);
                        }
                    }
                    if (!string.equals("IDL") || !string2.equals("uuid")) continue;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.buildUUIDProperty(id, roseNode);
        }
        this.buildJavaStaticProperty(id, roseNode);
    }

    private void buildAttributes(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.ATTRIBUTE, false);
        if (vector != null) {
            String string = "";
            if (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE) {
                string = "class_attributes";
            } else if (id.getType() == Type.ASSOCIATION_END) {
                string = "keys";
            }
            RoseNode roseNode2 = new RoseNode(string, "class_attribute_list", 3);
            roseNode.addNode(roseNode2, false);
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string2 = ModelElements.get(id2, Property.NAME);
                if (string2 == null) continue;
                if (debug) {
                    System.out.println("===== buildAttributes: " + string2);
                }
                RoseNode roseNode3 = new RoseNode("", "ClassAttribute \"" + string2 + "\"", 2);
                roseNode2.addNode(roseNode3, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode3);
                this.buildRoseProperties(id2, roseNode3);
                this.buildStereoTypeProperty(id2, roseNode3);
                if (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE) {
                    this.buildAttributeListProperties(id2, roseNode3);
                }
                if (!debug) continue;
                System.out.println("===== End buildAttributes");
            }
        }
    }

    private void buildClasses(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.CLASS, false);
        if (vector != null) {
            RoseNode roseNode2 = roseNode;
            if (vector.size() > 0 && (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE)) {
                RoseNode roseNode3 = roseNode.findNodeWithKey("nestedClasses");
                if (roseNode3 == null) {
                    roseNode3 = new RoseNode("nestedClasses", "nestedClasses", 3);
                    roseNode.addNode(roseNode3, false);
                }
                roseNode2 = roseNode3;
            }
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string = ModelElements.get(id2, Property.NAME);
                if (string == null) continue;
                if (debug) {
                    System.out.println("===== Build class: " + string);
                }
                RoseNode roseNode4 = new RoseNode("", "Class \"" + string + "\"", 2);
                roseNode2.addNode(roseNode4, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode4);
                this.buildRoseProperties(id2, roseNode4);
                this.buildStereoTypeProperty(id2, roseNode4);
                this.buildAttributeListProperties(id2, roseNode4);
                this.buildAttributes(id2, roseNode4);
                this.buildOperations(id2, roseNode4);
                this.buildUsesRelationship(id2, roseNode4);
                this.buildInheritanceRelationship(id2, roseNode4);
                this.buildRealizeRelationship(id2, roseNode4);
                this.buildClasses(id2, roseNode4);
                this.buildInterfaces(id2, roseNode4);
                this.buildPrimitives(id2, roseNode4);
                this.buildEnumerations(id2, roseNode4);
                this.buildStructures(id2, roseNode4);
                if (!debug) continue;
                System.out.println("===== End build class");
            }
        }
    }

    private boolean buildClientSupplierProperties(Id id, RoseNode roseNode) {
        Object object;
        Object object2;
        boolean bl;
        String string;
        String string2;
        block17: {
            block16: {
                String string3;
                Object object3;
                Object object4;
                block19: {
                    String string4;
                    Object object5;
                    Object object6;
                    block18: {
                        String string5;
                        Object object7;
                        Object object8;
                        string2 = "";
                        string = "";
                        bl = false;
                        if (id.getType() != Type.PRESENTATION) break block16;
                        object2 = ModelElements.get(id, Link.P_MODEL, false);
                        if (object2 == null || ((Vector)object2).size() != 1) break block17;
                        object = (Id)((Vector)object2).elementAt(0);
                        if (((Id)object).getType() != Type.ASSOCIATION_END) break block18;
                        bl = true;
                        Vector vector = ModelElements.get((Id)object, Link.AE_TYPE, false);
                        if (vector != null && vector.size() == 1 && (object8 = ModelElements.get((Id)(object7 = (Id)vector.elementAt(0)), "Rose", "quid")) != null) {
                            string2 = (String)this.quid_ViewIdTable.get(object8);
                        }
                        if ((object7 = ModelElements.get((Id)object, Link.AE_ASSOCIATION, false)) == null || ((Vector)object7).size() != 1 || (string5 = ModelElements.get((Id)(object8 = (Id)((Vector)object7).elementAt(0)), "Rose", "quid")) == null) break block17;
                        string = (String)this.quid_ViewIdTable.get(string5);
                        break block17;
                    }
                    if (((Id)object).getType() != Type.DEPENDENCY) break block19;
                    bl = true;
                    Vector vector = ModelElements.get((Id)object, Link.SUPPLIER, false);
                    if (vector != null && vector.size() == 1 && (object6 = ModelElements.get((Id)(object5 = (Id)vector.elementAt(0)), "Rose", "quid")) != null) {
                        string2 = (String)this.quid_ViewIdTable.get(object6);
                    }
                    if ((object5 = ModelElements.get((Id)object, Link.CLIENT, false)) == null || ((Vector)object5).size() != 1 || (string4 = ModelElements.get((Id)(object6 = (Id)((Vector)object5).elementAt(0)), "Rose", "quid")) == null) break block17;
                    string = (String)this.quid_ViewIdTable.get(string4);
                    break block17;
                }
                if (((Id)object).getType() != Type.GENERALIZATION) break block17;
                bl = true;
                Vector vector = ModelElements.get((Id)object, Link.SUPERTYPE, false);
                if (vector != null && vector.size() == 1 && (object4 = ModelElements.get((Id)(object3 = (Id)vector.elementAt(0)), "Rose", "quid")) != null) {
                    string2 = (String)this.quid_ViewIdTable.get(object4);
                }
                if ((object3 = ModelElements.get((Id)object, Link.SUBTYPE, false)) != null && ((Vector)object3).size() == 1 && (string3 = ModelElements.get((Id)(object4 = (Id)((Vector)object3).elementAt(0)), "Rose", "quid")) != null) {
                    string = (String)this.quid_ViewIdTable.get(string3);
                }
                break block17;
            }
            if (id.getType() == Type.EXTENSION && ModelElements.get(id, Property.EXTENSION_NAME).equals("Realize_Relationship")) {
                bl = true;
                object2 = ModelElements.get(id, Link.EXTENSION_REFERENCE, false);
                if (object2 != null && ((Vector)object2).size() == 1) {
                    object = (Id)((Vector)object2).elementAt(0);
                    String string6 = ModelElements.get((Id)object, "Rose", "quid");
                    if (string6 != null) {
                        string2 = (String)this.quid_ViewIdTable.get(string6);
                    }
                    Vector vector = ModelElements.get((Id)object, Link.REALIZATION, false);
                    boolean bl2 = false;
                    if (vector != null) {
                        for (int i = 0; i < vector.size(); ++i) {
                            Id id2 = (Id)vector.elementAt(i);
                            Vector<Object> vector2 = new Vector<Object>();
                            vector2.addElement(Property.XMI_EXTENDER);
                            vector2.addElement("Rose");
                            vector2.addElement(Property.XMI_EXTENDER_ID);
                            vector2.addElement("Rose");
                            Vector vector3 = ModelElements.get(id2, Type.XMI_EXTENSION, vector2, false);
                            if (vector3 != null) {
                                for (int j = 0; j < vector3.size(); ++j) {
                                    Id id3 = (Id)vector3.elementAt(j);
                                    Vector<Object> vector4 = new Vector<Object>();
                                    vector4.addElement(Property.EXTENSION_NAME);
                                    vector4.addElement("Realize_Relationship");
                                    Vector vector5 = ModelElements.get(id3, Type.EXTENSION, vector4, false);
                                    if (vector5 != null) {
                                        for (int k = 0; k < vector5.size(); ++k) {
                                            Id id4 = (Id)vector5.elementAt(k);
                                            if (id4 != id) continue;
                                            bl2 = true;
                                            break;
                                        }
                                    }
                                    if (bl2) break;
                                }
                            }
                            if (!bl2) continue;
                            string6 = ModelElements.get(id2, "Rose", "quid");
                            if (string6 == null) break;
                            string = (String)this.quid_ViewIdTable.get(string6);
                            break;
                        }
                    }
                }
            }
        }
        if (!string2.equals("") && !string.equals("")) {
            if (debug) {
                System.out.println("create supplier and client nodes");
            }
            object2 = new RoseNode("supplier", string2, 0);
            roseNode.addNode((RoseNode)object2, false);
            object = new RoseNode("client", string, 0);
            roseNode.addNode((RoseNode)object, false);
            return true;
        }
        if (bl) {
            object2 = roseNode.findNodeWithKey("quidu");
            return false;
        }
        return true;
    }

    private void buildComplicatedProperty(Id id, RoseNode roseNode) {
        if (id.getType() == Type.ATTRIBUTE || id.getType() == Type.PARAMETER) {
            Property property = null;
            property = id.getType() == Type.ATTRIBUTE ? Property.INITIAL_VALUE : Property.DEFAULT_VALUE;
            Vector vector = ModelElements.get(id, property.getLink(), false);
            if (vector != null && vector.size() == 1) {
                int n;
                Id id2 = (Id)vector.elementAt(0);
                String string = ModelElements.get(id2, Property.EXPRESSION_BODY);
                if (debug) {
                    System.out.println("===== buildComplicatedProperty");
                }
                if ((n = string.indexOf("\"")) != -1) {
                    RoseNode roseNode2 = new RoseNode("initv", "", 1);
                    roseNode.addNode(roseNode2, false);
                    RoseNode roseNode3 = new RoseNode("", string, 0);
                    roseNode2.addNode(roseNode3, false);
                } else {
                    RoseNode roseNode4 = new RoseNode("initv", "\"" + string + "\"", 0);
                    roseNode.addNode(roseNode4, false);
                }
                if (debug) {
                    System.out.println("===== End buildComplicatedProperty");
                }
            }
        }
    }

    private void buildComponentView(Id id, RoseNode roseNode) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(Property.EXTENSION_NAME);
        vector.addElement(ResourceUtil.getString("COMPONENT_VIEW"));
        Vector vector2 = ModelElements.get(id, Type.EXTENSION, vector, false);
        if (vector2 != null && vector2.size() == 1) {
            if (debug) {
                System.out.println("===== Build comonent view folder");
            }
            RoseNode roseNode2 = new RoseNode("root_subsystem", "SubSystem \"" + ResourceUtil.getString("COMPONENT_VIEW") + "\"", 2);
            roseNode.addNode(roseNode2, false);
            Id id2 = (Id)vector2.elementAt(0);
            this.buildProperties(id2, roseNode2);
            this.buildRoseProperties(id2, roseNode2);
            if (debug) {
                System.out.println("===== End build comonent view folder");
            }
        }
    }

    private void buildDDLProperties(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.getTags(id, "DDL");
        if (vector != null) {
            RoseNode roseNode2;
            if (debug) {
                System.out.println("===== buildDDLProperties");
            }
            if ((roseNode2 = roseNode.findNodeWithKey("attributes")) == null) {
                roseNode2 = new RoseNode("attributes", "Attribute_Set", 3);
                roseNode.addNode(roseNode2, false);
            }
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode3 = new RoseNode("", "Attribute", 2);
                roseNode2.addNode(roseNode3, false);
                String string = (String)vector.elementAt(i);
                String string2 = ModelElements.get(id, "DDL", string);
                if (!(string2.equals("TRUE") || string2.equals("FALSE") || string2.startsWith("(") || string2.endsWith(")"))) {
                    string2 = "\"" + string2 + "\"";
                }
                if (debug) {
                    System.out.println("Property Attribute: DDL, " + string + ", " + string2);
                }
                RoseNode roseNode4 = new RoseNode("tool", "\"DDL\"", 0);
                RoseNode roseNode5 = new RoseNode("name", "\"" + string + "\"", 0);
                RoseNode roseNode6 = new RoseNode("value", string2, 0);
                roseNode3.addNode(roseNode4, false);
                roseNode3.addNode(roseNode5, false);
                roseNode3.addNode(roseNode6, false);
            }
            if (debug) {
                System.out.println("===== End buildDDLProperties");
            }
        }
    }

    private void buildDefaultProperties(Id id, RoseNode roseNode) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(Property.EXTENSION_NAME);
        vector.addElement("properties");
        Vector vector2 = ModelElements.get(id, Type.EXTENSION, vector, false);
        if (vector2 != null && vector2.size() == 1) {
            if (debug) {
                System.out.println("===== Build model default properties");
            }
            RoseNode roseNode2 = new RoseNode("properties", "Properties", 2);
            roseNode.addNode(roseNode2, false);
            Id id2 = (Id)vector2.elementAt(0);
            this.buildProperties(id2, roseNode2);
            this.buildRoseProperties(id2, roseNode2);
            if (debug) {
                System.out.println("===== End build model default properties");
            }
        }
    }

    private void buildDeploymentView(Id id, RoseNode roseNode) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(Property.EXTENSION_NAME);
        vector.addElement("process_structure");
        Vector vector2 = ModelElements.get(id, Type.EXTENSION, vector, false);
        if (vector2 != null && vector2.size() == 1) {
            RoseNode roseNode2 = new RoseNode("process_structure", "Processes", 2);
            roseNode.addNode(roseNode2, false);
            Id id2 = (Id)vector2.elementAt(0);
            this.buildProperties(id2, roseNode2);
            this.buildRoseProperties(id2, roseNode2);
            RoseNode roseNode3 = new RoseNode("ProcsNDevs", "", 3);
            roseNode2.addNode(roseNode3, false);
            Vector vector3 = ModelElements.get(id2, Type.EXTENSION, false);
            if (vector3 != null && vector3.size() == 1) {
                if (debug) {
                    System.out.println("===== Build deployment view folder");
                }
                RoseNode roseNode4 = new RoseNode("", "Process_Diagram \"Deployment View\"", 2);
                roseNode3.addNode(roseNode4, false);
                Id id3 = (Id)vector3.elementAt(0);
                this.buildProperties(id3, roseNode4);
                this.buildRoseProperties(id3, roseNode4);
                if (debug) {
                    System.out.println("===== End build deployment view folder");
                }
            }
        }
    }

    private void buildDerived(Id id, RoseNode roseNode) {
        String string;
        if (id.getType() == Type.ATTRIBUTE && (string = ModelElements.get(id, "", "derived")) != null && string.equals("TRUE")) {
            if (debug) {
                System.out.println("===== buildDerived");
            }
            RoseNode roseNode2 = new RoseNode("derived", string, 0);
            roseNode.addNode(roseNode2, false);
            if (debug) {
                System.out.println("===== End buildDerived");
            }
        }
    }

    private void buildDocumentation(Id id, RoseNode roseNode) {
        Vector vector;
        Object object;
        Object object2;
        String string = ModelElements.get(id, "", "documentation");
        if (string != null) {
            RoseNode roseNode2;
            int n;
            if (debug) {
                System.out.println("===== buildDocumentation");
            }
            if ((n = string.indexOf("|#")) == -1) {
                if (string.indexOf("\"") == -1) {
                    if (debug) {
                        System.out.println("Documentation String Node: " + string);
                    }
                    object2 = new RoseNode("documentation", "\"" + string + "\"", 0);
                    roseNode.addNode((RoseNode)object2, false);
                } else {
                    if (debug) {
                        System.out.println("Documentation String Seq Node: " + string);
                    }
                    object2 = new RoseNode("documentation", "", 1);
                    roseNode.addNode((RoseNode)object2, false);
                    roseNode2 = new RoseNode("", string, 0);
                    ((RoseNode)object2).addNode(roseNode2, false);
                }
            } else {
                object2 = new RoseNode("documentation", "", 1);
                roseNode.addNode((RoseNode)object2, false);
                roseNode2 = null;
                while (string.length() != 0) {
                    n = string.indexOf("|#");
                    object = "";
                    if (n == -1) {
                        object = string;
                        string = "";
                    } else {
                        object = string.substring(0, n);
                        string = string.substring(n + 2, string.length());
                    }
                    if (debug) {
                        System.out.println("Documentation string seq: " + (String)object);
                    }
                    roseNode2 = new RoseNode("", (String)object, 0);
                    ((RoseNode)object2).addNode(roseNode2, false);
                }
            }
            if (debug) {
                System.out.println("===== End buildDocumentation");
            }
        }
        if (id.getType() == Type.ENUMERATION && (vector = ModelElements.get(id, Type.ENUMERATION_LITERAL, false)) != null) {
            object2 = "";
            for (int i = 0; i < vector.size(); ++i) {
                object = (Id)vector.elementAt(i);
                String string2 = ModelElements.get((Id)object, Property.EL_NAME);
                if (string2 == null) continue;
                object2 = ((String)object2).equals("") ? string2 : (String)object2 + " " + string2;
            }
            if (!((String)object2).equals("")) {
                if (debug) {
                    System.out.println("===== buildDocumentation for " + id.getType());
                }
                RoseNode roseNode3 = new RoseNode("documentation", "\"" + (String)object2 + "\"", 0);
                roseNode.addNode(roseNode3, false);
                if (debug) {
                    System.out.println("===== End buildDocumentation");
                }
            }
        }
    }

    private void buildEnumerations(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.ENUMERATION, false);
        if (vector != null) {
            RoseNode roseNode2 = roseNode;
            if (vector.size() > 0 && (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE)) {
                RoseNode roseNode3 = roseNode.findNodeWithKey("nestedClasses");
                if (roseNode3 == null) {
                    roseNode3 = new RoseNode("nestedClasses", "nestedClasses", 3);
                    roseNode.addNode(roseNode3, false);
                }
                roseNode2 = roseNode3;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                Id id2 = (Id)vector.elementAt(i);
                String string2 = ModelElements.get(id2, "Rose", "IsFromModel");
                if (string2 != null || (string = ModelElements.get(id2, Property.NAME)) == null) continue;
                if (debug) {
                    System.out.println("===== buildEnumerations: " + string);
                }
                RoseNode roseNode4 = new RoseNode("", "Class \"" + string + "\"", 2);
                roseNode2.addNode(roseNode4, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode4);
                this.buildRoseProperties(id2, roseNode4);
                this.buildStereoTypeProperty(id2, roseNode4);
                this.buildAttributeListProperties(id2, roseNode4);
                this.buildAttributes(id2, roseNode4);
                this.buildOperations(id2, roseNode4);
                this.buildUsesRelationship(id2, roseNode4);
                this.buildInheritanceRelationship(id2, roseNode4);
                this.buildRealizeRelationship(id2, roseNode4);
                this.buildClasses(id2, roseNode4);
                this.buildInterfaces(id2, roseNode4);
                this.buildPrimitives(id2, roseNode4);
                this.buildEnumerations(id2, roseNode4);
                this.buildStructures(id2, roseNode4);
                if (!debug) continue;
                System.out.println("===== buildEnumerations");
            }
        }
    }

    private void buildExceptions(Id id, RoseNode roseNode) {
        String string = ModelElements.get(id, "", "exceptions");
        if (string != null) {
            if (debug) {
                System.out.println("===== buildExceptions");
            }
            RoseNode roseNode2 = new RoseNode("exceptions", "\"" + string + "\"", 0);
            roseNode.addNode(roseNode2, false);
            if (debug) {
                System.out.println("===== End buildExceptions");
            }
        }
    }

    private void buildIDLProperties(Id id, RoseNode roseNode) {
        RoseNode roseNode2;
        Object object;
        Object object2;
        RoseNode roseNode3;
        Vector vector = ModelElements.getTags(id, "IDL");
        RoseNode roseNode4 = null;
        boolean bl = false;
        if (vector != null) {
            if (debug) {
                System.out.println("===== buildIDLProperties");
            }
            if ((roseNode4 = roseNode.findNodeWithKey("attributes")) == null) {
                roseNode4 = new RoseNode("attributes", "Attribute_Set", 3);
                roseNode.addNode(roseNode4, false);
            }
            for (int i = 0; i < vector.size(); ++i) {
                roseNode3 = new RoseNode("", "Attribute", 2);
                roseNode4.addNode(roseNode3, false);
                object2 = (String)vector.elementAt(i);
                object = ModelElements.get(id, "IDL", (String)object2);
                if (!(((String)object).equals("TRUE") || ((String)object).equals("FALSE") || ((String)object).startsWith("(") || ((String)object).endsWith(")"))) {
                    object = "\"" + (String)object + "\"";
                }
                if (debug) {
                    System.out.println("Property Attribute: IDL, " + (String)object2 + ", " + (String)object);
                }
                roseNode2 = new RoseNode("tool", "\"IDL\"", 0);
                RoseNode roseNode5 = new RoseNode("name", "\"" + (String)object2 + "\"", 0);
                RoseNode roseNode6 = new RoseNode("value", (String)object, 0);
                roseNode3.addNode(roseNode2, false);
                roseNode3.addNode(roseNode5, false);
                roseNode3.addNode(roseNode6, false);
                if (!((String)object2).equals("uuid")) continue;
                bl = true;
            }
            if (debug) {
                System.out.println("===== End buildIDLProperties");
            }
        }
        if (!(id.getType() != Type.MODEL && id.getType() != Type.PACKAGE && id.getType() != Type.CLASS && id.getType() != Type.INTERFACE && id.getType() != Type.PRIMITIVE && id.getType() != Type.ENUMERATION && id.getType() != Type.STRUCTURE && id.getType() != Type.ATTRIBUTE && id.getType() != Type.OPERATION && id.getType() != Type.GENERALIZATION && id.getType() != Type.ASSOCIATION && id.getType() != Type.ASSOCIATION_END || bl)) {
            String string = id.getUUID();
            if (roseNode4 == null) {
                roseNode4 = new RoseNode("attributes", "Attribute_Set", 3);
                roseNode.addNode(roseNode4, false);
            }
            if (debug) {
                System.out.println("===== Add uuid as IDL properties");
            }
            roseNode3 = new RoseNode("", "Attribute", 2);
            roseNode4.addNode(roseNode3, false);
            object2 = new RoseNode("tool", "\"IDL\"", 0);
            object = new RoseNode("name", "\"uuid\"", 0);
            roseNode2 = new RoseNode("value", "\"" + string + "\"", 0);
            roseNode3.addNode((RoseNode)object2, false);
            roseNode3.addNode((RoseNode)object, false);
            roseNode3.addNode(roseNode2, false);
            if (debug) {
                System.out.println("===== End add uuid as IDL properties");
            }
        }
    }

    private void buildInheritanceRelationship(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Link.GENERALIZATION, false);
        if (vector != null) {
            if (debug) {
                System.out.println("===== buildInheritanceRelationship");
            }
            RoseNode roseNode2 = new RoseNode("superclasses", "inheritance_relationship_list", 3);
            roseNode.addNode(roseNode2, false);
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                Object object2;
                Id id2 = (Id)vector.elementAt(i);
                String string = ModelElements.getName(id2);
                Vector vector2 = ModelElements.get(id2, Link.SUPERTYPE, false);
                Id id3 = null;
                String string2 = "";
                boolean bl = false;
                if (vector2 != null && vector2.size() == 1) {
                    id3 = (Id)vector2.elementAt(0);
                    bl = true;
                } else {
                    string2 = ModelElements.get(id2, "", "supplier");
                    if (this.withJDK116 && string2 != null && (string2.startsWith("java") || string2.startsWith("sun"))) {
                        object2 = string2;
                        int n2 = ((String)object2).indexOf(".");
                        string2 = ResourceUtil.getString("LOGICAL_VIEW");
                        while (n2 != -1) {
                            string2 = string2 + "::" + ((String)object2).substring(0, n2);
                            object2 = ((String)object2).substring(n2 + 1, ((String)object2).length());
                            n2 = ((String)object2).indexOf(".");
                        }
                        string2 = string2 + "::" + (String)object2;
                        System.out.println("after processing, supplier: " + string2);
                    }
                    bl = true;
                }
                if (!bl) continue;
                object2 = new RoseNode("", "Inheritance_Relationship", 2);
                roseNode2.addNode((RoseNode)object2, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, (RoseNode)object2);
                if (string != null && !string.equals("")) {
                    RoseNode roseNode3 = new RoseNode("label", "\"" + string + "\"", 0);
                    ((RoseNode)object2).addNode(roseNode3, false);
                }
                this.buildRoseProperties(id2, (RoseNode)object2);
                this.buildStereoTypeProperty(id2, (RoseNode)object2);
                if (id3 != null) {
                    if (debug) {
                        System.out.println("gen link has supertype, create supplier and quidu nodes");
                    }
                    RoseNode roseNode4 = new RoseNode("supplier", "\"" + ModelElements.getRoseSupplierName(id3) + "\"", 0);
                    RoseSave.getQUID(id3);
                    object = new RoseNode("quidu", "\"" + ModelElements.get(id3, "Rose", "quid") + "\"", 0);
                    ((RoseNode)object2).addNode(roseNode4, false);
                    ((RoseNode)object2).addNode((RoseNode)object, false);
                } else if (!string2.equals("")) {
                    RoseNode roseNode5 = new RoseNode("supplier", "\"" + string2 + "\"", 0);
                    ((RoseNode)object2).addNode(roseNode5, false);
                    object = ModelElements.get(id2, "", "quidu");
                    if (object != null) {
                        System.out.println("quidu: " + (String)object);
                        RoseNode roseNode6 = new RoseNode("quidu", "\"" + (String)object + "\"", 0);
                        ((RoseNode)object2).addNode(roseNode6, false);
                    }
                }
                this.buildAttributeListProperties(id2, (RoseNode)object2);
                ++n;
            }
            if (n == 0) {
                roseNode.deleteNode(roseNode2);
            }
            if (debug) {
                System.out.println("===== End buildInheritanceRelationship");
            }
        }
    }

    private void buildInterfaces(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.INTERFACE, false);
        if (vector != null) {
            RoseNode roseNode2 = roseNode;
            if (vector.size() > 0 && (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE)) {
                RoseNode roseNode3 = roseNode.findNodeWithKey("nestedClasses");
                if (roseNode3 == null) {
                    roseNode3 = new RoseNode("nestedClasses", "nestedClasses", 3);
                    roseNode.addNode(roseNode3, false);
                }
                roseNode2 = roseNode3;
            }
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string = ModelElements.get(id2, Property.NAME);
                if (string == null) continue;
                if (debug) {
                    System.out.println("===== buildInterfaces: " + string);
                }
                RoseNode roseNode4 = new RoseNode("", "Class \"" + string + "\"", 2);
                roseNode2.addNode(roseNode4, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode4);
                this.buildRoseProperties(id2, roseNode4);
                this.buildStereoTypeProperty(id2, roseNode4);
                this.buildAttributeListProperties(id2, roseNode4);
                this.buildAttributes(id2, roseNode4);
                this.buildOperations(id2, roseNode4);
                this.buildUsesRelationship(id2, roseNode4);
                this.buildInheritanceRelationship(id2, roseNode4);
                this.buildRealizeRelationship(id2, roseNode4);
                this.buildClasses(id2, roseNode4);
                this.buildInterfaces(id2, roseNode4);
                this.buildPrimitives(id2, roseNode4);
                this.buildEnumerations(id2, roseNode4);
                this.buildStructures(id2, roseNode4);
                if (!debug) continue;
                System.out.println("===== End buildInterfaces");
            }
        }
    }

    private void buildItems(Id id, RoseNode roseNode) {
        Id id2;
        Vector vector;
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(Property.XMI_EXTENDER);
        vector2.addElement("UMLNotation");
        vector2.addElement(Property.XMI_EXTENDER_ID);
        vector2.addElement("UMLNotation");
        Vector vector3 = ModelElements.get(id, Type.XMI_EXTENSION, vector2, false);
        if (vector3 != null && vector3.size() == 1 && (vector = ModelElements.get(id2 = (Id)vector3.elementAt(0), Type.PRESENTATION, false)) != null) {
            if (debug) {
                System.out.println("===== buildItems");
            }
            RoseNode roseNode2 = new RoseNode("items", "diagram_item_list", 3);
            roseNode.addNode(roseNode2, false);
            for (int i = 0; i < vector.size(); ++i) {
                Id id3;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Id id4 = (Id)vector.elementAt(i);
                String string = "@" + String.valueOf(++this.numOfView);
                String string2 = "";
                Vector vector4 = ModelElements.get(id4, Link.P_MODEL, false);
                if (vector4 != null && vector4.size() == 1) {
                    object7 = (Id)vector4.elementAt(0);
                    object6 = ModelElements.get((Id)object7, Property.NAME);
                    object5 = ModelElements.getRoseSupplierName((Id)object7);
                    if (((Id)object7).getType() == Type.PACKAGE) {
                        string2 = "CategoryView \"" + (String)object5 + "\" " + string;
                    } else if (((Id)object7).getType() == Type.CLASS || ((Id)object7).getType() == Type.INTERFACE || ((Id)object7).getType() == Type.PRIMITIVE || ((Id)object7).getType() == Type.ENUMERATION || ((Id)object7).getType() == Type.STRUCTURE) {
                        string2 = "ClassView \"Class\" \"" + (String)object5 + "\" " + string;
                    } else if (((Id)object7).getType() == Type.GENERALIZATION) {
                        string2 = "InheritView \"" + (String)object6 + "\" " + string;
                    } else if (((Id)object7).getType() == Type.ASSOCIATION) {
                        string2 = "AssociationViewNew \"" + (String)object6 + "\" " + string;
                    } else if (((Id)object7).getType() == Type.DEPENDENCY && (object4 = ModelElements.get((Id)object7, Link.CLIENT, false)) != null) {
                        object3 = (Id)((Vector)object4).elementAt(0);
                        if (((Id)object3).getType() == Type.CLASS) {
                            int n;
                            object2 = ModelElements.get((Id)object7, "Rose", "label");
                            if (object2 != null && !((String)object2).equals("") && (n = ((String)object2).indexOf("|#")) != -1 && (n = ((String)(object2 = ((String)object2).substring(0, n))).indexOf("\"")) != -1) {
                                object = "";
                                while (n != -1) {
                                    object = (String)object + ((String)object2).substring(0, n) + "\\\"";
                                    object2 = ((String)object2).substring(n + 1, ((String)object2).length());
                                    n = ((String)object2).indexOf("\"");
                                }
                                object2 = "\"" + (String)object + (String)object2 + "\"";
                            }
                            if (object2 == null) {
                                object2 = "\"\"";
                            }
                            string2 = "UsesView " + (String)object2 + " " + string;
                        } else if (((Id)object3).getType() == Type.PACKAGE) {
                            string2 = "ImportView \"" + (String)object6 + "\" " + string;
                        }
                    }
                    if (!((Id)object7).isLoaded()) continue;
                    object4 = new RoseNode("", string2, 2);
                    object3 = ModelElements.get((Id)object7, "Rose", "quid");
                    object2 = new RoseNode("quidu", "\"" + (String)object3 + "\"", 0);
                    ((RoseNode)object4).addNode((RoseNode)object2, false);
                    if (!this.buildClientSupplierProperties(id4, (RoseNode)object4)) continue;
                    if (debug) {
                        System.out.println("===== build Presentation: " + string2);
                    }
                    roseNode2.addNode((RoseNode)object4, false);
                    this.buildProperties(id4, (RoseNode)object4);
                    this.buildRoseProperties(id4, (RoseNode)object4);
                    this.quid_ViewIdTable.put(object3, string);
                    this.buildSubPresentations(id4, (RoseNode)object4);
                    if (((Id)object7).getType() == Type.ASSOCIATION && ((RoseNode)object4).findNodeWithKey("roleview_list") == null) {
                        roseNode2.deleteNode((RoseNode)object4);
                    }
                    if (!debug) continue;
                    System.out.println("===== End build Presentation");
                    continue;
                }
                object7 = new Vector<Object>();
                ((Vector)object7).addElement(Property.XMI_EXTENDER);
                ((Vector)object7).addElement("Rose");
                ((Vector)object7).addElement(Property.XMI_EXTENDER_ID);
                ((Vector)object7).addElement("Rose");
                object6 = ModelElements.get(id4, Type.XMI_EXTENSION, (Vector)object7, false);
                if (object6 == null || ((Vector)object6).size() != 1 || (object4 = ModelElements.get((Id)(object5 = (Id)((Vector)object6).elementAt(0)), Type.EXTENSION, false)) == null || ((Vector)object4).size() != 1 || (object2 = ModelElements.get((Id)(object3 = (Id)((Vector)object4).elementAt(0)), Link.EXTENSION_REFERENCE, false)) == null || ((Vector)object2).size() != 1 || (id3 = (Id)((Vector)object2).elementAt(0)).getType() != Type.EXTENSION || !ModelElements.get(id3, Property.EXTENSION_NAME).equals("Realize_Relationship")) continue;
                string2 = "RealizeView \"\" " + string;
                object = new RoseNode("", string2, 2);
                String string3 = ModelElements.get(id3, "Rose", "quid");
                RoseNode roseNode3 = new RoseNode("quidu", "\"" + string3 + "\"", 0);
                ((RoseNode)object).addNode(roseNode3, false);
                if (!this.buildClientSupplierProperties(id3, (RoseNode)object)) continue;
                if (debug) {
                    System.out.println("===== build Presentation: " + string2);
                }
                roseNode2.addNode((RoseNode)object, false);
                this.buildProperties(id4, (RoseNode)object);
                this.buildRoseProperties(id4, (RoseNode)object);
                this.quid_ViewIdTable.put(string3, string);
                this.buildSubPresentations(id4, (RoseNode)object);
                if (!debug) continue;
                System.out.println("===== End build Presentation");
            }
            if (roseNode2.getNodes().size() == 0) {
                roseNode.deleteNode(roseNode2);
            }
            if (debug) {
                System.out.println("===== End buildItems");
            }
        }
    }

    private void buildJavaProperties(Id id, RoseNode roseNode) {
        Object object;
        RoseNode roseNode2;
        RoseNode roseNode3;
        Object object2;
        String string;
        if (debug) {
            System.out.println("===== buildJavaProperties");
        }
        if ((string = ModelElements.get(id, Property.OWNER_SCOPE)) != null && string.equals("classifier")) {
            object2 = roseNode.findNodeWithKey("attributes");
            if (object2 == null) {
                object2 = new RoseNode("attributes", "Attribute_Set", 3);
                roseNode.addNode((RoseNode)object2, false);
            }
            roseNode3 = new RoseNode("", "Attribute", 2);
            ((RoseNode)object2).addNode(roseNode3, false);
            RoseNode roseNode4 = new RoseNode("tool", "\"Java\"", 0);
            roseNode2 = new RoseNode("name", "\"Static\"", 0);
            object = new RoseNode("value", "TRUE", 0);
            roseNode3.addNode(roseNode4, false);
            roseNode3.addNode(roseNode2, false);
            roseNode3.addNode((RoseNode)object, false);
        }
        if ((object2 = ModelElements.getTags(id, "Java")) != null) {
            roseNode3 = roseNode.findNodeWithKey("attributes");
            if (roseNode3 == null) {
                roseNode3 = new RoseNode("attributes", "Attribute_Set", 3);
                roseNode.addNode(roseNode3, false);
            }
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                roseNode2 = new RoseNode("", "Attribute", 2);
                roseNode3.addNode(roseNode2, false);
                object = (String)((Vector)object2).elementAt(i);
                if (((String)object).equals("WithJDK116")) continue;
                string = ModelElements.get(id, "Java", (String)object);
                if (!(string.equals("TRUE") || string.equals("FALSE") || string.startsWith("(") || string.endsWith(")"))) {
                    string = "\"" + string + "\"";
                }
                if (debug) {
                    System.out.println("Property Attribute: Java, " + (String)object + ", " + string);
                }
                RoseNode roseNode5 = new RoseNode("tool", "\"Java\"", 0);
                RoseNode roseNode6 = new RoseNode("name", "\"" + (String)object + "\"", 0);
                RoseNode roseNode7 = new RoseNode("value", string, 0);
                roseNode2.addNode(roseNode5, false);
                roseNode2.addNode(roseNode6, false);
                roseNode2.addNode(roseNode7, false);
            }
        }
        if (debug) {
            System.out.println("===== End buildJavaProperties");
        }
    }

    private void buildJavaStaticProperty(Id id, RoseNode roseNode) {
        String string;
        if (id.getType() == Type.OPERATION && (string = ModelElements.get(id, Property.OWNER_SCOPE)) != null && string.equals("classifier")) {
            RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
            if (roseNode2 == null) {
                roseNode2 = new RoseNode("attributes", "Attribute_Set", 3);
                roseNode.addNode(roseNode2, false);
            }
            RoseNode roseNode3 = new RoseNode("", "Attribute", 2);
            roseNode2.addNode(roseNode3, false);
            RoseNode roseNode4 = new RoseNode("tool", "\"Java\"", 0);
            RoseNode roseNode5 = new RoseNode("name", "\"Static\"", 0);
            RoseNode roseNode6 = new RoseNode("value", "TRUE", 0);
            roseNode3.addNode(roseNode4, false);
            roseNode3.addNode(roseNode5, false);
            roseNode3.addNode(roseNode6, false);
        }
    }

    private void buildJDK116Framework(Id id, RoseNode roseNode) throws Exception {
        RoseNode roseNode2;
        RoseNode roseNode3;
        RoseNode roseNode4;
        RoseNode roseNode5;
        String string;
        String string2;
        RoseNode roseNode6;
        Vector vector = ModelElements.getTags(id, "java.cat");
        if (vector != null && vector.size() == 1) {
            roseNode6 = new RoseNode("", "Class_Category \"java\"", 2);
            roseNode.addNode(roseNode6, false);
            string2 = (String)vector.elementAt(0);
            string = ModelElements.get(id, "java.cat", string2);
            roseNode5 = new RoseNode("is_unit", "TRUE", 0);
            roseNode6.addNode(roseNode5, false);
            roseNode4 = new RoseNode("is_loaded", "FALSE", 0);
            roseNode6.addNode(roseNode4, false);
            roseNode3 = new RoseNode("file_name", string2, 0);
            roseNode6.addNode(roseNode3, false);
            roseNode2 = new RoseNode("quid", string, 0);
            roseNode6.addNode(roseNode2, false);
        }
        if ((vector = ModelElements.getTags(id, "sun.cat")) != null && vector.size() == 1) {
            roseNode6 = new RoseNode("", "Class_Category \"sun\"", 2);
            roseNode.addNode(roseNode6, false);
            string2 = (String)vector.elementAt(0);
            string = ModelElements.get(id, "sun.cat", string2);
            roseNode5 = new RoseNode("is_unit", "TRUE", 0);
            roseNode6.addNode(roseNode5, false);
            roseNode4 = new RoseNode("is_loaded", "FALSE", 0);
            roseNode6.addNode(roseNode4, false);
            roseNode3 = new RoseNode("file_name", string2, 0);
            roseNode6.addNode(roseNode3, false);
            roseNode2 = new RoseNode("quid", string, 0);
            roseNode6.addNode(roseNode2, false);
        }
    }

    private void buildLabelProperty(Id id, Id id2, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Link.P_MODEL, false);
        String string = roseNode.getKey();
        if (vector != null && vector.size() == 1) {
            Id id3 = (Id)vector.elementAt(0);
            if (string.equals("stereotype")) {
                String string2;
                if (id3.getType() == Type.PRIMITIVE) {
                    RoseNode roseNode2 = new RoseNode("label", "\"<<primitive>>\"", 0);
                    roseNode.addNode(roseNode2, false);
                } else if (id3.getType() == Type.ENUMERATION) {
                    RoseNode roseNode3 = new RoseNode("label", "\"<<enumeration>>\"", 0);
                    roseNode.addNode(roseNode3, false);
                } else if (id3.getType() == Type.INTERFACE) {
                    RoseNode roseNode4 = new RoseNode("label", "\"<<Interface>>\"", 0);
                    roseNode.addNode(roseNode4, false);
                } else if (id3.getType() == Type.CLASS && (string2 = ModelElements.get(id2, "Rose", "label")) != null) {
                    int n = string2.indexOf("|#");
                    if (n == -1) {
                        RoseNode roseNode5 = new RoseNode("label", string2, 0);
                        roseNode.addNode(roseNode5, false);
                    } else {
                        RoseNode roseNode6 = new RoseNode("label", "", 1);
                        roseNode.addNode(roseNode6, false);
                        RoseNode roseNode7 = null;
                        while (string2.length() != 0) {
                            n = string2.indexOf("|#");
                            String string3 = "";
                            if (n == -1) {
                                string3 = string2;
                                string2 = "";
                            } else {
                                string3 = string2.substring(0, n);
                                string2 = string2.substring(n + 2, string2.length());
                            }
                            roseNode7 = new RoseNode("", string3, 0);
                            roseNode6.addNode(roseNode7, false);
                        }
                    }
                }
            } else {
                String string4 = ModelElements.get(id3, Property.NAME);
                string4 = string4 == null || string4.equals("") ? ModelElements.get(id3, "Rose", "label") : "\"" + string4 + "\"";
                if (string4 != null) {
                    int n = string4.indexOf("|#");
                    if (n != -1) {
                        RoseNode roseNode8 = new RoseNode("label", "", 1);
                        roseNode.addNode(roseNode8, false);
                        RoseNode roseNode9 = null;
                        while (string4.length() != 0) {
                            n = string4.indexOf("|#");
                            String string5 = "";
                            if (n == -1) {
                                string5 = string4;
                                string4 = "";
                            } else {
                                string5 = string4.substring(0, n);
                                string4 = string4.substring(n + 2, string4.length());
                            }
                            roseNode9 = new RoseNode("", string5, 0);
                            roseNode8.addNode(roseNode9, false);
                        }
                    } else {
                        RoseNode roseNode10 = new RoseNode("label", string4, 0);
                        roseNode.addNode(roseNode10, false);
                    }
                }
            }
        }
    }

    private void buildLanguage(Id id, RoseNode roseNode) {
        String string = ModelElements.get(id, "", "language");
        if (string != null) {
            if (debug) {
                System.out.println("===== buildLanguage");
            }
            RoseNode roseNode2 = new RoseNode("language", "\"" + string + "\"", 0);
            roseNode.addNode(roseNode2, false);
            if (debug) {
                System.out.println("===== End buildLanguage");
            }
        }
    }

    private void buildLogicalPresentation(Id id, RoseNode roseNode) {
        Id id2;
        Vector vector;
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(Property.XMI_EXTENDER);
        vector2.addElement("UMLNotation");
        vector2.addElement(Property.XMI_EXTENDER_ID);
        vector2.addElement("UMLNotation");
        Vector vector3 = ModelElements.get(id, Type.XMI_EXTENSION, vector2, false);
        if (vector3 != null && vector3.size() == 1 && (vector = ModelElements.get(id2 = (Id)vector3.elementAt(0), Type.VIEW_ELEMENT, false)) != null) {
            RoseNode roseNode2 = new RoseNode("logical_presentations", "unit_reference_list", 3);
            roseNode.addNode(roseNode2, false);
            for (int i = 0; i < vector.size(); ++i) {
                Id id3 = (Id)vector.elementAt(i);
                if (debug) {
                    System.out.println("===== build ClassDiagram: " + ModelElements.get(id3, "UMLNotation", "name"));
                }
                RoseNode roseNode3 = new RoseNode("", "ClassDiagram \"" + ModelElements.get(id3, "UMLNotation", "name") + "\"", 2);
                roseNode2.addNode(roseNode3, false);
                this.buildProperties(id3, roseNode3);
                this.buildRoseProperties(id3, roseNode3);
                this.buildItems(id3, roseNode3);
                if (!debug) continue;
                System.out.println("===== End build ClassDiagram");
            }
        }
    }

    private void buildLogicalView(Id id, RoseNode roseNode) throws Exception {
        Object object;
        if (debug) {
            System.out.println("===== Build logical view folder");
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(Property.EXTENSION_NAME);
        vector.addElement(ResourceUtil.getString("LOGICAL_VIEW"));
        Vector vector2 = ModelElements.get(id, Type.EXTENSION, vector, false);
        RoseNode roseNode2 = new RoseNode("root_category", "Class_Category \"" + ResourceUtil.getString("LOGICAL_VIEW") + "\"", 2);
        roseNode.addNode(roseNode2, false);
        if (vector2 != null && vector2.size() == 1) {
            object = (Id)vector2.elementAt(0);
            this.buildProperties((Id)object, roseNode2);
            this.buildRoseProperties((Id)object, roseNode2);
        } else {
            RoseSave.getQUID(id);
            this.buildRoseProperties(id, roseNode2);
        }
        this.buildAttributeListProperties(this.rootId, roseNode2);
        object = new RoseNode("logical_models", "unit_reference_list", 3);
        roseNode2.addNode((RoseNode)object, false);
        if (this.withJDK116) {
            this.buildJDK116Framework(this.rootId, (RoseNode)object);
        }
        this.buildAssociations(this.rootId, (RoseNode)object);
        this.buildPackageAndClass(this.rootId, (RoseNode)object);
        this.buildLogicalPresentation(this.rootId, roseNode2);
        if (debug) {
            System.out.println("===== End build logical view folder");
        }
    }

    private void buildOperations(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.OPERATION, false);
        if (vector != null) {
            RoseNode roseNode2 = new RoseNode("operations", "Operations", 3);
            roseNode.addNode(roseNode2, false);
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string = ModelElements.get(id2, Property.NAME);
                if (string == null) continue;
                if (debug) {
                    System.out.println("===== buildOperations: " + string);
                }
                RoseNode roseNode3 = new RoseNode("", "Operation \"" + string + "\"", 2);
                roseNode2.addNode(roseNode3, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode3);
                this.buildRoseProperties(id2, roseNode3);
                this.buildStereoTypeProperty(id2, roseNode3);
                this.buildAttributeListProperties(id2, roseNode3);
                this.buildParameters(id2, roseNode3);
                if (!debug) continue;
                System.out.println("===== End buildOperations");
            }
        }
    }

    private void buildPackageAndClass(Id id, RoseNode roseNode) throws Exception {
        this.buildPackages(id, roseNode);
        this.buildClasses(id, roseNode);
        this.buildInterfaces(id, roseNode);
        this.buildPrimitives(id, roseNode);
        this.buildEnumerations(id, roseNode);
        this.buildStructures(id, roseNode);
    }

    private void buildPackages(Id id, RoseNode roseNode) throws Exception {
        Vector vector = ModelElements.get(id, Type.PACKAGE, false);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode2;
                String string;
                Id id2 = (Id)vector.elementAt(i);
                String string2 = ModelElements.get(id2, "Rose", "IsFromModel");
                if (string2 != null || (string = ModelElements.get(id2, Property.NAME)) == null) continue;
                if (debug) {
                    System.out.println("===== Build package: " + string);
                }
                RoseNode roseNode3 = new RoseNode("", "Class_Category \"" + string + "\"", 2);
                roseNode.addNode(roseNode3, false);
                RoseSave.getQUID(id2);
                String string3 = ModelElements.get(id2, "Rose", "is_unit");
                if (string3 != null && string3.toLowerCase().equals("true")) {
                    roseNode2 = new RoseNode("is_unit", "TRUE", 0);
                    RoseNode roseNode4 = new RoseNode("is_loaded", "FALSE", 0);
                    RoseNode roseNode5 = new RoseNode("file_name", ModelElements.get(id2, "Rose", "file_name"), 0);
                    RoseNode roseNode6 = new RoseNode("quid", "\"" + RoseSave.getQUID(id2) + "\"", 0);
                    roseNode3.addNode(roseNode2, false);
                    roseNode3.addNode(roseNode4, false);
                    roseNode3.addNode(roseNode5, false);
                    roseNode3.addNode(roseNode6, false);
                    this.buildAttributeListProperties(id2, roseNode3);
                    if (this.bCreateCatFile) {
                        String string4 = ModelElements.get(id2, "Rose", "file_name");
                        String string5 = Util.resolveFileName(string4);
                        RoseSave roseSave = null;
                        if (!(string5.endsWith("boim.cat") || string5.endsWith("managed.cat") || string5.endsWith("services.cat") || string5.endsWith("java.cat") || string5.endsWith("sun.cat"))) {
                            roseSave = new RoseSave(id2, string5, this.bCreateCatFile);
                        }
                    }
                } else {
                    this.buildProperties(id2, roseNode3);
                    this.buildRoseProperties(id2, roseNode3);
                    this.buildStereoTypeProperty(id2, roseNode3);
                    this.buildAttributeListProperties(id2, roseNode3);
                    this.buildVisibilityRelationship(id2, roseNode3);
                    roseNode2 = new RoseNode("logical_models", "unit_reference_list", 3);
                    roseNode3.addNode(roseNode2, false);
                    this.buildAssociations(id2, roseNode2);
                    this.buildPackageAndClass(id2, roseNode2);
                    this.buildLogicalPresentation(id2, roseNode3);
                }
                if (!debug) continue;
                System.out.println("===== End build package");
            }
        }
    }

    private void buildParameters(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.getParameters(id);
        if (vector != null && vector.size() != 0) {
            RoseNode roseNode2 = new RoseNode("parameters", "Parameters", 3);
            roseNode.addNode(roseNode2, false);
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string = ModelElements.get(id2, Property.NAME);
                if (string == null) continue;
                if (debug) {
                    System.out.println("===== buildParameters: " + string);
                }
                RoseNode roseNode3 = new RoseNode("", "Parameter \"" + string + "\"", 2);
                roseNode2.addNode(roseNode3, false);
                this.buildProperties(id2, roseNode3);
                this.buildRoseProperties(id2, roseNode3);
                this.buildAttributeListProperties(id2, roseNode3);
                if (!debug) continue;
                System.out.println("===== End buildParameters");
            }
        }
    }

    private void buildParentView(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode.getParent();
        while (roseNode2.getType() != 2) {
            roseNode2 = roseNode2.getParent();
        }
        String string = roseNode2.getValue();
        String string2 = "";
        int n = string.lastIndexOf("@");
        if (n != -1) {
            string2 = string.substring(n, string.length());
        }
        if (!string2.equals("")) {
            RoseNode roseNode3 = new RoseNode("Parent_View", string2, 0);
            roseNode.addNode(roseNode3, false);
        }
    }

    private void buildPrimitives(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.PRIMITIVE, false);
        if (vector != null) {
            RoseNode roseNode2 = roseNode;
            if (vector.size() > 0 && (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE)) {
                RoseNode roseNode3 = roseNode.findNodeWithKey("nestedClasses");
                if (roseNode3 == null) {
                    roseNode3 = new RoseNode("nestedClasses", "nestedClasses", 3);
                    roseNode.addNode(roseNode3, false);
                }
                roseNode2 = roseNode3;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                Id id2 = (Id)vector.elementAt(i);
                String string2 = ModelElements.get(id2, "Rose", "IsFromModel");
                if (string2 != null || (string = ModelElements.get(id2, Property.NAME)) == null) continue;
                if (debug) {
                    System.out.println("===== buildPrimitives: " + string);
                }
                RoseNode roseNode4 = new RoseNode("", "Class \"" + string + "\"", 2);
                roseNode2.addNode(roseNode4, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode4);
                this.buildRoseProperties(id2, roseNode4);
                this.buildStereoTypeProperty(id2, roseNode4);
                this.buildAttributeListProperties(id2, roseNode4);
                this.buildAttributes(id2, roseNode4);
                this.buildOperations(id2, roseNode4);
                this.buildUsesRelationship(id2, roseNode4);
                this.buildInheritanceRelationship(id2, roseNode4);
                this.buildRealizeRelationship(id2, roseNode4);
                this.buildClasses(id2, roseNode4);
                this.buildInterfaces(id2, roseNode4);
                this.buildPrimitives(id2, roseNode4);
                this.buildEnumerations(id2, roseNode4);
                this.buildStructures(id2, roseNode4);
                if (!debug) continue;
                System.out.println("===== End buildPrimitives");
            }
        }
    }

    private void buildProperties(Id id, RoseNode roseNode) {
        String string;
        Object object;
        Vector vector = ModelElements.getProperties(id);
        if (vector != null) {
            if (debug) {
                System.out.println("===== buildProperties");
            }
            for (int i = 0; i < vector.size(); ++i) {
                RoseNode roseNode2;
                object = (Property)vector.elementAt(i);
                String string2 = "";
                if (object != null) {
                    string2 = ModelElements.get(id, (Property)object);
                }
                String string3 = "";
                if (object == Property.INITIAL_VALUE || object == Property.DEFAULT_VALUE) {
                    string3 = "initv";
                } else if (object == Property.ME_VISIBILITY) {
                    string3 = id.getType() == Type.OPERATION ? "opExportControl" : "exportControl";
                } else if (object == Property.CONCURRENCY) {
                    string3 = "concurrency";
                    if (string2.equals("concurrent")) {
                        string2 = "synchronous";
                    }
                } else if (object == Property.IS_ABSTRACT) {
                    string3 = "abstract";
                } else if (object == Property.AE_MULTIPLICITY) {
                    string3 = "client_cardinality";
                } else if (object == Property.IS_NAVIGABLE) {
                    string3 = "is_navigable";
                } else if (object == Property.OWNER_SCOPE) {
                    if (string2.equals("classifier")) {
                        if (id.getType() == Type.ATTRIBUTE) {
                            string3 = "static";
                            string2 = "TRUE";
                        } else {
                            string3 = "";
                            string2 = "";
                        }
                    } else {
                        string3 = "";
                        string2 = "";
                    }
                }
                if (!(string2.equals("TRUE") || string2.equals("FALSE") || string2.equals("true") || string2.equals("false"))) {
                    string2 = "\"" + string2 + "\"";
                }
                if (string3.equals("") || string2.equals("")) continue;
                if (string3.equals("client_cardinality")) {
                    roseNode2 = new RoseNode(string3, "cardinality", 4);
                    roseNode.addNode(roseNode2, false);
                    RoseNode roseNode3 = new RoseNode("", string2, 0);
                    roseNode2.addNode(roseNode3, false);
                    continue;
                }
                if (string3.equals("is_navigable")) {
                    if (!string2.equals("TRUE") && !string2.equals("true")) continue;
                    roseNode2 = new RoseNode(string3, string2, 0);
                    roseNode.addNode(roseNode2, false);
                    continue;
                }
                roseNode2 = new RoseNode(string3, string2, 0);
                roseNode.addNode(roseNode2, false);
            }
            if (debug) {
                System.out.println("===== End buildProperties");
            }
        }
        this.buildDocumentation(id, roseNode);
        this.buildDerived(id, roseNode);
        this.buildSupplier(id, roseNode);
        this.buildExceptions(id, roseNode);
        this.buildLanguage(id, roseNode);
        this.buildReturnType(id, roseNode);
        this.buildTypeProperty(id, roseNode);
        this.buildComplicatedProperty(id, roseNode);
        this.buildViewProperties(id, roseNode);
        if (id.getType() == Type.ASSOCIATION_END && (string = ModelElements.get(id, "", "static")) != null && string.equals("TRUE")) {
            object = new RoseNode("static", "TRUE", 0);
            roseNode.addNode((RoseNode)object, false);
        }
    }

    private void buildR2000VersionTree() {
        this.versionTree = new RoseNode("", "Petal", 2);
        RoseNode roseNode = new RoseNode("version", "43", 0);
        RoseNode roseNode2 = new RoseNode("_written", "\"Rose 6.5.9232.10\"", 0);
        RoseNode roseNode3 = new RoseNode("charSet", "0", 0);
        this.versionTree.addNode(roseNode, false);
        this.versionTree.addNode(roseNode2, false);
        this.versionTree.addNode(roseNode3, false);
    }

    private void buildR98VersionTree() {
        this.versionTree = new RoseNode("", "Petal", 2);
        RoseNode roseNode = new RoseNode("version", "42", 0);
        RoseNode roseNode2 = new RoseNode("_written", "\"Rose 4.5.8054a\"", 0);
        RoseNode roseNode3 = new RoseNode("charSet", "0", 0);
        this.versionTree.addNode(roseNode, false);
        this.versionTree.addNode(roseNode2, false);
        this.versionTree.addNode(roseNode3, false);
    }

    private void buildRealizeRelationship(Id id, RoseNode roseNode) {
        RoseNode roseNode2 = new RoseNode("realized_interfaces", "realize_rel_list", 3);
        roseNode.addNode(roseNode2, false);
        int n = 0;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(Property.XMI_EXTENDER);
        vector.addElement("Rose");
        vector.addElement(Property.XMI_EXTENDER_ID);
        vector.addElement("Rose");
        Vector vector2 = ModelElements.get(id, Type.XMI_EXTENSION, vector, false);
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Id id2 = (Id)vector2.elementAt(i);
                Vector<Object> vector3 = new Vector<Object>();
                vector3.addElement(Property.EXTENSION_NAME);
                vector3.addElement("Realize_Relationship");
                Vector vector4 = ModelElements.get(id2, Type.EXTENSION, vector3, false);
                if (vector4 == null) continue;
                if (debug) {
                    System.out.println("===== buildRealizeRelationship");
                }
                for (int j = 0; j < vector4.size(); ++j) {
                    RoseNode roseNode3;
                    String string;
                    Object object;
                    Object object2;
                    Object object3;
                    Id id3 = (Id)vector4.elementAt(j);
                    RoseNode roseNode4 = new RoseNode("", "Realize_Relationship", 2);
                    roseNode2.addNode(roseNode4, false);
                    ++n;
                    RoseSave.getQUID(id3);
                    String string2 = ModelElements.get(id3, "Rose", "quid");
                    if (string2 != null) {
                        object3 = new RoseNode("quid", "\"" + string2 + "\"", 0);
                        roseNode4.addNode((RoseNode)object3, false);
                    }
                    if ((object3 = ModelElements.get(id3, Link.EXTENSION_REFERENCE, false)) != null && ((Vector)object3).size() == 1) {
                        object2 = (Id)((Vector)object3).elementAt(0);
                        object = new RoseNode("supplier", "\"" + ModelElements.getRoseSupplierName((Id)object2) + "\"", 0);
                        roseNode4.addNode((RoseNode)object, false);
                        RoseSave.getQUID((Id)object2);
                        string = ModelElements.get((Id)object2, "Rose", "quid");
                        if (string == null) continue;
                        roseNode3 = new RoseNode("quidu", "\"" + string + "\"", 0);
                        roseNode4.addNode(roseNode3, false);
                        continue;
                    }
                    object2 = ModelElements.get(id3, "", "supplier");
                    if (this.withJDK116 && object2 != null && (((String)object2).startsWith("java") || ((String)object2).startsWith("sun"))) {
                        object = object2;
                        int n2 = ((String)object).indexOf(".");
                        object2 = ResourceUtil.getString("LOGICAL_VIEW");
                        while (n2 != -1) {
                            object2 = (String)object2 + "::" + ((String)object).substring(0, n2);
                            object = ((String)object).substring(n2 + 1, ((String)object).length());
                            n2 = ((String)object).indexOf(".");
                        }
                        object2 = (String)object2 + "::" + (String)object;
                    }
                    object = new RoseNode("supplier", "\"" + (String)object2 + "\"", 0);
                    roseNode4.addNode((RoseNode)object, false);
                    string = ModelElements.get(id3, "", "quidu");
                    if (string == null) continue;
                    roseNode3 = new RoseNode("quidu", "\"" + string + "\"", 0);
                    roseNode4.addNode(roseNode3, false);
                }
                if (!debug) continue;
                System.out.println("===== End buildRealizeRelationship");
            }
        }
        if (n == 0) {
            roseNode.deleteNode(roseNode2);
        }
    }

    private void buildReturnType(Id id, RoseNode roseNode) {
        if (id.getType() == Type.OPERATION) {
            Id id2;
            Vector vector;
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(Property.PA_KIND);
            vector2.addElement("return");
            Vector vector3 = ModelElements.get(id, Type.PARAMETER, vector2, false);
            if (vector3 != null && vector3.size() == 1 && (vector = ModelElements.get(id2 = (Id)vector3.elementAt(0), Link.PARM_TYPE, false)) != null && vector.size() == 1) {
                Id id3 = (Id)vector.elementAt(0);
                String string = ModelElements.get(id3, Property.NAME);
                if (string.equals("unsignedshort")) {
                    string = "unsigned short";
                }
                if (string.equals("unsignedlong")) {
                    string = "unsigned long";
                }
                if ((string.startsWith("java.") || string.startsWith("sun.")) && this.withJDK116) {
                    int n = string.lastIndexOf(".");
                    string = string.substring(n + 1, string.length());
                }
                if (debug) {
                    System.out.println("====== buildReturnType");
                }
                RoseNode roseNode2 = new RoseNode("result", "\"" + string + "\"", 0);
                roseNode.addNode(roseNode2, false);
                if (debug) {
                    System.out.println("====== End buildReturnType");
                }
            }
        }
    }

    private void buildRose98iVersionTree() {
        this.versionTree = new RoseNode("", "Petal", 2);
        RoseNode roseNode = new RoseNode("version", "43", 0);
        RoseNode roseNode2 = new RoseNode("_written", "\"Rose 6.1.9113.5\"", 0);
        RoseNode roseNode3 = new RoseNode("charSet", "0", 0);
        this.versionTree.addNode(roseNode, false);
        this.versionTree.addNode(roseNode2, false);
        this.versionTree.addNode(roseNode3, false);
    }

    private void buildRoseProperties(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.getTags(id, "Rose");
        if (vector != null) {
            if (debug) {
                System.out.println("===== buildRoseProperties");
            }
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                Object object2;
                Object object3;
                String string = (String)vector.elementAt(i);
                String string2 = ModelElements.get(id, "Rose", string);
                if (string.equals("supplier")) {
                    if (id.getType() != Type.GENERALIZATION && id.getType() != Type.ASSOCIATION_END && id.getType() != Type.DEPENDENCY) continue;
                    RoseNode roseNode2 = new RoseNode("supplier", "\"" + string2 + "\"", 0);
                    RoseNode roseNode3 = new RoseNode("quidu", "\"" + RoseSave.getQUID(string2) + "\"", 0);
                    roseNode.addNode(roseNode2, false);
                    roseNode.addNode(roseNode3, false);
                    continue;
                }
                if (string.equals("file_name")) {
                    if (roseNode == this.modelTree) continue;
                    RoseNode roseNode4 = new RoseNode(string, string2, 0);
                    roseNode.addNode(roseNode4, false);
                    continue;
                }
                if (string.equals("label")) {
                    if (id.getType() == Type.PRESENTATION) continue;
                    int n = string2.indexOf("|#");
                    if (n != -1) {
                        RoseNode roseNode5 = new RoseNode(string, "", 1);
                        roseNode.addNode(roseNode5, false);
                        object3 = null;
                        while (string2.length() != 0) {
                            n = string2.indexOf("|#");
                            object2 = "";
                            if (n == -1) {
                                object2 = string2;
                                string2 = "";
                            } else {
                                object2 = string2.substring(0, n);
                                string2 = string2.substring(n + 2, string2.length());
                            }
                            object3 = new RoseNode("", (String)object2, 0);
                            roseNode5.addNode((RoseNode)object3, false);
                        }
                        continue;
                    }
                    RoseNode roseNode6 = new RoseNode(string, string2, 0);
                    roseNode.addNode(roseNode6, false);
                    continue;
                }
                if (string.equals("CreatedFrom") || string.equals("Containment") || string.equals("stereotype") || string.equals("presentationFor")) continue;
                if ((string.equals("quid") || string.equals("quidu")) && !string2.startsWith("\"") && !string2.endsWith("\"")) {
                    string2 = "\"" + string2 + "\"";
                }
                boolean bl = true;
                if (id.getType() == Type.MODEL && string.equals("quid")) {
                    Vector<Object> vector2 = new Vector<Object>();
                    vector2.addElement(Property.XMI_EXTENDER);
                    vector2.addElement("Rose");
                    vector2.addElement(Property.XMI_EXTENDER_ID);
                    vector2.addElement("Rose");
                    object3 = ModelElements.get(id, Type.XMI_EXTENSION, vector2, false);
                    if (object3 != null && ((Vector)object3).size() == 1) {
                        object2 = (Id)((Vector)object3).elementAt(0);
                        vector2.removeAllElements();
                        vector2.addElement(Property.EXTENSION_NAME);
                        vector2.addElement(ResourceUtil.getString("LOGICAL_VIEW"));
                        object = ModelElements.get((Id)object2, Type.EXTENSION, vector2, false);
                        if (object != null && ((Vector)object).size() == 1) {
                            Id id2 = (Id)((Vector)object).elementAt(0);
                            String string3 = ModelElements.get(id2, "Rose", "quid");
                            if (string2.equals("\"" + string3 + "\"")) {
                                bl = false;
                            }
                        }
                    }
                }
                if (!bl) continue;
                int n = string2.indexOf("|#");
                if (n != -1) {
                    object3 = new RoseNode(string, "", 1);
                    roseNode.addNode((RoseNode)object3, false);
                    object2 = null;
                    while (string2.length() != 0) {
                        n = string2.indexOf("|#");
                        object = "";
                        if (n == -1) {
                            object = string2;
                            string2 = "";
                        } else {
                            object = string2.substring(0, n);
                            string2 = string2.substring(n + 2, string2.length());
                        }
                        object2 = new RoseNode("", (String)object, 0);
                        ((RoseNode)object3).addNode((RoseNode)object2, false);
                    }
                    continue;
                }
                object3 = new RoseNode(string, string2, 0);
                roseNode.addNode((RoseNode)object3, false);
            }
            if (debug) {
                System.out.println("===== End buildRoseProperties");
            }
        }
    }

    private void buildStereoTypeProperty(Id id, RoseNode roseNode) {
        Object object;
        String string = "";
        if (id.getType() == Type.INTERFACE) {
            string = "Interface";
        } else if (id.getType() == Type.PRIMITIVE) {
            string = "primitive";
        } else if (id.getType() == Type.ENUMERATION) {
            string = "enumeration";
        } else if (id.getType() == Type.STRUCTURE) {
            string = "structure";
        } else if ((id.getType() == Type.CLASS || id.getType() == Type.PACKAGE || id.getType() == Type.ATTRIBUTE || id.getType() == Type.OPERATION || id.getType() == Type.ASSOCIATION || id.getType() == Type.GENERALIZATION || id.getType() == Type.DEPENDENCY) && (object = ModelElements.get(id, Link.ME_STEREOTYPE, false)) != null && ((Vector)object).size() == 1) {
            Id id2 = (Id)((Vector)object).elementAt(0);
            string = ModelElements.getName(id2);
        }
        if (string != null && !string.equals("")) {
            if (debug) {
                System.out.println("===== buildStereoTypeProperty");
            }
            object = new RoseNode("stereotype", "\"" + string + "\"", 0);
            roseNode.addNode((RoseNode)object, false);
            if (debug) {
                System.out.println("===== End buildStereoTypeProperty");
            }
        }
    }

    private void buildStructures(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Type.STRUCTURE, false);
        if (vector != null) {
            RoseNode roseNode2 = roseNode;
            if (vector.size() > 0 && (id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE)) {
                RoseNode roseNode3 = roseNode.findNodeWithKey("nestedClasses");
                if (roseNode3 == null) {
                    roseNode3 = new RoseNode("nestedClasses", "nestedClasses", 3);
                    roseNode.addNode(roseNode3, false);
                }
                roseNode2 = roseNode3;
            }
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string = ModelElements.get(id2, Property.NAME);
                if (string == null) continue;
                if (debug) {
                    System.out.println("===== builStructures: " + string);
                }
                RoseNode roseNode4 = new RoseNode("", "Class \"" + string + "\"", 2);
                roseNode2.addNode(roseNode4, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode4);
                this.buildRoseProperties(id2, roseNode4);
                this.buildStereoTypeProperty(id2, roseNode4);
                this.buildAttributeListProperties(id2, roseNode4);
                this.buildAttributes(id2, roseNode4);
                this.buildOperations(id2, roseNode4);
                this.buildUsesRelationship(id2, roseNode4);
                this.buildInheritanceRelationship(id2, roseNode4);
                this.buildRealizeRelationship(id2, roseNode4);
                this.buildClasses(id2, roseNode4);
                this.buildInterfaces(id2, roseNode4);
                this.buildPrimitives(id2, roseNode4);
                this.buildEnumerations(id2, roseNode4);
                this.buildStructures(id2, roseNode4);
                if (!debug) continue;
                System.out.println("===== End builStructures");
            }
        }
    }

    private void buildSubPresentations(Id id, RoseNode roseNode) {
        Id id2;
        Vector vector;
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(Property.XMI_EXTENDER);
        vector2.addElement("UMLNotation");
        vector2.addElement(Property.XMI_EXTENDER_ID);
        vector2.addElement("UMLNotation");
        Vector vector3 = ModelElements.get(id, Type.XMI_EXTENSION, vector2, false);
        if (vector3 != null && vector3.size() == 1 && (vector = ModelElements.get(id2 = (Id)vector3.elementAt(0), Type.PRESENTATION, false)) != null) {
            RoseNode roseNode2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                String string;
                Object object2;
                Id id3 = (Id)vector.elementAt(i);
                Vector vector4 = ModelElements.get(id3, Link.P_MODEL, false);
                if (vector4 != null && vector4.size() == 1) {
                    object2 = (Id)vector4.elementAt(0);
                    if (((Id)object2).getType() != Type.ASSOCIATION_END) continue;
                    string = ModelElements.get((Id)object2, Property.NAME);
                    String string2 = "@" + String.valueOf(++this.numOfView);
                    object = "RoleView \"" + string + "\" " + string2;
                    if (roseNode2 == null) {
                        roseNode2 = new RoseNode("roleview_list", "RoleViews", 3);
                        roseNode.addNode(roseNode2, false);
                    }
                    RoseNode roseNode3 = new RoseNode("", (String)object, 2);
                    String string3 = ModelElements.get((Id)object2, "Rose", "quid");
                    RoseNode roseNode4 = new RoseNode("quidu", "\"" + string3 + "\"", 0);
                    roseNode3.addNode(roseNode4, false);
                    if (!this.buildClientSupplierProperties(id3, roseNode3)) continue;
                    if (debug) {
                        System.out.println("===== build Presentation: " + (String)object);
                    }
                    roseNode2.addNode(roseNode3, false);
                    this.buildProperties(id3, roseNode3);
                    this.buildRoseProperties(id3, roseNode3);
                    this.buildParentView(roseNode3);
                    this.buildSubPresentations(id3, roseNode3);
                    if (!debug) continue;
                    System.out.println("===== End build Presentation");
                    continue;
                }
                object2 = ModelElements.get(id3, "Rose", "presentationFor");
                if (object2 == null) continue;
                string = ModelElements.get(id3, "UMLNotation", "name");
                int n = string.lastIndexOf("@");
                if (n != -1) {
                    object = "@" + String.valueOf(++this.numOfView);
                    string = string.substring(0, n - 1) + " " + (String)object;
                    string = string.substring(0, n) + (String)object;
                }
                object = new RoseNode((String)object2, string, 2);
                roseNode.addNode((RoseNode)object, false);
                this.buildProperties(id3, (RoseNode)object);
                this.buildRoseProperties(id3, (RoseNode)object);
                if (((String)object2).equals("label") || ((String)object2).equals("stereotype")) {
                    this.buildLabelProperty(id, id3, (RoseNode)object);
                }
                if (((String)object2).equals("label") || ((String)object2).equals("stereotype") || ((String)object2).equals("compartment")) {
                    this.buildParentView((RoseNode)object);
                }
                this.buildSubPresentations(id3, (RoseNode)object);
            }
            if (roseNode2 != null && roseNode2.getNodes().size() != 2) {
                roseNode.deleteNode(roseNode2);
            }
        }
    }

    private void buildSupplier(Id id, RoseNode roseNode) {
        String string = ModelElements.get(id, "", "supplier");
        if (string != null && (id.getType() == Type.GENERALIZATION || id.getType() == Type.ASSOCIATION_END || id.getType() == Type.DEPENDENCY)) {
            RoseNode roseNode2 = new RoseNode("supplier", "\"" + string + "\"", 0);
            RoseNode roseNode3 = new RoseNode("quidu", "\"" + RoseSave.getQUID(string) + "\"", 0);
            roseNode.addNode(roseNode2, false);
            roseNode.addNode(roseNode3, false);
        }
    }

    private void buildTree(Id id) throws Exception {
        this.buildVersionTree(id);
        String string = ModelElements.get(id, "Java", "WithJDK116");
        this.withJDK116 = string != null && string.equals("TRUE");
        if (id.getType() == Type.MODEL) {
            this.modelTree = new RoseNode("", "Design \"Logical View\"", 2);
            RoseNode roseNode = new RoseNode("is_unit", "TRUE", 0);
            this.modelTree.addNode(roseNode, false);
            RoseNode roseNode2 = new RoseNode("is_loaded", "TRUE", 0);
            this.modelTree.addNode(roseNode2, false);
            this.buildRoseProperties(id, this.modelTree);
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(Property.XMI_EXTENDER);
            vector.addElement("Rose");
            vector.addElement(Property.XMI_EXTENDER_ID);
            vector.addElement("Rose");
            Vector vector2 = ModelElements.get(id, Type.XMI_EXTENSION, vector, false);
            if (vector2 != null && vector2.size() == 1) {
                Id id2 = (Id)vector2.elementAt(0);
                this.buildUseCaseView(id2, this.modelTree);
                this.buildLogicalView(id2, this.modelTree);
                this.buildComponentView(id2, this.modelTree);
                this.buildDeploymentView(id2, this.modelTree);
                this.buildDefaultProperties(id2, this.modelTree);
            } else {
                if (debug) {
                    System.out.println("build logical view folder only");
                }
                this.buildLogicalView(id, this.modelTree);
            }
        } else if (id.getType() == Type.PACKAGE) {
            this.modelTree = new RoseNode("", "Class_Category \"" + ModelElements.get(id, Property.NAME) + "\"", 2);
            RoseSave.getQUID(id);
            this.buildRoseProperties(id, this.modelTree);
            this.buildStereoTypeProperty(id, this.modelTree);
            this.buildAttributeListProperties(id, this.modelTree);
            this.buildVisibilityRelationship(id, this.modelTree);
            RoseNode roseNode = new RoseNode("logical_models", "unit_reference_list", 3);
            this.modelTree.addNode(roseNode, false);
            this.buildAssociations(this.rootId, roseNode);
            this.buildPackageAndClass(this.rootId, roseNode);
            this.buildLogicalPresentation(this.rootId, this.modelTree);
        }
    }

    private void buildTypeProperty(Id id, RoseNode roseNode) {
        if (id.getType() == Type.ATTRIBUTE || id.getType() == Type.PARAMETER) {
            Link link = null;
            link = id.getType() == Type.ATTRIBUTE ? Link.SF_TYPE : Link.PARM_TYPE;
            Vector vector = ModelElements.get(id, link, false);
            if (vector != null && vector.size() == 1) {
                Id id2 = (Id)vector.elementAt(0);
                String string = ModelElements.get(id2, Property.NAME);
                if (string.equals("unsignedshort")) {
                    string = "unsigned short";
                }
                if (string.equals("unsignedlong")) {
                    string = "unsigned long";
                }
                if ((string.startsWith("java.") || string.startsWith("sun.")) && this.withJDK116) {
                    int n = string.lastIndexOf(".");
                    string = string.substring(n + 1, string.length());
                }
                if (debug) {
                    System.out.println("===== buildTypeProperty");
                }
                RoseNode roseNode2 = new RoseNode("type", "\"" + string + "\"", 0);
                roseNode.addNode(roseNode2, false);
                if (debug) {
                    System.out.println("===== End buildTypeProperty");
                }
            }
        }
    }

    private void buildUseCaseView(Id id, RoseNode roseNode) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(Property.EXTENSION_NAME);
        vector.addElement(ResourceUtil.getString("USE_CASE_VIEW"));
        Vector vector2 = ModelElements.get(id, Type.EXTENSION, vector, false);
        if (vector2 != null && vector2.size() == 1) {
            if (debug) {
                System.out.println("===== Build use case view folder");
            }
            RoseNode roseNode2 = new RoseNode("root_usecase_package", "Class_Category \"" + ResourceUtil.getString("USE_CASE_VIEW") + "\"", 2);
            roseNode.addNode(roseNode2, false);
            Id id2 = (Id)vector2.elementAt(0);
            this.buildProperties(id2, roseNode2);
            this.buildRoseProperties(id2, roseNode2);
            if (debug) {
                System.out.println("===== End build use case view folder");
            }
        }
    }

    private void buildUsesRelationship(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Link.REQUIREMENT, false);
        if (vector != null) {
            if (debug) {
                System.out.println("===== buildUsesRelationship");
            }
            RoseNode roseNode2 = new RoseNode("used_nodes", "uses_relationship_list", 3);
            roseNode.addNode(roseNode2, false);
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                Vector vector2 = ModelElements.get(id2, Link.SUPPLIER, false);
                Id id3 = null;
                String string = "";
                boolean bl = false;
                if (vector2 != null) {
                    id3 = (Id)vector2.elementAt(0);
                    bl = true;
                } else {
                    string = ModelElements.get(id2, "Rose", "supplier");
                    bl = true;
                }
                if (!bl) continue;
                RoseNode roseNode3 = new RoseNode("", "Uses_Relationship", 2);
                roseNode2.addNode(roseNode3, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode3);
                this.buildRoseProperties(id2, roseNode3);
                this.buildStereoTypeProperty(id2, roseNode3);
                if (id3 != null) {
                    if (debug) {
                        System.out.println("dependency link has supplier, create supplier and quidu nodes");
                    }
                    RoseNode roseNode4 = new RoseNode("supplier", "\"" + ModelElements.getRoseSupplierName(id3) + "\"", 0);
                    RoseSave.getQUID(id3);
                    RoseNode roseNode5 = new RoseNode("quidu", "\"" + ModelElements.get(id3, "Rose", "quid") + "\"", 0);
                    roseNode3.addNode(roseNode4, false);
                    roseNode3.addNode(roseNode5, false);
                }
                this.buildAttributeListProperties(id2, roseNode3);
                ++n;
            }
            if (n == 0) {
                roseNode.deleteNode(roseNode2);
            }
            if (debug) {
                System.out.println("===== End buildUsesRelationship");
            }
        }
    }

    private void buildUUIDProperty(Id id, RoseNode roseNode) {
        if (id.getType() == Type.MODEL || id.getType() == Type.PACKAGE || id.getType() == Type.CLASS || id.getType() == Type.INTERFACE || id.getType() == Type.PRIMITIVE || id.getType() == Type.ENUMERATION || id.getType() == Type.STRUCTURE || id.getType() == Type.ATTRIBUTE || id.getType() == Type.OPERATION || id.getType() == Type.PARAMETER || id.getType() == Type.GENERALIZATION || id.getType() == Type.ASSOCIATION || id.getType() == Type.ASSOCIATION_END) {
            String string = id.getUUID();
            RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
            if (roseNode2 == null) {
                roseNode2 = new RoseNode("attributes", "Attribute_Set", 3);
                roseNode.addNode(roseNode2, false);
            }
            if (debug) {
                System.out.println("===== Add uuid as IDL properties");
            }
            RoseNode roseNode3 = new RoseNode("", "Attribute", 2);
            roseNode2.addNode(roseNode3, false);
            RoseNode roseNode4 = new RoseNode("tool", "\"IDL\"", 0);
            RoseNode roseNode5 = new RoseNode("name", "\"uuid\"", 0);
            RoseNode roseNode6 = new RoseNode("value", "Text", 4);
            RoseNode roseNode7 = new RoseNode("", "\"" + string + "\"", 0);
            roseNode6.addNode(roseNode7, false);
            roseNode3.addNode(roseNode4, false);
            roseNode3.addNode(roseNode5, false);
            roseNode3.addNode(roseNode6, false);
            if (debug) {
                System.out.println("===== End add uuid as IDL properties");
            }
        }
    }

    private void buildVersionTree(Id id) {
        Vector vector = ModelElements.getTags(id, "RosePetal");
        if (vector == null) {
            this.buildR98VersionTree();
        } else {
            this.versionTree = new RoseNode("", "Petal", 2);
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = ModelElements.get(id, "RosePetal", string);
                RoseNode roseNode = new RoseNode(string, string2, 0);
                this.versionTree.addNode(roseNode);
            }
        }
    }

    private void buildViewProperties(Id id, RoseNode roseNode) {
        RoseNode roseNode2;
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        String string2;
        if (debug) {
            System.out.println("===== buildViewProperties");
        }
        if ((string2 = ModelElements.get(id, "UMLNotation", "location")) != null) {
            if (!(string2.equals("TRUE") || string2.equals("FALSE") || string2.startsWith("(") || string2.endsWith(")"))) {
                string2 = "\"" + string2 + "\"";
            }
            object4 = new RoseNode("location", string2, 0);
            roseNode.addNode((RoseNode)object4, false);
        }
        if ((object4 = ModelElements.get(id, "UMLNotation", "originX")) != null) {
            object3 = new RoseNode("origin_x", (String)object4, 0);
            roseNode.addNode((RoseNode)object3, false);
        }
        if ((object3 = ModelElements.get(id, "UMLNotation", "originY")) != null) {
            object2 = new RoseNode("origin_y", (String)object3, 0);
            roseNode.addNode((RoseNode)object2, false);
        }
        if ((object2 = ModelElements.get(id, "UMLNotation", "width")) != null) {
            string = "width";
            if (id.getType() == Type.VIEW_ELEMENT || id.getType() == Type.EXTENSION) {
                string = "max_width";
            } else {
                object = ModelElements.get(id, "UMLNotation", "name");
                if (object != null && (((String)object).startsWith("SegLabel") || ((String)object).startsWith("ItemLabel"))) {
                    string = "max_width";
                }
            }
            object = new RoseNode(string, (String)object2, 0);
            roseNode.addNode((RoseNode)object, false);
        }
        if ((string = ModelElements.get(id, "UMLNotation", "height")) != null) {
            object = "";
            object = id.getType() == Type.VIEW_ELEMENT || id.getType() == Type.EXTENSION ? "max_height" : "height";
            roseNode2 = new RoseNode((String)object, string, 0);
            roseNode.addNode(roseNode2, false);
        }
        if ((object = ModelElements.get(id, "UMLNotation", "zoom")) != null) {
            roseNode2 = new RoseNode("zoom", (String)object, 0);
            roseNode.addNode(roseNode2, false);
        }
        if (debug) {
            System.out.println("===== End buildViewProperties");
        }
    }

    private void buildVisibilityRelationship(Id id, RoseNode roseNode) {
        Vector vector = ModelElements.get(id, Link.REQUIREMENT, false);
        if (vector != null) {
            if (debug) {
                System.out.println("===== buildVisibilityRelationship");
            }
            RoseNode roseNode2 = new RoseNode("visible_categories", "visibility_relationship_list", 3);
            roseNode.addNode(roseNode2, false);
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                Vector vector2 = ModelElements.get(id2, Link.SUPPLIER, false);
                Id id3 = null;
                String string = "";
                boolean bl = false;
                if (vector2 != null) {
                    id3 = (Id)vector2.elementAt(0);
                    bl = true;
                } else {
                    string = ModelElements.get(id2, "Rose", "supplier");
                    bl = true;
                }
                if (!bl) continue;
                RoseNode roseNode3 = new RoseNode("", "Visibility_Relationship", 2);
                roseNode2.addNode(roseNode3, false);
                RoseSave.getQUID(id2);
                this.buildProperties(id2, roseNode3);
                this.buildRoseProperties(id2, roseNode3);
                this.buildStereoTypeProperty(id2, roseNode3);
                if (id3 != null) {
                    if (debug) {
                        System.out.println("dependency link has supplier, create supplier and quidu nodes");
                    }
                    RoseNode roseNode4 = new RoseNode("supplier", "\"" + ModelElements.getRoseSupplierName(id3) + "\"", 0);
                    RoseSave.getQUID(id3);
                    RoseNode roseNode5 = new RoseNode("quidu", "\"" + ModelElements.get(id3, "Rose", "quid") + "\"", 0);
                    roseNode3.addNode(roseNode4, false);
                    roseNode3.addNode(roseNode5, false);
                }
                this.buildAttributeListProperties(id2, roseNode3);
                ++n;
            }
            if (n == 0) {
                roseNode.deleteNode(roseNode2);
            }
            if (debug) {
                System.out.println("===== End buildVisibilityRelationship");
            }
        }
    }

    public void cleanUp() {
        if (propertyChangeListener != null) {
            propertyChangeListener = null;
        }
        if (String_QUIDTable != null && String_QUIDTable.size() != 0) {
            String_QUIDTable.clear();
        }
        if (this.quid_ViewIdTable != null && this.quid_ViewIdTable.size() != 0) {
            this.quid_ViewIdTable.clear();
        }
    }

    private static String getQUID(Id id) {
        String string = ModelElements.get(id, "Rose", "quid");
        if (string == null) {
            if (id.getType() == Type.PACKAGE && RoseUtil.pkgUUID_QUIDTable != null && !RoseUtil.pkgUUID_QUIDTable.isEmpty()) {
                String string2 = id.getUUID();
                string = (String)RoseUtil.pkgUUID_QUIDTable.get(string2);
            }
            if (string == null) {
                if ((string = String.valueOf(++quidnum)).length() < 12) {
                    while (string.length() < 12) {
                        string = "0" + string;
                    }
                } else if (string.length() > 12) {
                    int n = string.length();
                    string = string.substring(n - 12, n);
                }
                if (id.getType() == Type.PACKAGE && RoseUtil.pkgUUID_QUIDTable != null) {
                    RoseUtil.pkgUUID_QUIDTable.put(id.getUUID(), string);
                }
            }
            ModelElements.set(id, "Rose", "quid", string);
        }
        if (debug) {
            System.out.println("get quid: " + string);
        }
        return string;
    }

    private static String getQUID(String string) {
        String string2 = (String)String_QUIDTable.get(string);
        if (string2 == null) {
            if ((string2 = String.valueOf(++quidnum)).length() < 12) {
                while (string2.length() < 12) {
                    string2 = "0" + string2;
                }
            } else if (string2.length() > 12) {
                int n = string2.length();
                string2 = string2.substring(n - 12, n);
            }
            String_QUIDTable.put(string, string2);
        }
        return string2;
    }

    static {
        String_QUIDTable = new Hashtable();
    }
}

