/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.rb30;

import com.ibm.psh.rb30.ModelElements;
import com.ibm.psh.rb30.ResourceUtil;
import com.ibm.psh.roseparser.RoseLexer;
import com.ibm.psh.roseparser.RoseLoader;
import com.ibm.psh.roseparser.RoseNode;
import com.ibm.psh.roseparser.RoseParser;
import com.ibm.psh.roseparser.Util;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UML;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RBConvertUtil {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public String OBRootDir;
    public Vector OBProjDirs;
    public UML uml;

    public RBConvertUtil(String string, String string2, String string3) {
        this.OBRootDir = string3;
        if (!string2.equals("")) {
            this.storeRoseVirtualSymbol(string2);
        }
        if (this.OBProjDirs == null) {
            this.OBProjDirs = new Vector();
        } else {
            this.OBProjDirs.removeAllElements();
        }
        try {
            if (!string.equals("")) {
                this.getOBProjectDirs(string);
            }
            if (this.OBProjDirs.size() > 0) {
                this.uml = new UML();
            }
            int n = string.lastIndexOf(System.getProperty("file.separator"));
            int n2 = string.lastIndexOf(".");
            String string4 = n2 != -1 ? string.substring(n + 1, n2) : string.substring(n + 1, string.length());
            for (int i = 0; i < this.OBProjDirs.size(); ++i) {
                String string5 = (String)this.OBProjDirs.elementAt(i);
                this.convertToROSEMODEL(string5, "xmi" + File.separator + string4 + ".xml");
                ModelElements.delete(this.uml.getSession());
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void convertToROSEMODEL(String string, String string2) {
        Object object;
        Object object2;
        System.out.println("convertoROSEMODEL for: " + string);
        String string3 = "";
        String string4 = "";
        String string5 = string + File.separator + "xmi";
        File file = new File(string5);
        if (file.exists() && file.isDirectory()) {
            object2 = file.list();
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = object2[i];
                File file2 = new File(file.getPath() + File.separator + (String)object);
                if (file2.isFile() && ((String)object).endsWith(".xml")) {
                    string3 = "xmi" + File.separator + (String)object;
                    continue;
                }
                if (!file2.isFile() || !((String)object).endsWith(".dat")) continue;
                string4 = string + File.separator + "xmi" + File.separator + (String)object;
            }
        }
        if (!string4.equals("") && ((File)(object2 = new File(string4))).exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));
                object = bufferedReader.readLine();
                bufferedReader.close();
                this.uml.setFilePath((String)object);
            }
            catch (Exception exception) {
                System.out.println(exception + "thrown when reading file: " + string4);
            }
        }
        if (!string3.equals("")) {
            Object object3;
            System.out.println("loading xmlFile: " + string3);
            object2 = null;
            try {
                object3 = this.uml.load(string3, new Vector(), 1, false);
                if (object3 != null) {
                    object2 = (Id)((Vector)object3).elementAt(0);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            object3 = this.uml.getSession();
            object = ModelElements.get((Id)object3, Type.ALL, true);
            if (object != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Vector vector;
                    Id id = (Id)((Vector)object).elementAt(i);
                    String string6 = ModelElements.get(id, "", "xmiFile");
                    if (string6 != null && string6.equals(string2)) {
                        ModelElements.set(id, "", "xmiFile", "xmi" + File.separator + "ROSEMODEL.xml");
                    }
                    if ((vector = ModelElements.getLinks(id)) == null) continue;
                    for (int j = 0; j < vector.size(); ++j) {
                        Link link = (Link)vector.elementAt(j);
                        Vector vector2 = ModelElements.get(id, link, false);
                        if (vector2 == null) continue;
                        for (int k = 0; k < vector2.size(); ++k) {
                            Id id2 = (Id)vector2.elementAt(k);
                            String string7 = id2.getHref();
                            if (string7 == null || !string7.equals(string2)) continue;
                            id2.setHref("xmi" + File.separator + "ROSEMODEL.xml");
                        }
                    }
                }
            }
            if (object2 != null) {
                try {
                    ((Id)object2).save(string, 1);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
    }

    private String getOBProjectDirectory(RoseNode roseNode, boolean bl) {
        Object object;
        Object object2;
        boolean bl2 = false;
        RoseNode roseNode2 = roseNode.findNodeWithKey("attributes");
        if (roseNode2 != null) {
            object2 = roseNode2.getNodes();
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                Serializable serializable;
                RoseNode roseNode3;
                String string;
                object = (RoseNode)((Vector)object2).elementAt(i);
                RoseNode roseNode4 = ((RoseNode)object).findNodeWithKey("name");
                if (roseNode4 == null || !(string = roseNode4.getValue()).equals("\"OBProjectDirectory\"") || (roseNode3 = ((RoseNode)object).findNodeWithKey("value")) == null) continue;
                String string2 = "";
                if (roseNode3.getType() == 0) {
                    string2 = roseNode3.getValue();
                } else if (roseNode3.getType() == 4 && (serializable = roseNode3.getNodes()) != null && ((Vector)serializable).size() == 1) {
                    RoseNode roseNode5 = (RoseNode)((Vector)serializable).elementAt(0);
                    string2 = roseNode5.getValue();
                }
                string2 = Util.resolveFileName(string2);
                if (File.separator.equals("\\")) {
                    if (string2.charAt(1) != ':') {
                        string2 = this.OBRootDir + File.separator + string2;
                    }
                } else if (!string2.substring(0, 1).equals(File.separator)) {
                    string2 = this.OBRootDir + File.separator + string2;
                }
                if (!((File)(serializable = new File(string2))).isDirectory()) continue;
                try {
                    return ((File)serializable).getCanonicalPath();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                    return null;
                }
            }
        }
        if (!bl2 && !this.OBRootDir.equals("")) {
            if (bl) {
                object2 = new File(this.OBRootDir);
                if (((File)object2).isDirectory()) {
                    try {
                        return ((File)object2).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException);
                        return null;
                    }
                }
            } else {
                object2 = Util.getName(roseNode.getValue());
                object2 = ((String)object2).replace('\\', '-');
                object2 = ((String)object2).replace('/', '-');
                String string = this.OBRootDir + File.separator + (String)object2;
                object = new File(string);
                if (((File)object).isDirectory()) {
                    try {
                        return ((File)object).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException);
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public void getOBProjectDirs(String string) throws Exception {
        String string2;
        if (string.indexOf("$") != -1) {
            string = Util.resolveFileName(string);
        } else if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        String string3 = System.getProperty("file.separator");
        if (!string.startsWith(string3 + string3)) {
            int n;
            while ((n = string.indexOf(string3 + string3)) != -1) {
                string = string.substring(0, n + 1) + string.substring(n + 2, string.length());
            }
        }
        System.out.println("process file: " + string);
        RoseLoader roseLoader = new RoseLoader(string);
        RoseLexer roseLexer = new RoseLexer(roseLoader);
        RoseParser roseParser = new RoseParser(roseLexer, true, true);
        roseParser.parse();
        RoseNode roseNode = roseParser.getModelTree();
        if (string.endsWith(".cat") && (string2 = this.getOBProjectDirectory(roseNode, false)) != null && !string2.equals("")) {
            this.OBProjDirs.addElement(string2);
        }
        this.traverse(roseNode);
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (stringArray.length == 0) {
            System.out.println("Valid arguments are:");
            System.out.println("-r\t\t-- Rose mdl filename");
            System.out.println("-pathMap\t-- Path map for Rose .cat file");
            System.out.println("-ob\t\t-- OB root project directory");
            System.out.println("");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-r") && i + 1 < stringArray.length) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-pathMap") && i + 1 < stringArray.length) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (!stringArray[i].equals("-ob") || i + 1 >= stringArray.length) continue;
            string3 = stringArray[i + 1];
        }
        RBConvertUtil rBConvertUtil = new RBConvertUtil(string, string2, string3);
    }

    public void storeRoseVirtualSymbol(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, string2.length());
            Util.putIntoExternalFiles(string3, string4);
        }
    }

    public void traverse(RoseNode roseNode) throws Exception {
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            if (roseNode2.getType() == 2) {
                this.traverseObject(roseNode2);
                continue;
            }
            if (roseNode2.getType() != 3) continue;
            this.traverseList(roseNode2);
        }
    }

    private void traverseList(RoseNode roseNode) throws Exception {
        this.traverse(roseNode);
    }

    private void traverseObject(RoseNode roseNode) throws Exception {
        String string = roseNode.getKey();
        String string2 = Util.getType(roseNode.getValue());
        String string3 = Util.getName(roseNode.getValue());
        if (string.equals("root_category") && string2.equals("Class_Category") && string3.equals(ResourceUtil.getString("LOGICAL_VIEW"))) {
            String string4 = this.getOBProjectDirectory(roseNode, true);
            if (string4 != null && !string4.equals("")) {
                this.OBProjDirs.addElement(string4);
            }
            this.traverse(roseNode);
        } else if (string.equals("") && string2.equals("Class_Category")) {
            RoseNode roseNode2 = roseNode.findNodeWithKey("is_loaded");
            if (roseNode2 != null) {
                RoseNode roseNode3;
                String string5;
                String string6;
                if (!(!roseNode2.getValue().equals("FALSE") || (string6 = Util.resolveFileName(string5 = (roseNode3 = roseNode.findNodeWithKey("file_name")).getValue())).endsWith("boim.cat") || string6.endsWith("managed.cat") || string6.endsWith("services.cat") || string6.endsWith("java.cat") || string6.endsWith("sun.cat"))) {
                    this.getOBProjectDirs(string6);
                }
            } else {
                this.traverse(roseNode);
            }
        } else {
            this.traverse(roseNode);
        }
    }
}

