/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.diffmerge;

import com.ibm.psh.diffmerge.IdInfo;
import com.ibm.psh.rb30.ModelElements;
import com.ibm.psh.rb30.RoseUtil;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UML;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DiffMergeTool {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int QUID = 0;
    public static final int UUID = 1;
    public static boolean debug;
    public static boolean stopAtUnit;
    public static boolean keepStereotype;
    public boolean forVAJ;
    private int option;
    private IdInfo baseModelIdInfo;
    private IdInfo refModelIdInfo;
    private Hashtable baseHashTable;
    private Hashtable refHashTable;

    public DiffMergeTool() {
    }

    public DiffMergeTool(Id id, Id id2, int n) {
        this.baseModelIdInfo = null;
        this.refModelIdInfo = null;
        this.baseHashTable = new Hashtable();
        this.refHashTable = new Hashtable();
        this.option = n;
        this.buildModelIdInfo(id, n, true);
        this.baseModelIdInfo.calculateGlobalHashValue();
        this.buildModelIdInfo(id2, n, false);
        this.refModelIdInfo.calculateGlobalHashValue();
        if (debug) {
            System.out.println("===== Base model =====");
            this.showIdInfo(this.baseModelIdInfo, 0);
            System.out.println("===== Reference model =====");
            this.showIdInfo(this.refModelIdInfo, 0);
            System.out.println("===== Base Hash Table =====");
            this.showHashTable(this.baseHashTable);
            System.out.println("===== Reference Hash Table =====");
            this.showHashTable(this.refHashTable);
        }
    }

    private void addToBaseModel(IdInfo idInfo) {
        Object object;
        if (idInfo.getStatus() == 3) {
            Object object2;
            object = idInfo.getParent().getId();
            Id id = idInfo.getReferenceId();
            Type type = id.getType();
            Id id2 = ((Id)object).getAPI().getId(id.getUUID());
            if (id2 != null && (object2 = ModelElements.get(id2, Link.NAMESPACE, false)) == null) {
                ModelElements.delete(id2);
            }
            object2 = ModelElements.addConstruct((Id)object, type);
            idInfo.setId((Id)object2);
            ModelElements.setUUID((Id)object2, id.getUUID());
            this.setProperties((Id)object2, id);
            this.setDefaultProperties((Id)object2, id);
            this.setTagValueProperties((Id)object2, id);
        }
        if ((object = idInfo.getNodes()) != null && ((Vector)object).size() > 0) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.addToBaseModel((IdInfo)((Vector)object).elementAt(i));
            }
        }
    }

    public void buildBaseModel(Id id, int n) {
        this.baseModelIdInfo = null;
        this.baseHashTable = new Hashtable();
        this.option = n;
        this.buildModelIdInfo(id, n, true);
        this.baseModelIdInfo.calculateGlobalHashValue();
        if (debug) {
            System.out.println("===== Base model =====");
            this.showIdInfo(this.baseModelIdInfo, 0);
            System.out.println("===== Base Hash Table =====");
            this.showHashTable(this.baseHashTable);
        }
    }

    private void buildIdInfoContents(Id id, int n, IdInfo idInfo, boolean bl) {
        Vector vector = ModelElements.get(id, Type.ALL, false);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string = "";
                if (n == 0) {
                    string = id2.getType() == Type.PARAMETER ? id2.getUUID() : (id2.getType() == Type.XMI_EXTENSION && id2.getUUID().indexOf("Realize_Relationship") != -1 ? id2.getUUID() : ModelElements.get(id2, "Rose", "quid"));
                } else if (n == 1) {
                    string = id2.getUUID();
                }
                IdInfo idInfo2 = new IdInfo(id2);
                if (string != null && !string.equals("")) {
                    boolean bl2 = true;
                    if (keepStereotype && id2.getType() == Type.STEREOTYPE) {
                        bl2 = false;
                        idInfo2.visited(true);
                    }
                    if (bl2) {
                        if (bl) {
                            this.baseHashTable.put(string, idInfo2);
                        } else {
                            this.refHashTable.put(string, idInfo2);
                        }
                    }
                }
                idInfo.addNode(idInfo2);
                String string2 = ModelElements.get(id2, "", "is_unit");
                if (stopAtUnit && (!stopAtUnit || string2 != null && string2.equals("true"))) continue;
                this.buildIdInfoContents(id2, n, idInfo2, bl);
            }
        }
    }

    public void buildModelIdInfo(Id id, int n, boolean bl) {
        String string = "";
        if (n == 0) {
            string = "MODEL_QUID";
        } else if (n == 1) {
            string = "MODEL_UUID";
        }
        if (bl) {
            if (this.baseHashTable == null) {
                this.baseHashTable = new Hashtable();
            }
            this.baseModelIdInfo = new IdInfo(id);
            if (string != null && !string.equals("")) {
                this.baseHashTable.put(string, this.baseModelIdInfo);
            }
            this.buildIdInfoContents(id, n, this.baseModelIdInfo, bl);
        } else {
            this.refModelIdInfo = new IdInfo(id);
            if (this.refHashTable == null) {
                this.refHashTable = new Hashtable();
            }
            if (string != null && !string.equals("")) {
                this.refHashTable.put(string, this.refModelIdInfo);
            }
            this.buildIdInfoContents(id, n, this.refModelIdInfo, bl);
        }
    }

    public void buildReferenceModel(Id id, int n) {
        this.refModelIdInfo = null;
        this.refHashTable = new Hashtable();
        this.option = n;
        this.buildModelIdInfo(id, n, false);
        this.refModelIdInfo.calculateGlobalHashValue();
        if (debug) {
            System.out.println("===== Reference model =====");
            this.showIdInfo(this.refModelIdInfo, 0);
            System.out.println("===== Reference Hash Table =====");
            this.showHashTable(this.refHashTable);
        }
    }

    private void compare(IdInfo idInfo, IdInfo idInfo2, boolean bl) {
        long l = idInfo.getGlobalHashValue();
        long l2 = idInfo.getLocalHashValue();
        long l3 = idInfo2.getGlobalHashValue();
        long l4 = idInfo2.getLocalHashValue();
        if (l == l3) {
            idInfo.setReferenceIdInfo(idInfo2);
            idInfo2.setReferenceIdInfo(idInfo);
            idInfo.visited(true);
            idInfo2.visited(true);
        } else {
            if (l2 != l4) {
                idInfo.setStatus(2);
                idInfo2.setStatus(2);
            }
            idInfo.setReferenceIdInfo(idInfo2);
            idInfo2.setReferenceIdInfo(idInfo);
            idInfo.visited(true);
            idInfo2.visited(true);
        }
        Vector vector = idInfo.getNodes();
        if (vector != null && vector.size() > 0) {
            Vector vector2 = idInfo2.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                IdInfo idInfo3 = (IdInfo)vector.elementAt(i);
                if (this.baseHashTable.contains(idInfo3)) continue;
                long l5 = idInfo3.getGlobalHashValue();
                long l6 = idInfo3.getLocalHashValue();
                if (vector2 != null && vector2.size() > 0) {
                    Object object;
                    for (int j = 0; j < vector2.size(); ++j) {
                        object = (IdInfo)vector2.elementAt(j);
                        long l7 = ((IdInfo)object).getGlobalHashValue();
                        long l8 = ((IdInfo)object).getLocalHashValue();
                        if (l6 != l8) continue;
                        idInfo3.setReferenceIdInfo((IdInfo)object);
                        ((IdInfo)object).setReferenceIdInfo(idInfo3);
                        idInfo3.visited(true);
                        ((IdInfo)object).visited(true);
                        this.compare(idInfo3, (IdInfo)object, bl);
                    }
                    if (idInfo3.isBeingVisited()) continue;
                    idInfo3.visited(true);
                    Id id = idInfo3.getId();
                    if (bl) {
                        if (id.getType() == Type.XMI_EXTENSION) {
                            object = ModelElements.get(id, Property.XMI_EXTENDER);
                            String string = ModelElements.get(id, Property.XMI_EXTENDER_ID);
                            if (!(((String)object).equals("Rose") || string.equals("Rose") || ((String)object).equals("UMLNotation") || ((String)object).equals("UMLNotation"))) {
                                idInfo3.setStatus(4);
                                idInfo3.setChildrenStatusToDelete();
                                continue;
                            }
                            idInfo3.setChildrenVisitedToTrue();
                            continue;
                        }
                        if (id.getType() == Type.EXTENSION || id.getType() == Type.VIEW_ELEMENT || id.getType() == Type.PRESENTATION) {
                            idInfo3.setChildrenVisitedToTrue();
                            continue;
                        }
                        idInfo3.setStatus(4);
                        idInfo3.setChildrenStatusToDelete();
                        continue;
                    }
                    if (id.getUUID().indexOf("Realize_Relationship") != -1) continue;
                    idInfo3.setStatus(4);
                    idInfo3.setChildrenStatusToDelete();
                    continue;
                }
                idInfo3.visited(true);
                Id id = idInfo3.getId();
                if (bl) {
                    String string;
                    if (id.getType() == Type.XMI_EXTENSION) {
                        String string2 = ModelElements.get(id, Property.XMI_EXTENDER);
                        string = ModelElements.get(id, Property.XMI_EXTENDER_ID);
                        if (!(string2.equals("Rose") || string.equals("Rose") || string2.equals("UMLNotation") || string2.equals("UMLNotation"))) {
                            idInfo3.setStatus(4);
                            idInfo3.setChildrenStatusToDelete();
                            continue;
                        }
                        idInfo3.setChildrenVisitedToTrue();
                        continue;
                    }
                    if (id.getType() == Type.EXTENSION || id.getType() == Type.VIEW_ELEMENT || id.getType() == Type.PRESENTATION) {
                        boolean bl2 = true;
                        if (id.getType() == Type.EXTENSION && (string = ModelElements.getName(id)) != null && string.equals("Realize_Relationship")) {
                            idInfo3.setStatus(4);
                            idInfo3.setChildrenStatusToDelete();
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        idInfo3.setChildrenVisitedToTrue();
                        continue;
                    }
                    idInfo3.setStatus(4);
                    idInfo3.setChildrenStatusToDelete();
                    continue;
                }
                if (id.getUUID().indexOf("Realize_Relationship") != -1) continue;
                idInfo3.setStatus(4);
                idInfo3.setChildrenStatusToDelete();
            }
        }
    }

    private void createIdInfoInBase(IdInfo idInfo) {
        IdInfo idInfo2;
        int n;
        Object object;
        if (!idInfo.isBeingVisited() && (object = idInfo.getParent()) != null) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Id id;
            n = 1;
            idInfo2 = ((IdInfo)object).getReferenceIdInfo();
            Id id2 = idInfo.getId();
            String string = ModelElements.getName(id2);
            if (string != null && string.equals("IDL_DATATYPE")) {
                id = idInfo2.getId();
                object5 = new Vector();
                ((Vector)object5).addElement(Property.NAME);
                ((Vector)object5).addElement(string);
                object4 = ModelElements.get(id, id2.getType(), (Vector)object5, false);
                if (object4 != null && ((Vector)object4).size() == 1) {
                    object3 = (Id)((Vector)object4).elementAt(0);
                    object2 = this.getIdInfoFromId((Id)object3, this.baseModelIdInfo);
                    ((IdInfo)object2).setStatus(1);
                    idInfo.setStatus(1);
                    idInfo.visited(true);
                    ((IdInfo)object2).setReferenceIdInfo(idInfo);
                    idInfo.setReferenceIdInfo((IdInfo)object2);
                    n = 0;
                }
            }
            if ((id = ((IdInfo)object).getId()).getType() == Type.PACKAGE && ((String)(object5 = ModelElements.getName(id))).equals("IDL_DATATYPE") && (object4 = idInfo2.getId()) != null) {
                object3 = new Vector<Object>();
                ((Vector)object3).addElement(Property.NAME);
                ((Vector)object3).addElement(ModelElements.getName(id2));
                object2 = ModelElements.get((Id)object4, id2.getType(), object3, false);
                if (object2 != null && ((Vector)object2).size() == 1) {
                    Id id3 = (Id)((Vector)object2).elementAt(0);
                    IdInfo idInfo3 = this.getIdInfoFromId(id3, this.baseModelIdInfo);
                    idInfo3.setStatus(1);
                    idInfo.setStatus(1);
                    idInfo.visited(true);
                    idInfo3.setReferenceIdInfo(idInfo);
                    idInfo.setReferenceIdInfo(idInfo3);
                    n = 0;
                }
            }
            if (n != 0) {
                object5 = new IdInfo(null, idInfo.getLocalHashValue(), idInfo.getGlobalHashValue(), idInfo.getPropertiesHashValue(), idInfo.getDefaultSetHashValue(), idInfo.getSetsHashValue(), idInfo.getLinksHashValue(), 3, true);
                idInfo2.addNode((IdInfo)object5);
                idInfo.setStatus(3);
                idInfo.visited(true);
                ((IdInfo)object5).setReferenceIdInfo(idInfo);
                idInfo.setReferenceIdInfo((IdInfo)object5);
            }
        }
        if ((object = idInfo.getNodes()) != null && ((Vector)object).size() > 0) {
            for (n = 0; n < ((Vector)object).size(); ++n) {
                idInfo2 = (IdInfo)((Vector)object).elementAt(n);
                this.createIdInfoInBase(idInfo2);
            }
        }
    }

    private boolean deleteFromBaseModel(IdInfo idInfo) {
        if (idInfo.getStatus() == 4) {
            IdInfo idInfo2 = idInfo.getParent();
            ModelElements.delete(idInfo.getId());
            idInfo2.getNodes().removeElement(idInfo);
            return true;
        }
        Vector vector = idInfo.getNodes();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                IdInfo idInfo3 = (IdInfo)vector.elementAt(n);
                if (this.deleteFromBaseModel(idInfo3)) continue;
                ++n;
            }
        }
        return false;
    }

    public void differencing() {
        this.differencing(false);
    }

    public void differencing(boolean bl) {
        if (this.baseHashTable.size() != 0) {
            Enumeration enumeration = this.baseHashTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                IdInfo idInfo = (IdInfo)this.baseHashTable.get(string);
                if (idInfo.isBeingVisited()) continue;
                IdInfo idInfo2 = (IdInfo)this.refHashTable.get(string);
                if (idInfo2 != null) {
                    this.compare(idInfo, idInfo2, bl);
                    continue;
                }
                idInfo.visited(true);
                Id id = idInfo.getId();
                if (bl) {
                    String string2;
                    if (id.getType() == Type.XMI_EXTENSION) {
                        String string3 = ModelElements.get(id, Property.XMI_EXTENDER);
                        string2 = ModelElements.get(id, Property.XMI_EXTENDER_ID);
                        if (!(string3.equals("Rose") || string2.equals("Rose") || string3.equals("UMLNotation") || string3.equals("UMLNotation"))) {
                            idInfo.setStatus(4);
                            idInfo.setChildrenStatusToDelete();
                            continue;
                        }
                        boolean bl2 = true;
                        if (string3.equals("Rose") && string2.equals("Rose") && id.getUUID().indexOf("Realize_Relationship") != -1) {
                            idInfo.setStatus(4);
                            idInfo.setChildrenStatusToDelete();
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        idInfo.setChildrenVisitedToTrue();
                        continue;
                    }
                    if (id.getType() == Type.EXTENSION || id.getType() == Type.VIEW_ELEMENT || id.getType() == Type.PRESENTATION) {
                        boolean bl3 = true;
                        if (id.getType() == Type.EXTENSION && (string2 = ModelElements.getName(id)) != null && string2.equals("Realize_Relationship")) {
                            idInfo.setStatus(4);
                            idInfo.setChildrenStatusToDelete();
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        idInfo.setChildrenVisitedToTrue();
                        continue;
                    }
                    if (this.forVAJ) {
                        if (id.getType() == Type.DEPENDENCY) {
                            idInfo.setChildrenVisitedToTrue();
                            continue;
                        }
                        idInfo.setStatus(4);
                        idInfo.setChildrenStatusToDelete();
                        continue;
                    }
                    idInfo.setStatus(4);
                    idInfo.setChildrenStatusToDelete();
                    continue;
                }
                if (this.forVAJ) {
                    if (id.getType() == Type.DEPENDENCY) {
                        idInfo.setChildrenVisitedToTrue();
                        continue;
                    }
                    idInfo.setStatus(4);
                    idInfo.setChildrenStatusToDelete();
                    continue;
                }
                idInfo.setStatus(4);
                idInfo.setChildrenStatusToDelete();
            }
        }
        this.createIdInfoInBase(this.refModelIdInfo);
        if (debug) {
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("===== Base model after differencing =====");
            this.showIdInfo(this.baseModelIdInfo, 0);
            System.out.println("===== Reference model after differencing=====");
            this.showIdInfo(this.refModelIdInfo, 0);
        }
    }

    public IdInfo getbaseModelIdInfo() {
        return this.baseModelIdInfo;
    }

    public Id getIdByName(Id id, Type type, String string) {
        Vector vector = ModelElements.get(id, type, true);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string2 = ModelElements.getName(id2);
                if (string2 == null || !string2.equals(string)) continue;
                return id2;
            }
        } else {
            return null;
        }
        return null;
    }

    public Id getIdByQUID(Id id, Type type, String string) {
        Vector vector = ModelElements.get(id, type, true);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string2 = ModelElements.get(id2, "Rose", "quid");
                if (string2 == null || !string2.equals(string)) continue;
                return id2;
            }
        } else {
            return null;
        }
        return null;
    }

    public Id getIdByUUID(Id id, Type type, String string) {
        Vector vector = ModelElements.get(id, type, true);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                if (!id2.getUUID().equals(string)) continue;
                return id2;
            }
        } else {
            return null;
        }
        return null;
    }

    private IdInfo getIdInfoFromId(Id id, IdInfo idInfo) {
        IdInfo idInfo2 = null;
        if (idInfo.getId() == id) {
            idInfo2 = idInfo;
            return idInfo2;
        }
        Vector vector = idInfo.getNodes();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                idInfo2 = this.getIdInfoFromId(id, (IdInfo)vector.elementAt(i));
                if (idInfo2 == null) continue;
                return idInfo2;
            }
        }
        return idInfo2;
    }

    public IdInfo getrefModelIdInfo() {
        return this.refModelIdInfo;
    }

    public static void main(String[] stringArray) {
        Vector vector;
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 1;
        if (stringArray.length == 0) {
            System.out.println("Valid arguments are:");
            System.out.println("-baseRoseFile \t-- Rose mdl file as base model");
            System.out.println("-refRoseFile \t-- Rose mdl file as reference model");
            System.out.println("");
            System.out.println("-baseXMIFile       -- xml file as base model");
            System.out.println("-baseModelPath     -- ModelPath variable to search xml file");
            System.out.println("-refXMIFile        -- xml file as reference model");
            System.out.println("-refModelPath      -- ModelPath variable to search xml file");
            System.out.println("");
            System.out.println("-uuid              -- differencing and merging based on uuid");
            System.out.println("-quid              -- differencing and merging based on quid");
            System.out.println("-diff              -- differencing only");
            System.out.println("");
            System.out.println("-xml               -- output to xml file");
            System.out.println("-rose              -- output to rose file");
            System.out.println("-stopAtUnit");
            System.out.println("-debug");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-baseRoseFile") && i + 1 < stringArray.length) {
                string = stringArray[i + 1];
            } else if (stringArray[i].equals("-refRoseFile") && i + 1 < stringArray.length) {
                string2 = stringArray[i + 1];
            }
            if (stringArray[i].equals("-baseXMIFile") && i + 1 < stringArray.length) {
                string3 = stringArray[i + 1];
            }
            if (stringArray[i].equals("-baseModelPath") && i + 1 < stringArray.length) {
                string4 = stringArray[i + 1];
            } else if (stringArray[i].equals("-refXMIFile") && i + 1 < stringArray.length) {
                string5 = stringArray[i + 1];
            }
            if (stringArray[i].equals("-refModelPath") && i + 1 < stringArray.length) {
                string6 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-xml") && i + 1 < stringArray.length) {
                string7 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-rose") && i + 1 < stringArray.length) {
                string8 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-uuid")) {
                n = 1;
                continue;
            }
            if (stringArray[i].equals("-quid")) {
                n = 0;
                continue;
            }
            if (!stringArray[i].equals("-diff")) continue;
            bl2 = true;
        }
        if (bl) {
            debug = true;
        }
        Id id = null;
        Id id2 = null;
        DiffMergeTool diffMergeTool = new DiffMergeTool();
        if (bl3) {
            stopAtUnit = true;
        }
        if (!string.equals("")) {
            try {
                object = new RoseUtil();
                ((RoseUtil)object).rLoad(string, true, "", false, false, false, false, true);
                id = RoseUtil.modelId;
                System.out.println("baseModelId : " + id);
                diffMergeTool.buildBaseModel(id, n);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (!string2.equals("")) {
            try {
                object = new RoseUtil();
                ((RoseUtil)object).rLoad(string2, true, "", false, false, false, false, true);
                id2 = RoseUtil.modelId;
                System.out.println("refModelId: " + id2);
                diffMergeTool.buildReferenceModel(id2, n);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (!string3.equals("")) {
            try {
                object = new UML();
                ((UML)object).setFilePath(string4);
                vector = ((UML)object).load(string3, new Vector(), 1, false);
                if (vector != null && vector.size() == 1) {
                    id = (Id)vector.elementAt(0);
                    diffMergeTool.buildBaseModel(id, n);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (!string5.equals("")) {
            try {
                object = new UML();
                ((UML)object).setFilePath(string6);
                vector = ((UML)object).load(string5, new Vector(), 1, false);
                if (vector != null && vector.size() == 1) {
                    id2 = (Id)vector.elementAt(0);
                    diffMergeTool.buildReferenceModel(id2, n);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        diffMergeTool.differencing();
        if (!bl2) {
            diffMergeTool.merging();
            if (!string7.equals("")) {
                try {
                    id.save(string7, 1);
                }
                catch (Exception exception) {
                    System.out.println(exception + " thrown from save function");
                }
            }
            if (!string8.equals("")) {
                object = new RoseUtil();
                ((RoseUtil)object).rSave(string8, id, "");
            }
        }
    }

    public void merging() {
        this.deleteFromBaseModel(this.baseModelIdInfo);
        this.addToBaseModel(this.baseModelIdInfo);
        this.updateInBaseModel(this.baseModelIdInfo);
        this.processForLinks(this.baseModelIdInfo);
        Id id = this.baseModelIdInfo.getId();
        if (this.baseModelIdInfo.getStatus() == 2 || id.getType() == Type.PACKAGE) {
            IdInfo idInfo = this.baseModelIdInfo.getReferenceIdInfo();
            Vector vector = ModelElements.get(id, Link.NAMESPACE, false);
            Id id2 = null;
            Id id3 = null;
            if (vector != null && vector.size() == 1) {
                id2 = (Id)vector.elementAt(0);
            }
            if ((vector = ModelElements.get(idInfo.getId(), Link.NAMESPACE, false)) != null && vector.size() == 1) {
                id3 = (Id)vector.elementAt(0);
            }
            if (id2 != null && id3 != null) {
                Object object;
                Object object2;
                boolean bl = false;
                if (this.option == 1) {
                    if (!id2.getUUID().equals(id3.getUUID())) {
                        bl = true;
                    }
                } else if (this.option == 0 && !((String)(object2 = ModelElements.get(id2, "Rose", "quid"))).equals(object = ModelElements.get(id3, "Rose", "quid"))) {
                    bl = true;
                }
                if (bl) {
                    ModelElements.delete(id, Link.NAMESPACE, id2);
                    object2 = id.getAPI();
                    object = ((UML)object2).getId(id3.getUUID());
                    if (object == null) {
                        object = ModelElements.addConstruct(((UML)object2).getSession(), id3.getType(), ModelElements.getName(id3));
                        ModelElements.setUUID((Id)object, id3.getUUID());
                        ModelElements.set((Id)object, "", "xmiFile", ModelElements.get(id3, "", "xmiFile"));
                        ModelElements.set((Id)object, "", "is_unit", ModelElements.get(id3, "", "is_unit"));
                    }
                    if (object != null) {
                        ModelElements.add(id, Link.NAMESPACE, (Id)object);
                    }
                }
            }
        }
        if (debug) {
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("===== Base model after merging =====");
            this.showIdInfo(this.baseModelIdInfo, 0);
        }
    }

    private void processForLinks(IdInfo idInfo) {
        Object object;
        if (idInfo.getStatus() == 2 || idInfo.getStatus() == 3) {
            object = idInfo.getReferenceIdInfo();
            idInfo.calculateLinksHashValue();
            if (idInfo.getLinksHashValue() != ((IdInfo)object).getLinksHashValue()) {
                Id id = idInfo.getId();
                Id id2 = ((IdInfo)object).getId();
                this.updateLinks(id, id2);
            }
        }
        if ((object = idInfo.getNodes()) != null && ((Vector)object).size() > 0) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.processForLinks((IdInfo)((Vector)object).elementAt(i));
            }
        }
    }

    private void setDefaultProperties(Id id, Id id2) {
        Vector vector = ModelElements.getTags(id2, "");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = ModelElements.get(id2, "", string);
                if (string2 == null) continue;
                ModelElements.set(id, "", string, string2);
            }
        }
    }

    private void setProperties(Id id, Id id2) {
        Vector vector = ModelElements.getProperties(id2);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Property property = (Property)vector.elementAt(i);
                String string = ModelElements.get(id2, property);
                if (string == null) continue;
                ModelElements.set(id, property, string);
            }
        }
    }

    private void setTagValueProperties(Id id, Id id2) {
        Vector vector = ModelElements.getSets(id2);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                Vector vector2 = ModelElements.getTags(id2, string);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    String string2 = (String)vector2.elementAt(j);
                    String string3 = ModelElements.get(id2, string, string2);
                    if (string3 == null) continue;
                    ModelElements.set(id, string, string2, string3);
                }
            }
        }
    }

    public void setVAJavaFlag(boolean bl) {
        this.forVAJ = bl;
    }

    private void showHashTable(Hashtable hashtable) {
        if (hashtable.size() != 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                IdInfo idInfo = (IdInfo)hashtable.get(string);
                String string2 = ModelElements.getName(idInfo.getId());
                if (string2 != null && !string2.equals("")) {
                    System.out.println(string + ", " + string2 + ", " + idInfo.getLocalHashValue() + ", " + idInfo.getGlobalHashValue());
                    continue;
                }
                System.out.println(string + ", " + "[Type]:" + idInfo.getId().getType() + ", " + idInfo.getLocalHashValue() + ", " + idInfo.getGlobalHashValue());
            }
        }
    }

    private void showIdInfo(IdInfo idInfo, int n) {
        String string;
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "\t";
        }
        Id id = idInfo.getId();
        if (id == null) {
            id = idInfo.getReferenceId();
        }
        if ((string = ModelElements.getName(id)) != null && !string.equals("")) {
            System.out.println(string2 + string + ", " + idInfo.getLocalHashValue() + ", " + idInfo.getGlobalHashValue() + ", " + idInfo.getPropertiesHashValue() + ", " + idInfo.getDefaultSetHashValue() + ", " + idInfo.getSetsHashValue() + ", " + idInfo.getLinksHashValue() + ", " + idInfo.getStatus() + ", " + idInfo.isBeingVisited() + ", " + idInfo.getReferenceIdInfo());
        } else {
            System.out.println(string2 + "[Type]:" + id.getType() + ", " + idInfo.getLocalHashValue() + ", " + idInfo.getGlobalHashValue() + ", " + idInfo.getPropertiesHashValue() + ", " + idInfo.getDefaultSetHashValue() + ", " + idInfo.getSetsHashValue() + ", " + idInfo.getLinksHashValue() + ", " + idInfo.getStatus() + ", " + idInfo.isBeingVisited() + ", " + idInfo.getReferenceIdInfo());
        }
        Vector vector = idInfo.getNodes();
        if (vector != null && vector.size() > 0) {
            ++n;
            for (int i = 0; i < vector.size(); ++i) {
                IdInfo idInfo2 = (IdInfo)vector.elementAt(i);
                this.showIdInfo(idInfo2, n);
            }
        }
    }

    private void updateInBaseModel(IdInfo idInfo) {
        Object object;
        if (idInfo.getStatus() == 2) {
            Object object2;
            int n;
            Vector vector;
            object = idInfo.getId();
            IdInfo idInfo2 = idInfo.getReferenceIdInfo();
            Id id = idInfo.getReferenceId();
            if (idInfo.getPropertiesHashValue() != idInfo2.getPropertiesHashValue()) {
                vector = ModelElements.getProperties((Id)object);
                if (vector != null) {
                    for (n = 0; n < vector.size(); ++n) {
                        object2 = (Property)vector.elementAt(n);
                        if (ModelElements.get(id, (Property)object2) != null) {
                            ModelElements.set((Id)object, (Property)object2, null);
                            continue;
                        }
                        if (object2 != Property.ME_VISIBILITY) continue;
                        ModelElements.set((Id)object, (Property)object2, null);
                    }
                }
                this.setProperties((Id)object, id);
            }
            if (idInfo.getDefaultSetHashValue() != idInfo2.getDefaultSetHashValue()) {
                vector = ModelElements.getTags((Id)object, "");
                if (vector != null) {
                    for (n = 0; n < vector.size(); ++n) {
                        object2 = (String)vector.elementAt(n);
                        if (ModelElements.get(id, "", (String)object2) == null) continue;
                        ModelElements.set((Id)object, "", (String)object2, null);
                    }
                }
                this.setDefaultProperties((Id)object, id);
            }
            if (idInfo.getSetsHashValue() != idInfo2.getSetsHashValue()) {
                vector = ModelElements.getSets((Id)object);
                if (vector != null) {
                    for (n = 0; n < vector.size(); ++n) {
                        object2 = (String)vector.elementAt(n);
                        Vector vector2 = ModelElements.getTags((Id)object, (String)object2);
                        if (vector2 == null) continue;
                        for (int i = 0; i < vector2.size(); ++i) {
                            String string = (String)vector2.elementAt(i);
                            if (ModelElements.get(id, (String)object2, string) == null) continue;
                            ModelElements.set((Id)object, (String)object2, string, null);
                        }
                    }
                }
                this.setTagValueProperties((Id)object, id);
            }
        }
        if ((object = idInfo.getNodes()) != null && ((Vector)object).size() > 0) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.updateInBaseModel((IdInfo)((Vector)object).elementAt(i));
            }
        }
    }

    private void updateLinks(Id id, Id id2) {
        IdInfo idInfo;
        Id id3;
        int n;
        Vector vector;
        Link link;
        int n2;
        Vector vector2 = ModelElements.getLinks(id);
        if (vector2 != null) {
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                link = (Link)vector2.elementAt(n2);
                if (link == Link.OWNED_ELEMENT || link == Link.NAMESPACE || link == Link.OWNER || link == Link.BEHAVIORAL_FEATURE || keepStereotype && link == Link.ME_STEREOTYPE || (vector = ModelElements.get(id, link, false)) == null) continue;
                for (n = 0; n < vector.size(); ++n) {
                    id3 = (Id)vector.elementAt(n);
                    idInfo = this.getIdInfoFromId(id3, this.baseModelIdInfo);
                    if (idInfo == null) {
                        ModelElements.delete(id, link, id3);
                        continue;
                    }
                    if (idInfo.getStatus() != 1) {
                        ModelElements.delete(id, link, id3);
                        continue;
                    }
                    if (link != Link.SF_TYPE && link != Link.PARM_TYPE && link != Link.ME_STEREOTYPE) continue;
                    ModelElements.delete(id, link, id3);
                }
            }
        }
        if ((vector2 = ModelElements.getLinks(id2)) != null) {
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                link = (Link)vector2.elementAt(n2);
                if (link == Link.OWNED_ELEMENT || link == Link.NAMESPACE || link == Link.OWNER || link == Link.BEHAVIORAL_FEATURE || (vector = ModelElements.get(id2, link, false)) == null) continue;
                for (n = 0; n < vector.size(); ++n) {
                    Object object;
                    Object object2;
                    Object object3;
                    id3 = (Id)vector.elementAt(n);
                    idInfo = this.getIdInfoFromId(id3, this.refModelIdInfo);
                    if (idInfo != null) {
                        object3 = idInfo.getReferenceIdInfo();
                        boolean bl = true;
                        object2 = ModelElements.get(id, link, false);
                        if (object2 != null) {
                            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                                object = (Id)((Vector)object2).elementAt(i);
                                if (object != ((IdInfo)object3).getId()) continue;
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        ModelElements.add(id, link, ((IdInfo)object3).getId());
                        continue;
                    }
                    if (id.getType() == Type.ASSOCIATION_END && link == Link.AE_TYPE || id.getType() == Type.GENERALIZATION && link == Link.SUPERTYPE || id.getType() == Type.DEPENDENCY && link == Link.SUPPLIER || id.getType() == Type.PRESENTATION && link == Link.P_MODEL || id.getType() == Type.PARAMETER && link == Link.PARM_TYPE || id.getType() == Type.ATTRIBUTE && link == Link.SF_TYPE || id.getType() == Type.EXTENSION && link == Link.EXTENSION_REFERENCE || id.getType() == Type.CLASS && link == Link.CL_ASSOCIATION_END) {
                        UML uML;
                        object3 = id.getAPI();
                        if (object3 != (uML = id3.getAPI())) {
                            object2 = null;
                            if (this.option == 1) {
                                ((UML)object3).setDemandLoad(false);
                                object2 = this.getIdByUUID(((UML)object3).getSession(), id3.getType(), id3.getUUID());
                                ((UML)object3).setDemandLoad(true);
                                object2 = ((UML)object3).getId(id3.getUUID());
                            } else if (this.option == 0) {
                                String string = ModelElements.get(id3, "Rose", "quid");
                                if (string != null && !string.equals("")) {
                                    ((UML)object3).setDemandLoad(false);
                                    object2 = this.getIdByQUID(((UML)object3).getSession(), id3.getType(), string);
                                    ((UML)object3).setDemandLoad(true);
                                    object2 = ((UML)object3).getId(id3.getUUID());
                                } else {
                                    object = ModelElements.getName(id3);
                                    ((UML)object3).setDemandLoad(false);
                                    object2 = this.getIdByName(((UML)object3).getSession(), id3.getType(), (String)object);
                                    ((UML)object3).setDemandLoad(true);
                                    object2 = ((UML)object3).getId(id3.getUUID());
                                }
                            }
                            if (object2 == null) {
                                object2 = ModelElements.addConstruct(((UML)object3).getSession(), id3.getType(), ModelElements.getName(id3));
                                ModelElements.setUUID((Id)object2, id3.getUUID());
                                String string = ModelElements.get(id3, "Rose", "quid");
                                if (string != null) {
                                    ModelElements.set((Id)object2, "Rose", "quid", string);
                                }
                                ModelElements.set((Id)object2, "", "xmiFile", ModelElements.get(id3, "", "xmiFile"));
                                ModelElements.set((Id)object2, "", "is_unit", ModelElements.get(id3, "", "is_unit"));
                            }
                            if (object2 == null) continue;
                            ModelElements.add(id, link, (Id)object2);
                            continue;
                        }
                        ModelElements.add(id, link, id3);
                        continue;
                    }
                    object3 = ModelElements.create(id.getAPI(), id3.getType());
                    this.setProperties((Id)object3, id3);
                    ModelElements.add(id, link, (Id)object3);
                }
            }
        }
    }
}

