/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.validation.ejb;

import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.j2ee.validation.IValidationContext;
import com.ibm.etools.j2ee.validation.ejb.AbstractEJBValidationRuleFactory;
import com.ibm.etools.j2ee.validation.ejb.IValidationRuleList;
import com.ibm.etools.j2ee.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.EJBJar11VRule;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.EnterpriseBean11VRule;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateBMPBean;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateBMPHome;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateBMPKey;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateBMPRemote;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateCMPBean;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateCMPKey;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateCMPRemote;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateSessionBean;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateSessionHome;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.ValidateSessionRemote;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.BMPBeanClassVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.BMPKeyClassVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.BMPLocalComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.BMPLocalHomeVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.BMPRemoteComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.BMPRemoteHomeVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.CMPBeanClassVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.CMPKeyClassVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.CMPLocalComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.CMPLocalHomeVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.CMPRemoteComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.CMPRemoteHomeVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.EJBJar20VRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.EnterpriseBean20VRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.MessageDrivenBeanClassVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatefulSessionBeanClassVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatefulSessionLocalComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatefulSessionLocalHomeVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatefulSessionRemoteComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatefulSessionRemoteHomeVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatelessSessionBeanClassVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatelessSessionLocalComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatelessSessionLocalHomeVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatelessSessionRemoteComponentVRule;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.StatelessSessionRemoteHomeVRule;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.wtp.common.logger.proxy.Logger;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.jem.java.JavaClass;

public class EJBValidationRuleFactory
extends AbstractEJBValidationRuleFactory {
    private static EJBValidationRuleFactory _inst = null;
    private Logger logger = null;

    public EJBValidationRuleFactory() {
        this.createRuleList();
    }

    public static EJBValidationRuleFactory getFactory() {
        if (_inst == null) {
            _inst = new EJBValidationRuleFactory();
        }
        return _inst;
    }

    protected Logger getMsgLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("com.ibm.etools.j2ee.core");
        }
        return this.logger;
    }

    private void createRuleList() {
        this._ruleList = new HashMap();
        this._ruleList.put(IValidationRuleList.EJB11_EJBJAR, new EJBJar11VRule());
        this._ruleList.put(IValidationRuleList.EJB20_EJBJAR, new EJBJar20VRule());
        this._ruleList.put(IValidationRuleList.EJB11_ENTERPRISEBEAN, new EnterpriseBean11VRule());
        this._ruleList.put(IValidationRuleList.EJB20_ENTERPRISEBEAN, new EnterpriseBean20VRule());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_BEANCLASS, new ValidateSessionBean());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_REMOTE, new ValidateSessionRemote());
        this._ruleList.put(IValidationRuleList.EJB11_SESSION_HOME, new ValidateSessionHome());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS, new StatelessSessionBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE, new StatelessSessionRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_HOME, new StatelessSessionRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL, new StatelessSessionLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME, new StatelessSessionLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS, new StatefulSessionBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE, new StatefulSessionRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, new StatefulSessionRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, new StatefulSessionLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, new StatefulSessionLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_BEANCLASS, new ValidateCMPBean());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_REMOTE, new ValidateCMPRemote());
        this._ruleList.put(IValidationRuleList.EJB11_CMP_KEYCLASS, new ValidateCMPKey());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_BEANCLASS, new CMPBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_REMOTE, new CMPRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_HOME, new CMPRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_LOCAL, new CMPLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_LOCALHOME, new CMPLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_CMP_KEYCLASS, new CMPKeyClassVRule());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_BEANCLASS, new ValidateBMPBean());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_REMOTE, new ValidateBMPRemote());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_HOME, new ValidateBMPHome());
        this._ruleList.put(IValidationRuleList.EJB11_BMP_KEYCLASS, new ValidateBMPKey());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_BEANCLASS, new BMPBeanClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_REMOTE, new BMPRemoteComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_HOME, new BMPRemoteHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_LOCAL, new BMPLocalComponentVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_LOCALHOME, new BMPLocalHomeVRule());
        this._ruleList.put(IValidationRuleList.EJB20_BMP_KEYCLASS, new BMPKeyClassVRule());
        this._ruleList.put(IValidationRuleList.EJB20_MESSAGE_BEANCLASS, new MessageDrivenBeanClassVRule());
        this.addDependentRuleToRuleList();
        this.logAllDependentRules();
    }

    public final Object getRuleId(IValidationContext vc, IFileDelta delta) {
        if (delta == null) {
            Logger logger = vc.getMsgLogger();
            if (logger != null && logger.isLoggingLevel(Level.FINE)) {
                logger.write(Level.FINE, "Cannot load rule from delta: " + delta);
            }
            return null;
        }
        return this.getRuleId(vc, delta.getFileName());
    }

    public Object getRuleId(IValidationContext vc, String fileName) {
        if (fileName == null) {
            Logger logger = vc.getMsgLogger();
            if (logger != null && logger.isLoggingLevel(Level.FINE)) {
                logger.write(Level.FINE, "Cannot load rule from fileName: " + fileName);
            }
            return null;
        }
        EJBJar ejbJar = this.getEJBJar(vc);
        if (fileName.endsWith("ejb-jar.xml")) {
            if (ejbJar.getVersionID() == 11) {
                return IValidationRuleList.EJB11_EJBJAR;
            }
            return IValidationRuleList.EJB20_EJBJAR;
        }
        return null;
    }

    public final Object getRuleId(IValidationContext vc, JavaClass clazz, EnterpriseBean bean) {
        Logger logger;
        boolean isStatefulSession;
        if (clazz == null || bean == null) {
            Logger logger2 = vc.getMsgLogger();
            if (logger2 != null && logger2.isLoggingLevel(Level.FINE)) {
                logger2.write(Level.FINE, "Cannot load rule because either bean (" + bean + ") or class (" + clazz + ") is null");
            }
            return null;
        }
        boolean isStatelessSession = bean.isSession() && ValidationRuleUtility.isStateless(bean);
        boolean bl = isStatefulSession = bean.isSession() && ValidationRuleUtility.isStateful(bean);
        if (bean.getVersionID() >= 20) {
            if (clazz.equals(bean.getEjbClass())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_BEANCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_BEANCLASS;
                }
                if (bean.isMessageDriven()) {
                    return IValidationRuleList.EJB20_MESSAGE_BEANCLASS;
                }
                Logger logger3 = vc.getMsgLogger();
                if (logger3 != null && logger3.isLoggingLevel(Level.FINE)) {
                    logger3.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getEjbClass()");
                }
                return null;
            }
            if (clazz.equals(bean.getRemoteInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_REMOTE;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_REMOTE;
                }
                Logger logger4 = vc.getMsgLogger();
                if (logger4.isLoggingLevel(Level.FINE)) {
                    logger4.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getRemoteInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getHomeInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_HOME;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_HOME;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_HOME;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_HOME;
                }
                Logger logger5 = vc.getMsgLogger();
                if (logger5.isLoggingLevel(Level.FINE)) {
                    logger5.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getHomeInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getLocalHomeInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_LOCALHOME;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_LOCALHOME;
                }
                Logger logger6 = vc.getMsgLogger();
                if (logger6.isLoggingLevel(Level.FINE)) {
                    logger6.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getLocalHomeInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getLocalInterface())) {
                if (isStatelessSession) {
                    return IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL;
                }
                if (isStatefulSession) {
                    return IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB20_CMP_LOCAL;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_LOCAL;
                }
                Logger logger7 = vc.getMsgLogger();
                if (logger7.isLoggingLevel(Level.FINE)) {
                    logger7.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(bean.getLocalInterface()");
                }
                return null;
            }
            if (bean instanceof Entity && clazz.equals(((Entity)bean).getPrimaryKey())) {
                if (bean.isContainerManagedEntity()) {
                    ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
                    if (ValidationRuleUtility.isPrimitivePrimaryKey(cmp)) {
                        return null;
                    }
                    if (ValidationRuleUtility.usesUnknownPrimaryKey(cmp)) {
                        return null;
                    }
                    return IValidationRuleList.EJB20_CMP_KEYCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB20_BMP_KEYCLASS;
                }
                Logger logger8 = vc.getMsgLogger();
                if (logger8.isLoggingLevel(Level.FINE)) {
                    logger8.write(Level.FINE, "Cannot load rule: bean.isVersion2_X() && clazz.equals(((Entity)bean).getPrimaryKey()");
                }
                return null;
            }
            Logger logger9 = vc.getMsgLogger();
            if (logger9.isLoggingLevel(Level.FINE)) {
                logger9.write(Level.FINE, "Cannot load rule: bean.isVersion2_X()");
            }
            return null;
        }
        if (bean.getVersionID() <= 11) {
            if (clazz.equals(bean.getEjbClass())) {
                if (bean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_BEANCLASS;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_BEANCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_BEANCLASS;
                }
                Logger logger10 = vc.getMsgLogger();
                if (logger10.isLoggingLevel(Level.FINE)) {
                    logger10.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getEjbClass()");
                }
                return null;
            }
            if (clazz.equals(bean.getRemoteInterface())) {
                if (bean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_REMOTE;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_REMOTE;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_REMOTE;
                }
                Logger logger11 = vc.getMsgLogger();
                if (logger11.isLoggingLevel(Level.FINE)) {
                    logger11.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getRemoteInterface()");
                }
                return null;
            }
            if (clazz.equals(bean.getHomeInterface())) {
                if (bean.isSession()) {
                    return IValidationRuleList.EJB11_SESSION_HOME;
                }
                if (bean.isContainerManagedEntity()) {
                    return IValidationRuleList.EJB11_CMP_HOME;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_HOME;
                }
                Logger logger12 = vc.getMsgLogger();
                if (logger12.isLoggingLevel(Level.FINE)) {
                    logger12.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(bean.getHomeInterface()");
                }
                return null;
            }
            if (bean instanceof Entity && clazz.equals(((Entity)bean).getPrimaryKey())) {
                if (bean.isContainerManagedEntity()) {
                    ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
                    if (ValidationRuleUtility.isPrimitivePrimaryKey(cmp)) {
                        return null;
                    }
                    if (ValidationRuleUtility.usesUnknownPrimaryKey(cmp)) {
                        return null;
                    }
                    return IValidationRuleList.EJB11_CMP_KEYCLASS;
                }
                if (bean.isBeanManagedEntity()) {
                    return IValidationRuleList.EJB11_BMP_KEYCLASS;
                }
                Logger logger13 = vc.getMsgLogger();
                if (logger13.isLoggingLevel(Level.FINE)) {
                    logger13.write(Level.FINE, "Cannot load rule: bean.isVersion1_X() && clazz.equals(((Entity)bean).getPrimaryKey()");
                }
                return null;
            }
        }
        if ((logger = vc.getMsgLogger()).isLoggingLevel(Level.FINE)) {
            logger.write(Level.FINE, "Cannot load rule: !bean.isVersion1_X() && !bean.isVersion2_X()");
        }
        return null;
    }
}

