/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration;

import com.ibm.etools.j2ee.migration.J2EEMigrationStatus;

public class J2EEMigrationMultiStatus
extends J2EEMigrationStatus {
    private J2EEMigrationStatus[] children = new J2EEMigrationStatus[0];

    public void add(J2EEMigrationStatus status) {
        J2EEMigrationStatus[] result = new J2EEMigrationStatus[this.children.length + 1];
        System.arraycopy(this.children, 0, result, 0, this.children.length);
        result[result.length - 1] = status;
        this.children = result;
        int newSev = status.getSeverity();
        int currentSev = this.getSeverity();
        if (this.children.length == 1) {
            this.setSeverity(newSev);
        } else if (currentSev > 0 && currentSev < 3 && newSev == 0) {
            this.setSeverity(newSev);
        } else if (newSev > currentSev && (currentSev != 0 || newSev >= 3)) {
            this.setSeverity(newSev);
        }
    }

    public void addAll(J2EEMigrationStatus status) {
        if (status == null) {
            return;
        }
        J2EEMigrationStatus[] statuses = status.getChildren();
        int i = 0;
        while (i < statuses.length) {
            this.add(statuses[i]);
            ++i;
        }
    }

    public J2EEMigrationStatus[] getChildren() {
        return this.children;
    }

    public boolean isMultiStatus() {
        return true;
    }

    public void merge(J2EEMigrationStatus status) {
        if (status == null) {
            return;
        }
        if (!status.isMultiStatus()) {
            this.add(status);
        } else {
            this.addAll(status);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" children={");
        int i = 0;
        while (i < this.children.length) {
            if (i != 0) {
                buf.append("\n");
            }
            buf.append(this.children[i].toString());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public J2EEMigrationStatus append(J2EEMigrationStatus aStatus) {
        if (aStatus != null) {
            this.merge(aStatus);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.children.length == 0;
    }
}

