/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DeleteOnExitUtility {
    private static Set tempFilesToDelete;
    private static boolean initialized;
    private static int cleanupCount;
    private static final int CLEANUP_THRESHOLD = 10000;

    static {
        initialized = false;
        cleanupCount = 0;
    }

    public static void markForDeletion(File file) {
        if (!initialized) {
            initialized = true;
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    public void run() {
                        if (tempFilesToDelete != null) {
                            Set set = tempFilesToDelete;
                            synchronized (set) {
                                Iterator iterator = tempFilesToDelete.iterator();
                                File file = null;
                                while (iterator.hasNext()) {
                                    try {
                                        file = (File)iterator.next();
                                        if (!file.exists()) continue;
                                        file.delete();
                                    }
                                    catch (SecurityException securityException) {}
                                }
                            }
                        }
                    }
                }));
                tempFilesToDelete = new HashSet();
            }
            catch (SecurityException securityException) {}
        }
        if (tempFilesToDelete != null) {
            Set set = tempFilesToDelete;
            synchronized (set) {
                tempFilesToDelete.add(file);
            }
            if (++cleanupCount > 10000) {
                DeleteOnExitUtility.runCleanup();
            }
        }
    }

    public static void fileHasBeenDeleted(File file) {
        if (tempFilesToDelete != null) {
            Set set = tempFilesToDelete;
            synchronized (set) {
                ++cleanupCount;
                try {
                    if (!file.exists()) {
                        tempFilesToDelete.remove(file);
                    }
                }
                catch (SecurityException securityException) {}
            }
            if (cleanupCount > 10000) {
                DeleteOnExitUtility.runCleanup();
            }
        }
    }

    public static void runCleanup() {
        if (tempFilesToDelete != null) {
            Set set = tempFilesToDelete;
            synchronized (set) {
                cleanupCount = 0;
                ArrayList<File> filesToRemove = null;
                Iterator iterator = tempFilesToDelete.iterator();
                File file = null;
                while (iterator.hasNext()) {
                    try {
                        file = (File)iterator.next();
                        if (file.exists()) continue;
                        if (filesToRemove == null) {
                            filesToRemove = new ArrayList<File>();
                        }
                        filesToRemove.add(file);
                    }
                    catch (SecurityException securityException) {}
                }
                if (filesToRemove != null) {
                    tempFilesToDelete.removeAll(filesToRemove);
                }
            }
        }
    }
}

