/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.strategy;

import com.ibm.etools.j2ee.common.impl.J2EEResouceFactorySaxRegistry;
import com.ibm.etools.j2ee.common.impl.J2EEResourceFactoryDomRegistry;
import com.ibm.etools.j2ee.common.impl.J2EEResourceFactoryRegistry;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.CommonarchiveFactory;
import com.ibm.etools.j2ee.commonarchivecore.Container;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveRuntimeException;
import com.ibm.etools.j2ee.commonarchivecore.exception.OpenFailureException;
import com.ibm.etools.j2ee.commonarchivecore.exception.ResourceLoadException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveURIConverterImpl;
import com.ibm.etools.j2ee.commonarchivecore.helpers.FileIterator;
import com.ibm.etools.j2ee.commonarchivecore.helpers.FileIteratorImpl;
import com.ibm.etools.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import com.ibm.etools.j2ee.commonarchivecore.looseconfig.LooseArchive;
import com.ibm.etools.j2ee.commonarchivecore.looseconfig.LooseConfigRegister;
import com.ibm.etools.j2ee.commonarchivecore.nls.CommonArchiveResourceHandler;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import com.ibm.wtp.common.logger.proxy.Logger;
import com.ibm.wtp.emf.utilities.ExtendedEcoreUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;

public abstract class LoadStrategyImpl
extends AdapterImpl
implements LoadStrategy {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected boolean isOpen = true;
    protected Container container;
    protected ResourceSet resourceSet;
    protected LooseArchive looseArchive;
    protected Map collectedLooseArchiveFiles;
    protected boolean readOnly = false;
    private int rendererType;

    public void addOrReplaceMofResource(Resource aResource) {
        Resource existingResource = this.getResourceSet().getResource(aResource.getURI(), false);
        if (existingResource != null) {
            this.getResourceSet().getResources().remove((Object)existingResource);
        }
        this.getResourceSet().getResources().add((Object)aResource);
    }

    protected void updateModificationTracking(Resource res) {
        boolean shouldTrackMods;
        boolean trackingMods = res.isTrackingModification();
        boolean isReadOnly = this.container != null ? ((Archive)this.container).getOptions().isReadOnly() : false;
        boolean bl = shouldTrackMods = !isReadOnly && !ArchiveUtil.isJavaResource(res) && !ArchiveUtil.isRegisteredURIMapping(res);
        if (shouldTrackMods && !trackingMods) {
            res.setTrackingModification(true);
        }
    }

    public void close() {
        this.setIsOpen(false);
        if (this.resourceSet != null && this.resourceSet.eAdapters().contains((Object)this)) {
            this.resourceSet.eAdapters().remove((Object)this);
        }
    }

    protected abstract boolean primContains(String var1);

    public boolean contains(String uri) {
        if (this.containsUsingLooseArchive(uri)) {
            return true;
        }
        return this.primContains(uri);
    }

    protected boolean containsUsingLooseArchive(String uri) {
        if (this.getLooseArchive() == null) {
            return false;
        }
        LooseArchive loose = this.getLooseArchive();
        if (loose.getResourcesPath() == null) {
            return false;
        }
        java.io.File aFile = new java.io.File(loose.getResourcesPath(), uri);
        if (aFile.exists()) {
            return true;
        }
        return LooseConfigRegister.singleton().findFirstLooseChild(uri, loose) != null;
    }

    protected File createFile(String uri) {
        File aFile = null;
        if (this.isArchive(uri)) {
            aFile = this.openNestedArchive(uri);
        }
        if (aFile == null) {
            aFile = this.getArchiveFactory().createFile();
            aFile.setURI(uri);
            aFile.setOriginalURI(uri);
        }
        aFile.setLoadingContainer(this.getContainer());
        return aFile;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String getAbsolutePath() throws FileNotFoundException {
        throw new FileNotFoundException(CommonArchiveResourceHandler.getString("Absolute_path_unknown_EXC_"));
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLooseArchive() == null ? this.getAbsolutePath() : this.getLooseArchive().getResourcesPath();
    }

    protected String primGetResourcesPath() {
        return this.getLooseArchive() == null ? null : this.getLooseArchive().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        return this.getLooseArchive() == null ? this.getAbsolutePath() : this.getLooseArchive().getBinariesPath();
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory();
    }

    public Container getContainer() {
        return this.container;
    }

    public ResourceSet primGetResourceSet() {
        return this.resourceSet;
    }

    public boolean requiresIterationOnSave() {
        if (!this.getContainer().isArchive() || this.isDirectory()) {
            return true;
        }
        Archive anArchive = (Archive)this.getContainer();
        if (anArchive.isModuleFile()) {
            return !anArchive.getOptions().isReadOnly();
        }
        if (anArchive.getOptions().isSaveLibrariesAsFiles() && anArchive.getLoadingContainer() != null) {
            if (anArchive.isIndexed()) {
                EList files = anArchive.getFiles();
                File aFile = null;
                Container firstContainer = null;
                Container lContainer = null;
                int i = 0;
                while (i < files.size()) {
                    aFile = (File)files.get(i);
                    if (i == 0 && (firstContainer = aFile.getLoadingContainer()).getLoadStrategy().isDirectory()) {
                        return true;
                    }
                    lContainer = aFile.getLoadingContainer();
                    if (lContainer != firstContainer) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.initializeResourceSet();
            this.resourceSet.eAdapters().add((Object)this);
        }
        return this.resourceSet;
    }

    public void notifyChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                this.updateModificationTracking((Resource)msg.getNewValue());
                break;
            }
            case 5: {
                List list = (List)msg.getNewValue();
                int i = 0;
                while (i < list.size()) {
                    this.updateModificationTracking((Resource)list.get(i));
                    ++i;
                }
                break;
            }
        }
    }

    public FileIterator getFileIterator() throws IOException {
        return new FileIteratorImpl((List)this.getContainer().getFiles());
    }

    public abstract List getFiles();

    public List collectFiles() {
        this.collectFilesFromLooseArchives();
        List files = this.getFiles();
        files.addAll(this.collectedLooseArchiveFiles.values());
        this.collectedLooseArchiveFiles = null;
        return files;
    }

    protected void collectFilesFromLooseArchives() {
        if (!this.canHaveLooseChildren() || this.getLooseArchive() == null) {
            this.collectedLooseArchiveFiles = Collections.EMPTY_MAP;
            return;
        }
        this.collectedLooseArchiveFiles = new HashMap();
        List children = LooseConfigRegister.singleton().getLooseChildren(this.getLooseArchive());
        int i = 0;
        while (i < children.size()) {
            Archive archive;
            LooseArchive loose = (LooseArchive)children.get(i);
            String uri = loose.getUri();
            if (!this.collectedLooseArchiveFiles.containsKey(uri) && (archive = this.openNestedArchive(loose)) != null) {
                this.collectedLooseArchiveFiles.put(uri, archive);
                archive.setLoadingContainer(this.getContainer());
            }
            ++i;
        }
    }

    public abstract InputStream getInputStream(String var1) throws IOException, FileNotFoundException;

    public InputStream getResourceInputStream(String uri) throws IOException {
        return this.getResourceSet().getURIConverter().createInputStream(URI.createURI((String)uri));
    }

    public Collection getLoadedMofResources() {
        EList resources = this.getResourceSet().getResources();
        if (resources.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            if (!res.isLoaded()) continue;
            result.add(res);
        }
        return result;
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        try {
            return this.getResourceSet().getResource(URI.createURI((String)uri), true);
        }
        catch (WrappedException wrapEx) {
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrapEx)) {
                FileNotFoundException fileNotFoundEx = ExtendedEcoreUtil.getInnerFileNotFoundException(wrapEx);
                throw fileNotFoundEx;
            }
            this.throwResourceLoadException(uri, (Exception)((Object)wrapEx));
            return null;
        }
    }

    protected void initializeResourceSet() {
        Archive archive = (Archive)this.getContainer();
        ArchiveURIConverterImpl converter = new ArchiveURIConverterImpl(archive, this.primGetResourcesPath());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource.Factory.Registry reg = this.createResourceFactoryRegistry();
        rs.setResourceFactoryRegistry(reg);
        this.setResourceSet((ResourceSet)rs);
        rs.setURIConverter((URIConverter)converter);
        if (archive.shouldUseJavaReflection()) {
            rs.getAdapterFactories().add((Object)new JavaJDKAdapterFactory());
            archive.initializeClassLoader();
        }
    }

    protected Resource.Factory.Registry createResourceFactoryRegistry() {
        if (this.isReadOnly()) {
            return new J2EEResouceFactorySaxRegistry();
        }
        J2EEResourceFactoryRegistry registry = null;
        switch (this.getRendererType()) {
            case 1: {
                registry = new J2EEResouceFactorySaxRegistry();
                break;
            }
            case 2: {
                registry = new J2EEResourceFactoryDomRegistry();
                break;
            }
            default: {
                registry = new J2EEResourceFactoryRegistry();
            }
        }
        return registry;
    }

    public int getRendererType() {
        return this.rendererType;
    }

    protected boolean isArchive(String uri) {
        return ((Archive)this.getContainer()).isNestedArchive(uri);
    }

    public boolean isClassLoaderNeeded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public Resource getExistingMofResource(String uri) {
        return this.getResourceSet().getResource(URI.createURI((String)uri), false);
    }

    public boolean isMofResourceLoaded(String uri) {
        Resource res = this.getExistingMofResource(uri);
        return res != null && res.isLoaded();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUsing(java.io.File aSystemFile) {
        return false;
    }

    public Resource makeMofResource(String uri, EList extent) {
        Resource existing = this.getExistingMofResource(uri);
        if (existing != null) {
            return existing;
        }
        return this.getResourceSet().createResource(URI.createURI((String)uri));
    }

    protected Archive openNestedArchive(String uri) {
        try {
            return ((Archive)this.getContainer()).openNestedArchive(uri);
        }
        catch (OpenFailureException e) {
            Logger.getLogger().logError(e);
            return null;
        }
    }

    protected Archive openNestedArchive(LooseArchive loose) {
        try {
            return ((Archive)this.getContainer()).openNestedArchive(loose);
        }
        catch (OpenFailureException e) {
            Logger.getLogger().logError(e);
            return null;
        }
    }

    public void setContainer(Container newContainer) {
        this.container = newContainer;
    }

    public void setResourceSet(ResourceSet newResourceSet) {
        if (this.resourceSet != newResourceSet) {
            if (this.resourceSet != null) {
                this.resourceSet.eAdapters().remove((Object)this);
            }
            if (newResourceSet != null && !newResourceSet.eAdapters().contains((Object)this)) {
                newResourceSet.eAdapters().add((Object)this);
            }
            this.resourceSet = newResourceSet;
        }
    }

    protected void setIsOpen(boolean newIsOpen) {
        this.isOpen = newIsOpen;
    }

    protected void throwResourceLoadException(String resourceUri, Exception ex) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString("load_resource_EXC_", new Object[]{resourceUri, this.getContainer().getURI()}), ex);
    }

    public LooseArchive getLooseArchive() {
        return this.looseArchive;
    }

    public void setLooseArchive(LooseArchive looseArchive) {
        this.looseArchive = looseArchive;
        this.checkLoosePathsValid();
    }

    protected void checkLoosePathsValid() {
        java.io.File ioFile;
        if (this.looseArchive == null) {
            return;
        }
        String path = this.looseArchive.getBinariesPath();
        if (path != null && !(ioFile = new java.io.File(path)).exists()) {
            throw new ArchiveRuntimeException("Invalid binaries path: " + path);
        }
        path = this.looseArchive.getResourcesPath();
        if (path != null && !(ioFile = new java.io.File(path)).exists()) {
            throw new ArchiveRuntimeException("Invalid resources path: " + path);
        }
    }

    protected boolean canHaveLooseChildren() {
        return this.container.isEARFile() || this.container.isWARFile();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
    }
}

