/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.strategy;

import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.exception.SaveFailureException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveManifest;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveURIConverterImpl;
import com.ibm.etools.j2ee.commonarchivecore.strategy.SaveStrategy;
import com.ibm.etools.j2ee.commonarchivecore.strategy.SaveStrategyImpl;
import com.ibm.etools.j2ee.commonarchivecore.strategy.ZipStreamSaveStrategyImpl;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;

public class DirectorySaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected String directoryName;
    protected URIConverter uriConverter;
    protected int expansionFlags;

    public DirectorySaveStrategyImpl() {
    }

    public DirectorySaveStrategyImpl(String dirName, int flags) {
        this.setDirectoryName(dirName);
        this.setExpansionFlags(flags);
        this.initialize();
    }

    protected SaveStrategy createNestedDirectoryStrategy(Archive anArchive) {
        String uri = ArchiveUtil.getOSUri(this.getDirectoryName(), anArchive.getURI());
        return new DirectorySaveStrategyImpl(uri, this.getExpansionFlags());
    }

    protected SaveStrategy createNestedSaveStrategy(Archive anArchive) throws IOException {
        if (this.shouldExpand(anArchive)) {
            return this.createNestedDirectoryStrategy(anArchive);
        }
        return this.createNestedZipStrategy(anArchive);
    }

    protected SaveStrategy createNestedZipStrategy(Archive anArchive) throws IOException {
        OutputStream out = this.getUriConverter().createOutputStream(URI.createURI((String)anArchive.getURI()));
        return new ZipStreamSaveStrategyImpl(out);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getExpansionFlags() {
        return this.expansionFlags;
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return this.getUriConverter().createOutputStream(aResource.getURI());
    }

    public URIConverter getUriConverter() {
        return this.uriConverter;
    }

    public void initialize() {
        ArchiveURIConverterImpl converter = new ArchiveURIConverterImpl(this.getArchive(), this.getDirectoryName());
        converter.setOutputFilepath(this.getDirectoryName());
        this.setUriConverter((URIConverter)converter);
    }

    public boolean isDirectory() {
        return true;
    }

    protected void mkdirs(String directoryPath) {
        java.io.File aDirectory = new java.io.File(String.valueOf(this.getDirectoryName()) + java.io.File.separatorChar + directoryPath);
        aDirectory.mkdirs();
    }

    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        try {
            OutputStream out = this.getUriConverter().createOutputStream(URI.createURI((String)"META-INF/MANIFEST.MF"));
            aManifest.write(out);
            out.close();
            if (this.getArchive().getOptions().isReadOnly()) {
                this.setTimestampAfterSaving("META-INF/MANIFEST.MF");
            }
        }
        catch (IOException iox) {
            throw new SaveFailureException("META-INF/MANIFEST.MF", iox);
        }
    }

    public void save(File aFile, InputStream in) throws SaveFailureException {
        String entryName = aFile.getURI();
        if (aFile.isDirectoryEntry()) {
            this.mkdirs(entryName);
        } else {
            try {
                OutputStream out = this.getUriConverter().createOutputStream(URI.createURI((String)entryName));
                ArchiveUtil.copy(in, out);
                this.setTimestampAfterSaving(aFile);
            }
            catch (IOException iox) {
                throw new SaveFailureException(aFile.getURI(), iox);
            }
        }
    }

    protected void saveMofResource(Resource aResource, OutputStream os) throws IOException {
        super.saveMofResource(aResource, os);
        os.close();
    }

    public void setDirectoryName(String newDirectoryName) {
        this.directoryName = newDirectoryName;
    }

    public void setExpansionFlags(int newExpansionFlags) {
        this.expansionFlags = newExpansionFlags;
    }

    protected void setTimestampAfterSaving(File aFile) {
        long lastMod = aFile.getLastModified();
        if (lastMod == 0L) {
            return;
        }
        String absPath = ArchiveUtil.getOSUri(this.getDirectoryName(), aFile.getURI());
        java.io.File ioFile = new java.io.File(absPath);
        ioFile.setLastModified(lastMod);
    }

    protected void setTimestampAfterSaving(String uri) {
        File aFile = null;
        try {
            aFile = this.getArchive().getFile(uri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        this.setTimestampAfterSaving(aFile);
    }

    public void setUriConverter(URIConverter newUriConverter) {
        this.uriConverter = newUriConverter;
    }

    protected boolean shouldExpand(Archive anArchive) {
        int flag = 0;
        flag = anArchive.isWARFile() ? 2 : (anArchive.isEARFile() ? 4 : (anArchive.isRARFile() ? 64 : (anArchive.isEJBJarFile() ? 8 : (anArchive.isApplicationClientFile() ? 16 : 32))));
        return (this.getExpansionFlags() & flag) != 0;
    }

    protected boolean shouldIterateOver(Archive anArchive) {
        return super.shouldIterateOver(anArchive) || this.shouldExpand(anArchive);
    }
}

