/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.impl;

import com.ibm.etools.j2ee.common.util.Defaultable;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.CommonarchiveFactory;
import com.ibm.etools.j2ee.commonarchivecore.CommonarchivePackage;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.WARFile;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveRuntimeException;
import com.ibm.etools.j2ee.commonarchivecore.exception.DuplicateObjectException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveManifest;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveManifestImpl;
import com.ibm.etools.j2ee.commonarchivecore.impl.ArchiveCopySessionUtility;
import com.ibm.etools.j2ee.commonarchivecore.nls.CommonArchiveResourceHandler;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import com.ibm.etools.webapplication.FilterMapping;
import com.ibm.wtp.emf.utilities.copy.CopyGroup;
import com.ibm.wtp.emf.utilities.copy.EtoolsCopySession;
import com.ibm.wtp.emf.utilities.copy.EtoolsCopyUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;

public class ArchiveCopyUtility
extends EtoolsCopyUtility {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ArchiveCopyUtility() {
        this.setCopyAdapters(true);
    }

    protected void addDeferredSingleReferenceCopy(EReference reference, EObject aValue, String idSuffix, EObject aCopyContainer) {
        if (((Defaultable)aValue).isDefault()) {
            return;
        }
        super.addDeferredSingleReferenceCopy(reference, aValue, idSuffix, aCopyContainer);
    }

    public ArchiveManifest copy(ArchiveManifest mf) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            mf.write(out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            return new ArchiveManifestImpl(in);
        }
        catch (IOException iox) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString("IOException_occurred_while_EXC_"), iox);
        }
    }

    public Archive copy(Archive anArchive) {
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(true);
        this.prepareResourcesForCopy(anArchive, copyGroup);
        copyGroup.add(anArchive);
        this.copy(copyGroup);
        Archive copiedArchive = (Archive)this.getCopy(anArchive);
        this.finishCopy(anArchive, copiedArchive, copyGroup);
        return copiedArchive;
    }

    public ModuleFile copy(ModuleFile aModuleFile) {
        aModuleFile.getStandardDeploymentDescriptor();
        if (aModuleFile.isWARFile()) {
            EList filterMappings = ((WARFile)aModuleFile).getDeploymentDescriptor().getFilterMappings();
            int i = 0;
            while (i < filterMappings.size()) {
                ((FilterMapping)filterMappings.get(i)).getServlet();
                ++i;
            }
        }
        ModuleFile copied = (ModuleFile)this.copy((Archive)aModuleFile);
        return copied;
    }

    public void copy(CopyGroup aGroup) {
        if (aGroup != null) {
            ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
            session.setPreserveIds(aGroup.getPreserveIds());
            session.copy(aGroup);
            session.flush();
        }
    }

    public EObject copy(EObject aRefObject, String idSuffix) {
        ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
        EObject copied = ((EtoolsCopySession)session).copy(aRefObject, idSuffix);
        session.flush();
        return copied;
    }

    public Resource copy(Resource aResource, String newUri) {
        ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
        Resource copied = session.copy(aResource, newUri);
        session.flush();
        return copied;
    }

    protected void copyImportStrategyIfNecessary(ModuleFile aModuleFile, ModuleFile copy) {
        if (!aModuleFile.isDeploymentDescriptorSet()) {
            copy.setImportStrategy(aModuleFile.getImportStrategy().createImportStrategy(aModuleFile, copy));
        }
    }

    public EObject copyObject(EObject aRefObject, String idSuffix) {
        ArchiveCopySessionUtility session = new ArchiveCopySessionUtility(this);
        EObject copied = ((EtoolsCopySession)session).copyObject(aRefObject, idSuffix);
        session.flush();
        return copied;
    }

    public static void createCopy(CopyGroup aGroup) {
        ArchiveCopyUtility utility = new ArchiveCopyUtility();
        utility.copy(aGroup);
    }

    protected void finishCopy(Archive source, Archive copy, CopyGroup group) {
        copy.setLoadStrategy(this.getCommonarchiveFactory().createEmptyLoadStrategy());
        copy.setExtraClasspath(source.getExtraClasspath());
        copy.setXmlEncoding(source.getXmlEncoding());
        if (source.isManifestSet()) {
            copy.setManifest(this.copy(source.getManifest()));
        } else {
            try {
                File manifestToCopy = source.getFile("META-INF/MANIFEST.MF");
                if (manifestToCopy != null) {
                    File copiedManifest = (File)this.getCopy(manifestToCopy);
                    copiedManifest.setLoadingContainer(manifestToCopy.getLoadingContainer());
                    copy.addCopy(copiedManifest);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (DuplicateObjectException duplicateObjectException) {}
        }
        this.retrieveResourcesFromCopy(copy, group);
        if (source.isModuleFile()) {
            this.copyImportStrategyIfNecessary((ModuleFile)source, (ModuleFile)copy);
        }
        EList files = source.getFiles();
        int i = 0;
        while (i < files.size()) {
            File aFile = (File)files.get(i);
            File copiedFile = (File)this.getCopy(aFile);
            copiedFile.setLoadingContainer(aFile.getLoadingContainer());
            if (aFile.isArchive()) {
                this.finishNestedCopy((Archive)aFile, (Archive)copiedFile);
            }
            ++i;
        }
        copy.rebuildFileIndex();
    }

    protected void finishNestedCopy(Archive source, Archive copy) {
        CopyGroup group = new CopyGroup();
        this.prepareResourcesForCopy(source, group);
        this.copy(group);
        this.finishCopy(source, copy, group);
    }

    private CommonarchiveFactory getCommonarchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    protected void prepareResourcesForCopy(Archive anArchive, CopyGroup copyGroup) {
        Iterator iter = anArchive.getLoadedMofResources().iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (ArchiveUtil.isJavaResource(resource)) continue;
            copyGroup.add(resource);
        }
    }

    protected void retrieveResourcesFromCopy(Archive copiedArchive, CopyGroup copyGroup) {
        List resources = copyGroup.getCopiedResources();
        int i = 0;
        while (i < resources.size()) {
            Resource copiedResource = (Resource)resources.get(i);
            copiedArchive.addOrReplaceMofResource(copiedResource);
            ++i;
        }
    }
}

