/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.helpers;

import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveRuntimeException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.FileIteratorImpl;
import com.ibm.etools.j2ee.commonarchivecore.nls.CommonArchiveResourceHandler;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class NestedArchiveIterator
extends FileIteratorImpl {
    protected ZipInputStream zipInputStream;
    protected ZipEntry currentEntry;

    public NestedArchiveIterator(List theFiles, ZipInputStream stream) {
        super(theFiles);
        this.zipInputStream = stream;
    }

    public InputStream getInputStream(File aFile) throws IOException, FileNotFoundException {
        if (!aFile.getURI().equals(this.currentEntry.getName())) {
            throw new IOException(CommonArchiveResourceHandler.getString("Internal_Error__Iterator_o_EXC_"));
        }
        return new WrapperInputStream(this.zipInputStream);
    }

    public File next() {
        File next = super.next();
        try {
            do {
                this.currentEntry = this.zipInputStream.getNextEntry();
            } while (this.currentEntry.isDirectory());
        }
        catch (IOException ex) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString("Error_iterating_the_archiv_EXC_"), ex);
        }
        return next;
    }

    static class WrapperInputStream
    extends FilterInputStream {
        public WrapperInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }
}

