/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.helpers;

import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveManifest;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ArchiveManifestImpl
extends Manifest
implements ArchiveManifest {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ArchiveManifestImpl() {
    }

    public ArchiveManifestImpl(InputStream is) throws IOException {
        super(is);
    }

    public ArchiveManifestImpl(Manifest man) {
        super(man);
    }

    public void addEntry(String entryName) {
        Attributes attr = new Attributes();
        this.addEntry(entryName, attr);
    }

    public void addEntry(String entryName, Attributes attr) {
        this.getEntries().put(entryName, attr);
    }

    public void addEntryAttribute(String entryName, String key, String value) {
        Attributes attr = this.getAttributes(entryName);
        if (attr == null) {
            this.addEntry(entryName);
        }
        attr = this.getAttributes(entryName);
        attr.putValue(key, value);
    }

    public void addVersionIfNecessary() {
        if (this.getManifestVersion() == null || this.getManifestVersion().equals("")) {
            this.setManifestVersion("1.0");
        }
    }

    public void appendClassPath(String extension) {
        String classPath = this.getClassPath();
        if (classPath != null) {
            this.setClassPath(String.valueOf(classPath) + " " + extension);
        } else {
            this.setClassPath(extension);
        }
    }

    public String getClassPath() {
        return ArchiveUtil.getValueIgnoreKeyCase(Attributes.Name.CLASS_PATH.toString(), this.getMainAttributes());
    }

    public String[] getClassPathTokenized() {
        String classPath = this.getClassPath();
        if (classPath == null) {
            return new String[0];
        }
        return ArchiveUtil.getTokens(classPath);
    }

    public String getEntryAttribute(String entryName, String key) {
        Attributes attr = this.getAttributes(entryName);
        if (attr == null) {
            return null;
        }
        return attr.getValue(key);
    }

    public String getMainClass() {
        return ArchiveUtil.getValueIgnoreKeyCase(Attributes.Name.MAIN_CLASS.toString(), this.getMainAttributes());
    }

    public String getManifestVersion() {
        return this.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION);
    }

    public void mergeClassPath(String[] classPathEntries) {
        StringBuffer sb = new StringBuffer();
        List<String> existing = Arrays.asList(this.getClassPathTokenized());
        String cp = this.getClassPath();
        if (cp != null) {
            sb.append(cp);
        }
        boolean empty = cp == null || "".equals(cp);
        int i = 0;
        while (i < classPathEntries.length) {
            if (!existing.contains(classPathEntries[i])) {
                if (!empty) {
                    sb.append(" ");
                } else {
                    empty = false;
                }
                sb.append(classPathEntries[i]);
            }
            ++i;
        }
        this.setClassPath(sb.toString());
    }

    public void removeEntry(String entryName) {
        this.getEntries().remove(entryName);
    }

    public void removeEntryAttribute(String entryName, Object key) {
        Attributes attr = this.getAttributes(entryName);
        if (attr != null) {
            attr.remove(key);
        }
    }

    public void setClassPath(String aSpaceDelimitedPath) {
        Attributes attributes = this.getMainAttributes();
        if (aSpaceDelimitedPath == null) {
            attributes.remove(Attributes.Name.CLASS_PATH);
        } else {
            attributes.putValue(Attributes.Name.CLASS_PATH.toString(), aSpaceDelimitedPath);
        }
    }

    public void setMainClass(String className) {
        Attributes attributes = this.getMainAttributes();
        if (className == null) {
            attributes.remove(Attributes.Name.MAIN_CLASS);
        } else {
            attributes.putValue(Attributes.Name.MAIN_CLASS.toString(), className);
        }
    }

    public void setManifestVersion(String version) {
        Attributes attributes = this.getMainAttributes();
        attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), version);
    }

    /*
     * Exception decompiling
     */
    public void writeSplittingClasspath(OutputStream out) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 159->163)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void write(Attributes attributes, OutputStreamWriter writer) throws IOException {
        Iterator<Map.Entry<Object, Object>> it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            StringBuffer buffer = new StringBuffer(((Attributes.Name)e.getKey()).toString());
            buffer.append(": ");
            buffer.append((String)e.getValue());
            buffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(buffer);
            writer.write(buffer.toString());
        }
        writer.write("\r\n");
    }

    protected void writeMainSplittingClasspath(Attributes attributes, OutputStreamWriter writer) throws IOException {
        String vername = Attributes.Name.MANIFEST_VERSION.toString();
        String version = attributes.getValue(vername);
        if (version == null) {
            vername = Attributes.Name.SIGNATURE_VERSION.toString();
            version = attributes.getValue(vername);
        }
        if (version != null) {
            writer.write(String.valueOf(vername) + ": " + version + "\r\n");
        }
        Iterator<Map.Entry<Object, Object>> it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            String name = ((Attributes.Name)e.getKey()).toString();
            if (version == null || name.equalsIgnoreCase(vername)) continue;
            if (name.equalsIgnoreCase(Attributes.Name.CLASS_PATH.toString())) {
                this.writeSplit(writer, name, (String)e.getValue());
                continue;
            }
            StringBuffer buffer = new StringBuffer(name);
            buffer.append(": ");
            buffer.append((String)e.getValue());
            buffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(buffer);
            writer.write(buffer.toString());
        }
        writer.write("\r\n");
    }

    protected void writeSplit(OutputStreamWriter writer, String name, String value) throws IOException {
        StringTokenizer tok = new StringTokenizer(value);
        int inc = 0;
        while (tok.hasMoreTokens()) {
            StringBuffer buffer = null;
            if (inc == 0) {
                buffer = new StringBuffer(name);
                buffer.append(": ");
            } else {
                buffer = new StringBuffer();
                buffer.append(' ');
            }
            buffer.append(tok.nextToken());
            if (tok.countTokens() > 0) {
                buffer.append(" \r\n");
            } else {
                buffer.append("\r\n");
            }
            ArchiveManifestImpl.localMake72Safe(buffer);
            writer.write(buffer.toString());
            ++inc;
        }
    }

    protected static void localMake72Safe(StringBuffer line) {
        int length = line.length();
        if (length > 72) {
            int index = 70;
            while (index - 1 < length) {
                line.insert(index, "\r\n ");
                index += 72;
                length += 3;
            }
        }
    }

    protected void writeMainSplittingClasspath(Attributes attributes, DataOutputStream out) throws IOException {
        String vername = Attributes.Name.MANIFEST_VERSION.toString();
        String version = attributes.getValue(vername);
        if (version == null) {
            vername = Attributes.Name.SIGNATURE_VERSION.toString();
            version = attributes.getValue(vername);
        }
        if (version != null) {
            out.writeBytes(String.valueOf(vername) + ": " + version + "\r\n");
        }
        Iterator<Map.Entry<Object, Object>> it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            String name = ((Attributes.Name)e.getKey()).toString();
            if (version == null || name.equalsIgnoreCase(vername)) continue;
            if (name.equalsIgnoreCase(Attributes.Name.CLASS_PATH.toString())) {
                this.writeSplit(out, name, (String)e.getValue());
                continue;
            }
            StringBuffer buffer = new StringBuffer(name);
            buffer.append(": ");
            buffer.append((String)e.getValue());
            buffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(buffer);
            out.writeBytes(buffer.toString());
        }
        out.writeBytes("\r\n");
    }

    protected void writeSplit(DataOutputStream out, String name, String value) throws IOException {
        StringTokenizer tok = new StringTokenizer(value);
        int inc = 0;
        while (tok.hasMoreTokens()) {
            StringBuffer buffer = null;
            if (inc == 0) {
                buffer = new StringBuffer(name);
                buffer.append(": ");
            } else {
                buffer = new StringBuffer();
                buffer.append(' ');
            }
            buffer.append(tok.nextToken());
            if (tok.countTokens() > 0) {
                buffer.append(" \r\n");
            } else {
                buffer.append("\r\n");
            }
            ArchiveManifestImpl.localMake72Safe(buffer);
            out.writeBytes(buffer.toString());
            ++inc;
        }
    }

    protected void write(Attributes attributes, DataOutputStream os) throws IOException {
        Iterator<Map.Entry<Object, Object>> it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            StringBuffer buffer = new StringBuffer(((Attributes.Name)e.getKey()).toString());
            buffer.append(": ");
            buffer.append((String)e.getValue());
            buffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(buffer);
            os.writeBytes(buffer.toString());
        }
        os.writeBytes("\r\n");
    }
}

