/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.command;

import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.command.XmlValidationResult;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveRuntimeException;
import com.ibm.etools.j2ee.xml.CollectingErrorHandler;
import com.ibm.etools.j2ee.xml.bridge.XmlDocumentReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.xml.sax.InputSource;

public class ValidateXmlCommand
extends AbstractCommand {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected List results;
    protected ModuleFile archive;
    public boolean validateNested = true;

    protected ValidateXmlCommand() {
    }

    public ValidateXmlCommand(ModuleFile m) {
        this.archive = m;
    }

    protected ValidateXmlCommand(String label) {
        super(label);
    }

    protected ValidateXmlCommand(String label, String description) {
        super(label, description);
    }

    public void execute() {
        this.results = new ArrayList();
        this.validatateXml();
        if (this.isValidateNested()) {
            List archives = this.archive.getArchiveFiles();
            int i = 0;
            while (i < archives.size()) {
                Archive a = (Archive)archives.get(i);
                if (a.isModuleFile()) {
                    ModuleFile m = (ModuleFile)a;
                    ValidateXmlCommand cmd = new ValidateXmlCommand(m);
                    cmd.execute();
                    this.results.addAll(cmd.getResult());
                }
                ++i;
            }
        }
    }

    public Collection getResult() {
        return this.results;
    }

    public boolean isValidateNested() {
        return this.validateNested;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    public void setValidateNested(boolean newValidateNested) {
        this.validateNested = newValidateNested;
    }

    protected void validatateXml() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Resource res = this.archive.getStandardDeploymentDescriptor().eResource();
        XmlValidationResult result = new XmlValidationResult();
        result.setArchive(this.archive);
        try {
            res.save((OutputStream)bos, new HashMap());
        }
        catch (Exception ex) {
            throw new ArchiveRuntimeException(ex);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(bos.toByteArray());
        InputSource source = new InputSource(inStream);
        CollectingErrorHandler handler = new CollectingErrorHandler();
        XmlDocumentReader parseAdapter = new XmlDocumentReader(source, null, handler);
        try {
            parseAdapter.parseDocument();
        }
        catch (RuntimeException re) {
            if (handler.getCaughtExceptions() != null) {
                result.setArchive(this.archive);
                result.setCaughtExceptions(handler.getCaughtExceptions());
                this.results.add(result);
            }
            throw re;
        }
        result.setArchive(this.archive);
        result.setCaughtExceptions(handler.getCaughtExceptions());
        this.results.add(result);
    }
}

