/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.UserFinderDescriptor;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.MethodElementKind;
import com.ibm.etools.j2ee.commonarchivecore.EJBJarFile;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.impl.JavaClassImpl;

public class FinderHelperMetaDataConverter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String FIND = "find";
    public static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    public static final String FINDER_HELPER = "FinderHelper";
    public static final String WHERE_CLAUSE = "WhereClause";
    public static final String QUERY_STRING = "QueryString";
    protected EJBJarFile ejbJarFile;
    protected ContainerManagedEntity currentCMP;
    protected JavaClass currentInterface;

    public FinderHelperMetaDataConverter(EJBJarFile anEJBJarFile) {
        this.ejbJarFile = anEJBJarFile;
    }

    protected void addFinderDescriptor(FinderDescriptor desc, MethodElement methodElement) {
        desc.getFinderMethodElements().add((Object)methodElement);
        this.getCurrentExtension().getFinderDescriptors().add((Object)desc);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Field finderField) {
        FinderDescriptor desc = null;
        Block aBlock = finderField.getInitializer();
        String finderString = null;
        if (aBlock == null || (finderString = aBlock.getSource()) == null) {
            return;
        }
        String value = finderString.substring(1, finderString.length() - 1);
        if (this.isWhereClause(finderField)) {
            desc = this.getExtensionsFactory().createWhereClauseFinderDescriptor();
            desc.setWhereClause(value);
        } else {
            desc = this.getExtensionsFactory().createFullSelectFinderDescriptor();
            ((FullSelectFinderDescriptor)desc).setSelectStatement(value);
        }
        this.addFinderDescriptor(desc, methodElement);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Method userMethod) {
        UserFinderDescriptor desc = this.getExtensionsFactory().createUserFinderDescriptor();
        this.addFinderDescriptor(desc, methodElement);
    }

    protected MethodElement createMethodElement(Method aMethod) {
        MethodElement methodElement = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createMethodElementFrom(aMethod);
        methodElement.setEnterpriseBean(this.currentCMP);
        methodElement.setType(MethodElementKind.HOME_LITERAL);
        if (!methodElement.hasMethodParams()) {
            methodElement.applyZeroParams();
        }
        return methodElement;
    }

    protected Field detectFinderFieldFor(Method finderMethod) {
        List extendedFields = this.currentInterface.getFieldsExtended();
        int i = 0;
        while (i < extendedFields.size()) {
            Field aField = (Field)extendedFields.get(i);
            String name = aField.getName();
            if (name.equals(finderMethod.getName().concat(WHERE_CLAUSE)) || name.equals(finderMethod.getName().concat(QUERY_STRING))) {
                return aField;
            }
            ++i;
        }
        return null;
    }

    protected Method detectFinderMethodFor(MethodElement finderMethodElement) {
        List extendedMethods = this.currentInterface.getMethodsExtended();
        int i = 0;
        while (i < extendedMethods.size()) {
            Method aMethod = (Method)extendedMethods.get(i);
            if (finderMethodElement.nameAndParamsEquals(aMethod)) {
                return aMethod;
            }
            ++i;
        }
        return null;
    }

    protected ContainerManagedEntityExtension getCurrentExtension() {
        return (ContainerManagedEntityExtension)EjbExtensionsHelper.getEjbExtension(this.currentCMP);
    }

    public EjbextFactory getExtensionsFactory() {
        return ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
    }

    protected List getFindMethods() {
        ArrayList<Method> filtered = new ArrayList<Method>();
        if (this.currentCMP.getHomeInterface() != null) {
            List methods = this.currentCMP.getHomeInterface().getMethodsExtended();
            int i = 0;
            while (i < methods.size()) {
                Method aMethod = (Method)methods.get(i);
                if (aMethod.getName().startsWith(FIND) && !aMethod.getName().equals(FIND_BY_PRIMARY_KEY)) {
                    filtered.add(aMethod);
                }
                ++i;
            }
        }
        return filtered;
    }

    protected boolean isWhereClause(Field aField) {
        return aField.getName().endsWith(WHERE_CLAUSE);
    }

    protected void primReflectCurrentCMP() {
        this.setCurrentInterface();
        if (this.currentInterface == null) {
            return;
        }
        List methods = this.getFindMethods();
        int i = 0;
        while (i < methods.size()) {
            Method aMethod = (Method)methods.get(i);
            MethodElement methodElement = this.createMethodElement(aMethod);
            Field finderField = this.detectFinderFieldFor(aMethod);
            if (finderField != null) {
                this.addFinderDescriptor(methodElement, finderField);
            } else {
                Method userMethod = this.detectFinderMethodFor(methodElement);
                if (userMethod != null) {
                    this.addFinderDescriptor(methodElement, userMethod);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reflectCurrentCMP() {
        block4: {
            try {
                this.primReflectCurrentCMP();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                if (this.currentInterface != null) {
                    JavaReflectionAdaptor.releaseSourceType(this.currentInterface);
                }
                if (this.currentCMP == null) throw throwable;
                if (this.currentCMP.getHomeInterface() == null) throw throwable;
                JavaReflectionAdaptor.releaseSourceType(this.currentCMP.getHomeInterface());
                throw throwable;
            }
            {
                Object var1_3 = null;
                if (this.currentInterface == null) break block4;
            }
            JavaReflectionAdaptor.releaseSourceType(this.currentInterface);
        }
        if (this.currentCMP == null) return;
        if (this.currentCMP.getHomeInterface() == null) return;
        JavaReflectionAdaptor.releaseSourceType(this.currentCMP.getHomeInterface());
    }

    public void reflectMetaData() {
        EList ejbs = this.ejbJarFile.getDeploymentDescriptor().getEnterpriseBeans();
        int i = 0;
        while (i < ejbs.size()) {
            EnterpriseBean bean = (EnterpriseBean)ejbs.get(i);
            if (bean.isContainerManagedEntity()) {
                this.currentCMP = (ContainerManagedEntity)bean;
                this.reflectCurrentCMP();
            }
            ++i;
        }
    }

    protected JavaClass setCurrentInterface() {
        String className = this.currentCMP.getEjbClassName().concat(FINDER_HELPER);
        if (!this.ejbJarFile.containsFile(ArchiveUtil.classNameToUri(className))) {
            this.currentInterface = null;
        }
        this.currentInterface = (JavaClass)JavaClassImpl.reflect(className, this.ejbJarFile.getResourceSet());
        return this.currentInterface;
    }
}

