/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.j2ee.commonarchivecore.EJBJarFile;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveRuntimeException;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class BackendUtil {
    protected static final String EXCEPTION_LOADING_PROPERTIES = "Exception occurred loading properties: ";

    public static String getBABName(String backend_id, ContainerManagedEntity cmpBean) {
        return BackendUtil.getBABName(backend_id, cmpBean.getEjbJar(), cmpBean.getAbstractSchemaName());
    }

    public static String getBABName(String backend_id, EJBJar ejbJar, String asnName) {
        if (backend_id == null || ejbJar == null || asnName == null) {
            return null;
        }
        ModuleFile moduleFile = ArchiveUtil.getModuleFile(ejbJar);
        if (moduleFile == null || !moduleFile.isEJBJarFile()) {
            return null;
        }
        Properties p = BackendUtil.getBackendProperties(backend_id, (EJBJarFile)moduleFile);
        if (p == null) {
            return null;
        }
        return p.getProperty(asnName);
    }

    public static Properties getBackendProperties(String backendId, EJBJarFile jarFile) {
        if (backendId == null || jarFile == null) {
            return null;
        }
        String root = ArchiveUtil.concatUri("META-INF/backends", backendId, '/');
        String uri = ArchiveUtil.concatUri(root, "ibm_pmbab.properties", '/');
        try {
            return ArchiveUtil.loadProperties(jarFile, uri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException e) {
            throw new ArchiveRuntimeException(EXCEPTION_LOADING_PROPERTIES + uri, e);
        }
    }

    public static List getAllBackendIDs(EJBJarFile jar, boolean clearFilesList) {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator files = jar.filterFilesByPrefix("META-INF/backends").iterator();
        while (files.hasNext()) {
            File aFile = (File)files.next();
            if (!aFile.getURI().endsWith("dbxmi")) continue;
            StringTokenizer tok = new StringTokenizer(aFile.getURI(), "/");
            tok.nextToken();
            tok.nextToken();
            ids.add(tok.nextToken());
        }
        if (clearFilesList) {
            jar.clearFiles();
        }
        return ids;
    }
}

