/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.helper;

import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPResAuthType;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndPackage;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransaction;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransactionBoundaryKind;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransactionResolverKind;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransactionUnresolvedActionKind;
import com.ibm.ejs.models.base.extensions.commonext.localtran.LocaltranPackage;
import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbqlFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.LocalTran;
import com.ibm.ejs.models.base.extensions.ejbext.WhereClauseFinderDescriptor;
import com.ibm.etools.application.ApplicationResource;
import com.ibm.etools.client.ApplicationClientResource;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EJBResource;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.Query;
import com.ibm.etools.ejb.QueryMethod;
import com.ibm.etools.j2ee.J2EEConstants;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.migration.J2EEMigrationMultiStatus;
import com.ibm.etools.j2ee.migration.J2EEMigrationStatus;
import com.ibm.etools.j2ee.migration.J2EESpecificationMigrationConstants;
import com.ibm.etools.webapplication.WebAppResource;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;

public class J2EESpecificationMigrator
implements J2EEConstants,
J2EESpecificationMigrationConstants {
    protected XMLResource xmlResource;
    protected String version;
    protected boolean isComplex;

    public J2EESpecificationMigrator(XMLResource anXmlResource, String aVersion, boolean complex) {
        this.xmlResource = anXmlResource;
        this.version = aVersion;
        this.isComplex = complex;
    }

    public J2EESpecificationMigrator(String aVersion, boolean complex) {
        this.version = aVersion;
        this.isComplex = complex;
    }

    protected String format(String aPattern, String arg1) {
        return MessageFormat.format(aPattern, arg1);
    }

    protected String format(String aPattern, String arg1, String arg2) {
        return MessageFormat.format(aPattern, arg1, arg2);
    }

    public J2EEMigrationStatus migrate() {
        if (this.xmlResource != null && this.version != null) {
            switch (this.xmlResource.getType()) {
                case 1: {
                    return this.migrate((ApplicationClientResource)this.xmlResource);
                }
                case 2: {
                    return this.migrate((ApplicationResource)this.xmlResource);
                }
                case 3: {
                    return this.migrate((EJBResource)this.xmlResource);
                }
                case 4: {
                    return this.migrate((WebAppResource)this.xmlResource);
                }
            }
        }
        return new J2EEMigrationStatus(1, this.xmlResource);
    }

    private boolean basicNeedsToMigrate() {
        boolean isResource1_3 = this.xmlResource.isJ2EE1_3();
        boolean isTarget1_3 = this.isVersion1_3();
        return isResource1_3 && !isTarget1_3 || !isResource1_3 && isTarget1_3;
    }

    private boolean isVersion1_3() {
        return this.version.equals("J2EE_1.3");
    }

    private boolean isVersion1_2() {
        return this.version.equals("J2EE_1.2");
    }

    protected J2EEMigrationStatus migrate(ApplicationClientResource appClientResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, appClientResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/application-client_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application-client_1_2.dtd";
        appClientResource.setDoctypeValues(pubId, sysId);
        return new J2EEMigrationStatus(0, appClientResource);
    }

    protected J2EEMigrationStatus migrate(WebAppResource webResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, webResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN" : "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/web-app_2_3.dtd" : "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
        webResource.setDoctypeValues(pubId, sysId);
        return new J2EEMigrationStatus(0, webResource);
    }

    protected J2EEMigrationStatus migrate(ApplicationResource appResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, appResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/application_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
        appResource.setDoctypeValues(pubId, sysId);
        return new J2EEMigrationStatus(0, appResource);
    }

    protected J2EEMigrationStatus migrate(EJBResource ejbResource) {
        J2EEMigrationStatus status = null;
        boolean b = this.basicNeedsToMigrate();
        boolean isVersion1_3 = this.isVersion1_3();
        EJBJar jar = ejbResource.getEJBJar();
        if (b) {
            if (!isVersion1_3 && (status = this.getMigrateToLowerLevelStatus(jar)) != null) {
                return status;
            }
            this.ensureBeanVersionsSet(jar);
            String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN" : "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
            String sysId = isVersion1_3 ? "http://java.sun.com/dtd/ejb-jar_2_0.dtd" : "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
            ejbResource.setDoctypeValues(pubId, sysId);
        } else {
            status = new J2EEMigrationStatus(1, ejbResource);
        }
        boolean notNeeded = status != null;
        status = this.mergeStatuses(status, this.migrateEJBJar(jar));
        status = this.mergeStatuses(status, this.migrateBeans(jar));
        if (!notNeeded) {
            status = this.mergeStatuses(status, new J2EEMigrationStatus(0, ejbResource));
        }
        return status;
    }

    private J2EEMigrationStatus mergeStatuses(J2EEMigrationStatus status1, J2EEMigrationStatus status2) {
        if (status1 != null) {
            return status1.append(status2);
        }
        return status2;
    }

    private J2EEMigrationStatus migrateEJBJar(EJBJar jar) {
        if (jar == null) {
            return null;
        }
        EJBJarBinding jarBinding = EJBBindingsHelper.getEJBJarBinding(jar);
        ResourceRefBinding datasourceBnd = jarBinding.getDefaultDatasource();
        if (datasourceBnd != null) {
            if (jarBinding.getDefaultCMPConnectionFactory() == null) {
                CMPConnectionFactoryBinding factoryBnd = this.createCMPConnectionFactoryBinding(datasourceBnd);
                jarBinding.setDefaultCMPConnectionFactory(factoryBnd);
            }
            jarBinding.setDefaultDatasource(null);
            String msg = jar.getDisplayName() != null ? this.format(J2EESpecificationMigrationConstants.MIGRATED_DEFAULT_DATASOURCE_JAR_MSG, jar.getDisplayName()) : J2EESpecificationMigrationConstants.MIGRATED_DEFAULT_DATASOURCE_MSG;
            return new J2EEMigrationStatus(0, jar, msg);
        }
        return null;
    }

    private CMPConnectionFactoryBinding createCMPConnectionFactoryBinding(ResourceRefBinding datasource) {
        CMPConnectionFactoryBinding factoryBnd = ((EjbbndPackage)EPackage.Registry.INSTANCE.getEPackage("ejbbnd.xmi")).getEjbbndFactory().createCMPConnectionFactoryBinding();
        factoryBnd.setJndiName(datasource.getJndiName());
        factoryBnd.setResAuth(CMPResAuthType.PER_CONNECTION_FACTORY_LITERAL);
        return factoryBnd;
    }

    private void ensureBeanVersionsSet(EJBJar jar) {
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                if (bean.isContainerManagedEntity() && bean.isVersion1_X()) {
                    ((ContainerManagedEntity)bean).setVersion("1.x");
                }
                ++i;
            }
        }
    }

    protected J2EEMigrationStatus getMigrateToLowerLevelStatus(EJBJar ejbJar) {
        J2EEMigrationStatus status = null;
        if (ejbJar != null) {
            EList beans = ejbJar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                J2EEMigrationStatus beanStatus = this.getMigrateToLowerLevelStatus(bean);
                status = status == null ? beanStatus : status.append(beanStatus);
                ++i;
            }
        }
        return status;
    }

    protected J2EEMigrationStatus getMigrateToLowerLevelStatus(EnterpriseBean bean) {
        if (bean.isMessageDriven() && this.isVersion1_2()) {
            return new J2EEMigrationStatus(2, bean);
        }
        if (bean.isContainerManagedEntity() && bean.isVersion2_X() && this.isVersion1_2()) {
            return new J2EEMigrationStatus(2, bean);
        }
        return null;
    }

    private J2EEMigrationMultiStatus migrateBeans(EJBJar jar) {
        J2EEMigrationMultiStatus status = new J2EEMigrationMultiStatus();
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                status.merge(this.migrate(bean));
                ++i;
            }
        }
        return status;
    }

    public J2EEMigrationStatus migrate(EnterpriseBean anEJB) {
        if (anEJB != null && this.version != null) {
            if (anEJB.isContainerManagedEntity()) {
                return this.migrate((ContainerManagedEntity)anEJB);
            }
            return this.migrateBeanInterfaces(anEJB);
        }
        return new J2EEMigrationStatus(1, anEJB);
    }

    protected J2EEMigrationStatus migrate(ContainerManagedEntity aCMP) {
        if (this.isVersion1_2() && aCMP.isVersion2_X()) {
            return new J2EEMigrationStatus(2, aCMP);
        }
        if (this.isVersion1_3() && aCMP.isVersion1_X()) {
            return this.migrate1_xCMPFor2_0Target(aCMP);
        }
        return new J2EEMigrationStatus(1, aCMP);
    }

    private J2EEMigrationStatus migrate1_xCMPFor2_0Target(ContainerManagedEntity aCMP) {
        aCMP.setVersion("2.x");
        if (!this.isComplex) {
            aCMP.setVersion("1.x");
        } else {
            aCMP.setAbstractSchemaName(aCMP.getName());
        }
        J2EEMigrationStatus resultStatus = this.migrateDataSourceIfNecessary(aCMP);
        resultStatus = this.mergeStatuses(resultStatus, this.migrateExtensionsIfNecessary(aCMP));
        return this.mergeStatuses(resultStatus, new J2EEMigrationStatus(0, aCMP));
    }

    private J2EEMigrationStatus migrateDataSourceIfNecessary(ContainerManagedEntity aCMP) {
        EnterpriseBeanBinding ejbBinding = EJBBindingsHelper.getExistingEjbBinding(aCMP);
        if (ejbBinding != null && ejbBinding.getDatasource() != null) {
            return this.migrateDatasource(ejbBinding);
        }
        return null;
    }

    private J2EEMigrationStatus migrateDatasource(EnterpriseBeanBinding ejbBinding) {
        if (ejbBinding.getCmpConnectionFactory() == null) {
            ResourceRefBinding resBnd = ejbBinding.getDatasource();
            CMPConnectionFactoryBinding connectionFactoryBnd = this.createCMPConnectionFactoryBinding(resBnd);
            ejbBinding.setCmpConnectionFactory(connectionFactoryBnd);
        }
        ejbBinding.setDatasource(null);
        return new J2EEMigrationStatus(0, ejbBinding, this.format("Migrated Datasource binding to a CMP Connection Factory binding for \"{0}\" bean.", ejbBinding.getEnterpriseBean().getName()));
    }

    private J2EEMigrationStatus migrateExtensionsIfNecessary(ContainerManagedEntity aCMP) {
        if (!this.isComplex) {
            return null;
        }
        ContainerManagedEntityExtension cmpExt = (ContainerManagedEntityExtension)EjbExtensionsHelper.getExistingEjbExtension(aCMP);
        if (cmpExt == null) {
            return null;
        }
        String ejbName = aCMP.getName();
        if (ejbName == null) {
            ejbName = J2EESpecificationMigrationConstants.UNNAMED_EJB;
        }
        J2EEMigrationStatus result = this.removeIsolationLevels(cmpExt, ejbName);
        result = this.mergeStatuses(result, this.removeAccessIntents(cmpExt, ejbName));
        result = this.mergeStatuses(result, this.migrateLocalTran(cmpExt, ejbName));
        return this.mergeStatuses(result, this.migrateFinders(cmpExt, ejbName));
    }

    private J2EEMigrationStatus removeAccessIntents(ContainerManagedEntityExtension cmpExt, String ejbName) {
        int size = cmpExt.getAccessIntents().size();
        if (size > 0) {
            cmpExt.getAccessIntents().clear();
            return new J2EEMigrationStatus(0, this.format(J2EESpecificationMigrationConstants.REMOVED_ACCESS_INTENTS_MSG, Integer.toString(size), ejbName));
        }
        return null;
    }

    private J2EEMigrationStatus removeIsolationLevels(ContainerManagedEntityExtension cmpExt, String ejbName) {
        int size = cmpExt.getIsolationLevelAttributes().size();
        if (size > 0) {
            cmpExt.getIsolationLevelAttributes().clear();
            return new J2EEMigrationStatus(0, this.format(J2EESpecificationMigrationConstants.REMOVED_ISOLATION_LEVELS_MSG, Integer.toString(size), ejbName));
        }
        return null;
    }

    private J2EEMigrationStatus migrateLocalTran(ContainerManagedEntityExtension cmpExt, String ejbName) {
        LocalTran localTran = cmpExt.getLocalTran();
        if (localTran == null) {
            return null;
        }
        LocalTransaction localTransaction = ((LocaltranPackage)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/ejs/models/base/extensions/commonext/localtran.ecore")).getLocaltranFactory().createLocalTransaction();
        localTransaction.setBoundary(this.transformBoundary(localTran.getBoundary().getValue()));
        localTransaction.setResolver(this.transformResolver(localTran.getResolver().getValue()));
        localTransaction.setUnresolvedAction(this.transformUnresolvedAction(localTran.getUnresolvedAction().getValue()));
        cmpExt.setLocalTran(null);
        cmpExt.setLocalTransaction(localTransaction);
        return null;
    }

    private LocalTransactionUnresolvedActionKind transformUnresolvedAction(int value) {
        switch (value) {
            case 1: {
                return LocalTransactionUnresolvedActionKind.COMMIT_LITERAL;
            }
            case 0: {
                return LocalTransactionUnresolvedActionKind.ROLLBACK_LITERAL;
            }
        }
        return null;
    }

    private LocalTransactionResolverKind transformResolver(int value) {
        switch (value) {
            case 0: {
                return LocalTransactionResolverKind.APPLICATION_LITERAL;
            }
            case 1: {
                return LocalTransactionResolverKind.CONTAINER_AT_BOUNDARY_LITERAL;
            }
        }
        return null;
    }

    private LocalTransactionBoundaryKind transformBoundary(int value) {
        switch (value) {
            case 0: {
                return LocalTransactionBoundaryKind.ACTIVITY_SESSION_LITERAL;
            }
            case 1: {
                return LocalTransactionBoundaryKind.BEAN_METHOD_LITERAL;
            }
        }
        return null;
    }

    private J2EEMigrationStatus migrateFinders(ContainerManagedEntityExtension cmpExt, String ejbName) {
        if (cmpExt.getFinderDescriptors().size() == 0 || cmpExt.getEnterpriseBean() == null) {
            return null;
        }
        ContainerManagedEntity cmp = cmpExt.getContainerManagedEntity();
        Iterator iter = cmpExt.getFinderDescriptors().iterator();
        J2EEMigrationStatus result = null;
        while (iter.hasNext()) {
            FinderDescriptor finder = (FinderDescriptor)iter.next();
            Query aQuery = this.convertFinderToQuery(finder);
            iter.remove();
            if (aQuery != null) {
                cmp.getQueries().add((Object)aQuery);
            }
            result = this.mergeStatuses(result, this.newMigratedFinderStatus(finder, ejbName));
        }
        return result;
    }

    private MethodElement getMethodElement(FinderDescriptor finder) {
        if (finder.getFinderMethodElements().isEmpty()) {
            return null;
        }
        return (MethodElement)finder.getFinderMethodElements().get(0);
    }

    private Query convertFinderToQuery(FinderDescriptor finder) {
        Query aQuery = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createQuery();
        aQuery.setDescription(J2EESpecificationMigrationConstants.CONVERTED_QUERY_DESCRIPTION);
        aQuery.setQueryMethod(this.convertMethodElementToQueryMethod(this.getMethodElement(finder)));
        aQuery.setEjbQL(this.getEjbQLString(finder));
        return aQuery;
    }

    private String getEjbQLString(FinderDescriptor finder) {
        if (finder.isWhereClauseFinder()) {
            return ((WhereClauseFinderDescriptor)finder).getWhereClause();
        }
        if (finder.isFullSelectFinder()) {
            return ((FullSelectFinderDescriptor)finder).getSelectStatement();
        }
        if (finder.isEjbqlFinder()) {
            return ((EjbqlFinderDescriptor)finder).getEjbqlQueryString();
        }
        return "";
    }

    private QueryMethod convertMethodElementToQueryMethod(MethodElement me) {
        QueryMethod queryMethod = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createQueryMethod();
        queryMethod.setParms(me.getParms());
        queryMethod.setName(me.getName());
        return queryMethod;
    }

    private J2EEMigrationStatus newMigratedFinderStatus(FinderDescriptor finder, String ejbName) {
        MethodElement me = this.getMethodElement(finder);
        if (me == null) {
            return null;
        }
        return new J2EEMigrationStatus(0, this.format(J2EESpecificationMigrationConstants.CONVERTED_FINDER_MSG, me.getSignature(), ejbName));
    }

    protected J2EEMigrationStatus migrateBeanInterfaces(EnterpriseBean anEJB) {
        if (this.isVersion1_2() && anEJB.isVersion2_X() && anEJB.hasLocalClient()) {
            anEJB.setLocalInterface(null);
            anEJB.setLocalHomeInterface(null);
            return new J2EEMigrationStatus(3, anEJB, this.format(J2EESpecificationMigrationConstants.REMOVED_LOCAL_CLIENT_MSG, anEJB.getName()));
        }
        return new J2EEMigrationStatus(1, anEJB);
    }
}

