/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.ejbext;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.etools.ejb.CommonRelationshipRole;
import com.ibm.etools.ejb.ContainerManagedEntity;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaPackage;

public class RoleUtility {
    static final String LINK_CLASS_TYPE_PATTERN = "{0}To{1}Link";
    static final String LINK_GETTER_NAME_PATTERN = "get{0}Link";
    static final String KEY_GETTER_NAME_PATTERN = "get{0}Key";
    static final String KEY_SETTER_NAME_PATTERN = "privateSet{0}Key";
    static final String HOME_FINDER_PATTERN = "find{0}By{1}";
    static final String SECONDARY_SETTER_NAME_PREFIX = "secondarySet";
    static final String SECONDARY_ADD_NAME_PREFIX = "secondaryAdd";
    static final String SECONDARY_REMOVE_NAME_PREFIX = "secondaryRemove";
    static final String SETTER_NAME_PREFIX = "set";
    static final String GETTER_NAME_PREFIX = "get";
    static final String ADD_NAME_PREFIX = "add";
    static final String REMOVE_NAME_PREFIX = "remove";
    static final String PARAMETER_NAME_PREFIX = "arg";
    static final String LINK_IVAR_SUFFIX = "Link";
    static final String EJB_MANY_LINK_INT_NAME = "com.ibm.ivj.ejb.associations.interfaces.ManyLink";
    static final String EJB_SINGLE_LINK_INT_NAME = "com.ibm.ivj.ejb.associations.interfaces.SingleLink";

    protected RoleUtility(EObject aMetaObject) {
    }

    public static void collectLinkClassTypeNames(ContainerManagedEntityExtension cmpExt, List aList) {
        if (cmpExt == null || aList == null) {
            return;
        }
        EList roles = cmpExt.getLocalRelationshipRoles();
        int i = 0;
        while (i < roles.size()) {
            CommonRelationshipRole role = (CommonRelationshipRole)roles.get(i);
            aList.add(RoleUtility.getLinkClassTypeName(role));
            ++i;
        }
    }

    public static void collectRoleMethodNames(ContainerManagedEntityExtension cmpExt, List aList) {
        if (cmpExt == null || aList == null) {
            return;
        }
        EList roles = cmpExt.getLocalRelationshipRoles();
        int i = 0;
        while (i < roles.size()) {
            CommonRelationshipRole role = (CommonRelationshipRole)roles.get(i);
            RoleUtility.collectRoleMethodNames(role, aList);
            ++i;
        }
    }

    public static void collectRoleMethodNames(CommonRelationshipRole aRole, List aList) {
        if (aRole == null || aList == null) {
            return;
        }
        aList.add(RoleUtility.getLinkGetterName(aRole));
        if (aRole.isForward()) {
            aList.add(RoleUtility.getKeyGetterName(aRole));
            aList.add(RoleUtility.getKeySetterName(aRole));
        }
        if (aRole.isNavigable()) {
            aList.add(RoleUtility.getGetterName(aRole));
        }
        if (!RoleUtility.isMany(aRole)) {
            if (!aRole.getOppositeAsCommonRole().isKey()) {
                aList.add(RoleUtility.getSetterName(aRole));
            }
            if (!aRole.isKey()) {
                aList.add(RoleUtility.getSecondarySetterName(aRole));
            }
        } else {
            aList.add(RoleUtility.getSecondaryAddName(aRole));
            aList.add(RoleUtility.getSecondaryRemoveName(aRole));
            if (aRole.isNavigable()) {
                if (!aRole.getOppositeAsCommonRole().isKey()) {
                    aList.add(RoleUtility.getAddName(aRole));
                }
                if (aRole.getOppositeAsCommonRole() != null && !aRole.getOppositeAsCommonRole().isRequired()) {
                    aList.add(RoleUtility.getRemoveName(aRole));
                }
            }
        }
    }

    public static void collectRoleMethodNamesExtended(ContainerManagedEntityExtension cmpExt, List aList) {
        if (cmpExt == null || aList == null) {
            return;
        }
        List roles = cmpExt.getRelationshipRoles();
        int i = 0;
        while (i < roles.size()) {
            CommonRelationshipRole role = (CommonRelationshipRole)roles.get(i);
            RoleUtility.collectRoleMethodNames(role, aList);
            ++i;
        }
    }

    public static final String firstAsUppercase(String aString) {
        if (aString != null && aString.length() > 0 && !Character.isUpperCase(aString.charAt(0))) {
            char[] chars = aString.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return String.valueOf(chars);
        }
        return aString;
    }

    protected static String format(String pattern, String[] replacements) {
        return MessageFormat.format(pattern, replacements);
    }

    public static String getAddName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return ADD_NAME_PREFIX + arg;
    }

    public static String getGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return GETTER_NAME_PREFIX + arg;
    }

    public static String getHomeFinderName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg1 = RoleUtility.firstAsUppercase(aRole.getOppositeAsCommonRole().getName());
        String arg2 = RoleUtility.firstAsUppercase(aRole.getName());
        return RoleUtility.format(HOME_FINDER_PATTERN, new String[]{arg1, arg2});
    }

    public static String getKeyGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return RoleUtility.format(KEY_GETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getKeySetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return RoleUtility.format(KEY_SETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getLinkClassTypeName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String firstArg = RoleUtility.getRoleType(aRole.getOppositeAsCommonRole()).getName();
        String secondArg = RoleUtility.firstAsUppercase(aRole.getName());
        return RoleUtility.format(LINK_CLASS_TYPE_PATTERN, new String[]{firstArg, secondArg});
    }

    public static List getLinkClassTypeNames(ContainerManagedEntityExtension cmpExt) {
        if (cmpExt == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        RoleUtility.collectLinkClassTypeNames(cmpExt, list);
        return list;
    }

    public static String getLinkFieldName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        return String.valueOf(aRole.getName()) + LINK_IVAR_SUFFIX;
    }

    public static String getLinkGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return RoleUtility.format(LINK_GETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getLinkInterfaceTypeName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        if (aRole.isMany()) {
            return EJB_MANY_LINK_INT_NAME;
        }
        return EJB_SINGLE_LINK_INT_NAME;
    }

    public static EList getLocalRelationshipRoles(ContainerManagedEntityExtension cmex) {
        return cmex.getContainerManagedEntity().isVersion1_X() ? cmex.getLocalRelationshipRoles() : new BasicEList((Collection)cmex.getContainerManagedEntity().getRoles());
    }

    public static String getPackageName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        ContainerManagedEntity ejb = aRole.getSourceEntity();
        JavaClass ejbClass = ejb == null ? null : ejb.getEjbClass();
        JavaPackage pack = ejbClass == null ? null : ejbClass.getJavaPackage();
        return pack == null ? null : pack.getName();
    }

    public static String getParameterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return PARAMETER_NAME_PREFIX + arg;
    }

    public static List getQualifiedLinkClassTypeNames(ContainerManagedEntityExtension cmpExt) {
        List linkClassNames = RoleUtility.getLinkClassTypeNames(cmpExt);
        ArrayList<String> qualifiedLinkClassNames = new ArrayList<String>();
        int i = 0;
        while (i < linkClassNames.size()) {
            qualifiedLinkClassNames.add(String.valueOf(cmpExt.getEnterpriseBean().getEjbClass().getJavaPackage().getName()) + "." + (String)linkClassNames.get(i));
            ++i;
        }
        return qualifiedLinkClassNames;
    }

    public static String getRemoveName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return REMOVE_NAME_PREFIX + arg;
    }

    public static ContainerManagedEntity getRoleDeclaringBean(CommonRelationshipRole aRole) {
        if (aRole != null) {
            return aRole.getSourceEntity();
        }
        return null;
    }

    public static List getRoleMethodNames(ContainerManagedEntityExtension cmpExt) {
        ArrayList list = new ArrayList();
        if (cmpExt != null) {
            RoleUtility.collectRoleMethodNames(cmpExt, list);
        }
        return list;
    }

    public static List getRoleMethodNamesExtended(ContainerManagedEntityExtension cmpExt) {
        ArrayList list = new ArrayList();
        if (cmpExt != null) {
            RoleUtility.collectRoleMethodNamesExtended(cmpExt, list);
        }
        return list;
    }

    public static ContainerManagedEntity getRoleType(CommonRelationshipRole aRole) {
        if (aRole != null) {
            return aRole.getSourceEntity();
        }
        return null;
    }

    public static String getSecondaryAddName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return SECONDARY_ADD_NAME_PREFIX + arg;
    }

    public static String getSecondaryRemoveName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return SECONDARY_REMOVE_NAME_PREFIX + arg;
    }

    public static String getSecondarySetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return SECONDARY_SETTER_NAME_PREFIX + arg;
    }

    public static String getSetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleUtility.firstAsUppercase(aRole.getName());
        return SETTER_NAME_PREFIX + arg;
    }

    public static boolean isMany(CommonRelationshipRole aRole) {
        return aRole != null && aRole.isMany();
    }
}

