/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.ejbext;

import com.ibm.ejs.models.base.extensions.ejbext.MofCrawlerListener;
import com.ibm.wtp.internal.emf.utilities.Revisit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class MofCrawler
extends AdapterImpl {
    private HashMap containmentMap = new HashMap();
    private HashSet listeningHashSet = new HashSet();
    private Vector listeners = new Vector();
    private EClass target;
    private boolean fireEvents;
    private EObject startPoint;
    private Notification currentNotification;

    public MofCrawler() {
    }

    public MofCrawler(EClass target) {
        this.setTarget(target);
    }

    protected void setTarget(EClass target) {
        this.target = target;
    }

    protected void addMap(EClass eClass, EReference reference) {
        this.containmentMap.put(eClass, reference);
    }

    private EObject findRoot(EObject refObject) {
        EObject base = refObject.eContainer();
        while (base != null) {
            refObject = base;
            base = refObject.eContainer();
        }
        return refObject;
    }

    protected void setStartPoint(EObject refObject) {
        this.startPoint = refObject;
        this.fireEvents = false;
        this.addRefObject(refObject, 3);
        this.fireEvents = true;
    }

    protected Notification getCurrentNotification() {
        return this.currentNotification;
    }

    public void notifyChanged(Notification msg) {
        this.currentNotification = msg;
        Revisit.toDo();
        this.notifyChangedRevist((Notifier)msg.getNotifier(), msg.getEventType(), (EObject)msg.getFeature(), msg.getOldValue(), msg.getNewValue(), msg.getPosition());
    }

    private void notifyChangedRevist(Notifier notifier, int eventType, EObject feature, Object oldValue, Object newValue, int index) {
        block19: {
            try {
                if (!(notifier instanceof EObject)) break block19;
                EObject refObject = (EObject)notifier;
                switch (eventType) {
                    case 1: 
                    case 3: {
                        if (newValue instanceof EObject) {
                            this.addRefObject((EObject)newValue, 3);
                        }
                        if (refObject.eClass() == this.target) {
                            this.addRefObject(refObject, 3);
                        }
                        break;
                    }
                    case 4: {
                        if (index != -1 && oldValue instanceof EObject) {
                            this.removeRefObject((EObject)oldValue, 4);
                        }
                        if (refObject.eClass() == this.target) {
                            this.removeRefObject(refObject, 4);
                        }
                        break;
                    }
                    case 2: {
                        if (this.containmentMap.containsValue(feature) && oldValue instanceof EObject) {
                            this.removeRefObject((EObject)oldValue, 4);
                        }
                        if (refObject.eClass() == this.target) {
                            this.notifyTarget(refObject, 3);
                        }
                        break;
                    }
                    case 8: {
                        if (oldValue == this) {
                            this.removeAdapter(refObject, eventType, false);
                        }
                        break;
                    }
                    case 5: {
                        Iterator objects = ((Collection)newValue).iterator();
                        while (objects.hasNext()) {
                            Object object = objects.next();
                            if (!(object instanceof EObject)) continue;
                            this.addRefObject((EObject)object, 3);
                        }
                        break;
                    }
                    case 6: {
                        Iterator objects = ((Collection)oldValue).iterator();
                        while (objects.hasNext()) {
                            Object object = objects.next();
                            if (!(object instanceof EObject)) continue;
                            this.removeRefObject((EObject)object, 4);
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removeRefObject(EObject refObject, int eventType) {
        try {
            if (refObject != null) {
                TreeIterator i = EcoreUtil.getAllContents((Collection)refObject.eContents());
                while (i.hasNext()) {
                    this.removeAdapter((EObject)i.next(), eventType);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeAdapter(EObject deleteRefObject, int eventType) {
        this.removeAdapter(deleteRefObject, eventType, true);
    }

    private void removeAdapter(EObject deleteRefObject, int eventType, boolean shouldRemoveCrawler) {
        try {
            if (this.listeningHashSet.contains(deleteRefObject)) {
                this.listeningHashSet.remove(deleteRefObject);
                if (shouldRemoveCrawler) {
                    deleteRefObject.eAdapters().remove((Object)this);
                }
                if (this.fireEvents && this.target == deleteRefObject.eClass()) {
                    this.notifyTarget(deleteRefObject, eventType);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addRefObject(EObject refObject, int eventType) {
        try {
            if (refObject != null && (this.target == refObject.eClass() || this.containmentMap.containsKey(refObject.eClass()))) {
                EReference reference;
                if (!this.listeningHashSet.contains(refObject)) {
                    this.listeningHashSet.add(refObject);
                    refObject.eAdapters().add((Object)this);
                }
                if (this.fireEvents && this.target == refObject.eClass()) {
                    this.notifyTarget(refObject, eventType);
                }
                if ((reference = (EReference)this.containmentMap.get(refObject.eClass())) != null) {
                    Object refValue = refObject.eGet((EStructuralFeature)reference);
                    if (reference.isMany()) {
                        Iterator iterator = ((List)refValue).iterator();
                        while (iterator.hasNext()) {
                            this.addRefObject((EObject)iterator.next(), eventType);
                        }
                    } else {
                        this.addRefObject((EObject)refValue, eventType);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addMofCrawlerListener(MofCrawlerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeMofCrawlerListener(MofCrawlerListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            HashSet clone = (HashSet)this.listeningHashSet.clone();
            this.listeningHashSet.clear();
            Iterator iterator = clone.iterator();
            while (iterator.hasNext()) {
                EObject refObject = (EObject)iterator.next();
                refObject.eAdapters().remove((Object)this);
            }
            MofCrawler.removeInstance(this.startPoint);
        }
    }

    protected static void removeInstance(EObject refObject) {
    }

    protected void notifyTarget(EObject refObject, int eventType) {
        Notification[] notifications = this.createNotification(refObject, eventType);
        if (notifications != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                MofCrawlerListener listener = (MofCrawlerListener)iterator.next();
                int i = 0;
                while (i < notifications.length) {
                    if (notifications[i] != null) {
                        listener.notifyCrawlerChangedEvent(notifications[i]);
                    }
                    ++i;
                }
            }
        }
    }

    protected abstract Notification[] createNotification(EObject var1, int var2);
}

