/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.IBMCertPathHelper;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.InhibitAnyPolicyExtension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PolicyConstraintsExtension;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

class CertPathUtil {
    static final int SUCCESS = 0;
    static final int NO_TRUST_BASE = 1;
    static final int NAME_CHAINING_ERROR = 4;
    static final int FAIL = Integer.MAX_VALUE;
    static final String LDAP_URI_START = "ldap://";
    static final String HTTP_URI_START = "http://";
    static final String URI_NAME = "URIName: ";
    private static Debug debug = Debug.getInstance((String)"certpath");

    CertPathUtil() {
    }

    static Object[] getExtension(String string, X509CRL x509CRL) throws CertPathValidatorException {
        boolean bl = false;
        String string2 = OIDMap.getOID((String)string).toString();
        byte[] byArray = x509CRL.getExtensionValue(string2);
        if (byArray != null) {
            bl = x509CRL.getCriticalExtensionOIDs().contains(string2);
            try {
                byArray = new DerValue(byArray).getOctetString();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        Object[] objectArray = new Object[]{new Boolean(bl), byArray};
        return objectArray;
    }

    static Object[] getExtension(String string, X509Certificate x509Certificate) throws CertPathValidatorException {
        Object[] objectArray;
        boolean bl = false;
        String string2 = null;
        ObjectIdentifier objectIdentifier = OIDMap.getOID((String)string);
        if (objectIdentifier == null) {
            throw new CertPathValidatorException("An internal error has occurred. The extension definition could not be found:" + string + ".");
        }
        string2 = OIDMap.getOID((String)string).toString();
        byte[] byArray = x509Certificate.getExtensionValue(string2);
        if (byArray != null) {
            objectArray = x509Certificate.getCriticalExtensionOIDs();
            bl = objectArray.contains(string2);
            try {
                DerValue derValue = new DerValue(byArray);
                byArray = derValue.getOctetString();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        objectArray = new Object[]{new Boolean(bl), byArray};
        return objectArray;
    }

    static void removeExtensions(Collection collection, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            collection.remove(stringArray[i]);
        }
    }

    static Object[] getBasicConstraints(X509Certificate x509Certificate) throws CertPathValidatorException {
        Object[] objectArray = new Object[3];
        BasicConstraintsExtension basicConstraintsExtension = null;
        Object[] objectArray2 = CertPathUtil.getExtension("x509.info.extensions.BasicConstraints", x509Certificate);
        if (objectArray2[1] != null) {
            try {
                basicConstraintsExtension = new BasicConstraintsExtension((Boolean)objectArray2[0], objectArray2[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        objectArray[0] = basicConstraintsExtension;
        if (basicConstraintsExtension == null) {
            objectArray[1] = Boolean.FALSE;
            objectArray[2] = new Integer(Integer.MAX_VALUE);
        } else {
            try {
                objectArray[1] = basicConstraintsExtension.get("is_ca");
                objectArray[2] = basicConstraintsExtension.get("path_len");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        return objectArray;
    }

    static int verifyIssuer(X509Certificate x509Certificate, PublicKey publicKey, Principal principal, String string) throws CertPathValidatorException {
        int n = Integer.MAX_VALUE;
        if (publicKey == null || principal == null) {
            throw new CertPathValidatorException("No trust base");
        }
        if (((Object)x509Certificate.getIssuerDN()).equals(principal)) {
            try {
                CertPathUtil.verifySignature(x509Certificate, publicKey, string);
                n = 0;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertPathValidatorException(certificateNotYetValidException.getMessage());
            }
        } else {
            throw new CertPathValidatorException("Certificate chaining error");
        }
        return n;
    }

    static TrustAnchor findIssuer(X509Certificate x509Certificate, Collection collection, String string) throws CertPathValidatorException {
        TrustAnchor trustAnchor = null;
        Iterator iterator = collection.iterator();
        TrustAnchor trustAnchor2 = null;
        X509Certificate x509Certificate2 = null;
        int n = Integer.MAX_VALUE;
        String string2 = null;
        if (!(x509Certificate instanceof X509CertImpl)) {
            try {
                x509Certificate = new X509CertImpl(x509Certificate.getEncoded());
            }
            catch (CertificateException certificateException) {
                throw new CertPathValidatorException(certificateException.getMessage());
            }
        }
        while (iterator.hasNext()) {
            trustAnchor2 = (TrustAnchor)iterator.next();
            x509Certificate2 = trustAnchor2.getTrustedCert();
            if (x509Certificate2 != null) {
                if (!(x509Certificate2 instanceof X509CertImpl)) {
                    try {
                        x509Certificate2 = new X509CertImpl(x509Certificate2.getEncoded());
                    }
                    catch (CertificateException certificateException) {
                        throw new CertPathValidatorException(certificateException.getMessage());
                    }
                }
                try {
                    n = CertPathUtil.verifyIssuer(x509Certificate, x509Certificate2.getPublicKey(), x509Certificate2.getSubjectDN(), string);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    string2 = certPathValidatorException.getMessage();
                }
                if (n != 0) continue;
                trustAnchor = trustAnchor2;
                break;
            }
            try {
                X500Name x500Name = IBMCertPathHelper.getCA(trustAnchor2);
                n = CertPathUtil.verifyIssuer(x509Certificate, trustAnchor2.getCAPublicKey(), (Principal)x500Name, string);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                string2 = certPathValidatorException.getMessage();
            }
            if (n != 0) continue;
            trustAnchor = trustAnchor2;
            break;
        }
        if (trustAnchor != null) {
            return trustAnchor;
        }
        throw new CertPathValidatorException(string2);
    }

    static boolean findIssuerForCRSCheck(X509Certificate x509Certificate, Collection collection, String string) {
        Iterator iterator = collection.iterator();
        X509Certificate x509Certificate2 = null;
        int n = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2 == null) continue;
            try {
                n = CertPathUtil.verifyIssuer(x509Certificate, x509Certificate2.getPublicKey(), x509Certificate2.getSubjectDN(), string);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                continue;
            }
            if (n != 0) continue;
            return true;
        }
        return false;
    }

    static void verifySignature(X509Certificate x509Certificate, PublicKey publicKey, String string) throws CertificateNotYetValidException {
        try {
            if (string == null) {
                x509Certificate.verify(publicKey);
            } else {
                x509Certificate.verify(publicKey, string);
            }
        }
        catch (SignatureException signatureException) {
            throw new CertificateNotYetValidException(signatureException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertificateNotYetValidException(invalidKeyException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CertificateNotYetValidException(noSuchProviderException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateNotYetValidException(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new CertificateNotYetValidException(certificateException.getMessage());
        }
    }

    static boolean[] getKeyUsage(X509Certificate x509Certificate) throws CertPathValidatorException {
        KeyUsageExtension keyUsageExtension = null;
        boolean[] blArray = null;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.KeyUsage", x509Certificate);
        if (objectArray[1] != null) {
            try {
                keyUsageExtension = new KeyUsageExtension((Boolean)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        if (keyUsageExtension != null) {
            try {
                blArray = new boolean[9];
                blArray[0] = (Boolean)keyUsageExtension.get("digital_signature");
                blArray[1] = (Boolean)keyUsageExtension.get("non_repudiation");
                blArray[2] = (Boolean)keyUsageExtension.get("key_encipherment");
                blArray[4] = (Boolean)keyUsageExtension.get("key_agreement");
                blArray[5] = (Boolean)keyUsageExtension.get("key_certsign");
                blArray[6] = (Boolean)keyUsageExtension.get("crl_sign");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        return blArray;
    }

    static Collection getExtendedKeyUsage(X509Certificate x509Certificate) throws CertPathValidatorException {
        ExtKeyUsageExtension extKeyUsageExtension = null;
        Vector<String> vector = null;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.ExtKeyUsage", x509Certificate);
        if (objectArray[1] != null) {
            try {
                extKeyUsageExtension = new ExtKeyUsageExtension((Boolean)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        if (extKeyUsageExtension != null && extKeyUsageExtension.isCritical()) {
            try {
                Vector vector2 = (Vector)extKeyUsageExtension.get("extkeyusage");
                vector = new Vector<String>();
                Iterator iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    ObjectIdentifier objectIdentifier = (ObjectIdentifier)iterator.next();
                    vector.add(objectIdentifier.toString());
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        return vector;
    }

    static Extension getPolicyInformation(X509Certificate x509Certificate, Collection collection, boolean bl) throws CertPathValidatorException {
        CertificatePoliciesExtension certificatePoliciesExtension = null;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.CertificatePolicies", x509Certificate);
        if (objectArray[1] != null) {
            try {
                certificatePoliciesExtension = new CertificatePoliciesExtension((Boolean)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        if (certificatePoliciesExtension != null) {
            try {
                Vector vector = (Vector)certificatePoliciesExtension.get("cert_policies");
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    PolicyInformation policyInformation = (PolicyInformation)iterator.next();
                    Object[] objectArray2 = new Object[]{policyInformation.getPolicyIdentifier(), bl ? null : policyInformation.getPolicyQualifiers()};
                    collection.add(objectArray2);
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        return certificatePoliciesExtension;
    }

    static int[] getPolicyConstraints(X509Certificate x509Certificate) throws CertPathValidatorException {
        int[] nArray = new int[2];
        PolicyConstraintsExtension policyConstraintsExtension = null;
        nArray[0] = Integer.MAX_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.PolicyConstraints", x509Certificate);
        if (objectArray[1] == null) {
            return null;
        }
        try {
            policyConstraintsExtension = new PolicyConstraintsExtension((Boolean)objectArray[0], objectArray[1]);
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("An internal error has occurred.", iOException);
        }
        if (policyConstraintsExtension != null) {
            try {
                nArray[0] = (Integer)policyConstraintsExtension.get("require");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
            try {
                nArray[1] = (Integer)policyConstraintsExtension.get("inhibit");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        return nArray;
    }

    static int getInhibitAnyPolicy(X509Certificate x509Certificate) throws CertPathValidatorException {
        int n = Integer.MAX_VALUE;
        InhibitAnyPolicyExtension inhibitAnyPolicyExtension = null;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.InhibitAnyPolicy", x509Certificate);
        if (objectArray[1] != null) {
            try {
                inhibitAnyPolicyExtension = new InhibitAnyPolicyExtension((Boolean)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        if (inhibitAnyPolicyExtension != null) {
            try {
                n = ((BigInteger)inhibitAnyPolicyExtension.get("value")).intValue();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        return n;
    }

    static DistributionPoint[] getCRLDistributionPoints(X509Certificate x509Certificate) throws CertPathValidatorException {
        CRLDistributionPointsExtension cRLDistributionPointsExtension = null;
        DistributionPoint[] distributionPointArray = null;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.CRLDistributionPoints", x509Certificate);
        if (objectArray[1] != null) {
            try {
                cRLDistributionPointsExtension = new CRLDistributionPointsExtension((Boolean)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        if (cRLDistributionPointsExtension != null) {
            try {
                distributionPointArray = (DistributionPoint[])cRLDistributionPointsExtension.get("distribution_pts");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        return distributionPointArray;
    }

    static X509Certificate findIssuerOfCRL(X509CRL x509CRL, Collection collection, Collection collection2, Collection collection3, String string) throws CertificateNotYetValidException {
        int n = Integer.MAX_VALUE;
        X509Certificate x509Certificate = null;
        x509Certificate = CertPathUtil.findIssuerOfCRL(x509CRL, collection, string);
        if (x509Certificate == null) {
            x509Certificate = CertPathUtil.findIssuerOfCRL(x509CRL, collection2, string);
        }
        if (x509Certificate == null) {
            Iterator iterator = collection3.iterator();
            while (iterator.hasNext() && x509Certificate == null) {
                CertStore certStore = (CertStore)iterator.next();
                try {
                    X509CertSelector x509CertSelector = new X509CertSelector();
                    Principal principal = x509CRL.getIssuerDN();
                    if (principal instanceof X500Name) {
                        IBMCertPathHelper.setSubject(x509CertSelector, (X500Name)principal);
                    } else {
                        x509CertSelector.setSubject(x509CRL.getIssuerX500Principal().getName());
                    }
                    Collection<? extends Certificate> collection4 = certStore.getCertificates(x509CertSelector);
                    x509Certificate = CertPathUtil.findIssuerOfCRL(x509CRL, collection4, string);
                }
                catch (CertStoreException certStoreException) {
                }
                catch (IOException iOException) {}
            }
        }
        return x509Certificate;
    }

    static X509Certificate findIssuerOfCRL(X509CRL x509CRL, Collection collection, String string) throws CertificateNotYetValidException {
        int n = Integer.MAX_VALUE;
        X509Certificate x509Certificate = null;
        TrustAnchor trustAnchor = null;
        if (collection == null) {
            n = 1;
        } else if (collection != null) {
            if (collection.isEmpty()) {
                n = 1;
            } else {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof X509Certificate) {
                        x509Certificate = (X509Certificate)e;
                        if (!(x509Certificate instanceof X509CertImpl)) {
                            try {
                                x509Certificate = new X509CertImpl(x509Certificate.getEncoded());
                            }
                            catch (CertificateException certificateException) {
                                throw new CertificateNotYetValidException(certificateException.getMessage());
                            }
                        }
                        n = CertPathUtil.verifyCRLIssuer(x509CRL, x509Certificate.getPublicKey(), x509Certificate.getSubjectDN(), string);
                    } else if (e instanceof TrustAnchor) {
                        trustAnchor = (TrustAnchor)e;
                        x509Certificate = trustAnchor.getTrustedCert();
                        if (x509Certificate != null) {
                            if (!(x509Certificate instanceof X509CertImpl)) {
                                try {
                                    x509Certificate = new X509CertImpl(x509Certificate.getEncoded());
                                }
                                catch (CertificateException certificateException) {
                                    throw new CertificateNotYetValidException(certificateException.getMessage());
                                }
                            }
                            n = CertPathUtil.verifyCRLIssuer(x509CRL, x509Certificate.getPublicKey(), x509Certificate.getSubjectDN(), string);
                        } else {
                            X500Name x500Name = IBMCertPathHelper.getCA(trustAnchor);
                            n = CertPathUtil.verifyCRLIssuer(x509CRL, trustAnchor.getCAPublicKey(), (Principal)x500Name, string);
                        }
                    }
                    if (n != 0) continue;
                }
            }
        }
        if (n == 0) {
            return x509Certificate;
        }
        return null;
    }

    static int verifyCRLIssuer(X509CRL x509CRL, PublicKey publicKey, Principal principal, String string) throws CertificateNotYetValidException {
        int n = 0;
        if (publicKey == null || principal == null) {
            n = 1;
        } else if (((Object)x509CRL.getIssuerDN()).equals(principal)) {
            CertPathUtil.verifySignature(x509CRL, publicKey, string);
        } else {
            n = 4;
        }
        return n;
    }

    static void verifySignature(X509CRL x509CRL, PublicKey publicKey, String string) throws CertificateNotYetValidException {
        try {
            x509CRL.verify(publicKey, string);
        }
        catch (SignatureException signatureException) {
            throw new CertificateNotYetValidException(signatureException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertificateNotYetValidException(invalidKeyException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CertificateNotYetValidException(noSuchProviderException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateNotYetValidException(noSuchAlgorithmException.getMessage());
        }
        catch (CRLException cRLException) {
            throw new CertificateNotYetValidException(cRLException.getMessage());
        }
    }

    static Principal findDNCRLIssuer(GeneralNames generalNames) {
        boolean bl = true;
        GeneralName generalName = null;
        if (generalNames != null) {
            int n = 0;
            while (bl) {
                try {
                    generalName = generalNames.getGeneralName(n);
                }
                catch (GeneralNamesException generalNamesException) {
                    bl = false;
                }
                if (generalName != null) {
                    if (generalName.getType() == 4) {
                        bl = false;
                    } else {
                        generalName = null;
                    }
                }
                ++n;
            }
        }
        X500Name x500Name = null;
        if (generalName != null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            try {
                generalName.encode(derOutputStream);
                DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
                DerValue derValue = derInputStream.getDerValue();
                byte[] byArray = derValue.getData().getDerValue().toByteArray();
                x500Name = new X500Name(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return x500Name;
    }

    static GeneralName getSupportedNameObjectFromGeneralNames(GeneralNames generalNames) {
        GeneralName generalName = null;
        if (generalNames != null) {
            try {
                String string;
                generalName = generalNames.getGeneralName(6);
                if (generalName != null && !CertPathUtil.isSupportedURI(string = CertPathUtil.stripJunk(generalName.toString()))) {
                    generalName = null;
                }
                if (generalName == null) {
                    generalName = generalNames.getGeneralName(4);
                }
            }
            catch (GeneralNamesException generalNamesException) {
                generalName = null;
            }
        }
        return generalName;
    }

    static boolean isEqualReasons(boolean[] blArray, boolean[] blArray2) {
        boolean bl = false;
        if (blArray == blArray2) {
            bl = true;
        } else if (blArray.length == blArray2.length) {
            int n = 0;
            for (n = 0; n < blArray.length && blArray[n] == blArray2[n]; ++n) {
            }
            bl = n >= blArray.length;
        }
        return bl;
    }

    static void unionReasons(boolean[] blArray, boolean[] blArray2) {
        int n = Math.min(blArray.length, blArray2.length);
        for (int i = 0; i < n; ++i) {
            if (!blArray2[i]) continue;
            blArray[i] = true;
        }
    }

    static boolean minimalUserReasonsSatisfied(boolean[] blArray, boolean[] blArray2) {
        int n = Math.min(blArray.length, blArray2.length);
        boolean bl = false;
        for (int i = 0; i < n && !bl; ++i) {
            if (!blArray[i] || !blArray2[i]) continue;
            bl = true;
        }
        return bl;
    }

    static boolean allUserReasonsSatisfied(boolean[] blArray, boolean[] blArray2) {
        int n = Math.min(blArray.length, blArray2.length);
        boolean bl = true;
        for (int i = 0; i < n && bl; ++i) {
            if (blArray[i] && blArray2[i] || !blArray[i]) continue;
            bl = false;
        }
        return bl;
    }

    static boolean interimContainMoreReasons(boolean[] blArray, boolean[] blArray2) {
        int n = Math.min(blArray.length, blArray2.length);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (blArray[i] && blArray2[i]) continue;
            if (blArray[i] && !blArray2[i]) {
                bl = true;
                break;
            }
            if (blArray[i]) continue;
        }
        return bl;
    }

    static void intersectReasons(boolean[] blArray, boolean[] blArray2) {
        int n;
        int n2 = Math.min(blArray.length, blArray2.length);
        for (n = 0; n < n2; ++n) {
            if (blArray[n] && blArray2[n]) continue;
            blArray[n] = false;
        }
        for (n = n2; n < blArray.length; ++n) {
            blArray[n] = false;
        }
    }

    static DirContext getDirContext(String string) {
        if (debug != null) {
            System.out.println("CERTPATH: connect to " + string);
        }
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", string);
        InitialDirContext initialDirContext = null;
        try {
            initialDirContext = new InitialDirContext(properties);
        }
        catch (NamingException namingException) {
            if (debug != null) {
                System.err.println("CERTPATH: getDirContext failed: " + namingException.getMessage());
            }
            initialDirContext = null;
        }
        return initialDirContext;
    }

    static X509CRLImpl[] retrieveCRLs(DirContext dirContext, String string, String[] stringArray) {
        X509CRLImpl[] x509CRLImplArray;
        block7: {
            x509CRLImplArray = new X509CRLImpl[stringArray.length];
            try {
                Attributes attributes = dirContext.getAttributes(string, stringArray);
                if (attributes != null && attributes.size() != 0) {
                    NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                    while (namingEnumeration.hasMoreElements()) {
                        Attribute attribute = namingEnumeration.next();
                        String string2 = attribute.getID();
                        int n = 0;
                        for (n = 0; n < stringArray.length; ++n) {
                            if (!string2.equalsIgnoreCase(stringArray[n])) continue;
                            Object object = attribute.get();
                            x509CRLImplArray[n / 2] = new X509CRLImpl((byte[])object);
                            if (debug == null) continue;
                            System.out.println("CERTPATH: retrieveCRLs, crl with type: " + stringArray[n]);
                        }
                    }
                }
            }
            catch (NamingException namingException) {
                if (debug != null) {
                    System.err.println("CERTPATH: NewGetAttr failed: " + namingException.getMessage());
                }
            }
            catch (CRLException cRLException) {
                if (debug == null) break block7;
                System.err.println("CERTPATH: NewGetAttr failed: " + cRLException.getMessage());
            }
        }
        return x509CRLImplArray;
    }

    static boolean isSupportedURI(String string) {
        if (CertPathUtil.isLDAPURI(string)) {
            return true;
        }
        return CertPathUtil.isHTTPURI(string);
    }

    static boolean isLDAPURI(String string) {
        boolean bl = false;
        bl = string.regionMatches(true, 0, LDAP_URI_START, 0, LDAP_URI_START.length());
        return bl;
    }

    static boolean isHTTPURI(String string) {
        boolean bl = false;
        bl = string.regionMatches(true, 0, HTTP_URI_START, 0, HTTP_URI_START.length());
        return bl;
    }

    static String stripJunk(String string) {
        String string2 = string;
        if (string.startsWith(URI_NAME)) {
            string2 = string2.substring(URI_NAME.length());
        }
        return string2;
    }

    static boolean isCACert(X509Certificate x509Certificate) throws CertPathValidatorException {
        Object[] objectArray = CertPathUtil.getBasicConstraints(x509Certificate);
        return !objectArray[1].equals(Boolean.FALSE);
    }
}

