/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.CacheEvictionListener;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.zOS.SAFCredentialTokenImpl;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;

public final class PlatformCredentialManager {
    public static final String DEFAULT_UNAUTHENTICATED_AUDIT_STRING = "WebSphere Default/Unauthenticated Login";
    private static final String DEFAULT_PASSWORD_AUDIT_STRING = "WebSphere Userid/Password Login";
    private static final String DEFAULT_CERTIFICATE_AUDIT_STRING = "WebSphere Certificate Login";
    private static final String DEFAULT_AUTHORIZED_CREATE_AUDIT_STRING = "WebSphere Authorized Login";
    private static final TraceComponent tc = Tr.register((Class)PlatformCredentialManager.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final PlatformCredentialManager _instance = new PlatformCredentialManager();
    private String unauthenticatedUserId;
    private Cache _cache;

    public static PlatformCredentialManager instance() {
        return _instance;
    }

    private PlatformCredentialManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        int n = 100;
        long l = 300000L;
        int n2 = 1000;
        this._cache = new Cache(n, l, n2, new CacheEvictionCallback());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public PlatformCredential createPasswordCredential(String string, String string2) throws PasswordCheckFailedException {
        return this.createPasswordCredential(string, string2, DEFAULT_PASSWORD_AUDIT_STRING);
    }

    public PlatformCredential createCertificateCredential(X509Certificate[] x509CertificateArray) throws CertificateMapFailedException {
        return this.createCertificateCredential(x509CertificateArray, DEFAULT_CERTIFICATE_AUDIT_STRING);
    }

    public PlatformCredential createCredential(String string) {
        return this.createCredential(string, DEFAULT_AUTHORIZED_CREATE_AUDIT_STRING);
    }

    public PlatformCredential createDefaultCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDefaultCredential");
        }
        PlatformCredential platformCredential = new PlatformCredential();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDefaultCredential", (Object)platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createPasswordCredential(String string, String string2, String string3) throws PasswordCheckFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createPasswordCredential", (Object)new Object[]{string, string2 != null ? "****" : null, string3});
        }
        PlatformCredential platformCredential = new PlatformCredential(PlatformCredential.BASIC, string, string3);
        try {
            this.authenticateCredential(platformCredential, string2);
        }
        catch (Throwable throwable) {
            throw new PasswordCheckFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createPasswordCredential", (Object)platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createCertificateCredential(X509Certificate[] x509CertificateArray, String string) throws CertificateMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCertificateCredential", (Object)new Object[]{x509CertificateArray, string});
        }
        PlatformCredential platformCredential = new PlatformCredential(x509CertificateArray, string);
        try {
            this.authenticateCredential(platformCredential, null);
        }
        catch (Throwable throwable) {
            throw new CertificateMapFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCertificateCredential", (Object)platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createRoleCredential(String string, String string2, String string3) {
        PlatformCredential platformCredential;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createRoleCredential", (Object)new Object[]{string, string2, string3});
            }
            String string4 = this.createRoleAuditString(string, string2, string3);
            platformCredential = new PlatformCredential(PlatformCredential.ROLE, string3, string4);
            try {
                SAFCredentialTokenImpl sAFCredentialTokenImpl = this.getCredentialToken(platformCredential);
                if (sAFCredentialTokenImpl != null) {
                    platformCredential.setMvsUserId(sAFCredentialTokenImpl.getMvsUserId());
                } else {
                    platformCredential = null;
                }
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Credential destroyed", (Object)((Object)credentialDestroyedException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRoleCredential", (Object)platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createCredential(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCredential", (Object)new Object[]{string, string2});
        }
        PlatformCredential platformCredential = new PlatformCredential(PlatformCredential.ASSERTED, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)platformCredential);
        }
        return platformCredential;
    }

    public PlatformCredential createServerCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createServerCredential", null);
        }
        String string = System.getProperty("user.name");
        PlatformCredential platformCredential = new PlatformCredential(PlatformCredential.SERVER, string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createServerCredential", (Object)platformCredential);
        }
        return platformCredential;
    }

    private String createRoleAuditString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("WebSphere Role Delegation:");
        stringBuffer.append(" Application=").append(string);
        stringBuffer.append(",Role=").append(string2);
        stringBuffer.append(",Profile=").append(string3);
        return stringBuffer.toString();
    }

    public String getKeyFromCredential(PlatformCredential platformCredential) {
        String string;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getKeyFromCredential", (Object)platformCredential);
            }
            string = null;
            try {
                SAFCredentialTokenImpl sAFCredentialTokenImpl = this.getCredentialToken(platformCredential);
                if (sAFCredentialTokenImpl == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Unable to get native credential token from PlatFormCredential");
                    }
                    throw new IllegalArgumentException("Unable to get native credential token from PlatFormCredential");
                }
                string = sAFCredentialTokenImpl.getAsString();
                this._cache.insert(string, platformCredential);
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Credential already destroyed", (Object)((Object)credentialDestroyedException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKeyFromCredential", (Object)string);
        }
        return string;
    }

    public PlatformCredential getCredentialFromKey(String string) {
        PlatformCredential platformCredential;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getCredentialFromKey", (Object)string);
            }
            platformCredential = null;
            try {
                platformCredential = (PlatformCredential)this._cache.get(string);
            }
            catch (CacheException cacheException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Unexpected cache exception", (Object)((Object)cacheException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCredentialFromKey", (Object)platformCredential);
        }
        return platformCredential;
    }

    public byte[] createUtoken(PlatformCredential platformCredential) {
        byte[] byArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createUtoken", (Object)platformCredential);
            }
            byArray = null;
            if (platformCredential.getUserId() == null) {
                SAFCredentialTokenImpl sAFCredentialTokenImpl = null;
                try {
                    sAFCredentialTokenImpl = this.getCredentialToken(platformCredential);
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Unable to create UTOKEN", (Object)((Object)credentialDestroyedException));
                }
            }
        }
        if (platformCredential.getUserId() != null) {
            byArray = this.ntv_createUtoken(platformCredential.getUserId());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createUtoken", (Object)byArray);
        }
        return byArray;
    }

    private SAFCredentialTokenImpl getCredentialToken(PlatformCredential platformCredential) throws CredentialDestroyedException {
        SAFCredentialTokenImpl sAFCredentialTokenImpl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getCredentialToken", (Object)platformCredential);
            }
            sAFCredentialTokenImpl = null;
            try {
                sAFCredentialTokenImpl = (SAFCredentialTokenImpl)this._cache.get(platformCredential);
            }
            catch (CacheException cacheException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Unexpected cache exception", (Object)((Object)cacheException));
            }
        }
        if (sAFCredentialTokenImpl == null) {
            sAFCredentialTokenImpl = this.refreshCredential(platformCredential);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCredentialToken", (Object)sAFCredentialTokenImpl);
        }
        return sAFCredentialTokenImpl;
    }

    public SAFCredentialTokenImpl refreshCredential(PlatformCredential platformCredential) throws CredentialDestroyedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshCredential", (Object)platformCredential);
        }
        if (platformCredential.getCredentialType() == PlatformCredential.BASIC && !platformCredential.isAuthenticated()) {
            throw new CredentialDestroyedException();
        }
        SAFCredentialTokenImpl sAFCredentialTokenImpl = null;
        if (platformCredential.getCredentialType() == PlatformCredential.DEFAULT) {
            sAFCredentialTokenImpl = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), null);
        } else if (platformCredential.getCredentialType() == PlatformCredential.BASIC) {
            sAFCredentialTokenImpl = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), null);
        } else if (platformCredential.getCredentialType() == PlatformCredential.ASSERTED) {
            sAFCredentialTokenImpl = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), null);
        } else if (platformCredential.getCredentialType() == PlatformCredential.ROLE) {
            sAFCredentialTokenImpl = this.ntv_createRoleCredentialToken(platformCredential, platformCredential.getRoleProfile(), platformCredential.getAuditString());
            if (sAFCredentialTokenImpl != null) {
                sAFCredentialTokenImpl.setMvsUserId(platformCredential.getUserId());
            }
        } else if (platformCredential.getCredentialType() == PlatformCredential.SERVER) {
            sAFCredentialTokenImpl = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), null);
        } else if (platformCredential.getCredentialType() == PlatformCredential.CERTIFICATE) {
            byte[] byArray = this.getEncodedCertificate(platformCredential);
            sAFCredentialTokenImpl = this.ntv_createCertificateCredentialToken(platformCredential, byArray, byArray.length, platformCredential.getAuditString());
        } else {
            throw new IllegalArgumentException();
        }
        if (sAFCredentialTokenImpl != null) {
            this._cache.insert(platformCredential, sAFCredentialTokenImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refreshCredential", (Object)sAFCredentialTokenImpl);
        }
        return sAFCredentialTokenImpl;
    }

    private SAFCredentialTokenImpl authenticateCredential(PlatformCredential platformCredential, String string) throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"authenticateCredential", (Object)new Object[]{platformCredential, string != null ? "****" : null});
        }
        SAFCredentialTokenImpl sAFCredentialTokenImpl = null;
        if (platformCredential.getCredentialType() == PlatformCredential.BASIC) {
            sAFCredentialTokenImpl = this.ntv_createCredentialToken(platformCredential, platformCredential.getUserId(), platformCredential.getAuditString(), string);
        } else if (platformCredential.getCredentialType() == PlatformCredential.CERTIFICATE) {
            byte[] byArray = this.getEncodedCertificate(platformCredential);
            sAFCredentialTokenImpl = this.ntv_createCertificateCredentialToken(platformCredential, byArray, byArray.length, platformCredential.getAuditString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Updated PlatformCredential", (Object)platformCredential);
        }
        if (sAFCredentialTokenImpl == null) {
            throw new AuthenticationFailedException();
        }
        this._cache.insert(platformCredential, sAFCredentialTokenImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authenticateCredential", (Object)sAFCredentialTokenImpl);
        }
        return sAFCredentialTokenImpl;
    }

    private byte[] getEncodedCertificate(PlatformCredential platformCredential) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getEncodedCertificate", (Object)platformCredential);
            }
            byArray = null;
            try {
                X509Certificate x509Certificate = platformCredential.getCertificateChain()[0];
                byArray = x509Certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Unable to get certificate data", (Object)certificateEncodingException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEncodedCertificate", (Object)byArray);
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOSThreadSecurityEnvironment(PlatformCredential platformCredential) throws CredentialDestroyedException, IllegalArgumentException {
        SAFCredentialTokenImpl sAFCredentialTokenImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setOSThreadSecurityEnvironment", (Object)platformCredential);
        }
        if ((sAFCredentialTokenImpl = this.getCredentialToken(platformCredential)) == null) throw new IllegalArgumentException("SAF cred token from PlatformCredential is null.");
        int n = this.ntv_setOSThreadSecurityEnvironment(platformCredential);
        if (n == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ntv_setOSThreadSecurityEnvironment failed, attempting to refresh credential", null);
            }
            if ((sAFCredentialTokenImpl = this.refreshCredential(platformCredential)) == null) throw new IllegalArgumentException("SAF cred token from PlatformCredential is null.");
            n = this.ntv_setOSThreadSecurityEnvironment(platformCredential);
            if (n != 0) {
                if (!tc.isDebugEnabled()) throw new IllegalArgumentException("Unable to set SAF cred token on native thread.");
                Tr.debug((TraceComponent)tc, (String)"Second ntv_setOSThreadSecurityEnvironment failed, return code:", (Object)new Integer(n));
                throw new IllegalArgumentException("Unable to set SAF cred token on native thread.");
            }
        } else if (n != 0) {
            if (!tc.isDebugEnabled()) throw new IllegalArgumentException("Unable to set SAF cred token on native thread.");
            Tr.debug((TraceComponent)tc, (String)"ntv_setOSThreadSecurityEnvironment failed, return code:", (Object)new Integer(n));
            throw new IllegalArgumentException("Unable to set SAF cred token on native thread.");
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setOSThreadSecurityEnvironment");
    }

    private native SAFCredentialTokenImpl ntv_createCredentialToken(PlatformCredential var1, String var2, String var3, String var4);

    private native SAFCredentialTokenImpl ntv_createCertificateCredentialToken(PlatformCredential var1, byte[] var2, int var3, String var4);

    private native SAFCredentialTokenImpl ntv_createRoleCredentialToken(PlatformCredential var1, String var2, String var3);

    private native int ntv_setOSThreadSecurityEnvironment(PlatformCredential var1);

    private native void ntv_destroyCredential(SAFCredentialTokenImpl var1);

    private native byte[] ntv_createUtoken(String var1);

    private static final class CacheEvictionCallback
    implements CacheEvictionListener {
        CacheEvictionCallback() {
        }

        public void evicted(List list) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"evicted", (Object)list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SAFCredentialTokenImpl)) continue;
                _instance.ntv_destroyCredential((SAFCredentialTokenImpl)e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"evicted");
            }
        }
    }
}

