/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.web.WebReply;
import com.ibm.ws.webcontainer.srt.IExtendedResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class RedirectReply
extends WebReply {
    private ArrayList cookieList = null;
    private static TraceComponent tc = Tr.register((Class)RedirectReply.class, null, (String)"com.ibm.ejs.resources.security");
    private static String LOCATION_HDR = "Location";
    private static int replyCode = 0;

    public RedirectReply(String string) {
        super(RedirectReply.getReplyCode(), string);
    }

    public RedirectReply(String string, ArrayList arrayList) {
        super(RedirectReply.getReplyCode(), string);
        this.cookieList = arrayList;
    }

    public void writeResponse(HttpServletResponse httpServletResponse) throws IOException {
        if (this.cookieList != null && this.cookieList.size() > 0) {
            ListIterator listIterator = this.cookieList.listIterator();
            while (listIterator.hasNext()) {
                Cookie cookie = (Cookie)listIterator.next();
                if (cookie == null) continue;
                httpServletResponse.addCookie(cookie);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Security redirect code: " + this.getStatusCode()));
        }
        if (this.getStatusCode() != 303) {
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(this.message));
        } else if (httpServletResponse instanceof IExtendedResponse) {
            ((IExtendedResponse)httpServletResponse).sendRedirect303(httpServletResponse.encodeURL(this.message));
        } else {
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(this.message));
            Tr.debug((TraceComponent)tc, (String)"Response is not of type IExtendedResponse.");
        }
    }

    private static int getReplyCode() {
        if (replyCode == 0) {
            replyCode = 302;
            String string = System.getProperty("com.ibm.ws.security.RedirectCode");
            if (string != null && string.equalsIgnoreCase("SC_SEE_OTHER")) {
                replyCode = 303;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Security redirect code set to: " + replyCode));
            }
        }
        return replyCode;
    }
}

