/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class FormLoginExtensionProcessor
extends WebExtensionProcessor {
    private String loginPage = null;
    private String loginErrorPage = null;
    private static TraceComponent tc = Tr.register((Class)FormLoginExtensionProcessor.class, null, (String)"com.ibm.ejs.resources.security");
    private WebAttributes webAttrs = null;
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static AuditService auditService = null;

    public FormLoginExtensionProcessor(IServletContext iServletContext) throws Exception {
        super(iServletContext);
        try {
            Class<?> clazz;
            String string;
            WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
            WebModuleMetaData webModuleMetaData = webAppConfig.getMetaData();
            SecurityMetaData securityMetaData = (SecurityMetaData)webModuleMetaData.getSecurityMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Create WebAttributes for this webApp.");
            }
            if (securityMetaData != null) {
                this.webAttrs = securityMetaData.getWebAttributes();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"In FormLoginExtensionProcessor(), security MetaData is null.");
            }
            this.loginPage = this.webAttrs.getLoginURL();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("login page is: " + this.loginPage));
            }
            this.loginErrorPage = this.webAttrs.getReloginURL();
            if (this.loginErrorPage != null && !this.loginErrorPage.startsWith("/")) {
                this.loginErrorPage = "/" + this.loginErrorPage;
            }
            if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (auditFactory = (J2EEAuditEventFactory)(auditHandler = (AuditHandlerImpl)auditService.newAuditHandler(string = "WAS.security", string)).getAuditEventFactory("J2EE")) != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                auditFactory = null;
            }
            if (auditService == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditService was not initialized");
            }
            if (auditHandler == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditHandler was not initialized");
            }
            if (auditFactory == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"J2EEAuditEventFactory was not initialized");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("login error page is: " + this.loginErrorPage));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.FormLoginServlet.init", (String)"124", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.web.form.noWebAppInfo", (Object)new Object[]{exception});
        }
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            this.formLogin(httpServletRequest, httpServletResponse);
        }
    }

    private void formLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrivilegedExceptionAction privilegedExceptionAction;
        Object object;
        Object object2;
        String string;
        Object object3;
        String string2;
        String string3;
        CharSequence charSequence;
        boolean bl = false;
        WSCredential wSCredential = null;
        Subject subject = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("formLogin, WebAttributes: \n" + this.webAttrs.toString()));
        }
        String string4 = null;
        if (this.loginErrorPage != null) {
            charSequence = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
            string3 = ((StringBuffer)charSequence).toString();
            String string5 = httpServletRequest.getContextPath();
            if (string5.equals("/")) {
                string5 = "";
            }
            int n = string3.indexOf("//");
            n = string3.indexOf("/", n + 2);
            int n2 = string3.length();
            string4 = string5 + this.loginErrorPage;
            ((StringBuffer)charSequence).replace(n, n2, string4);
            string4 = ((StringBuffer)charSequence).toString();
        }
        charSequence = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig");
        boolean bl2 = false;
        Boolean bl3 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
        if (auditHandler != null) {
            auditHandler.setAppName(this.webAttrs.getWebAppName());
        }
        if (bl3.booleanValue() && !((Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled")).booleanValue()) {
            Tr.error((TraceComponent)tc, (String)"security.formlogin.badconfig", (Object)new Object[]{this.webAttrs.getWebAppName()});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Configuration error.  SSO Not enabled when using FormLogin. Redirecting to error page: " + string4));
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "INVALID_CONFIG", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.formlogin.badconfig.audit", new Object[]{this.webAttrs.getWebAppName()});
            }
            return;
        }
        String string6 = httpServletRequest.getParameter("j_username");
        String string7 = httpServletRequest.getParameter("j_password");
        if (string6 == null || string7 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"username and/or password are not present");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "MISSING_UIDPSWD", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string6, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string4});
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Form based login: userid/password present in the form. User is: " + string6));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        try {
            hashMap.put("WebAppName", this.webAttrs.getWebAppName());
            hashMap.put("RedirectURL", string4);
            string2 = ContextManagerFactory.getInstance().getDefaultRealm();
            object3 = string6;
            string = string7;
            String string8 = string3;
            HttpServletRequest httpServletRequest2 = httpServletRequest;
            object2 = httpServletResponse;
            object = hashMap;
            privilegedExceptionAction = new PrivilegedExceptionAction((String)object3, string, string8, httpServletRequest2, (HttpServletResponse)object2, (HashMap)object){
                private final /* synthetic */ String val$_username;
                private final /* synthetic */ String val$_password;
                private final /* synthetic */ String val$_custom_jaas_config;
                private final /* synthetic */ HttpServletRequest val$_req;
                private final /* synthetic */ HttpServletResponse val$_res;
                private final /* synthetic */ HashMap val$_appcontext;
                {
                    this.val$_username = string22;
                    this.val$_password = string3;
                    this.val$_custom_jaas_config = string4;
                    this.val$_req = httpServletRequest;
                    this.val$_res = httpServletResponse;
                    this.val$_appcontext = hashMap;
                }

                public Object run() throws Exception {
                    Subject subject = ContextManagerFactory.getInstance().login(string2, this.val$_username, this.val$_password, this.val$_custom_jaas_config, this.val$_req, this.val$_res, (Map)this.val$_appcontext);
                    return subject;
                }
            };
            String string9 = null;
            try {
                string9 = (String)hashMap.get("RedirectURL");
            }
            catch (Throwable throwable) {
                string9 = null;
                Tr.error((TraceComponent)tc, (String)"incorrect customized error page: ", (Object)new Object[]{throwable});
            }
            if (string9 != null && string9.length() > 0) {
                string4 = string9;
            }
            try {
                subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
                if (subject != null) {
                    wSCredential = (WSCredential)subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator().next();
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.web.FormLoginServlet.formLogin", (String)"244", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.authn.error.foruser", (Object)new Object[]{string6});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), (Exception)privilegedActionException, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string6, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string4});
                }
                return;
            }
            if (subject == null || wSCredential == null) {
                Tr.audit((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string6});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string6, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string4});
                }
                return;
            }
            ContextManagerFactory.getInstance().setInvocationSubject(subject);
            ContextManagerFactory.getInstance().setCallerSubject(subject);
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string6, providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.success.audit", null);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.FormLoginServlet.formLogin", (String)"218", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.authn.error.foruser", (Object)new Object[]{string6});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), exception, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string6, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string4});
            }
            return;
        }
        WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "FORM");
        string2 = null;
        object3 = null;
        if (((String)charSequence).equals("SWAM")) {
            string2 = httpServletRequest.getSession(true);
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Form based login: Store auth data in the HTTP Session");
                }
                if ((object3 = (FormLoginInfo)((IHttpSession)string2).getSecurityInfo()) == null) {
                    object3 = new FormLoginInfo(string6, string7);
                } else {
                    ((FormLoginInfo)object3).setUsername(string6);
                    ((FormLoginInfo)object3).setPassword(string7);
                }
                ((IHttpSession)string2).putSecurityInfo(object3);
            }
            bl2 = false;
        } else {
            string = null;
            boolean bl4 = false;
            bl2 = false;
            boolean bl5 = false;
            if (this.webAttrs.isSSOEnabled()) {
                bl5 = true;
                if (this.webAttrs.isSecureSSO()) {
                    bl2 = httpServletRequest.getScheme().equalsIgnoreCase("https");
                    bl4 = true;
                } else {
                    bl2 = true;
                }
            }
            if (bl2) {
                try {
                    object2 = WebAttributes.createCookies(httpServletRequest, subject);
                    this.clearCookie(httpServletRequest, httpServletResponse);
                    if (object2 != null) {
                        object = ((ArrayList)object2).listIterator();
                        while (object.hasNext()) {
                            privilegedExceptionAction = (Cookie)object.next();
                            httpServletResponse.addCookie((Cookie)privilegedExceptionAction);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.FormLoginServlet.formLogin", (String)"309", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
                    }
                    httpServletResponse.setStatus(401);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
                    return;
                }
            }
        }
        string = "";
        if (((String)charSequence).equals("SWAM")) {
            string = ((FormLoginInfo)object3).getRefererURL();
        } else {
            Cookie[] cookieArray = httpServletRequest.getCookies();
            string = WebAuthenticator.getCookieValue(cookieArray, "WASReqURL");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Successful auth - redirecting to the original URL" + string));
        }
        if (string != null) {
            if (string.equals("/")) {
                string = "";
            } else if (string.startsWith("/")) {
                string = string.substring(1);
            }
        }
        if (string == null) {
            string = "";
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string));
    }

    private Cookie createCookie(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createCookie " + string + " " + string2));
        }
        Cookie cookie = new Cookie(string, string2);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        cookie.setSecure(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCookie");
        }
        return cookie;
    }

    private void clearCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearCookie");
        }
        if ((string = WebAuthenticator.getCookieValue(cookieArray = httpServletRequest.getCookies(), "WASReqURL")) != null && string.length() > 0) {
            Cookie cookie = new Cookie("WASReqURL", "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            httpServletResponse.addCookie(cookie);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cleared REFERER_URL cookie. Original value was " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearCookie");
        }
    }
}

